/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity.validation.patch;

import com.fasterxml.jackson.databind.JsonNode;
import com.sap.scimono.callback.schemas.SchemasCallback;
import com.sap.scimono.entity.patch.PatchOperation;
import com.sap.scimono.entity.schema.Attribute;
import com.sap.scimono.entity.schema.Schema;
import com.sap.scimono.entity.validation.AttributeImmutableValueValidator;
import com.sap.scimono.entity.validation.SchemaBasedAttributeValueValidator;
import com.sap.scimono.entity.validation.Validator;
import com.sap.scimono.entity.validation.patch.PatchValidationException;
import com.sap.scimono.exception.SCIMException;
import com.sap.scimono.helper.Strings;
import java.util.Iterator;
import java.util.Map;

public class PatchOperationSchemaBasedAttributeValueValidator
implements Validator<PatchOperation> {
    private final SchemasCallback schemaAPI;
    private final String coreSchemaId;
    private final Map<String, Schema> permittedSchemas;

    public PatchOperationSchemaBasedAttributeValueValidator(SchemasCallback schemaAPI, String coreSchemaId, Map<String, Schema> permittedSchemas) {
        this.schemaAPI = schemaAPI;
        this.coreSchemaId = coreSchemaId;
        this.permittedSchemas = permittedSchemas;
    }

    @Override
    public void validate(PatchOperation operation) {
        SchemaBasedAttributeValueValidator attributeAndValueValidator;
        String path = operation.getPath();
        JsonNode value = operation.getValue();
        if (Strings.isNullOrEmpty(path)) {
            Attribute coreSchemaAttribute = this.schemaAPI.getSchema(this.coreSchemaId).toAttribute();
            this.validateSchemaAttributes(coreSchemaAttribute, operation);
            attributeAndValueValidator = new SchemaBasedAttributeValueValidator(coreSchemaAttribute, this.permittedSchemas);
        } else if (this.schemaAPI.getSchema(path) != null) {
            Attribute schemaAttribute = this.schemaAPI.getSchema(path).toAttribute();
            this.validateSchemaAttributes(schemaAttribute, operation);
            attributeAndValueValidator = new SchemaBasedAttributeValueValidator(schemaAttribute, this.permittedSchemas);
        } else {
            String pathWithoutFilter = this.schemaAPI.removeValueFilterFromAttributeNotation(path);
            Attribute targetAttribute = this.schemaAPI.getAttribute(pathWithoutFilter);
            this.validatePathAttribute(targetAttribute, operation);
            attributeAndValueValidator = new SchemaBasedAttributeValueValidator(targetAttribute, this.permittedSchemas);
        }
        attributeAndValueValidator.validate(value);
    }

    private void validatePathAttribute(Attribute attribute, PatchOperation operation) {
        JsonNode value = operation.getValue();
        AttributeImmutableValueValidator mutabilityValidator = new AttributeImmutableValueValidator();
        if (!value.isArray() && PatchOperation.Type.REPLACE.equals(operation.getOp())) {
            mutabilityValidator.validate(attribute);
        }
    }

    private void validateSchemaAttributes(Attribute schemaAttribute, PatchOperation operation) {
        if (!PatchOperation.Type.REPLACE.equals(operation.getOp())) {
            return;
        }
        JsonNode value = operation.getValue();
        AttributeImmutableValueValidator mutabilityValidator = new AttributeImmutableValueValidator();
        Iterator fieldsIterator = value.fields();
        while (fieldsIterator.hasNext()) {
            String subAttrName = (String)((Map.Entry)fieldsIterator.next()).getKey();
            Attribute subAttribute = schemaAttribute.getSubAttributes().stream().filter(attr -> subAttrName.equalsIgnoreCase(attr.getName())).findAny().orElseThrow(() -> new PatchValidationException(SCIMException.Type.INVALID_PATH, String.format("Provided attribute with name '%s' does not exist according to the schema", subAttrName)));
            if (subAttribute.isMultiValued()) continue;
            mutabilityValidator.validate(subAttribute);
        }
    }
}

