/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity.validation;

import com.sap.scimono.callback.resourcetype.ResourceTypesCallback;
import com.sap.scimono.callback.schemas.SchemasCallback;
import com.sap.scimono.entity.Resource;
import com.sap.scimono.entity.base.Extension;
import com.sap.scimono.entity.schema.Attribute;
import com.sap.scimono.entity.schema.SchemaExtension;
import com.sap.scimono.entity.validation.AttributeImmutableValueValidator;
import com.sap.scimono.entity.validation.SchemaBasedAttributeValueValidator;
import com.sap.scimono.entity.validation.Validator;
import com.sap.scimono.exception.SCIMException;
import java.util.Collections;
import javax.ws.rs.core.Response;

public class ResourceCustomAttributesValidator<T extends Resource<T>>
implements Validator<T> {
    private final SchemasCallback schemaAPI;
    private final ResourceTypesCallback resourceTypesAPI;
    private final boolean isOperationPut;

    public static <T extends Resource<T>> ResourceCustomAttributesValidator<T> forPost(SchemasCallback schemaAPI, ResourceTypesCallback resourceTypesAPI) {
        return new ResourceCustomAttributesValidator<T>(schemaAPI, resourceTypesAPI, false);
    }

    public static <T extends Resource<T>> ResourceCustomAttributesValidator<T> forPut(SchemasCallback schemaAPI, ResourceTypesCallback resourceTypesAPI) {
        return new ResourceCustomAttributesValidator<T>(schemaAPI, resourceTypesAPI, true);
    }

    private ResourceCustomAttributesValidator(SchemasCallback schemaAPI, ResourceTypesCallback resourceTypesAPI, boolean isOperationPut) {
        this.schemaAPI = schemaAPI;
        this.resourceTypesAPI = resourceTypesAPI;
        this.isOperationPut = isOperationPut;
    }

    @Override
    public void validate(T resource) {
        if (((Resource)resource).getMeta() != null && ((Resource)resource).getMeta().getResourceType() != null) {
            this.resourceTypesAPI.getSchemaExtensions(((Resource)resource).getMeta().getResourceType()).stream().filter(SchemaExtension::isRequired).forEach(schemaExtension -> {
                if (!resource.isExtensionPresent(schemaExtension.getSchema())) {
                    throw new SCIMException(SCIMException.Type.INVALID_VALUE, String.format("Extension with schema %s is required.", schemaExtension.getSchema()), Response.Status.BAD_REQUEST);
                }
            });
        }
        ((Resource)resource).getExtensions().values().forEach(extension -> {
            Attribute schemaAttribute = this.schemaAPI.getSchema(extension.getUrn()).toAttribute();
            new SchemaBasedAttributeValueValidator(schemaAttribute, Collections.emptyMap()).validate(extension.getAttributes());
            if (this.isOperationPut) {
                this.validateForImmutableValue((Extension)extension, schemaAttribute);
            }
        });
    }

    private void validateForImmutableValue(Extension extension, Attribute schemaAttribute) {
        AttributeImmutableValueValidator mutabilityValidator = new AttributeImmutableValueValidator();
        extension.getAttributes().keySet().forEach(subAtrributeName -> {
            Attribute subAttribute = schemaAttribute.getSubAttributes().stream().filter(attribute -> subAtrributeName.equalsIgnoreCase(attribute.getName())).findAny().orElseThrow(() -> new SCIMException(SCIMException.Type.INVALID_SYNTAX, String.format("Provided attribute with name '%s' does not exist according to the schema", subAtrributeName), Response.Status.BAD_REQUEST));
            if (!subAttribute.isMultiValued()) {
                mutabilityValidator.validate(subAttribute);
            }
        });
    }
}

