/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity.schema;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.scimono.entity.Meta;
import com.sap.scimono.entity.Resource;
import com.sap.scimono.entity.schema.SchemaExtension;
import com.sap.scimono.entity.schema.validation.ValidCoreSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class ResourceType
extends Resource<ResourceType> {
    public static final String RESOURCE_TYPE_RESOURCE_TYPE = "ResourceType";
    public static final String SCHEMA = "urn:ietf:params:scim:schemas:core:2.0:ResourceType";
    private static final long serialVersionUID = 5854212230654248047L;
    @JsonProperty(required=true)
    private final String name;
    @JsonProperty
    private final String description;
    @JsonProperty(required=true)
    private final String endpoint;
    @JsonProperty(required=true)
    private final String schema;
    @JsonProperty
    private final List<SchemaExtension> schemaExtensions;

    @JsonCreator
    private ResourceType(@JsonProperty(value="id", required=true) String id, @JsonProperty(value="endpoint", required=true) String endpoint, @JsonProperty(value="schema", required=true) String schema, @JsonProperty(value="meta") Meta meta, @JsonProperty(value="schemas") Set<String> schemas, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="schemaExtensions") List<SchemaExtension> schemaExtensions) {
        super(id, null, meta, schemas);
        this.name = name;
        this.description = description;
        this.endpoint = endpoint;
        this.schema = schema;
        this.schemaExtensions = schemaExtensions;
    }

    private ResourceType(Builder builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.endpoint = builder.endpoint;
        this.schema = builder.schema;
        this.schemaExtensions = builder.schemaExtensions;
    }

    @Override
    @ValidCoreSchema(value="urn:ietf:params:scim:schemas:core:2.0:ResourceType")
    public Set<String> getSchemas() {
        return super.getSchemas();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getSchema() {
        return this.schema;
    }

    public List<SchemaExtension> getSchemaExtensions() {
        return this.schemaExtensions;
    }

    public Builder builder() {
        return new Builder(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.description);
        result = 31 * result + Objects.hash(this.endpoint);
        result = 31 * result + Objects.hash(this.name);
        result = 31 * result + Objects.hash(this.schema);
        result = 31 * result + Objects.hash(this.schemaExtensions);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ResourceType)) {
            return false;
        }
        ResourceType other = (ResourceType)obj;
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        if (!Objects.equals(this.endpoint, other.endpoint)) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.schema, other.schema)) {
            return false;
        }
        return Objects.equals(this.schemaExtensions, other.schemaExtensions);
    }

    public static class Builder
    extends Resource.Builder<ResourceType> {
        private String name;
        private String description;
        private String endpoint;
        private String schema;
        private List<SchemaExtension> schemaExtensions = new ArrayList<SchemaExtension>();

        Builder(ResourceType resource) {
            super(resource);
            if (resource != null) {
                this.name = resource.name;
                this.description = resource.description;
                this.endpoint = resource.endpoint;
                this.schema = resource.schema;
                this.schemaExtensions = resource.schemaExtensions;
            }
        }

        public Builder() {
            this((ResourceType)null);
            this.addSchema(ResourceType.SCHEMA);
        }

        public Builder setId(String id) {
            super.setId(id);
            return this;
        }

        public Builder setMeta(Meta meta) {
            super.setMeta(meta);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public Builder addSchemaExtension(SchemaExtension schemaExt) {
            this.schemaExtensions.add(schemaExt);
            return this;
        }

        public Builder removeSchemaExtension(SchemaExtension schemaExt) {
            this.schemaExtensions.remove(schemaExt);
            return this;
        }

        public Builder addSchemaExtensions(Collection<SchemaExtension> schemaExtensions) {
            if (schemaExtensions != null) {
                schemaExtensions.forEach(this::addSchemaExtension);
            }
            return this;
        }

        public Builder clearSchemaExtensions() {
            this.schemaExtensions.clear();
            return this;
        }

        @Override
        public ResourceType build() {
            return new ResourceType(this);
        }
    }
}

