/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity.data;

import com.sap.scimono.exception.InvalidInputException;
import com.sap.scimono.helper.Objects;
import com.sap.scimono.helper.Strings;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import javax.xml.bind.DatatypeConverter;

public class DataURI {
    private static final String DATA = "data:";
    private static final String BASE64 = ";base64,";
    private URI uri;

    DataURI(String dataUri) {
        if (Strings.isNullOrEmpty(dataUri)) {
            throw new InvalidInputException("The given string can't be null or empty.");
        }
        if (!dataUri.startsWith(DATA) || !dataUri.contains(BASE64)) {
            throw new InvalidInputException("The given string '" + dataUri + "' is not a data URI.");
        }
        try {
            this.uri = new URI(dataUri);
        }
        catch (URISyntaxException e) {
            throw new InvalidInputException(e.getMessage());
        }
    }

    DataURI(URI dataUri) {
        if (dataUri == null) {
            throw new InvalidInputException("The given dataUri can't be null.");
        }
        if (!dataUri.toString().startsWith(DATA) || !dataUri.toString().contains(BASE64)) {
            throw new InvalidInputException("The given URI '" + dataUri.toString() + "' is not a data URI.");
        }
        this.uri = dataUri;
    }

    DataURI(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new InvalidInputException("The given inputStream can't be null.");
        }
        BufferedInputStream bufferedStream = new BufferedInputStream(inputStream);
        String mimeType = URLConnection.guessContentTypeFromStream(bufferedStream);
        this.uri = this.convertInputStreamToDataURI(inputStream, mimeType);
    }

    private URI convertInputStreamToDataURI(InputStream inputStream, String mimeType) throws IOException {
        URI retDataUri;
        byte[] byteArrayPhoto = Objects.toByteArray(inputStream);
        String base64Photo = DatatypeConverter.printBase64Binary((byte[])byteArrayPhoto);
        StringBuilder uriStringBuilder = new StringBuilder();
        uriStringBuilder.append(DATA).append(mimeType).append(BASE64).append(base64Photo);
        try {
            retDataUri = new URI(uriStringBuilder.toString());
        }
        catch (URISyntaxException e) {
            throw new InvalidInputException(e.getMessage());
        }
        return retDataUri;
    }

    public URI getAsURI() {
        return this.uri;
    }

    public InputStream getAsInputStream() {
        String imageCode = this.uri.toString().substring(this.uri.toString().indexOf(BASE64) + BASE64.length());
        byte[] decodedBytes = DatatypeConverter.parseBase64Binary((String)imageCode);
        return new ByteArrayInputStream(decodedBytes);
    }

    public String getMimeType() {
        String uriString = this.uri.toString();
        return uriString.substring(DATA.length(), uriString.indexOf(BASE64));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataURI)) {
            return false;
        }
        DataURI other = (DataURI)obj;
        if (this.uri == null) {
            return other.uri == null;
        }
        return this.uri.equals(other.uri);
    }

    public String toString() {
        return this.uri.toString();
    }
}

