/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.scimono.entity.base.MultiValuedAttribute;
import com.sap.scimono.entity.base.MultiValuedAttributeType;
import com.sap.scimono.helper.Strings;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Objects;

public final class Im
extends MultiValuedAttribute
implements Serializable {
    private static final long serialVersionUID = -6629213491428871065L;
    private final Type type;

    @JsonCreator
    private Im(@JsonProperty(value="operation") String operation, @JsonProperty(value="value", required=true) String value, @JsonProperty(value="display") String display, @JsonProperty(value="primary") boolean primary, @JsonProperty(value="$ref") String reference, @JsonProperty(value="type") Type type) {
        super(operation, value, display, primary, reference);
        this.type = type;
    }

    private Im(Builder builder) {
        super(builder);
        this.type = builder.type;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.type);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Im other = (Im)obj;
        return Objects.equals(this.type, other.type);
    }

    @Override
    public String toString() {
        LinkedHashMap<String, Object> valuesToDisplay = new LinkedHashMap<String, Object>();
        valuesToDisplay.put("value", this.getValue());
        valuesToDisplay.put("type", this.type);
        valuesToDisplay.put("primary", this.isPrimary());
        valuesToDisplay.put("operation", this.getOperation());
        return Strings.createPrettyEntityString(valuesToDisplay, this.getClass());
    }

    public static class Type
    extends MultiValuedAttributeType {
        private static final long serialVersionUID = -6994765966620165960L;
        public static final Type AIM = new Type("aim");
        public static final Type GTALK = new Type("gtalk");
        public static final Type ICQ = new Type("icq");
        public static final Type XMPP = new Type("xmpp");
        public static final Type MSN = new Type("msn");
        public static final Type SKYPE = new Type("skype");
        public static final Type QQ = new Type("qq");
        public static final Type YAHOO = new Type("yahoo");

        Type(String typeName) {
            super(typeName);
        }

        public static Type of(String typeName) {
            if (Strings.isNullOrEmpty(typeName)) {
                return null;
            }
            return new Type(typeName);
        }
    }

    public static class Builder
    extends MultiValuedAttribute.Builder {
        private Type type;

        public Builder() {
        }

        public Builder(Im im) {
            super(im);
            this.type = im.type;
        }

        @Override
        public Builder setOperation(String operation) {
            super.setOperation(operation);
            return this;
        }

        @Override
        public Builder setDisplay(String display) {
            super.setDisplay(display);
            return this;
        }

        @Override
        public Builder setValue(String value) {
            super.setValue(value);
            return this;
        }

        public Builder setType(Type type) {
            this.type = type;
            return this;
        }

        @Override
        public Builder setPrimary(Boolean primary) {
            super.setPrimary(primary);
            return this;
        }

        @Override
        public Im build() {
            return new Im(this);
        }
    }
}

