/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.api;

import com.sap.scimono.SCIMApplication;
import com.sap.scimono.callback.config.SCIMConfigurationCallback;
import com.sap.scimono.callback.schemas.SchemasCallback;
import com.sap.scimono.entity.Meta;
import com.sap.scimono.entity.paging.PagedByIndexSearchResult;
import com.sap.scimono.entity.schema.Schema;
import com.sap.scimono.entity.schema.validation.ValidSchema;
import com.sap.scimono.entity.schema.validation.ValidSchemaId;
import com.sap.scimono.exception.InvalidInputException;
import com.sap.scimono.exception.ResourceNotFoundException;
import com.sap.scimono.helper.ResourceLocationService;
import com.sap.scimono.helper.Strings;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="Schemas")
@Produces(value={"application/scim+json"})
@Consumes(value={"application/scim+json"})
public class Schemas {
    private static final Logger logger = LoggerFactory.getLogger(Schemas.class);
    public static final int PREDEFINED_SCHEMAS_COUNT = 6;
    private static final int CUSTOM_SCHEMAS_MAX_COUNT = 20;
    private final SchemasCallback schemaAPI;
    private final SCIMConfigurationCallback scimConfig;
    private final ResourceLocationService resourceLocationService;

    public Schemas(@Context Application appContext, @Context UriInfo uriInfo) {
        SCIMApplication scimApplication = SCIMApplication.from(appContext);
        this.schemaAPI = scimApplication.getSchemasCallback();
        this.scimConfig = scimApplication.getConfigurationCallback();
        this.resourceLocationService = new ResourceLocationService(uriInfo, scimApplication.getConfigurationCallback(), "Schemas");
    }

    @GET
    public Response getSchemas() {
        logger.trace("Reading all schemas");
        List<Schema> schemas = this.schemaAPI.getSchemas();
        ArrayList<Schema> schemasWithLocation = new ArrayList<Schema>();
        for (Schema schema : schemas) {
            schema = this.resourceLocationService.addLocation(schema, schema.getId());
            schemasWithLocation.add(schema);
        }
        return Response.ok(new PagedByIndexSearchResult(schemasWithLocation, schemasWithLocation.size(), this.scimConfig.getMaxResourcesPerPage(), 1)).build();
    }

    @GET
    @Path(value="{id}")
    public Response getSchema(@PathParam(value="id") @ValidSchemaId String schemaId) {
        logger.trace("Reading schema {}", (Object)schemaId);
        Schema schema = this.schemaAPI.getSchema(schemaId);
        if (schema != null) {
            Schema schemaWithLocation = this.resourceLocationService.addLocation(schema, schemaId);
            return Response.ok((Object)schemaWithLocation).tag(schemaWithLocation.getMeta().getVersion()).location(this.resourceLocationService.getLocation(schemaId)).build();
        }
        throw new ResourceNotFoundException("Schema", schemaId);
    }

    @POST
    public Response createSchema(@Valid @ValidSchema Schema newSchema) {
        this.validateSchema(newSchema);
        URI location = this.resourceLocationService.getLocation(newSchema.getId());
        String version = UUID.randomUUID().toString();
        Meta schemaMeta = new Meta.Builder().setResourceType("Schema").setLocation(location.toString()).setVersion(version).build();
        Schema schemaWithMeta = newSchema.builder().setMeta(schemaMeta).build();
        this.schemaAPI.createCustomSchema(schemaWithMeta);
        logger.trace("Created schema {} with version {}", (Object)newSchema.getId(), (Object)version);
        return Response.created((URI)location).tag(version).entity((Object)schemaWithMeta).build();
    }

    @DELETE
    @Path(value="{id}")
    public void deleteSchema(@PathParam(value="id") @ValidSchemaId String schemaId) {
        this.validateSchemaId(schemaId);
        this.schemaAPI.deleteCustomSchema(schemaId);
        logger.trace("Deleted schema {}", (Object)schemaId);
        Response.noContent().build();
    }

    private void validateSchemaId(String schemaId) {
        if (!SchemasCallback.isCustomSchema(schemaId)) {
            throw new InvalidInputException(String.format("Invalid schema name. Expected an extension schema name starting with the extension schema URN: '%s'", "urn:sap:cloud:scim:schemas:extension:custom:2.0:"));
        }
        String schemaName = Strings.stripStart(schemaId, "urn:sap:cloud:scim:schemas:extension:custom:2.0:");
        if (!this.schemaAPI.isValidSchemaName(schemaName)) {
            throw new InvalidInputException("Invalid schema name. Expected format is alphanumeric.");
        }
    }

    private void validateSchema(Schema schema) {
        this.validateSchemaId(schema.getId());
        int customSchemasCount = this.schemaAPI.getCustomSchemas().size() - 6;
        if (customSchemasCount >= 20) {
            throw new InvalidInputException("Custom schema maximum count reached!");
        }
        if (!this.schemaAPI.isValidSchemaName(schema.getName())) {
            throw new InvalidInputException("Invalid schema name. Expected format is alphanumeric.");
        }
        schema.getAttributes().forEach(attribute -> {
            if (!this.schemaAPI.isValidSchemaName(attribute.getName())) {
                throw new InvalidInputException("Invalid attribute name. Expected format is alphanumeric.");
            }
        });
    }
}

