/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.api;

import com.sap.scimono.SCIMApplication;
import com.sap.scimono.callback.config.SCIMConfigurationCallback;
import com.sap.scimono.callback.resourcetype.ResourceTypesCallback;
import com.sap.scimono.entity.Meta;
import com.sap.scimono.entity.paging.PagedByIndexSearchResult;
import com.sap.scimono.entity.paging.PagedResult;
import com.sap.scimono.entity.schema.ResourceType;
import com.sap.scimono.exception.ResourceNotFoundException;
import com.sap.scimono.helper.ResourceLocationService;
import java.time.Instant;
import java.util.ArrayList;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

@Path(value="ResourceTypes")
@Produces(value={"application/scim+json"})
@Consumes(value={"application/scim+json"})
public class ResourceTypes {
    private static final Instant now = Instant.now();
    private static final ResourceType RESOURCE_TYPE_USER = new ResourceType.Builder().setId("User").name("User").description("User Account").endpoint("Users").schema("urn:ietf:params:scim:schemas:core:2.0:User").setMeta(new Meta.Builder(now, now).setResourceType("ResourceType").build()).build();
    private static final ResourceType RESOURCE_TYPE_GROUP = new ResourceType.Builder().setId("Group").name("Group").description("Group").endpoint("Groups").schema("urn:ietf:params:scim:schemas:core:2.0:Group").setMeta(new Meta.Builder(now, now).setResourceType("ResourceType").build()).build();
    private static final ResourceType RESOURCE_TYPE_SCHEMA = new ResourceType.Builder().setId("Schema").name("Schema").description("Schema").endpoint("Schemas").schema("urn:ietf:params:scim:schemas:core:2.0:Schema").setMeta(new Meta.Builder(now, now).setResourceType("ResourceType").build()).build();
    private final SCIMConfigurationCallback scimConfig;
    private final ResourceTypesCallback resourceTypesCallback;
    private final ResourceLocationService resourceLocationService;

    public ResourceTypes(@Context Application appContext, @Context UriInfo uriInfo) {
        SCIMApplication scimApplication = SCIMApplication.from(appContext);
        this.resourceTypesCallback = scimApplication.getResourceTypesCallback();
        this.scimConfig = scimApplication.getConfigurationCallback();
        this.resourceLocationService = new ResourceLocationService(uriInfo, scimApplication.getConfigurationCallback(), "ResourceTypes");
    }

    @GET
    public PagedByIndexSearchResult<ResourceType> getResourceTypes() {
        ArrayList<ResourceType> resources = new ArrayList<ResourceType>();
        ResourceType userResourceType = this.resourceLocationService.addLocation(RESOURCE_TYPE_USER, "User");
        resources.add(this.withSchemaExtensions(userResourceType));
        ResourceType groupResourceType = this.resourceLocationService.addLocation(RESOURCE_TYPE_GROUP, "Group");
        resources.add(this.withSchemaExtensions(groupResourceType));
        ResourceType schemaResourceType = this.resourceLocationService.addLocation(RESOURCE_TYPE_SCHEMA, "Schema");
        resources.add(this.withSchemaExtensions(schemaResourceType));
        PagedResult<ResourceType> customResourceTypes = this.resourceTypesCallback.getCustomResourceTypes();
        this.resourceLocationService.addLocation(customResourceTypes);
        for (ResourceType resourceType : customResourceTypes.getResources()) {
            resources.add(this.withSchemaExtensions(resourceType));
        }
        return new PagedByIndexSearchResult<ResourceType>(resources, resources.size(), this.scimConfig.getMaxResourcesPerPage(), 1);
    }

    @GET
    @Path(value="{id}")
    public ResourceType getResourceType(@PathParam(value="id") String typeId) {
        ResourceType resourceType;
        switch (typeId) {
            case "User": {
                resourceType = RESOURCE_TYPE_USER;
                break;
            }
            case "Group": {
                resourceType = RESOURCE_TYPE_GROUP;
                break;
            }
            case "Schema": {
                resourceType = RESOURCE_TYPE_SCHEMA;
                break;
            }
            default: {
                resourceType = this.resourceTypesCallback.getCustomResourceType(typeId);
            }
        }
        if (resourceType == null) {
            throw new ResourceNotFoundException("ResourceType", typeId);
        }
        resourceType = this.withSchemaExtensions(resourceType);
        return this.resourceLocationService.addLocation(resourceType, typeId);
    }

    private ResourceType withSchemaExtensions(ResourceType resourceType) {
        ResourceType.Builder builder = resourceType.builder();
        builder.clearSchemaExtensions();
        builder.addSchemaExtensions(this.resourceTypesCallback.getSchemaExtensions(resourceType.getId()));
        return builder.build();
    }
}

