/*
 * Decompiled with CFR 0.152.
 */
package com.sap.scimono.api;

import com.sap.scimono.SCIMApplication;
import com.sap.scimono.api.PagingParamsParser;
import com.sap.scimono.api.ServletRequestProvider;
import com.sap.scimono.api.patch.PATCH;
import com.sap.scimono.callback.config.SCIMConfigurationCallback;
import com.sap.scimono.callback.groups.GroupsCallback;
import com.sap.scimono.callback.resourcetype.ResourceTypesCallback;
import com.sap.scimono.callback.schemas.SchemasCallback;
import com.sap.scimono.entity.Group;
import com.sap.scimono.entity.Meta;
import com.sap.scimono.entity.paging.PageInfo;
import com.sap.scimono.entity.paging.PagedByIdentitySearchResult;
import com.sap.scimono.entity.paging.PagedByIndexSearchResult;
import com.sap.scimono.entity.paging.PagedResult;
import com.sap.scimono.entity.patch.PatchBody;
import com.sap.scimono.entity.schema.validation.ValidId;
import com.sap.scimono.entity.schema.validation.ValidStartId;
import com.sap.scimono.entity.validation.ResourceCustomAttributesValidator;
import com.sap.scimono.entity.validation.patch.PatchValidationFramework;
import com.sap.scimono.exception.InvalidInputException;
import com.sap.scimono.exception.ResourceNotFoundException;
import com.sap.scimono.helper.ReadOnlyAttributesEraser;
import com.sap.scimono.helper.ResourceLocationService;
import com.sap.scimono.helper.Strings;
import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.UUID;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="Groups")
@Produces(value={"application/scim+json"})
@Consumes(value={"application/scim+json"})
@ServletRequestProvider
public class Groups {
    private static final Logger logger = LoggerFactory.getLogger(Groups.class);
    private final GroupsCallback groupAPI;
    private final SchemasCallback schemaAPI;
    private final ResourceTypesCallback resourceTypesAPI;
    private final SCIMConfigurationCallback scimConfig;
    private final ResourceLocationService resourceLocationService;

    public Groups(@Context Application appContext, @Context UriInfo uriInfo) {
        SCIMApplication scimApplication = SCIMApplication.from(appContext);
        this.groupAPI = scimApplication.getGroupsCallback();
        this.schemaAPI = scimApplication.getSchemasCallback();
        this.resourceTypesAPI = scimApplication.getResourceTypesCallback();
        this.scimConfig = scimApplication.getConfigurationCallback();
        this.resourceLocationService = new ResourceLocationService(uriInfo, scimApplication.getConfigurationCallback(), "Groups");
    }

    @GET
    @Path(value="{id}")
    public Response getGroup(@PathParam(value="id") @ValidId String groupId) {
        logger.trace("Reading group {}", (Object)groupId);
        Group groupFromDb = this.groupAPI.getGroup(groupId);
        if (groupFromDb != null) {
            Group group = this.resourceLocationService.addLocation(groupFromDb, groupId);
            group = this.resourceLocationService.addMembersLocation(group);
            return Response.ok((Object)group).tag(group.getMeta().getVersion()).location(this.resourceLocationService.getLocation(groupId)).build();
        }
        throw new ResourceNotFoundException("Group", groupId);
    }

    @GET
    public Response getGroups(@DefaultValue(value="1") @QueryParam(value="startIndex") String startIndexParam, @DefaultValue(value="100") @QueryParam(value="count") String countParam, @QueryParam(value="startId") @ValidStartId String startId, @QueryParam(value="filter") String filter) {
        logger.trace("Reading groups with paging parameters startIndex {} startId {} count {}", new Object[]{startIndexParam, startId, countParam});
        int startIndex = PagingParamsParser.parseStartIndex(startIndexParam);
        int count = PagingParamsParser.parseCount(countParam);
        int maxCount = this.scimConfig.getMaxResourcesPerPage();
        logger.trace("Configured max count of returned resources is {}", (Object)maxCount);
        if (count > maxCount) {
            count = maxCount;
        }
        PageInfo pageInfo = PageInfo.getInstance(count, startIndex - 1, startId);
        PagedResult<Group> groups = this.groupAPI.getGroups(pageInfo, filter);
        ArrayList<Group> groupsToReturn = new ArrayList<Group>();
        for (Group group : groups.getResources()) {
            group = this.resourceLocationService.addLocation(group, group.getId());
            group = this.resourceLocationService.addMembersLocation(group);
            groupsToReturn.add(group);
        }
        if (Strings.isNotNullOrEmpty(startId)) {
            if (groupsToReturn.size() <= count) {
                return Response.ok(new PagedByIdentitySearchResult(groupsToReturn, groups.getTotalResourceCount(), count, startId, "end")).build();
            }
            int indexOfLastGroup = groupsToReturn.size() - 1;
            Group nextGroup = (Group)groupsToReturn.remove(indexOfLastGroup);
            return Response.ok(new PagedByIdentitySearchResult(groupsToReturn, groups.getTotalResourceCount(), count, startId, nextGroup.getId())).build();
        }
        return Response.ok(new PagedByIndexSearchResult(groupsToReturn, groups.getTotalResourceCount(), count, startIndex)).build();
    }

    @POST
    public Response createGroup(@Valid Group newGroup) {
        if (newGroup == null) {
            throw new InvalidInputException("One of the request inputs is not valid.");
        }
        ReadOnlyAttributesEraser<Group> readOnlyAttributesEraser = new ReadOnlyAttributesEraser<Group>(this.schemaAPI);
        newGroup = readOnlyAttributesEraser.eraseAllFormCustomExtensions(newGroup);
        String version = UUID.randomUUID().toString();
        Meta groupMeta = new Meta.Builder().setVersion(version).setResourceType("Group").build();
        Group.Builder groupWithMetaBuilder = newGroup.builder().setMeta(groupMeta);
        this.groupAPI.generateId().ifPresent(groupWithMetaBuilder::setId);
        Group groupWithMeta = groupWithMetaBuilder.build();
        ResourceCustomAttributesValidator<Group> customAttributesValidator = ResourceCustomAttributesValidator.forPost(this.schemaAPI, this.resourceTypesAPI);
        customAttributesValidator.validate(groupWithMeta);
        Group createdGroup = this.groupAPI.createGroup(groupWithMeta);
        createdGroup = this.resourceLocationService.addMembersLocation(createdGroup);
        createdGroup = this.resourceLocationService.addLocation(createdGroup, createdGroup.getId());
        logger.trace("Created group {} with version {}", (Object)createdGroup.getId(), (Object)version);
        return Response.created((URI)this.resourceLocationService.getLocation(createdGroup.getId())).tag(version).entity((Object)createdGroup).build();
    }

    @PUT
    @Path(value="{id}")
    public Response updateGroup(@PathParam(value="id") @ValidId String groupId, @Valid Group groupToUpdate) {
        ReadOnlyAttributesEraser<Group> readOnlyAttributesEraser = new ReadOnlyAttributesEraser<Group>(this.schemaAPI);
        groupToUpdate = readOnlyAttributesEraser.eraseAllFormCustomExtensions(groupToUpdate);
        String newVersion = UUID.randomUUID().toString();
        Meta.Builder lastUpdatedMeta = new Meta.Builder(groupToUpdate.getMeta());
        URI groupLocation = this.resourceLocationService.getLocation(groupId);
        lastUpdatedMeta.setLastModified(Instant.now()).setVersion(newVersion).setLocation(groupLocation.toString());
        Group updatedGroup = groupToUpdate.builder().setId(groupId).setMeta(lastUpdatedMeta.build()).build();
        ResourceCustomAttributesValidator<Group> customAttributesValidator = ResourceCustomAttributesValidator.forPut(this.schemaAPI, this.resourceTypesAPI);
        customAttributesValidator.validate(groupToUpdate);
        updatedGroup = this.groupAPI.updateGroup(updatedGroup);
        updatedGroup = this.resourceLocationService.addMembersLocation(updatedGroup);
        logger.trace("Updated group {}, new version is {}", (Object)groupId, (Object)newVersion);
        return Response.ok((Object)updatedGroup).tag(newVersion).location(groupLocation).build();
    }

    @DELETE
    @Path(value="{id}")
    public void deleteGroup(@PathParam(value="id") @ValidId String groupId) {
        this.groupAPI.deleteGroup(groupId);
        logger.trace("Deleted group {}", (Object)groupId);
        Response.noContent().build();
    }

    @PATCH
    @Path(value="{id}")
    public Response patchGroup(@PathParam(value="id") @ValidId String groupId, PatchBody patchBody) {
        PatchValidationFramework validationFramework = PatchValidationFramework.groupsFramework(this.schemaAPI, this.resourceTypesAPI);
        validationFramework.validate(patchBody);
        Meta meta = new Meta.Builder(null, Instant.now()).setVersion(UUID.randomUUID().toString()).build();
        this.groupAPI.patchGroup(groupId, patchBody, meta);
        logger.trace("Updated group {}", (Object)groupId);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }
}

