/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.engine.ws;

import com.sap.cloud.servicesdk.xbem.api.MessagingRuntimeException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketUpgrade {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketUpgrade.class);
    public static final String HTTP_HEADER_USER_AGENT = "User-Agent";
    private static final String SEC_WS_KEY_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private static final String EOL = "\r\n";
    private final String host;
    private final String path;
    private final String port;
    private final String protocol;
    private String webSocketKey = "";
    private Map<String, String> additionalHeaders;

    WebSocketUpgrade(String hostName, String webSocketPath, int webSocketPort, String webSocketProtocol, Map<String, String> additionalHeaders) {
        this.host = hostName;
        this.path = webSocketPath == null ? "/" : webSocketPath;
        this.port = String.valueOf(webSocketPort);
        this.protocol = webSocketProtocol;
        if (additionalHeaders != null && additionalHeaders.size() > 0) {
            this.additionalHeaders = new HashMap<String, String>();
            this.additionalHeaders.putAll(additionalHeaders);
        }
    }

    private String createWebSocketKey() {
        byte[] key = new byte[16];
        SecureRandom sr = new SecureRandom();
        sr.nextBytes(key);
        return DatatypeConverter.printBase64Binary((byte[])key).trim();
    }

    String createUpgradeRequest() {
        if (this.host == null || this.host.isEmpty()) {
            throw new InvalidParameterException("host header has no value");
        }
        if (this.protocol == null || this.protocol.isEmpty()) {
            throw new InvalidParameterException("protocol header has no value");
        }
        this.webSocketKey = this.createWebSocketKey();
        StringBuilder upgradeRequest = new StringBuilder().append("GET ").append(this.path).append(" HTTP/1.1").append(EOL).append("Connection: Upgrade").append(EOL).append("Upgrade: websocket").append(EOL).append("Sec-WebSocket-Version: 13").append(EOL).append("Sec-WebSocket-Key: ").append(this.webSocketKey).append(EOL).append("Sec-WebSocket-Protocol: ").append(this.protocol).append(EOL).append("Host: ").append(this.host).append(':').append(this.port).append(EOL);
        if (this.additionalHeaders != null) {
            this.additionalHeaders.forEach((key, value) -> upgradeRequest.append((String)key).append(": ").append((String)value).append(EOL));
        }
        upgradeRequest.append(EOL);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Created WS upgrade request with host={}, path={}, port={}, protocol={}, additionalHeaders={}", new Object[]{this.host, this.path, this.port, this.protocol, this.additionalHeaders});
        }
        return upgradeRequest.toString();
    }

    Boolean validateUpgradeReply(byte[] responseBytes) {
        String httpString = new String(responseBytes, StandardCharsets.UTF_8);
        boolean isStatusLineOk = false;
        boolean isUpgradeHeaderOk = false;
        boolean isConnectionHeaderOk = false;
        boolean isProtocolHeaderOk = false;
        boolean isAcceptHeaderOk = false;
        try (Scanner scanner = new Scanner(httpString);){
            while (scanner.hasNextLine()) {
                MessageDigest messageDigest;
                byte[] digest;
                String expectedKey;
                String line = scanner.nextLine();
                String lowerCase = line.toLowerCase();
                if (this.isValidStatusLine(lowerCase)) {
                    isStatusLineOk = true;
                    continue;
                }
                if (this.isValidUpgradeHeader(lowerCase)) {
                    isUpgradeHeaderOk = true;
                    continue;
                }
                if (this.isValidConnectionHeader(lowerCase)) {
                    isConnectionHeaderOk = true;
                    continue;
                }
                if (this.isValidProtocolHeader(lowerCase)) {
                    isProtocolHeaderOk = true;
                    continue;
                }
                if (!lowerCase.contains("sec-websocket-accept") || !line.contains(expectedKey = DatatypeConverter.printBase64Binary((byte[])(digest = (messageDigest = this.getMessageDigest()).digest((this.webSocketKey + SEC_WS_KEY_GUID).getBytes()))).trim())) continue;
                isAcceptHeaderOk = true;
            }
        }
        if (isStatusLineOk && isUpgradeHeaderOk && isConnectionHeaderOk && isProtocolHeaderOk && isAcceptHeaderOk) {
            LOG.trace("Successfully verified WS upgrade request.");
            return true;
        }
        LOG.debug("WS upgrade request verification failed with isStatusLineOk={}, isUpgradeHeaderOk={}, isConnectionHeaderOk={}, isProtocolHeaderOk={}, isAcceptHeaderOk={}.", new Object[]{isStatusLineOk, isUpgradeHeaderOk, isConnectionHeaderOk, isProtocolHeaderOk, isAcceptHeaderOk});
        LOG.trace("WS upgrade response was:\n{}", (Object)httpString);
        return false;
    }

    private boolean isValidProtocolHeader(String lowerCase) {
        return lowerCase.contains("sec-websocket-protocol") && lowerCase.contains(this.protocol.toLowerCase());
    }

    private boolean isValidConnectionHeader(String lowerCase) {
        return lowerCase.contains("connection") && lowerCase.contains("upgrade");
    }

    private boolean isValidUpgradeHeader(String lowerCase) {
        return lowerCase.contains("upgrade") && lowerCase.contains("websocket");
    }

    private boolean isValidStatusLine(String lowerCase) {
        return lowerCase.contains("http/1.1") && lowerCase.contains("101") && (lowerCase.contains("protocol handshake") || lowerCase.contains("switching protocols"));
    }

    private MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new MessagingRuntimeException("Unable to init MessageDigest: " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        return "WebSocketUpgrade{host='" + this.host + '\'' + ", path='" + this.path + '\'' + ", port='" + this.port + '\'' + ", protocol='" + this.protocol + '\'' + ", webSocketKey='" + this.webSocketKey + '\'' + ", additionalHeaders=" + this.additionalHeaders + '}';
    }
}

