/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.engine.ws;

import com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.engine.ws.WebSocketChunk;
import com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.engine.ws.WebSocketHandler;
import com.sap.cloud.servicesdk.xbem.api.MessagingRuntimeException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.qpid.proton.engine.TransportException;
import org.apache.qpid.proton.engine.impl.ByteBufferUtils;
import org.apache.qpid.proton.engine.impl.TransportInput;
import org.apache.qpid.proton.engine.impl.TransportLayer;
import org.apache.qpid.proton.engine.impl.TransportOutput;
import org.apache.qpid.proton.engine.impl.TransportWrapper;

public class WebSocketTransportLayer
implements TransportLayer {
    private static final int MIN_WS_BUFFER_SIZE = 8192;
    private static final int MAX_WS_BUFFER_SIZE = 0x800000;
    public static final int WS_HEADER_SIZE = 128;
    private boolean tailClosed = false;
    private boolean headClosed = false;
    private ByteBuffer inputBuffer;
    private ByteBuffer outputBuffer;
    private ByteBuffer pingBuffer;
    private int underlyingOutputSize = 0;
    private int webSocketHeaderSize = 0;
    private WebSocketHandler webSocketHandler;
    private WebSocketState state = WebSocketState.PN_WS_NOT_STARTED;
    private Boolean isWebSocketEnabled = false;

    public WebSocketTransportLayer(int amqpMaxFrameSize) {
        int bufferSize;
        if (amqpMaxFrameSize < 8192) {
            bufferSize = 8320;
        } else {
            if (amqpMaxFrameSize > 0x800000) {
                throw new IllegalArgumentException("Requested AMQP max frame size ('" + amqpMaxFrameSize + "') higher then MAX_WS_BUFFER_SIZE ('" + 0x800000 + "').");
            }
            bufferSize = amqpMaxFrameSize + 128;
        }
        this.inputBuffer = ByteBufferUtils.newWriteableBuffer((int)bufferSize);
        this.outputBuffer = ByteBufferUtils.newWriteableBuffer((int)bufferSize);
        this.pingBuffer = ByteBufferUtils.newWriteableBuffer((int)bufferSize);
    }

    public WebSocketTransportLayer() {
        this(8192);
    }

    public TransportWrapper wrap(TransportInput input, TransportOutput output) {
        return new WebSocketTransportWrapper(input, output);
    }

    public void configure(String host, String path, int port, String protocol, Map<String, String> additionalHeaders) {
        this.webSocketHandler = new WebSocketHandler(host, path, port, protocol, additionalHeaders);
        this.isWebSocketEnabled = true;
    }

    void wrapBuffer(ByteBuffer srcBuffer, ByteBuffer dstBuffer) {
        if (this.isWebSocketEnabled.booleanValue()) {
            this.webSocketHandler.wrapBuffer(srcBuffer, dstBuffer);
        } else {
            dstBuffer.clear();
            dstBuffer.put(srcBuffer);
        }
    }

    List<WebSocketChunk> unwrapBuffer(ByteBuffer buffer) {
        if (this.isWebSocketEnabled.booleanValue()) {
            return this.webSocketHandler.unwrapBuffer(buffer);
        }
        return Collections.singletonList(WebSocketChunk.createEmpty());
    }

    private void writeUpgradeRequest() {
        this.outputBuffer.clear();
        String request = this.webSocketHandler.createUpgradeRequest();
        this.outputBuffer.put(request.getBytes());
    }

    private void writePong() {
        this.webSocketHandler.createPong(this.pingBuffer, this.outputBuffer);
    }

    private void writeClose() {
        this.outputBuffer.clear();
        this.pingBuffer.flip();
        this.outputBuffer.put((byte)-120);
        if (this.pingBuffer.hasRemaining()) {
            this.outputBuffer.put((byte)2);
            this.outputBuffer.put(this.pingBuffer);
        }
    }

    private int handleWsConnecting() {
        if (this.headClosed && this.outputBuffer.position() == 0) {
            this.state = WebSocketState.PN_WS_FAILED;
            return -1;
        }
        return this.outputBuffer.position();
    }

    public String toString() {
        return "WebSocketTransportLayer [isWebSocketEnabled=" + this.isWebSocketEnabled + ", WebSocketHandler=" + this.webSocketHandler + "]";
    }

    private void processWsConnecting() {
        if (!this.webSocketHandler.validateUpgradeReply(this.inputBuffer)) {
            this.state = WebSocketState.PN_WS_FAILED;
            throw new MessagingRuntimeException("WS upgrade response verification failed.");
        }
        this.state = WebSocketState.PN_WS_CONNECTED_FLOW;
    }

    private class WebSocketTransportWrapper
    implements TransportWrapper {
        private final TransportInput underlyingInput;
        private final TransportOutput underlyingOutput;
        private final ByteBuffer head;

        private WebSocketTransportWrapper(TransportInput input, TransportOutput output) {
            this.underlyingInput = input;
            this.underlyingOutput = output;
            this.head = WebSocketTransportLayer.this.outputBuffer.asReadOnlyBuffer();
            this.head.limit(0);
        }

        private void processInput() throws TransportException {
            switch (WebSocketTransportLayer.this.state) {
                case PN_WS_CONNECTING: {
                    WebSocketTransportLayer.this.processWsConnecting();
                    break;
                }
                case PN_WS_CONNECTED_FLOW: 
                case PN_WS_CONNECTED_PONG: {
                    this.processWsConnected();
                    break;
                }
            }
        }

        private void processWsConnected() {
            boolean isRepeatedUpgradeAccept = false;
            if (WebSocketTransportLayer.this.inputBuffer.remaining() > 4) {
                byte[] data = new byte[WebSocketTransportLayer.this.inputBuffer.remaining()];
                WebSocketTransportLayer.this.inputBuffer.get(data);
                if (data[0] == 72 && data[1] == 84 && data[2] == 84 && data[3] == 80) {
                    WebSocketTransportLayer.this.inputBuffer.compact();
                    isRepeatedUpgradeAccept = true;
                } else {
                    WebSocketTransportLayer.this.inputBuffer.flip();
                }
            }
            if (!isRepeatedUpgradeAccept) {
                List<WebSocketChunk> chunkList = WebSocketTransportLayer.this.unwrapBuffer(WebSocketTransportLayer.this.inputBuffer);
                boolean counter = true;
                boolean forwardToInput = false;
                for (WebSocketChunk chunk : chunkList) {
                    forwardToInput = this.handleChunk(chunk);
                }
                if (chunkList.isEmpty()) {
                    WebSocketTransportLayer.this.inputBuffer.compact();
                } else if (forwardToInput) {
                    WebSocketTransportLayer.this.inputBuffer.compact();
                    this.underlyingInput.process();
                }
            }
        }

        private boolean handleChunk(WebSocketChunk chunk) {
            switch (chunk.type) {
                case WEB_SOCKET_MESSAGE_TYPE_AMQP: 
                case WEB_SOCKET_MESSAGE_TYPE_EMPTY: 
                case WEB_SOCKET_MESSAGE_TYPE_INVALID: 
                case WEB_SOCKET_MESSAGE_TYPE_INVALID_MASKED: 
                case WEB_SOCKET_MESSAGE_TYPE_INVALID_LENGTH: {
                    int bytes = this.pourAll(chunk.buffer, this.underlyingInput);
                    if (bytes == -1) {
                        WebSocketTransportLayer.this.tailClosed = true;
                    }
                    return true;
                }
                case WEB_SOCKET_MESSAGE_TYPE_CLOSE: {
                    WebSocketTransportLayer.this.pingBuffer.put(chunk.buffer);
                    WebSocketTransportLayer.this.state = WebSocketState.PN_WS_CONNECTED_CLOSING;
                    return false;
                }
                case WEB_SOCKET_MESSAGE_TYPE_PING: {
                    WebSocketTransportLayer.this.pingBuffer.put(chunk.buffer);
                    WebSocketTransportLayer.this.state = WebSocketState.PN_WS_CONNECTED_PONG;
                    return false;
                }
            }
            return false;
        }

        public int pourAll(ByteBuffer source, TransportInput destinationTransportInput) throws TransportException {
            int capacity = destinationTransportInput.capacity();
            if (capacity == -1) {
                if (source.hasRemaining()) {
                    throw new IllegalStateException("Destination has reached end of stream: " + destinationTransportInput);
                }
                return -1;
            }
            int total = source.remaining();
            while (source.hasRemaining() && destinationTransportInput.capacity() > 0) {
                ByteBufferUtils.pour((ByteBuffer)source, (ByteBuffer)destinationTransportInput.tail());
                if (!source.hasRemaining() || destinationTransportInput.capacity() != 0) continue;
                destinationTransportInput.process();
            }
            return total - source.remaining();
        }

        public int capacity() {
            if (WebSocketTransportLayer.this.isWebSocketEnabled.booleanValue()) {
                if (WebSocketTransportLayer.this.tailClosed) {
                    return -1;
                }
                return WebSocketTransportLayer.this.inputBuffer.remaining();
            }
            return this.underlyingInput.capacity();
        }

        public int position() {
            if (WebSocketTransportLayer.this.isWebSocketEnabled.booleanValue()) {
                if (WebSocketTransportLayer.this.tailClosed) {
                    return -1;
                }
                return WebSocketTransportLayer.this.inputBuffer.position();
            }
            return this.underlyingInput.position();
        }

        public ByteBuffer tail() {
            if (WebSocketTransportLayer.this.isWebSocketEnabled.booleanValue()) {
                return WebSocketTransportLayer.this.inputBuffer;
            }
            return this.underlyingInput.tail();
        }

        public void process() throws TransportException {
            if (WebSocketTransportLayer.this.isWebSocketEnabled.booleanValue()) {
                WebSocketTransportLayer.this.inputBuffer.flip();
                switch (WebSocketTransportLayer.this.state) {
                    case PN_WS_CONNECTING: 
                    case PN_WS_CONNECTED_FLOW: {
                        this.processInput();
                        break;
                    }
                    default: {
                        this.underlyingInput.process();
                        break;
                    }
                }
            } else {
                this.underlyingInput.process();
            }
        }

        public void close_tail() {
            WebSocketTransportLayer.this.tailClosed = true;
            if (WebSocketTransportLayer.this.isWebSocketEnabled.booleanValue()) {
                WebSocketTransportLayer.this.headClosed = true;
                this.underlyingInput.close_tail();
            } else {
                this.underlyingInput.close_tail();
            }
        }

        public int pending() {
            if (WebSocketTransportLayer.this.isWebSocketEnabled.booleanValue()) {
                switch (WebSocketTransportLayer.this.state) {
                    case PN_WS_NOT_STARTED: {
                        return this.handleWsNotStarted();
                    }
                    case PN_WS_CONNECTING: {
                        return WebSocketTransportLayer.this.handleWsConnecting();
                    }
                    case PN_WS_CONNECTED_FLOW: {
                        return this.handleWsConnectedFlow();
                    }
                    case PN_WS_CONNECTED_PONG: {
                        return this.handleWsConnectedPong();
                    }
                    case PN_WS_CONNECTED_CLOSING: {
                        return this.handleWsConnectedClosing();
                    }
                }
                return -1;
            }
            return this.underlyingOutput.pending();
        }

        private int handleWsConnectedClosing() {
            WebSocketTransportLayer.this.writeClose();
            this.head.limit(WebSocketTransportLayer.this.outputBuffer.position());
            if (WebSocketTransportLayer.this.headClosed) {
                WebSocketTransportLayer.this.state = WebSocketState.PN_WS_FAILED;
                return -1;
            }
            return WebSocketTransportLayer.this.outputBuffer.position();
        }

        private int handleWsConnectedPong() {
            WebSocketTransportLayer.this.state = WebSocketState.PN_WS_CONNECTED_FLOW;
            WebSocketTransportLayer.this.writePong();
            this.head.limit(WebSocketTransportLayer.this.outputBuffer.position());
            if (WebSocketTransportLayer.this.headClosed) {
                WebSocketTransportLayer.this.state = WebSocketState.PN_WS_FAILED;
                return -1;
            }
            return WebSocketTransportLayer.this.outputBuffer.position();
        }

        private int handleWsConnectedFlow() {
            WebSocketTransportLayer.this.underlyingOutputSize = this.underlyingOutput.pending();
            if (WebSocketTransportLayer.this.underlyingOutputSize > 0) {
                WebSocketTransportLayer.this.webSocketHeaderSize = WebSocketTransportLayer.this.webSocketHandler.calculateHeaderSize(WebSocketTransportLayer.this.underlyingOutputSize);
                return WebSocketTransportLayer.this.underlyingOutputSize + WebSocketTransportLayer.this.webSocketHeaderSize;
            }
            return WebSocketTransportLayer.this.underlyingOutputSize;
        }

        private int handleWsNotStarted() {
            if (WebSocketTransportLayer.this.outputBuffer.position() == 0) {
                WebSocketTransportLayer.this.state = WebSocketState.PN_WS_CONNECTING;
                WebSocketTransportLayer.this.writeUpgradeRequest();
                this.head.limit(WebSocketTransportLayer.this.outputBuffer.position());
                if (WebSocketTransportLayer.this.headClosed) {
                    WebSocketTransportLayer.this.state = WebSocketState.PN_WS_FAILED;
                    return -1;
                }
                return WebSocketTransportLayer.this.outputBuffer.position();
            }
            return WebSocketTransportLayer.this.outputBuffer.position();
        }

        public ByteBuffer head() {
            if (WebSocketTransportLayer.this.isWebSocketEnabled.booleanValue()) {
                switch (WebSocketTransportLayer.this.state) {
                    case PN_WS_CONNECTING: 
                    case PN_WS_CONNECTED_PONG: {
                        return this.head;
                    }
                    case PN_WS_CONNECTED_CLOSING: {
                        WebSocketTransportLayer.this.state = WebSocketState.PN_WS_CLOSED;
                        return this.head;
                    }
                    case PN_WS_CONNECTED_FLOW: {
                        WebSocketTransportLayer.this.underlyingOutputSize = this.underlyingOutput.pending();
                        if (WebSocketTransportLayer.this.underlyingOutputSize > 0) {
                            WebSocketTransportLayer.this.wrapBuffer(this.underlyingOutput.head(), WebSocketTransportLayer.this.outputBuffer);
                            WebSocketTransportLayer.this.webSocketHeaderSize = WebSocketTransportLayer.this.outputBuffer.position() - WebSocketTransportLayer.this.underlyingOutputSize;
                            this.head.limit(WebSocketTransportLayer.this.outputBuffer.position());
                        }
                        return this.head;
                    }
                }
                return this.underlyingOutput.head();
            }
            return this.underlyingOutput.head();
        }

        public void pop(int amount) {
            if (WebSocketTransportLayer.this.isWebSocketEnabled.booleanValue()) {
                switch (WebSocketTransportLayer.this.state) {
                    case PN_WS_CONNECTING: {
                        if (WebSocketTransportLayer.this.outputBuffer.position() != 0) {
                            WebSocketTransportLayer.this.outputBuffer.flip();
                            WebSocketTransportLayer.this.outputBuffer.position(amount);
                            WebSocketTransportLayer.this.outputBuffer.compact();
                            this.head.position(0);
                            this.head.limit(WebSocketTransportLayer.this.outputBuffer.position());
                            break;
                        }
                        this.underlyingOutput.pop(amount);
                        break;
                    }
                    case PN_WS_CONNECTED_FLOW: 
                    case PN_WS_CONNECTED_PONG: 
                    case PN_WS_CONNECTED_CLOSING: {
                        if (amount >= WebSocketTransportLayer.this.webSocketHeaderSize && WebSocketTransportLayer.this.outputBuffer.position() != 0) {
                            WebSocketTransportLayer.this.outputBuffer.flip();
                            WebSocketTransportLayer.this.outputBuffer.position(amount);
                            WebSocketTransportLayer.this.outputBuffer.compact();
                            this.head.position(0);
                            this.head.limit(WebSocketTransportLayer.this.outputBuffer.position());
                            this.underlyingOutput.pop(amount - WebSocketTransportLayer.this.webSocketHeaderSize);
                            WebSocketTransportLayer.this.webSocketHeaderSize = 0;
                            break;
                        }
                        if (amount > 0 && amount < WebSocketTransportLayer.this.webSocketHeaderSize) {
                            WebSocketTransportLayer.this.webSocketHeaderSize = WebSocketTransportLayer.this.webSocketHeaderSize - amount;
                            break;
                        }
                        this.underlyingOutput.pop(amount);
                        break;
                    }
                    case PN_WS_NOT_STARTED: 
                    case PN_WS_CLOSED: 
                    case PN_WS_FAILED: {
                        this.underlyingOutput.pop(amount);
                    }
                }
            } else {
                this.underlyingOutput.pop(amount);
            }
        }

        public void close_head() {
            this.underlyingOutput.close_head();
        }
    }

    public static enum WebSocketState {
        PN_WS_NOT_STARTED,
        PN_WS_CONNECTING,
        PN_WS_CONNECTED_FLOW,
        PN_WS_CONNECTED_PONG,
        PN_WS_CONNECTED_CLOSING,
        PN_WS_CLOSED,
        PN_WS_FAILED;

    }
}

