/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.engine.ws;

import com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.engine.ws.WebSocketHeader;
import java.nio.ByteBuffer;

class WebSocketHeaderParser {
    private ByteBuffer header = ByteBuffer.allocate(14);
    private int payloadLength;
    private byte opcode;
    private boolean maskedPayload;
    private int headerLength = 2;
    private int headerPayloadLengthSize;
    private byte[] mask = new byte[0];

    WebSocketHeaderParser() {
    }

    private void putNext(byte b) {
        this.header.put(b);
        if (this.header.position() == 1) {
            this.opcode = (byte)(b & 0xF);
        }
        if (this.header.position() == 2) {
            this.maskedPayload = (b & 0xFFFFFF80) != 0;
            byte tmpPayloadLength = (byte)(b & 0x7F);
            this.headerLength = this.headerPayloadLengthSize = this.headerLengthNoMask(tmpPayloadLength);
            if (this.maskedPayload) {
                this.headerLength += 4;
            }
            if (this.headerPayloadLengthSize == 2) {
                this.payloadLength = tmpPayloadLength;
            }
        }
        if (this.header.position() == this.headerPayloadLengthSize) {
            if (this.headerPayloadLengthSize == 4) {
                this.payloadLength = this.readPayloadLength(this.header, 2, 2);
            } else if (this.headerPayloadLengthSize == 10) {
                this.payloadLength = this.readPayloadLength(this.header, 2, 8);
            }
        }
        if (this.maskedPayload && this.header.position() == this.headerLength) {
            this.mask = new byte[4];
            this.header.position(this.header.position() - 4);
            this.header.get(this.mask);
        }
    }

    private int readPayloadLength(ByteBuffer buffer, int startPosition, int amount) {
        int result = 0;
        int shift = 0;
        int currentPos = startPosition + amount;
        while (currentPos > startPosition) {
            byte b = buffer.get(--currentPos);
            result |= (b & 0xFF) << shift;
            shift += 8;
        }
        return result;
    }

    public boolean parse(ByteBuffer buffer) {
        while (buffer.hasRemaining() && this.header.position() < this.headerLength) {
            this.putNext(buffer.get());
        }
        return this.isComplete();
    }

    public boolean isComplete() {
        return this.header.position() == this.headerLength;
    }

    public WebSocketHeader create() {
        if (this.isComplete()) {
            return new WebSocketHeader(this.opcode, this.payloadLength, this.mask);
        }
        return null;
    }

    private int headerLengthNoMask(byte payloadSize) {
        int size = 2;
        if (payloadSize > 0) {
            if (payloadSize == 126) {
                size = 4;
            } else if (payloadSize == 127) {
                size = 10;
            }
        }
        return size;
    }
}

