/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.engine.ws;

final class WebSocketHeader {
    static final byte MIN_HEADER_LENGTH = 2;
    static final byte MIN_HEADER_LENGTH_MASKED = 6;
    static final byte MED_HEADER_LENGTH_NOMASK = 4;
    static final byte MED_HEADER_LENGTH_MASKED = 8;
    static final byte MAX_HEADER_LENGTH_NOMASK = 10;
    static final byte MAX_HEADER_LENGTH_MASKED = 14;
    static final byte FINBIT_MASK = -128;
    static final byte OPCODE_MASK = 15;
    static final byte OPCODE_BINARY = 2;
    static final byte OPCODE_CLOSE = 8;
    static final byte OPCODE_PING = 9;
    static final byte OPCODE_PONG = 10;
    static final byte MASKBIT_MASK = -128;
    static final byte PAYLOAD_MASK = 127;
    static final byte FINAL_OPCODE_BINARY = -126;
    static final byte PAYLOAD_SHORT_MAX = 125;
    static final int PAYLOAD_MEDIUM_MAX = 65535;
    static final int PAYLOAD_LARGE_MAX = Integer.MAX_VALUE;
    static final byte PAYLOAD_EXTENDED_16 = 126;
    static final byte PAYLOAD_EXTENDED_64 = 127;
    private final int finalPayloadLength;
    private final byte[] mask;
    private final byte opcode;

    WebSocketHeader(byte opcode, int finalPayloadLength, byte[] mask) {
        this.opcode = opcode;
        this.mask = mask;
        this.finalPayloadLength = finalPayloadLength;
    }

    public int getFinalPayloadLength() {
        return this.finalPayloadLength;
    }

    public byte[] getMask() {
        return this.mask;
    }

    public byte getOpcode() {
        return this.opcode;
    }

    public boolean isMasked() {
        return this.mask != null && this.mask.length == 4;
    }
}

