/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.engine.ws;

import com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.engine.ws.WebSocketChunk;
import com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.engine.ws.WebSocketHeader;
import com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.engine.ws.WebSocketHeaderParser;
import com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.engine.ws.WebSocketMessageType;
import com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.engine.ws.WebSocketUpgrade;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;

class WebSocketHandler {
    private WebSocketUpgrade webSocketUpgrade = null;
    private final String host;
    private final String path;
    private final int port;
    private final String protocol;
    private final Map<String, String> additionalHeaders;
    private WebSocketChunk pendingChunk = null;
    private WebSocketHeaderParser pendingHeader = null;

    WebSocketHandler(String host, String path, int port, String protocol, Map<String, String> additionalHeaders) {
        this.host = host;
        this.path = path;
        this.port = port;
        this.protocol = protocol;
        this.additionalHeaders = additionalHeaders;
    }

    String createUpgradeRequest() {
        this.webSocketUpgrade = this.createWebSocketUpgrade(this.host, this.path, this.port, this.protocol, this.additionalHeaders);
        return this.webSocketUpgrade.createUpgradeRequest();
    }

    void createPong(ByteBuffer ping, ByteBuffer pong) {
        if (ping == null || pong == null) {
            throw new IllegalArgumentException("input parameter cannot be null");
        }
        if (ping.capacity() > pong.capacity()) {
            throw new IllegalArgumentException("insufficient output buffer size");
        }
        if (ping.remaining() > 0) {
            byte[] buffer = ping.array();
            buffer[0] = -118;
            pong.clear();
            pong.put(buffer);
        } else {
            pong.clear();
            pong.limit(0);
        }
    }

    boolean validateUpgradeReply(ByteBuffer buffer) {
        int size;
        boolean retVal = false;
        if (this.webSocketUpgrade != null && (size = buffer.remaining()) > 0) {
            byte[] data = new byte[buffer.remaining()];
            buffer.get(data);
            buffer.compact();
            retVal = this.webSocketUpgrade.validateUpgradeReply(data);
            this.webSocketUpgrade = null;
        }
        return retVal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void wrapBuffer(ByteBuffer srcBuffer, ByteBuffer dstBuffer) {
        if (srcBuffer == null || dstBuffer == null) {
            throw new IllegalArgumentException("input parameter is null");
        }
        if (srcBuffer.remaining() > 0) {
            int dataLength = srcBuffer.remaining();
            ByteArrayOutputStream webSocketFrame = new ByteArrayOutputStream(6 + dataLength);
            int firstByte = -126;
            webSocketFrame.write(firstByte);
            int secondByte = -128;
            if (dataLength <= 125) {
                secondByte = (byte)(secondByte | dataLength);
                webSocketFrame.write(secondByte);
            } else if (dataLength <= 65535) {
                secondByte = (byte)(secondByte | 0x7E);
                webSocketFrame.write(secondByte);
                webSocketFrame.write((byte)(dataLength >>> 8));
                webSocketFrame.write((byte)dataLength);
            } else {
                secondByte = (byte)(secondByte | 0x7F);
                webSocketFrame.write(secondByte);
                webSocketFrame.write((byte)(dataLength >>> 56));
                webSocketFrame.write((byte)(dataLength >>> 48));
                webSocketFrame.write((byte)(dataLength >>> 40));
                webSocketFrame.write((byte)(dataLength >>> 32));
                webSocketFrame.write((byte)(dataLength >>> 24));
                webSocketFrame.write((byte)(dataLength >>> 16));
                webSocketFrame.write((byte)(dataLength >>> 8));
                webSocketFrame.write((byte)dataLength);
            }
            byte[] maskingKey = this.createRandomMaskingKey();
            webSocketFrame.write(maskingKey, 0, 4);
            for (int i = 0; i < dataLength; ++i) {
                byte nextByte = srcBuffer.get();
                nextByte = (byte)(nextByte ^ maskingKey[i % 4]);
                webSocketFrame.write(nextByte);
            }
            dstBuffer.clear();
            if (dstBuffer.capacity() < webSocketFrame.size()) throw new IllegalStateException("insufficient output buffer size");
            dstBuffer.put(webSocketFrame.toByteArray());
            return;
        } else {
            dstBuffer.clear();
        }
    }

    private WebSocketHeader handleWsHeader(ByteBuffer srcBuffer) {
        if (this.pendingHeader != null) {
            if (this.pendingHeader.parse(srcBuffer)) {
                WebSocketHeader info = this.pendingHeader.create();
                this.pendingHeader = null;
                return info;
            }
        } else {
            if (srcBuffer.remaining() >= 14) {
                WebSocketHeaderParser parser = new WebSocketHeaderParser();
                parser.parse(srcBuffer);
                return parser.create();
            }
            this.pendingHeader = new WebSocketHeaderParser();
            if (this.pendingHeader.parse(srcBuffer)) {
                WebSocketHeader info = this.pendingHeader.create();
                this.pendingHeader = null;
                return info;
            }
        }
        return null;
    }

    List<WebSocketChunk> unwrapBuffer(ByteBuffer srcBuffer) {
        WebSocketChunk chunk;
        if (srcBuffer == null) {
            throw new IllegalArgumentException("input parameter is null");
        }
        if (srcBuffer.remaining() == 0) {
            return Collections.singletonList(WebSocketChunk.createEmpty());
        }
        ArrayList<WebSocketChunk> retVal = new ArrayList<WebSocketChunk>();
        while (srcBuffer.remaining() > 0 && (chunk = this.unwrapBufferInternal(srcBuffer, 0)) != null) {
            retVal.add(chunk);
        }
        return retVal;
    }

    private WebSocketChunk unwrapBufferInternal(ByteBuffer srcBuffer, int startPos) {
        if (this.pendingChunk != null) {
            return this.handlePendingChunk(srcBuffer);
        }
        WebSocketMessageType retVal = WebSocketMessageType.WEB_SOCKET_MESSAGE_TYPE_EMPTY;
        if (srcBuffer.remaining() >= 2) {
            WebSocketHeader header = this.handleWsHeader(srcBuffer);
            if (header == null) {
                return null;
            }
            if (header.getFinalPayloadLength() > srcBuffer.remaining()) {
                this.pendingChunk = WebSocketChunk.createPending(srcBuffer, header.getFinalPayloadLength(), header.getMask());
                return null;
            }
            if (retVal == WebSocketMessageType.WEB_SOCKET_MESSAGE_TYPE_EMPTY) {
                retVal = this.getMessageType(header.getOpcode());
                int newLimit = srcBuffer.position() + header.getFinalPayloadLength();
                if (srcBuffer.limit() > newLimit) {
                    // empty if block
                }
                WebSocketChunk c = WebSocketChunk.create(retVal, srcBuffer.slice(), header.getFinalPayloadLength(), header.getMask());
                srcBuffer.position(newLimit);
                return c;
            }
        }
        return WebSocketChunk.createEmpty();
    }

    private WebSocketMessageType getMessageType(byte opcode) {
        if (opcode == 2) {
            return WebSocketMessageType.WEB_SOCKET_MESSAGE_TYPE_AMQP;
        }
        if (opcode == 9) {
            return WebSocketMessageType.WEB_SOCKET_MESSAGE_TYPE_PING;
        }
        if (opcode == 8) {
            return WebSocketMessageType.WEB_SOCKET_MESSAGE_TYPE_CLOSE;
        }
        return WebSocketMessageType.WEB_SOCKET_MESSAGE_TYPE_INVALID;
    }

    private WebSocketChunk handlePendingChunk(ByteBuffer srcBuffer) {
        ByteBuffer pendingBuffer = this.pendingChunk.buffer;
        if (pendingBuffer.remaining() <= srcBuffer.remaining()) {
            byte[] tmp = new byte[pendingBuffer.remaining()];
            srcBuffer.get(tmp);
            pendingBuffer.put(tmp);
        } else {
            pendingBuffer.put(srcBuffer);
        }
        if (pendingBuffer.remaining() == 0) {
            pendingBuffer.flip();
            WebSocketChunk c = this.pendingChunk;
            this.pendingChunk = null;
            return c;
        }
        return null;
    }

    private WebSocketUpgrade createWebSocketUpgrade(String hostName, String webSocketPath, int webSocketPort, String webSocketProtocol, Map<String, String> additionalHeaders) {
        return new WebSocketUpgrade(hostName, webSocketPath, webSocketPort, webSocketProtocol, additionalHeaders);
    }

    private byte[] createRandomMaskingKey() {
        byte[] maskingKey = new byte[4];
        SecureRandom random = new SecureRandom();
        ((Random)random).nextBytes(maskingKey);
        return maskingKey;
    }

    int calculateHeaderSize(int payloadSize) {
        int retVal = 0;
        if (payloadSize > 0) {
            retVal = payloadSize <= 125 ? 6 : (payloadSize <= 65535 ? 8 : 14);
        }
        return retVal;
    }

    public String toString() {
        return "WebSocketHandler{webSocketUpgrade=" + this.webSocketUpgrade + ", host='" + this.host + '\'' + ", path='" + this.path + '\'' + ", port=" + this.port + ", protocol='" + this.protocol + '\'' + ", additionalHeaders=" + this.additionalHeaders + '}';
    }
}

