/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.engine.ws;

import com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.engine.ws.WebSocketMessageType;
import java.nio.ByteBuffer;

final class WebSocketChunk {
    protected static final byte[] EMPTY_MASK = new byte[0];
    final WebSocketMessageType type;
    final ByteBuffer buffer;
    final int payloadLen;
    final byte[] mask;

    WebSocketChunk(WebSocketMessageType type, ByteBuffer buffer, int payloadLen, byte[] mask) {
        this.type = type;
        this.buffer = buffer;
        this.mask = mask;
        this.buffer.limit(payloadLen);
        this.payloadLen = payloadLen;
    }

    WebSocketChunk(WebSocketMessageType type, ByteBuffer buffer, int payloadLen) {
        this(type, buffer, payloadLen, EMPTY_MASK);
    }

    ByteBuffer getUnmaskedData() {
        if (this.mask == null) {
            return this.buffer.duplicate();
        }
        ByteBuffer tmp = this.buffer.duplicate();
        int dataLength = tmp.remaining();
        ByteBuffer unmasked = ByteBuffer.allocateDirect(dataLength);
        for (int i = 0; i < dataLength; ++i) {
            byte nextByte = tmp.get();
            nextByte = (byte)(nextByte ^ this.mask[i % 4]);
            unmasked.put(nextByte);
        }
        unmasked.flip();
        return unmasked;
    }

    public static WebSocketChunk createEmpty() {
        return Instances.EMPTY;
    }

    static WebSocketChunk create(WebSocketMessageType type, ByteBuffer buffer, int payloadLen, byte[] mask) {
        return new WebSocketChunk(type, buffer, payloadLen, mask);
    }

    static WebSocketChunk createPending(ByteBuffer buffer, int payloadLen, byte[] mask) {
        ByteBuffer b = ByteBuffer.allocateDirect(payloadLen);
        b.put(buffer);
        return new WebSocketChunk(WebSocketMessageType.WEB_SOCKET_MESSAGE_TYPE_AMQP, b, payloadLen, mask);
    }

    public String toString() {
        return "WebSocketChunk{type=" + (Object)((Object)this.type) + ", payloadLen=" + this.payloadLen + '}';
    }

    private static final class Instances {
        private static final ByteBuffer BUFFER = ByteBuffer.wrap(new byte[0]);
        private static final WebSocketChunk EMPTY = new WebSocketChunk(WebSocketMessageType.WEB_SOCKET_MESSAGE_TYPE_EMPTY, BUFFER, 0);

        private Instances() {
        }
    }
}

