/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.engine.ssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.UUID;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SslHelper {
    private static final String CERT_BEGIN_BOUND = "-----BEGIN CERTIFICATE-----";
    private static final String CERT_END_BOUND = "-----END CERTIFICATE-----";

    public static SSLContext getSslContext() throws IOException {
        try {
            return SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("Exception occurred during creation of default SSL Context" + e.getMessage());
        }
    }

    public static SSLContext getSslContext(String cert) throws IOException {
        return SslHelper.getSslContext(cert, true);
    }

    public static SSLContext getSslContext(boolean verify) throws IOException {
        return SslHelper.getSslContext(null, verify);
    }

    private static SSLContext getSslContext(String cert, boolean verify) throws IOException {
        try {
            char[] pwd = SslHelper.getRandomPw();
            KeyStore keyStore = SslHelper.createKeyStore(cert, pwd);
            String protocol = "TLS";
            SSLContext ctx = SSLContext.getInstance(protocol);
            KeyManager[] keyManagers = SslHelper.createKeyManagers(keyStore, pwd);
            TrustManager[] tm = verify ? SslHelper.createTrustManagers(keyStore) : SslHelper.createTrustAllManagers();
            ctx.init(keyManagers, tm, null);
            return ctx;
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Failed to initialize SSL Context", e);
        }
    }

    private static TrustManager[] createTrustManagers(KeyStore keyStore) throws GeneralSecurityException {
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(keyStore);
        return tmf.getTrustManagers();
    }

    private static TrustManager[] createTrustAllManagers() {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
    }

    private static KeyManager[] createKeyManagers(KeyStore keyStore, char[] keyPass) throws GeneralSecurityException {
        String alg = KeyManagerFactory.getDefaultAlgorithm();
        KeyManagerFactory fac = KeyManagerFactory.getInstance(alg);
        fac.init(keyStore, keyPass);
        return fac.getKeyManagers();
    }

    private static char[] getRandomPw() {
        return UUID.randomUUID().toString().toCharArray();
    }

    private static KeyStore createKeyStore(String cert, char[] keyStorePw) {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, keyStorePw);
            if (cert != null) {
                SslHelper.addCertificateToKeyStore(keyStore, cert);
            }
            return keyStore;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create KeyStore", e);
        }
    }

    private static void addCertificateToKeyStore(KeyStore keyStore, String cert) {
        try {
            String name = "cert";
            keyStore.setCertificateEntry(name, SslHelper.convertContent(cert));
        }
        catch (KeyStoreException | CertificateException e) {
            throw new IllegalStateException("Failed to add certificate to KeyStore", e);
        }
    }

    private static Certificate convertContent(String content) throws CertificateException {
        if (!content.startsWith(CERT_BEGIN_BOUND)) {
            content = "-----BEGIN CERTIFICATE-----\r\n" + content;
        }
        if (!content.endsWith(CERT_END_BOUND)) {
            content = content + "\r\n-----END CERTIFICATE-----";
        }
        CertificateFactory instance = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream bin = new ByteArrayInputStream(content.getBytes(StandardCharsets.ISO_8859_1));
        return instance.generateCertificate(bin);
    }
}

