/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.engine.proxy;

import com.sap.cloud.servicesdk.xbem.adapter.amqp10.MessagingServiceImpl;
import com.sap.cloud.servicesdk.xbem.api.MessagingServiceVersion;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.qpid.proton.engine.TransportException;
import org.apache.qpid.proton.engine.impl.TransportInput;
import org.apache.qpid.proton.engine.impl.TransportLayer;
import org.apache.qpid.proton.engine.impl.TransportOutput;
import org.apache.qpid.proton.engine.impl.TransportWrapper;

public class ProxyTransportLayer
implements TransportLayer {
    private static final String USER_AGENT;
    private final String targetHost;
    private final int targetPort;
    private final ByteBuffer inBuffer = ByteBuffer.allocate(8192);
    private final ByteBuffer outBuffer = ByteBuffer.allocate(8192);

    public ProxyTransportLayer(String targetHost, int targetPort) {
        this.targetHost = targetHost;
        this.targetPort = targetPort;
    }

    public TransportWrapper wrap(TransportInput input, TransportOutput output) {
        return new ProxyTransportWrapper(input, output);
    }

    static {
        MessagingServiceVersion v = MessagingServiceImpl.getMessagingServiceVersion();
        USER_AGENT = v.getProductInfo() + " " + v.getRuntimeInfo();
    }

    private class ProxyTransportWrapper
    implements TransportWrapper {
        private static final String CRLF = "\r\n";
        private final TransportInput underlyingInput;
        private final TransportOutput underlyingOutput;
        private final ByteBuffer head;
        private State state = State.NOT_STARTED;
        private boolean closed = false;

        private ProxyTransportWrapper(TransportInput input, TransportOutput output) {
            this.underlyingInput = input;
            this.underlyingOutput = output;
            this.head = ProxyTransportLayer.this.outBuffer.asReadOnlyBuffer();
            this.head.limit(0);
        }

        private String createConnectRequest(String host, int port) {
            String uri = host + ":" + port;
            return "CONNECT " + uri + " HTTP/1.1" + CRLF + "User-Agent: " + USER_AGENT + CRLF + "Host: " + host + CRLF + "Proxy-Connection: keep-alive" + CRLF + CRLF;
        }

        public int capacity() {
            if (this.closed) {
                return -1;
            }
            if (this.state != State.CONNECTED) {
                return ProxyTransportLayer.this.inBuffer.remaining();
            }
            return this.underlyingInput.capacity();
        }

        public int position() {
            if (this.closed) {
                return -1;
            }
            if (this.state != State.CONNECTED) {
                return ProxyTransportLayer.this.inBuffer.position();
            }
            return this.underlyingInput.position();
        }

        public ByteBuffer tail() {
            if (this.state != State.CONNECTED) {
                return ProxyTransportLayer.this.inBuffer;
            }
            return this.underlyingInput.tail();
        }

        public void process() {
            if (this.state != State.CONNECTED) {
                this.handleProcess();
            } else {
                this.underlyingInput.process();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void handleProcess() {
            if (this.state == State.CONNECTING) {
                ProxyTransportLayer.this.inBuffer.flip();
                int size = ProxyTransportLayer.this.inBuffer.remaining();
                if (size <= 0) throw new TransportException("No proxy connect response data available.");
                byte[] data = new byte[size];
                ProxyTransportLayer.this.inBuffer.get(data);
                ProxyTransportLayer.this.inBuffer.compact();
                this.validateConnectResponse(data);
                this.state = State.CONNECTED;
                return;
            } else {
                if (this.state != State.CONNECTED) return;
                throw new TransportException("Proxy connection already establish.");
            }
        }

        private void validateConnectResponse(byte[] response) {
            String httpString = new String(response, StandardCharsets.ISO_8859_1);
            String[] statusLineParts = httpString.trim().split(" ", 4);
            if (statusLineParts.length >= 4) {
                String statusCode = statusLineParts[1];
                String statusDesc = statusLineParts[2] + " " + statusLineParts[3];
                if (!statusCode.equals("200")) {
                    throw new TransportException("Got invalid status code '" + statusCode + "' for connect response: " + httpString);
                }
                if (!statusDesc.equals("Connection established")) {
                    throw new TransportException("Got invalid status description '" + statusDesc + "' for connect response: " + httpString);
                }
            } else {
                throw new TransportException("Got invalid connect response: " + httpString);
            }
        }

        public void close_tail() {
            this.closed = true;
            this.underlyingInput.close_tail();
        }

        public int pending() {
            if (this.state != State.CONNECTED) {
                return this.handlePending();
            }
            return this.underlyingOutput.pending();
        }

        private int handlePending() {
            if (this.state == State.NOT_STARTED) {
                ProxyTransportLayer.this.outBuffer.clear();
                String request = this.createConnectRequest(ProxyTransportLayer.this.targetHost, ProxyTransportLayer.this.targetPort);
                ProxyTransportLayer.this.outBuffer.put(request.getBytes(StandardCharsets.ISO_8859_1));
                this.state = State.CONNECTING;
                this.head.limit(ProxyTransportLayer.this.outBuffer.position());
                return this.head.limit();
            }
            return ProxyTransportLayer.this.outBuffer.position();
        }

        public ByteBuffer head() {
            if (this.state != State.CONNECTED) {
                return this.head;
            }
            return this.underlyingOutput.head();
        }

        public void pop(int bytes) {
            if (this.state == State.CONNECTING) {
                if (ProxyTransportLayer.this.outBuffer.position() != 0) {
                    ProxyTransportLayer.this.outBuffer.flip();
                    ProxyTransportLayer.this.outBuffer.position(bytes);
                    ProxyTransportLayer.this.outBuffer.compact();
                    this.head.position(0);
                    this.head.limit(ProxyTransportLayer.this.outBuffer.position());
                } else {
                    this.underlyingOutput.pop(bytes);
                }
            } else {
                this.underlyingOutput.pop(bytes);
            }
        }

        public void close_head() {
            this.underlyingOutput.close_head();
        }
    }

    private static enum State {
        NOT_STARTED,
        CONNECTING,
        CONNECTED;

    }
}

