/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.engine.oauth;

import com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.engine.AuthSettings;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthHandler {
    private static final Logger LOG = LoggerFactory.getLogger(OAuthHandler.class);
    private static final String OAUTH_PASSWORD_FLOW_BODY_TEMPLATE = "username=%s&password=%s&grant_type=password&response_type=token";
    private static final String OAUTH_CLIENT_FLOW_BODY_TEMPLATE = "client_id=%s&client_secret=%s&grant_type=client_credentials&response_type=token";
    public static final String XBEM_OA2_FLOW = "xbem_oa2_flow";
    public static final String XBEM_OA2_ENDPOINT = "xbem_oa2_endpoint";
    public static final String XBEM_OA2_USER = "xbem_oa2_user";
    public static final String XBEM_OA2_PWD = "xbem_oa2_pwd";
    public static final String XBEM_OA2_CLIENT = "xbem_oa2_client";
    public static final String XBEM_OA2_SECRET = "xbem_oa2_secret";
    public static final String CLIENT_CREDENTIALS_GRANT = "client_credentials";
    public static final String PASSWORD_GRANT = "password";
    public static final String AUTH_BEARER = "Bearer ";
    public static final String ACCEPT_HEADER = "Accept";
    public static final String CONTENT_TYPE_HEADER = "Content-Type";
    public static final String APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final String APPLICATION_JSON = "application/json";
    public static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String HTTP_METHOD_POST = "POST";
    private static final String OAUTH_TOKEN_URL_POSTFIX = "/oauth/token";
    private static final String AUTH_BASIC = "Basic ";
    private static final int BUFFER_SIZE = 65536;
    private static final int MAX_READ_SIZE = 655360;
    private final AuthSettings authSettings;

    public OAuthHandler(AuthSettings authSettings) {
        this.authSettings = authSettings;
    }

    public String doTokenRequest() throws IOException {
        String oauthFlow = this.authSettings.getoAuthGrantType();
        if (PASSWORD_GRANT.equalsIgnoreCase(oauthFlow)) {
            throw new UnsupportedOperationException("Found unknown 'xbem_oa2_flow' value: " + oauthFlow);
        }
        if (CLIENT_CREDENTIALS_GRANT.equalsIgnoreCase(oauthFlow)) {
            String url = this.authSettings.getoAuthEndpoint();
            String clientId = this.authSettings.getoAuthClientId();
            String clientSecret = this.authSettings.getoAuthClientSecret();
            return AUTH_BEARER + this.doTokenRequestClientFlow(url, clientId, clientSecret);
        }
        throw new IllegalStateException("Found unknown 'xbem_oa2_flow' value: " + oauthFlow);
    }

    private String doTokenRequestClientFlow(String url, String clientId, String clientSecret) throws IOException {
        LOG.trace("Start doTokenRequestXsuaa:: {}", (Object)url);
        String body = String.format(OAUTH_CLIENT_FLOW_BODY_TEMPLATE, clientId, clientSecret);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(CONTENT_TYPE_HEADER, APPLICATION_X_WWW_FORM_URLENCODED);
        headers.put(ACCEPT_HEADER, APPLICATION_JSON);
        String cid = clientId + ":" + clientSecret;
        String b64 = Base64.getEncoder().encodeToString(cid.getBytes(StandardCharsets.ISO_8859_1));
        headers.put(AUTHORIZATION_HEADER, AUTH_BASIC + b64);
        String postUrl = url + "?grant_type=client_credentials";
        String response = this.post(postUrl, body, headers);
        return this.extractToken(response);
    }

    String extractToken(String response) throws IOException {
        int index = response.indexOf("\"access_token\"");
        int tokenIndex = response.indexOf("\"", index + 14) + 1;
        int lastTokenIndex = response.indexOf("\"", tokenIndex);
        if (index <= 0 || lastTokenIndex <= tokenIndex) {
            throw new IOException("Unable to extract access_token from response: " + response);
        }
        return response.substring(tokenIndex, lastTokenIndex);
    }

    /*
     * Exception decompiling
     */
    private String post(String url, String content, Map<String, String> additionalHeaders) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private HttpURLConnection openConnection(String url) throws IOException {
        URL urly = new URL(url);
        Proxy proxy = this.getProxy();
        HttpURLConnection con = proxy == null ? (HttpURLConnection)urly.openConnection() : (HttpURLConnection)urly.openConnection(proxy);
        if (con instanceof HttpsURLConnection) {
            LOG.trace("Configure HTTPS connection.");
            ((HttpsURLConnection)con).setHostnameVerifier((h, s) -> Boolean.TRUE);
        }
        return con;
    }

    private Proxy getProxy() {
        String portParam;
        String host = this.authSettings.getProxyHost();
        int port = this.authSettings.getProxyPort();
        if (host == null && System.getProperty("http.proxyHost") != null) {
            host = System.getProperty("http.proxyHost");
            portParam = System.getProperty("http.proxyPort");
            port = Integer.parseInt(portParam);
        }
        if (host == null && System.getProperty("https.proxyHost") != null) {
            host = System.getProperty("https.proxyHost");
            portParam = System.getProperty("https.proxyPort");
            port = Integer.parseInt(portParam);
        }
        if (host != null && port >= 1) {
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
        }
        return null;
    }

    private String handleResponse(HttpURLConnection con) throws IOException {
        int responseCode = con.getResponseCode();
        if (!this.is2xx(responseCode)) {
            String message = String.format("Got a none 2xx response code '%s'.", responseCode);
            if (LOG.isTraceEnabled()) {
                LOG.trace(message + " Used token endpoint: " + con.getURL());
            } else {
                LOG.warn(message);
            }
            throw new IOException(message);
        }
        return this.readResponseBody(con);
    }

    /*
     * Exception decompiling
     */
    private String readResponseBody(HttpURLConnection con) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Charset getCharset(HttpURLConnection connection) {
        String contentTypeHeader = connection.getHeaderField(CONTENT_TYPE_HEADER);
        if (contentTypeHeader != null) {
            String contentTypeHeaderLc = contentTypeHeader.toLowerCase(Locale.US);
            if (contentTypeHeaderLc.contains("utf-8")) {
                return StandardCharsets.UTF_8;
            }
            if (contentTypeHeaderLc.contains("iso-8859-1")) {
                return StandardCharsets.ISO_8859_1;
            }
        }
        return StandardCharsets.US_ASCII;
    }

    private boolean is2xx(int responseCode) {
        return responseCode >= 200 && responseCode < 300;
    }
}

