/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.engine;

import com.sap.cloud.servicesdk.xbem.adapter.amqp10.MessagingServiceImpl;
import com.sap.cloud.servicesdk.xbem.api.MessagingRuntimeException;
import com.sap.cloud.servicesdk.xbem.api.MessagingServiceVersion;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.engine.Collector;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;

public class MessageEndpointFactory {
    private static final UnsignedLong DEFAULT_SENDER_MAX_MESSAGE_SIZE = UnsignedLong.valueOf((long)0x1000000L);
    private static final UnsignedLong DEFAULT_RECEIVER_MAX_MESSAGE_SIZE = UnsignedLong.valueOf((long)0x1000000L);
    private static final Map<Symbol, Object> VERSION_PROPERTIES;
    private final Collector collector;
    private final LinkConstructor<Sender> outgoingConstructor = this::newOutgoing;
    private final LinkConstructor<Receiver> incomingConstructor = this::newIncoming;

    MessageEndpointFactory(Collector collector) {
        this.collector = collector;
    }

    private <T extends Link> T createLink(String clientId, String connectionUrl, String remoteAddress, String localAddress, LinkConstructor<T> constructor) {
        Connection connection = Connection.Factory.create();
        connection.collect(this.collector);
        connection.setContainer(this.generateContainerId(clientId));
        connection.setHostname(connectionUrl);
        connection.setProperties(VERSION_PROPERTIES);
        connection.open();
        Session session = connection.session();
        session.open();
        T link = constructor.create(session, remoteAddress, localAddress);
        link.open();
        return link;
    }

    private String generateContainerId(String prefix) {
        return prefix + "-" + UUID.randomUUID().toString().substring(24);
    }

    Sender outgoing(String clientId, String connectionUrl, String remoteTargetAddress) {
        return this.createLink(clientId, connectionUrl, remoteTargetAddress, null, this.outgoingConstructor);
    }

    Receiver incoming(String clientId, String connectionUrl, String remoteSourceAddress) {
        return this.createLink(clientId, connectionUrl, remoteSourceAddress, null, this.incomingConstructor);
    }

    private Sender newOutgoing(Session session, String remoteAddress, String localAddress) {
        Sender sender = session.sender(this.generateLinkName(localAddress, remoteAddress));
        sender.setMaxMessageSize(DEFAULT_RECEIVER_MAX_MESSAGE_SIZE);
        Source source = new Source();
        source.setAddress(localAddress);
        sender.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
        Target target = new Target();
        target.setAddress(remoteAddress);
        sender.setTarget((org.apache.qpid.proton.amqp.transport.Target)target);
        return sender;
    }

    private String generateLinkName(String localAddress, String remoteAddress) {
        if (remoteAddress == null && localAddress == null) {
            throw new MessagingRuntimeException("At least one of local/remote address must not be NULL.");
        }
        if (remoteAddress == null) {
            return String.format("L::%s", localAddress);
        }
        if (localAddress == null) {
            return String.format("R::%s", remoteAddress);
        }
        return String.format("L::%s_R::%s", localAddress, remoteAddress);
    }

    private Receiver newIncoming(Session session, String remoteAddress, String localAddress) {
        Receiver receiver = session.receiver(this.generateLinkName(localAddress, remoteAddress));
        receiver.setMaxMessageSize(DEFAULT_SENDER_MAX_MESSAGE_SIZE);
        Source source = new Source();
        source.setAddress(remoteAddress);
        receiver.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
        Target target = new Target();
        target.setAddress(localAddress);
        receiver.setTarget((org.apache.qpid.proton.amqp.transport.Target)target);
        return receiver;
    }

    static {
        HashMap<Symbol, String> props = new HashMap<Symbol, String>();
        MessagingServiceVersion msv = MessagingServiceImpl.getMessagingServiceVersion();
        props.put(Symbol.getSymbol((String)"platform"), msv.getRuntimeName() + "_" + msv.getRuntimeVersion());
        props.put(Symbol.getSymbol((String)"product"), msv.getProductName());
        props.put(Symbol.getSymbol((String)"version"), msv.getProductVersion());
        VERSION_PROPERTIES = Collections.unmodifiableMap(props);
    }

    static interface LinkConstructor<T extends Link> {
        public T create(Session var1, String var2, String var3);
    }
}

