/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.engine;

import com.sap.cloud.servicesdk.xbem.adapter.amqp10.AmqpMessagingEndpoint;
import com.sap.cloud.servicesdk.xbem.adapter.amqp10.AmqpProperty;
import com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.engine.AmqpMessagingUtils;
import com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.engine.AuthSettings;
import com.sap.cloud.servicesdk.xbem.api.MessagingException;
import com.sap.cloud.servicesdk.xbem.api.MessagingRuntimeException;
import com.sap.cloud.servicesdk.xbem.api.MessagingService;
import com.sap.cloud.servicesdk.xbem.api.MessagingSetting;

public final class MessageConfig {
    static final Integer DEFAULT_CONNECTION_TIMEOUT_MS = 30000;
    static final Integer DEFAULT_MAX_MESSAGES_IN_FLOW = 3000;
    private String connectionUrl;
    private String endpointAddress;
    private AuthSettings authSettings;
    private String username;
    private String password;
    private String proxyHost;
    private int proxyPort = -1;
    private MessagingSetting.MessagingReliableMode messagingReliableMode;
    private int messageGetWaitTimeInMs;
    private int initialConnectionTimeoutMs;
    private int maxMessagesInFlow;

    private MessageConfig() {
    }

    public static Builder init(String connectionUrl, String endpointAddress) {
        return new Builder(connectionUrl, endpointAddress);
    }

    public static Builder forReceiver(MessagingService.Config config, AmqpMessagingEndpoint endpoint) {
        Builder b = MessageConfig.from(config, endpoint);
        int connectionTimeout = (Integer)config.getSetting(MessagingService.Setting.RECEIVER_TIMEOUT_MS, (Object)DEFAULT_CONNECTION_TIMEOUT_MS);
        b.initialConnectionTimeout(connectionTimeout);
        return b;
    }

    public static Builder forSender(MessagingService.Config config, AmqpMessagingEndpoint endpoint) {
        Builder b = MessageConfig.from(config, endpoint);
        b.initialConnectionTimeout((Integer)config.getSetting(MessagingService.Setting.SENDER_TIMEOUT_MS, (Object)DEFAULT_CONNECTION_TIMEOUT_MS));
        b.maxFlow((Integer)config.getSetting(AmqpProperty.Setting.MAX_FLOW, (Object)DEFAULT_MAX_MESSAGES_IN_FLOW));
        return b;
    }

    private static Builder from(MessagingService.Config config, AmqpMessagingEndpoint endpoint) {
        String proxy;
        String qos;
        Builder builder = new Builder(config.getServiceUrl(), endpoint.getAddress());
        if (!config.isDaemonMode()) {
            builder.waitTimeInMs(config.getConsumerWaitTime());
        }
        if (config.getUser() != null) {
            builder.credentials(config.getUser(), config.getPassword());
        }
        if ((qos = (String)config.getSetting(MessagingService.Setting.MESSAGE_RELIABLE_MODE)) != null) {
            builder.qos(qos);
        }
        if ((proxy = (String)config.getSetting(MessagingService.Setting.MESSAGING_WS_PROXY)) != null) {
            AmqpMessagingUtils.ProxySetting proxySetting = AmqpMessagingUtils.createProxySetting(proxy).orElseThrow(() -> new IllegalArgumentException("Unable to parse proxy setting value: '" + proxy + "'"));
            builder.wsProxy(proxySetting.host, proxySetting.port);
        }
        builder.authSettings(AuthSettings.createFrom(config)).initialConnectionTimeout(DEFAULT_CONNECTION_TIMEOUT_MS);
        return builder;
    }

    public int getMaxMessagesInFlow() {
        return this.maxMessagesInFlow;
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public String getEndpointAddress() {
        return this.endpointAddress;
    }

    public AuthSettings getAuthSettings() {
        return this.authSettings;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int getMessageGetWaitTimeInMs() {
        return this.messageGetWaitTimeInMs;
    }

    public MessagingSetting.MessagingReliableMode getMessagingReliableMode() {
        return this.messagingReliableMode;
    }

    public int getInitialConnectionTimeoutMs() {
        return this.initialConnectionTimeoutMs;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public static class Builder {
        private MessageConfig config = new MessageConfig();

        public Builder(String connectionUrl, String endpointAddress) {
            this.config.connectionUrl = connectionUrl;
            this.config.endpointAddress = endpointAddress;
        }

        public MessageConfig create() throws MessagingException {
            if (this.config.connectionUrl == null) {
                throw new MessagingException("Mandatory Connection URI is missing.");
            }
            if (this.config.endpointAddress == null) {
                throw new MessagingException("Mandatory Endpoint address is missing.");
            }
            return this.config;
        }

        public Builder endpointAddress(String address) {
            this.config.endpointAddress = address;
            return this;
        }

        public Builder waitTimeInMs(int waitTimeInMs) {
            this.config.messageGetWaitTimeInMs = waitTimeInMs;
            return this;
        }

        public Builder qos(String qos) {
            this.config.messagingReliableMode = MessagingSetting.MessagingReliableMode.fromOr((String)qos, null);
            if (this.config.messagingReliableMode == null) {
                throw new MessagingRuntimeException("Invalid QOS value: " + qos);
            }
            return this;
        }

        public Builder authSettings(AuthSettings authSettings) {
            this.config.authSettings = authSettings;
            return this;
        }

        public Builder credentials(String username, String password) {
            this.config.username = username;
            this.config.password = password;
            return this;
        }

        public Builder initialConnectionTimeout(int timeoutInMs) {
            this.config.initialConnectionTimeoutMs = timeoutInMs;
            return this;
        }

        public Builder maxFlow(int maxFlow) {
            this.config.maxMessagesInFlow = maxFlow;
            return this;
        }

        public Builder wsProxy(String host, int port) {
            this.config.proxyHost = host;
            this.config.proxyPort = port;
            return this;
        }
    }
}

