/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.engine;

import com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.MessagingAmqpConnectionException;
import com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.MessagingAmqpException;
import com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.engine.AuthSettings;
import com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.engine.MessageConfig;
import com.sap.cloud.servicesdk.xbem.api.MessagingException;
import com.sap.cloud.servicesdk.xbem.api.MessagingSetting;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Link;

public abstract class MessageBaseHandler
extends BaseHandler {
    private static final boolean FAIL_ON_MISSING_REMOTE_CLOSE = false;
    public static final String ERROR_CONDITION_DESC_CONNECTION_ABORTED = "connection aborted";
    protected final String connectionUrl;
    protected final String endpoint;
    protected MessagingSetting.MessagingReliableMode messagingReliableMode;
    protected AuthSettings authSettings;
    protected String username;
    protected String password;
    protected String proxyHost;
    protected int proxyPort = -1;
    protected int initialConnectionTimeoutMs = 30000;
    private final String name;
    private CountDownLatch waitForCloseEvent;
    protected MessagingException lastError;
    protected boolean connectionUnboundEvent = false;
    protected boolean connectionRemoteCloseEvent = false;
    protected boolean connectionLocalClosed = false;

    protected MessageBaseHandler(String connectionUrl, String endpoint) {
        this(null, connectionUrl, endpoint);
    }

    protected MessageBaseHandler(String name, String connectionUrl, String endpoint) {
        if (name == null) {
            name = ((Object)((Object)this)).getClass().getSimpleName();
        }
        this.name = name;
        this.connectionUrl = connectionUrl;
        this.endpoint = endpoint;
    }

    protected String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public abstract boolean isConnected();

    public abstract boolean isClosed();

    public abstract void connect() throws MessagingException;

    protected void initBaseConfig(MessageConfig config) {
        this.authSettings = config.getAuthSettings();
        this.initialConnectionTimeoutMs = config.getInitialConnectionTimeoutMs();
        this.username = config.getUsername();
        this.password = config.getPassword();
        this.messagingReliableMode = config.getMessagingReliableMode();
        this.proxyHost = config.getProxyHost();
        this.proxyPort = config.getProxyPort();
    }

    void updateLinkReliableMode(Link link) {
        if (this.messagingReliableMode == MessagingSetting.MessagingReliableMode.AT_MOST_ONCE) {
            link.setSenderSettleMode(SenderSettleMode.SETTLED);
            link.setReceiverSettleMode(ReceiverSettleMode.FIRST);
        } else if (this.messagingReliableMode == MessagingSetting.MessagingReliableMode.AT_LEAST_ONCE) {
            link.setSenderSettleMode(SenderSettleMode.UNSETTLED);
            link.setReceiverSettleMode(ReceiverSettleMode.FIRST);
        } else if (this.messagingReliableMode == MessagingSetting.MessagingReliableMode.EXACTLY_ONCE) {
            link.setSenderSettleMode(SenderSettleMode.UNSETTLED);
            link.setReceiverSettleMode(ReceiverSettleMode.SECOND);
        }
    }

    public abstract boolean isActive();

    protected void close(long time, TimeUnit unit) throws MessagingException {
        if (this.lastError != null) {
            throw this.lastError;
        }
        if (this.waitForCloseEvent != null) {
            throw new IllegalStateException("Close was already called.");
        }
        if (this.connectionUnboundEvent || this.connectionRemoteCloseEvent) {
            return;
        }
        this.waitForCloseEvent = new CountDownLatch(1);
        try {
            if (this.waitForCloseEvent.await(time, unit)) {
                return;
            }
            if (!this.connectionLocalClosed) {
                throw new MessagingException("Timeout (" + unit.toMillis(time) + "ms) during close (no close event received ('onConnectionLocalClose'))");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void onConnectionUnbound(Event e) {
        EndpointState state;
        this.connectionUnboundEvent = true;
        if (this.waitForCloseEvent != null) {
            this.waitForCloseEvent.countDown();
        }
        if ((state = e.getConnection().getLocalState()) == EndpointState.ACTIVE) {
            if (this.isConnected()) {
                ErrorCondition condition = new ErrorCondition();
                condition.setDescription("Unexpected connection unbound");
                this.lastError = new MessagingAmqpException("TransportError occurred: " + condition.getDescription(), condition);
            }
            if (this.isActive()) {
                try {
                    this.close(500L, TimeUnit.MILLISECONDS);
                }
                catch (MessagingException closeException) {
                    this.lastError = closeException;
                }
            }
        }
    }

    public void onConnectionRemoteClose(Event event) {
        this.connectionRemoteCloseEvent = true;
        Connection connection = event.getConnection();
        ErrorCondition condition = connection.getRemoteCondition();
        if (this.isErrorOccurred(condition)) {
            this.lastError = new MessagingAmqpException("Error occurred (" + condition.getCondition() + "): " + condition.getDescription(), condition);
        }
        if (this.waitForCloseEvent != null) {
            this.waitForCloseEvent.countDown();
        }
    }

    public void onConnectionLocalClose(Event e) {
        this.connectionLocalClosed = true;
    }

    public void onTransportError(Event event) {
        ErrorCondition condition = event.getTransport().getCondition();
        if (condition == null) {
            condition = new ErrorCondition();
            condition.setDescription("(no description returned)");
        }
        if (this.isConnectionAbortedError(condition)) {
            this.lastError = new MessagingAmqpConnectionException("Connection lost due transport error.", condition);
            this.logError("TransportError occurred, desc=[%s], detail=[%s]", condition.getDescription(), condition.getCondition() == null ? "<no detail available>" : condition.getCondition().toString());
        } else {
            this.lastError = new MessagingAmqpException("TransportError occurred: " + condition.getDescription(), condition);
            this.logError("TransportError occurred, desc=[%s], detail=[%s]", condition.getDescription(), condition.getCondition() == null ? "<no detail available>" : condition.getCondition().toString());
        }
    }

    private boolean isConnectionAbortedError(ErrorCondition condition) {
        return ERROR_CONDITION_DESC_CONNECTION_ABORTED.equals(condition.getDescription());
    }

    private boolean isErrorOccurred(ErrorCondition condition) {
        return condition != null && condition.getCondition() != null;
    }

    protected abstract void logError(String var1, Object ... var2);
}

