/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.engine;

import com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.engine.AmqpMessagingUtils;
import com.sap.cloud.servicesdk.xbem.api.MessagingService;
import com.sap.cloud.servicesdk.xbem.api.MessagingSetting;

public class AuthSettings {
    private static final Boolean DEFAULT_SSL_NO_VERIFY = false;
    private static final AuthSettings DEFAULT_SETTINGS = new AuthSettings();
    private static final MessagingSetting<String> AUTH_GRANT_TYPE = MessagingSetting.create((String)"AUTH_GRANT_TYPE", String.class);
    private String authHeader;
    private String oAuthGrantType;
    private String oAuthClientId;
    private String oAuthClientSecret;
    private String oAuthEndpoint;
    private String sslCertificate;
    private boolean sslVerify = DEFAULT_SSL_NO_VERIFY == false;
    private String proxyHost;
    private int proxyPort;

    private AuthSettings() {
    }

    public static AuthSettings createDefault() {
        return DEFAULT_SETTINGS;
    }

    public static AuthSettings createFrom(MessagingService.Config config) {
        AuthSettings as = new AuthSettings();
        as.authHeader = (String)config.getSetting(MessagingService.Setting.AUTH_SERVICE_CONNECTION_HEADER);
        as.oAuthGrantType = (String)config.getSetting(AUTH_GRANT_TYPE, (Object)"client_credentials");
        as.oAuthClientId = (String)config.getSetting(MessagingService.Setting.AUTH_CLIENT_ID);
        as.oAuthClientSecret = (String)config.getSetting(MessagingService.Setting.AUTH_CLIENT_SECRET);
        as.oAuthEndpoint = (String)config.getSetting(MessagingService.Setting.AUTH_ENDPOINT);
        as.sslCertificate = (String)config.getSetting(MessagingService.Setting.SSL_CERTIFICATE);
        as.sslVerify = (Boolean)config.getSetting(MessagingService.Setting.SSL_NO_VERIFY, (Object)DEFAULT_SSL_NO_VERIFY) == false;
        String proxy = (String)config.getSetting(MessagingService.Setting.MESSAGING_WS_PROXY);
        if (proxy != null) {
            AmqpMessagingUtils.ProxySetting proxySetting = AmqpMessagingUtils.createProxySetting(proxy).orElseThrow(() -> new IllegalArgumentException("Unable to parse proxy setting value: '" + proxy + "'"));
            as.proxyHost = proxySetting.host;
            as.proxyPort = proxySetting.port;
        }
        return as;
    }

    public String getAuthHeader() {
        return this.authHeader;
    }

    public String getoAuthGrantType() {
        return this.oAuthGrantType;
    }

    public String getoAuthClientId() {
        return this.oAuthClientId;
    }

    public String getoAuthClientSecret() {
        return this.oAuthClientSecret;
    }

    public String getoAuthEndpoint() {
        return this.oAuthEndpoint;
    }

    public String getSslCertificate() {
        return this.sslCertificate;
    }

    public boolean isSslVerify() {
        return this.sslVerify;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }
}

