/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.engine;

import com.sap.cloud.servicesdk.xbem.adapter.amqp10.MessageImpl;
import com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.engine.AuthSettings;
import com.sap.cloud.servicesdk.xbem.api.Message;
import com.sap.cloud.servicesdk.xbem.api.MessagingRuntimeException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Receiver;

public class AmqpMessagingUtils {
    public static final String PROXY_HOST_PORT_SEPARATOR = ":";
    public static final int PROXY_PORT_NOT_SET = -1;
    private static final String PROTOCOL_SEPARATOR = "://";
    private static final String PATH_SEPARATOR = "/";
    private static final String PORT_SEPARATOR = ":";
    private static final String DEFAULT_PROTOCOL = "amqp";
    private static final String DEFAULT_PATH = null;
    private static final Map<String, Integer> SCHEME_2_DEFAULT_PORT = new HashMap<String, Integer>();

    private static String decodeQueryParaValue(String value) {
        try {
            return URLDecoder.decode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Standard charset 'StandardCharsets.UTF_8.name()' not available.", e);
        }
    }

    private static String[] splitPath(String prefixedPath) {
        int indexPath = prefixedPath.indexOf(PATH_SEPARATOR);
        if (indexPath > 0) {
            String path = prefixedPath.substring(indexPath);
            String prefix = prefixedPath.substring(0, indexPath);
            return new String[]{prefix, path};
        }
        return new String[]{prefixedPath, DEFAULT_PATH};
    }

    public Message createMessage(String endpointName, Receiver receiver, org.apache.qpid.proton.message.Message amqpMessage, byte[] content) {
        return new MessageImpl(amqpMessage.getMessageId(), content, amqpMessage.getApplicationProperties()).addRoutingInfo(amqpMessage.getSubject(), amqpMessage.getAddress()).addHeader("~em.endpoint", endpointName).addHeader("~amqp.receiver_name", receiver.getName());
    }

    static ConnectionParameter createConnectionParameter(Connection connection) {
        return new ConnectionParameter(connection);
    }

    static Optional<ProxySetting> createProxySetting(String hostAndPort) {
        String[] proxyHostAndPort = hostAndPort.split(":");
        if (proxyHostAndPort.length == 2) {
            try {
                String host = proxyHostAndPort[0];
                int port = Integer.valueOf(proxyHostAndPort[1]);
                return Optional.of(new ProxySetting(host, port));
            }
            catch (NumberFormatException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    static {
        SCHEME_2_DEFAULT_PORT.put("mqtt", 1883);
        SCHEME_2_DEFAULT_PORT.put("mqtts", 8883);
        SCHEME_2_DEFAULT_PORT.put(DEFAULT_PROTOCOL, 5672);
        SCHEME_2_DEFAULT_PORT.put("amqps", 5671);
        SCHEME_2_DEFAULT_PORT.put("ws", 80);
        SCHEME_2_DEFAULT_PORT.put("wss", 443);
        SCHEME_2_DEFAULT_PORT.put("http", 80);
        SCHEME_2_DEFAULT_PORT.put("https", 443);
    }

    static class ConnectionParameter {
        private final Connection connection;
        private String protocol;
        private String host;
        private int port;
        private String proxyHost;
        private int proxyPort = -1;
        private String path;
        private Map<String, String> queryParameters = new HashMap<String, String>();
        private AuthSettings authSettings = AuthSettings.createDefault();
        private String user;
        private String password;

        ConnectionParameter(Connection connection) {
            this.connection = connection;
            this.init(connection);
        }

        private void init(Connection connection) {
            this.init(connection.getHostname());
        }

        private void init(String serviceUrl) {
            String[] prefixAndPath;
            String[] parts;
            this.protocol = AmqpMessagingUtils.DEFAULT_PROTOCOL;
            int indexProtocol = serviceUrl.indexOf(AmqpMessagingUtils.PROTOCOL_SEPARATOR);
            if (indexProtocol > 0) {
                this.protocol = serviceUrl.substring(0, indexProtocol).toLowerCase(Locale.US);
                serviceUrl = serviceUrl.substring(indexProtocol + AmqpMessagingUtils.PROTOCOL_SEPARATOR.length());
            }
            if ((parts = serviceUrl.split(":", 2)).length > 1) {
                this.host = parts[0];
                prefixAndPath = AmqpMessagingUtils.splitPath(parts[1]);
                this.path = prefixAndPath[1];
                try {
                    this.port = Integer.parseInt(prefixAndPath[0]);
                }
                catch (NumberFormatException e) {
                    throw new MessagingRuntimeException("Unable to parse port as int (port: " + prefixAndPath[0] + ") of url=" + serviceUrl);
                }
            } else {
                this.port = this.getDefaultPort(this.protocol);
                prefixAndPath = AmqpMessagingUtils.splitPath(parts[0]);
                this.host = prefixAndPath[0];
                this.path = prefixAndPath[1];
            }
            if (this.path != null && this.path.contains("?")) {
                String[] pathAndQuery = this.path.split("\\?");
                this.path = pathAndQuery[0];
                String[] queryAndValues = pathAndQuery[1].split("&");
                if (queryAndValues.length > 0) {
                    this.queryParameters = Arrays.stream(queryAndValues).map(qav -> qav.split("=")).filter(qav -> ((String[])qav).length == 2).collect(Collectors.toMap(qav -> qav[0], qav -> AmqpMessagingUtils.decodeQueryParaValue(qav[1])));
                }
            }
        }

        private int getDefaultPort(String scheme) {
            Integer defaultPort = (Integer)SCHEME_2_DEFAULT_PORT.get(scheme);
            if (defaultPort == null) {
                throw new MessagingRuntimeException(String.format("No default port available for scheme '%s'.", scheme));
            }
            return defaultPort;
        }

        String getProtocol() {
            return this.protocol;
        }

        boolean isSsl() {
            return "amqps".equals(this.protocol) || "wss".equals(this.protocol) || "mqtts".equals(this.protocol) || "https".equals(this.protocol);
        }

        String getHost() {
            return this.host;
        }

        int getPort() {
            return this.port;
        }

        String getConnectionHost() {
            return this.proxyHost == null ? this.host : this.proxyHost;
        }

        int getConnectionPort() {
            return this.proxyPort == -1 ? this.port : this.proxyPort;
        }

        ConnectionParameter setProxy(String host, int port) {
            this.proxyHost = host;
            this.proxyPort = port;
            return this;
        }

        public boolean isProxyEnabled() {
            return this.proxyHost != null && this.proxyPort != -1;
        }

        public String getProxyHost() {
            return this.proxyHost;
        }

        public int getProxyPort() {
            return this.proxyPort;
        }

        Connection getConnection() {
            return this.connection;
        }

        void setAuthSettings(AuthSettings authHeader) {
            this.authSettings = authHeader;
        }

        AuthSettings getAuthSettings() {
            return this.authSettings;
        }

        String getPath() {
            return this.path;
        }

        public Map<String, String> getQueryParameters() {
            return Collections.unmodifiableMap(this.queryParameters);
        }

        public String toString() {
            return "ConnectionParameter{protocol='" + this.protocol + "', host='" + this.host + "', port=" + this.port + ", path='" + this.path + "', proxyHost='" + this.proxyHost + "', proxyPort='" + this.proxyPort + "'}";
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getSslCertificate() {
            return this.authSettings.getSslCertificate();
        }

        public boolean isSslVerify() {
            return this.authSettings.isSslVerify();
        }
    }

    static class ProxySetting {
        final String host;
        final int port;

        ProxySetting(String host, int port) {
            this.host = host;
            this.port = port;
        }
    }
}

