/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver;

import com.sap.cloud.servicesdk.xbem.adapter.amqp10.AmqpMessagingEndpoint;
import com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.MessagingAmqpConnectionException;
import com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.engine.MessageConfig;
import com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.engine.MessagePublisher;
import com.sap.cloud.servicesdk.xbem.api.Message;
import com.sap.cloud.servicesdk.xbem.api.MessagingException;
import com.sap.cloud.servicesdk.xbem.api.MessagingMessageBuilder;
import com.sap.cloud.servicesdk.xbem.api.MessagingRuntimeException;
import com.sap.cloud.servicesdk.xbem.api.MessagingService;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpMessagingProducer {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpMessagingProducer.class);
    public static final Integer DEFAULT_RECONNECT_ATTEMPTS = 5;
    public static final int DEFAULT_RECONNECT_ATTEMPTS_INTERVAL = 1000;
    private final AmqpMessagingEndpoint endpoint;
    private final MessagingService.Config config;
    private MessagePublisher publisher;
    private String reconnectId;

    public AmqpMessagingProducer(MessagingService.Config config, AmqpMessagingEndpoint endpoint) throws MessagingException {
        this.config = config;
        this.endpoint = endpoint;
        this.publisher = this.initPublisher();
    }

    AmqpMessagingProducer(MessagingService.Config config, AmqpMessagingEndpoint endpoint, MessagePublisher publisher) {
        this.config = config;
        this.endpoint = endpoint;
        this.publisher = publisher;
    }

    public void send(String message) throws MessagingException {
        MessagingMessageBuilder<String> m = this.endpoint.createMessage(String.class);
        m.setContent((Serializable)((Object)message));
        m.send();
    }

    private void handleSenderError(MessagingException error, Message<?> message) throws MessagingException {
        if (error instanceof MessagingAmqpConnectionException && ((Boolean)this.config.getSetting(MessagingService.Setting.RECONNECT_AFTER_FAILURE, (Object)true)).booleanValue()) {
            this.handleReconnect((MessagingAmqpConnectionException)error);
            this.publisher.publish(message);
            return;
        }
        throw new MessagingRuntimeException((Throwable)error);
    }

    private synchronized void handleReconnect(MessagingAmqpConnectionException exception) {
        String tmpReconnectId;
        int attempts = (Integer)this.config.getSetting(MessagingService.Setting.RECONNECT_ATTEMPTS, (Object)DEFAULT_RECONNECT_ATTEMPTS);
        int intervalMs = (Integer)this.config.getSetting(MessagingService.Setting.RECONNECT_ATTEMPTS_INTERVAL_MS, (Object)1000);
        this.reconnectId = tmpReconnectId = UUID.randomUUID().toString();
        while (attempts > 0 && tmpReconnectId.equals(this.reconnectId)) {
            try {
                this.publisher = null;
                this.publisher = this.initPublisher();
                this.publisher.connect();
                this.reconnectId = null;
            }
            catch (MessagingException | MessagingRuntimeException e) {
                if (!tmpReconnectId.equals(this.reconnectId)) continue;
                this.silentWait(intervalMs);
                LOG.error("Failed re-connect attempt with exception message: " + e.getMessage(), e);
                LOG.warn("Failed re-connect attempt (start retry after {}ms with {} remaining attempts).", (Object)intervalMs, (Object)(--attempts));
            }
        }
        if (this.reconnectId != null) {
            this.reconnectId = null;
            throw new MessagingRuntimeException("Failed to reconnect after '" + attempts + "' attempts. Initial connection error messages: " + exception.getMessage(), (Throwable)((Object)exception));
        }
    }

    private void silentWait(int waitInMs) {
        try {
            TimeUnit.MILLISECONDS.sleep(waitInMs);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void close(boolean force, long time, TimeUnit unit) throws MessagingException {
        if (this.publisher == null) {
            LOG.info("No publisher started, skip shutdown producer.");
        } else {
            LOG.info("Shutdown producer.");
            this.publisher.close(force, time, unit);
        }
    }

    public void send(Message<?> message) throws MessagingException {
        try {
            this.publisher.publish(message);
        }
        catch (MessagingAmqpConnectionException e) {
            this.handleSenderError(e, message);
        }
    }

    private MessagePublisher initPublisher() throws MessagingException {
        if (this.publisher == null) {
            MessageConfig cfg = MessageConfig.forSender(this.config, this.endpoint).create();
            return MessagePublisher.with(cfg);
        }
        return this.publisher;
    }

    private boolean isReconnecting() {
        return this.reconnectId != null;
    }

    public boolean isConnected() {
        if (this.publisher == null) {
            return this.isReconnecting();
        }
        return this.publisher.isConnected();
    }

    public boolean isActive() {
        if (this.publisher == null) {
            return this.isReconnecting();
        }
        return this.publisher.isActive();
    }

    public boolean isClosed() {
        if (this.publisher == null) {
            return !this.isReconnecting();
        }
        return this.publisher.isClosed();
    }
}

