/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.servicesdk.xbem.adapter.amqp10;

import com.sap.cloud.servicesdk.xbem.adapter.amqp10.AmqpMessagingEndpoint;
import com.sap.cloud.servicesdk.xbem.adapter.amqp10.AmqpProperty;
import com.sap.cloud.servicesdk.xbem.api.MessagingBinding;
import com.sap.cloud.servicesdk.xbem.api.MessagingEndpoint;
import com.sap.cloud.servicesdk.xbem.api.MessagingException;
import com.sap.cloud.servicesdk.xbem.api.MessagingRuntimeException;
import com.sap.cloud.servicesdk.xbem.api.MessagingService;
import com.sap.cloud.servicesdk.xbem.api.MessagingServiceVersion;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public class MessagingServiceImpl
extends MessagingService {
    private MessagingService.Config config;
    private static final MessagingServiceVersion MESSAGING_SERVICE_VERSION = MessagingServiceVersion.getVersionInfo((String)"emjapi-version-amqp10");

    public static MessagingServiceVersion getMessagingServiceVersion() {
        return MESSAGING_SERVICE_VERSION;
    }

    public MessagingEndpoint.Builder createEndpoint(String ... segments) {
        return new InnerBuilder(this.config, segments);
    }

    public MessagingEndpoint.Builder bind() throws MessagingException {
        String commonDestinationName = (String)this.config.getSetting(MessagingEndpoint.Setting.DEFAULT_ENDPOINT_NAME);
        if (commonDestinationName != null) {
            String[] paths = commonDestinationName.split("/");
            return this.createEndpoint(paths);
        }
        MessagingBinding defaultBinding = this.config.getBinding("default");
        if (defaultBinding == null) {
            Collection bindings = this.config.getBindings();
            if (bindings.isEmpty()) {
                throw new MessagingException("No default binding found.");
            }
            if (bindings.size() == 1) {
                return this.createBuilder((MessagingBinding)bindings.iterator().next());
            }
            throw new MessagingException("Found more then one binding ('" + bindings + "') and cannot define default.");
        }
        return this.createBuilder(defaultBinding);
    }

    public MessagingEndpoint.Builder bind(String bindingName) throws MessagingException {
        MessagingBinding binding = this.config.getBinding(bindingName);
        if (binding == null) {
            binding = this.config.getBinding(bindingName);
        }
        if (binding == null) {
            binding = this.config.getBinding(bindingName);
        }
        if (binding == null) {
            throw new MessagingException("No binding '" + bindingName + "' found...");
        }
        return this.createBuilder(binding);
    }

    public MessagingEndpoint.Builder bind(MessagingBinding binding) throws MessagingException {
        if (binding == null) {
            throw new MessagingException("MessagingBinding parameter must not be null.");
        }
        return this.createBuilder(binding);
    }

    private MessagingEndpoint.Builder createBuilder(MessagingBinding binding) {
        return new InnerBuilder(this.config, binding);
    }

    public MessagingService.Config getConfig() {
        return this.config;
    }

    public void init(MessagingService.Config config) {
        this.config = config;
    }

    private class InnerBuilder
    extends MessagingEndpoint.Builder {
        private final MessagingService.Config config;
        private final String[] paths;
        private final MessagingBinding binding;

        public InnerBuilder(MessagingService.Config config, MessagingBinding binding) {
            this.binding = binding;
            this.config = config;
            this.paths = null;
        }

        public InnerBuilder(MessagingService.Config config, String ... paths) {
            this.config = config;
            this.paths = paths;
            this.binding = null;
        }

        public MessagingEndpoint build() {
            MessagingService.Config buildConfig = MessagingService.Config.createFrom((MessagingService.Config)this.config, (Map)this.properties.getSettingsMap(), Collections.emptyMap());
            if (this.paths == null) {
                if (this.binding == null) {
                    throw new MessagingRuntimeException("Either path/segments or binding must be provided.");
                }
                return new AmqpMessagingEndpoint(buildConfig, this.binding);
            }
            String destinationName = Arrays.stream(this.paths).collect(Collectors.joining("/"));
            String name = "BindingByCreateDestination::" + destinationName;
            MessagingBinding.Builder binding = MessagingBinding.with((String)name);
            this.properties.getSettings().forEach(arg_0 -> ((MessagingBinding.Builder)binding).addSetting(arg_0));
            if (((Boolean)buildConfig.getSetting(AmqpProperty.Setting.USE_EXCHANGE, (Object)true)).booleanValue()) {
                binding.topic(destinationName);
            } else {
                binding.queue(destinationName);
            }
            return new AmqpMessagingEndpoint(buildConfig, binding.build());
        }
    }
}

