/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.servicesdk.xbem.adapter.amqp10;

import com.sap.cloud.servicesdk.xbem.adapter.amqp10.AmqpMessagingEndpoint;
import com.sap.cloud.servicesdk.xbem.adapter.amqp10.MessageImpl;
import com.sap.cloud.servicesdk.xbem.api.MessagingException;
import com.sap.cloud.servicesdk.xbem.api.MessagingMessageBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class MessagingMessageBuilderImpl<T extends Serializable>
implements MessagingMessageBuilder<T> {
    private final MessageImpl message;
    private final AmqpMessagingEndpoint messagingEndpoint;
    private final Class<T> tClass;

    MessagingMessageBuilderImpl(AmqpMessagingEndpoint messagingEndpoint, Class<T> tClass) {
        this.messagingEndpoint = messagingEndpoint;
        this.tClass = tClass;
        this.message = new MessageImpl();
    }

    public MessagingMessageBuilder<T> addHeader(String name, String value) {
        this.message.addHeader(name, value);
        return this;
    }

    public MessagingMessageBuilder<T> setContent(T content) {
        if (this.tClass == byte[].class && content instanceof byte[]) {
            this.message.setContent((byte[])content);
        } else {
            byte[] asBytes = this.serializeToBytes((Serializable)content);
            this.message.setContent(asBytes);
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] serializeToBytes(Serializable content) {
        if (content == null) {
            return null;
        }
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(content);
            out.flush();
            bos.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalStateException("Exception during object serialization: " + e.getMessage());
        }
    }

    public void send() throws MessagingException {
        this.messagingEndpoint.grantProducer().send(this.message);
    }
}

