/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.servicesdk.xbem.adapter.amqp10;

import com.sap.cloud.servicesdk.xbem.api.Message;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;

public class MessageImpl<CT extends Serializable>
implements Message<CT> {
    public static final String HEADER_AMQP_ID = "~amqp.id";
    public static final String HEADER_AMQP_SUBJECT = "~amqp.subject";
    public static final String HEADER_AMQP_ADDRESS = "~amqp.address";
    public static final String HEADER_AMQP_RECEIVER_NAME = "~amqp.receiver_name";
    private final Map<String, String> headers = new HashMap<String, String>();
    private byte[] content;

    MessageImpl() {
        this.headers.put(HEADER_AMQP_ID, this.generateMessageId("snd"));
    }

    MessageImpl(Object id, byte[] body) {
        this(id, body, null);
    }

    public MessageImpl(Object id, byte[] body, ApplicationProperties properties) {
        if (id == null) {
            this.headers.put(HEADER_AMQP_ID, this.generateMessageId("rcv"));
        } else {
            this.headers.put(HEADER_AMQP_ID, String.valueOf(id));
        }
        if (body == null) {
            throw new IllegalArgumentException("Content must not be NULL");
        }
        this.content = body;
        if (properties != null) {
            properties.getValue().forEach((k, v) -> this.headers.put(String.valueOf(k), String.valueOf(v)));
        }
    }

    public String getAddress() {
        return this.headers.get("~em.address");
    }

    public String getEndpoint() {
        return this.headers.get("~em.endpoint");
    }

    public MessageImpl addRoutingInfo(String subject, String address) {
        this.addHeader(HEADER_AMQP_SUBJECT, subject);
        this.addHeader(HEADER_AMQP_ADDRESS, address);
        if (address == null) {
            this.addHeader("~em.address", subject);
        } else {
            this.addHeader("~em.address", address);
        }
        return this;
    }

    public MessageImpl addHeader(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public Optional<String> getHeader(String name) {
        return Optional.ofNullable(this.headers.get(name));
    }

    public Set<String> getHeaderNames() {
        return Collections.unmodifiableSet(this.headers.keySet());
    }

    public boolean containsHeader(String name) {
        return this.headers.containsKey(name);
    }

    public CT getContent() {
        try {
            return (CT)((Serializable)this.deserializeContent(this.content));
        }
        catch (IllegalStateException e) {
            return (CT)this.content;
        }
    }

    public void setContent(byte[] content) {
        if (content == null) {
            throw new IllegalArgumentException("Content must not be NULL");
        }
        this.content = content;
    }

    public <T extends Serializable> T getContentAs(Class<T> tClass) {
        if (byte[].class == tClass) {
            return (T)this.content;
        }
        try {
            return (T)((Serializable)this.deserializeContent(this.content));
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException("Requested class '" + tClass + "' is not supported (root msg = " + e.getMessage() + ").", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object deserializeContent(byte[] content) {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(content);){
            ObjectInputStream in = new ObjectInputStream(bis);
            Object object = in.readObject();
            return object;
        }
        catch (EOFException e) {
            return content;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalStateException("Error during object ('" + this.headers + "') de-serialization: " + e.getMessage(), e);
        }
    }

    private String getContentPart(byte[] content, int amount) {
        int pos;
        if (content == null) {
            return "[]{len=null}";
        }
        StringBuilder b = new StringBuilder("[");
        int length = content.length > amount ? amount : content.length;
        for (pos = 0; pos < length - 1; ++pos) {
            b.append(content[pos]).append(",");
        }
        return b.append(content[pos]).append("]{len=").append(content.length).append("}").toString();
    }

    private String generateMessageId(String prefix) {
        return "em.gen.id_" + prefix + "_" + UUID.randomUUID().toString().substring(24);
    }

    public String toString() {
        String contentPart = this.getContentPart(this.content, 10);
        return "MessageImpl{headers=" + this.headers + ", content=" + contentPart + '}';
    }
}

