/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.servicesdk.xbem.adapter.amqp10;

import com.sap.cloud.servicesdk.xbem.adapter.amqp10.AmqpProperty;
import com.sap.cloud.servicesdk.xbem.api.MessagingRuntimeException;
import java.util.Arrays;
import java.util.stream.Collectors;

public class AmqpUtils {
    static String normalizeEndpointAddress(AmqpProperty.ServiceType serviceType, String endpointType, String[] topicPaths) {
        if ("*".equals(topicPaths[topicPaths.length - 1])) {
            topicPaths[topicPaths.length - 1] = serviceType.wildcardAny;
        }
        if ("queue:".equals(endpointType)) {
            return serviceType.queuePrefix + Arrays.stream(topicPaths).map(tp -> tp.equals("+") ? serviceType.wildcardSingle : tp).collect(Collectors.joining(serviceType.segmentSeparator));
        }
        if ("topic:".equals(endpointType)) {
            return serviceType.topicPrefix + Arrays.stream(topicPaths).map(tp -> tp.equals("+") ? serviceType.wildcardSingle : tp).collect(Collectors.joining(serviceType.segmentSeparator));
        }
        throw new MessagingRuntimeException("Unknown endpoint type '" + endpointType + "' for address normalization.");
    }

    public static String normalizeEndpointAddress(AmqpProperty.ServiceType type, String address) {
        int index = address.indexOf(58) + 1;
        if (index > 0) {
            String name = address.substring(index);
            String endpointType = address.substring(0, index);
            return AmqpUtils.normalizeEndpointAddress(type, endpointType, name.split("/"));
        }
        throw new MessagingRuntimeException("No address prefix separator found in address '" + address + "' for address normalization.");
    }
}

