/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.servicesdk.xbem.adapter.amqp10;

import com.sap.cloud.servicesdk.xbem.api.MessagingRuntimeException;
import com.sap.cloud.servicesdk.xbem.api.MessagingService;
import com.sap.cloud.servicesdk.xbem.api.MessagingSetting;
import java.util.Locale;

public interface AmqpProperty {

    public static enum ServiceType {
        SOLACEVMR("", "", "/", "*", ">"),
        RABBITMQ("/topic/", "/amq/queue/", ".", "*", "#"),
        SAPMGW("topic:", "queue:", "/", "+", "*");

        final String topicPrefix;
        final String queuePrefix;
        final String segmentSeparator;
        final String wildcardSingle;
        final String wildcardAny;

        private ServiceType(String topicPrefix, String queuePrefix, String segmentSeparator, String wildcardSingle, String wildcardAny) {
            this.topicPrefix = topicPrefix;
            this.queuePrefix = queuePrefix;
            this.segmentSeparator = segmentSeparator;
            this.wildcardSingle = wildcardSingle;
            this.wildcardAny = wildcardAny;
        }

        public static ServiceType parse(String name) {
            try {
                return ServiceType.valueOf(name.toUpperCase(Locale.US));
            }
            catch (IllegalArgumentException e) {
                throw new MessagingRuntimeException("Illegal and unsupported ServiceType '" + name + "' (related to property '" + MessagingService.Setting.MESSAGE_SERVICE_TYPE + "').");
            }
        }
    }

    public static final class Setting {
        public static final MessagingSetting<Integer> MAX_FLOW = MessagingSetting.create((String)"adapter.amqp10.maxFlow", Integer.class);
        public static final MessagingSetting<Boolean> USE_EXCHANGE = MessagingSetting.create((String)"USE_EXCHANGE", Boolean.class);
    }
}

