/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.servicesdk.xbem.adapter.amqp10;

import com.sap.cloud.servicesdk.xbem.adapter.amqp10.AmqpProperty;
import com.sap.cloud.servicesdk.xbem.adapter.amqp10.AmqpUtils;
import com.sap.cloud.servicesdk.xbem.adapter.amqp10.MessagingMessageBuilderImpl;
import com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.AmqpMessagingConsumer;
import com.sap.cloud.servicesdk.xbem.adapter.amqp10.driver.AmqpMessagingProducer;
import com.sap.cloud.servicesdk.xbem.api.Message;
import com.sap.cloud.servicesdk.xbem.api.MessagingBinding;
import com.sap.cloud.servicesdk.xbem.api.MessagingEndpoint;
import com.sap.cloud.servicesdk.xbem.api.MessagingException;
import com.sap.cloud.servicesdk.xbem.api.MessagingExceptionContext;
import com.sap.cloud.servicesdk.xbem.api.MessagingExceptionHandler;
import com.sap.cloud.servicesdk.xbem.api.MessagingMessageBuilder;
import com.sap.cloud.servicesdk.xbem.api.MessagingService;
import com.sap.cloud.servicesdk.xbem.api.MessagingSetting;
import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class AmqpMessagingEndpoint
implements MessagingEndpoint {
    private static final String DEFAULT_MESSAGE_SERVICE_TYPE = AmqpProperty.ServiceType.SAPMGW.name();
    public static final Pattern CLIENT_ID_REGEX_PATTERN = Pattern.compile("[\\w\\-:]{1,512}");
    private final MessagingService.Config config;
    private final String name;
    private final MessagingBinding binding;
    private final String normalizedAddress;
    private String clientId;
    private AmqpMessagingProducer producer;
    private AmqpMessagingConsumer consumer;
    private MessagingExceptionHandler handler = e -> {};

    AmqpMessagingEndpoint(MessagingService.Config config, MessagingBinding binding) {
        this.config = config;
        this.binding = binding;
        this.name = binding.getEndpointName();
        String type = (String)config.getSetting(MessagingService.Setting.MESSAGE_SERVICE_TYPE, (Object)DEFAULT_MESSAGE_SERVICE_TYPE);
        this.normalizedAddress = AmqpUtils.normalizeEndpointAddress(AmqpProperty.ServiceType.parse(type), binding.getAddress());
    }

    public Stream<Message<byte[]>> receive() {
        return this.receive(this.createClientId());
    }

    public Stream<Message<byte[]>> receive(String clientId) {
        return this.receive(clientId, byte[].class);
    }

    public <T extends Serializable> Stream<Message<T>> receive(Class<T> type) {
        return this.receive(this.createClientId(), type);
    }

    public <T extends Serializable> Stream<Message<T>> receive(String clientId, Class<T> type) {
        if (this.clientId != null) {
            throw new IllegalArgumentException("Currently only one receiver allowed per endpoint instance.");
        }
        if (clientId == null) {
            throw new IllegalArgumentException("Client id must not be null.");
        }
        if (!CLIENT_ID_REGEX_PATTERN.matcher(clientId).matches()) {
            throw new IllegalArgumentException("Invalid client id. Client id '" + clientId + "' must match the pattern '" + "[\\w\\-:]{1,512}" + "'.");
        }
        this.clientId = clientId;
        if (this.consumer == null) {
            this.initializeConsumer();
        }
        return this.consumer.provideStream(type);
    }

    public void receive(Consumer<Stream<Message<byte[]>>> consumer) {
        this.runInBackground(() -> this.wrap(consumer, this.receive()));
    }

    public void receive(String clientId, Consumer<Stream<Message<byte[]>>> consumer) {
        this.runInBackground(() -> this.wrap(consumer, this.receive(clientId)));
    }

    public <T extends Serializable> void receive(Class<T> type, Consumer<Stream<Message<T>>> consumer) {
        this.runInBackground(() -> this.wrap(consumer, this.receive(type)));
    }

    public <T extends Serializable> void receive(String clientId, Class<T> type, Consumer<Stream<Message<T>>> consumer) {
        this.runInBackground(() -> this.wrap(consumer, this.receive(clientId, type)));
    }

    private void runInBackground(Runnable runnable) {
        Executors.newSingleThreadExecutor().submit(runnable);
    }

    public AmqpMessagingEndpoint onReceiveConsumerException(MessagingExceptionHandler handler) {
        this.handler = handler;
        return this;
    }

    private <T extends Serializable> void wrap(Consumer<Stream<Message<T>>> consumer, Stream<Message<T>> stream) {
        try {
            consumer.accept(stream);
        }
        catch (Exception e) {
            this.handler.handleException(new MessagingExceptionContext(e));
        }
    }

    public boolean isReceiving() {
        if (this.consumer != null) {
            return this.consumer.isConnected();
        }
        return false;
    }

    public boolean isConnected() {
        if (this.producer != null) {
            return this.producer.isConnected();
        }
        return false;
    }

    public boolean isActive() {
        return this.consumer != null && this.consumer.isActive() || this.producer != null && this.producer.isActive();
    }

    public MessagingBinding getBinding() {
        return this.binding;
    }

    public <T> T getSetting(MessagingSetting<T> setting) {
        return (T)this.config.getSetting(setting);
    }

    public Map<String, MessagingSetting> getSettings() {
        return this.config.getProperties();
    }

    private synchronized void initializeConsumer() {
        if (this.consumer != null) {
            throw new IllegalStateException("Only one active receiver allowed per endpoint instance.");
        }
        this.consumer = new AmqpMessagingConsumer(this.config, this);
    }

    public void send(String text) throws MessagingException {
        AmqpMessagingProducer producer = this.grantProducer();
        producer.send(text);
    }

    AmqpMessagingProducer grantProducer() throws MessagingException {
        if (this.producer == null) {
            this.initProducer();
        }
        return this.producer;
    }

    private synchronized void initProducer() throws MessagingException {
        if (this.producer == null) {
            this.producer = new AmqpMessagingProducer(this.config, this);
        }
    }

    public MessagingMessageBuilder<byte[]> createMessage() {
        return new MessagingMessageBuilderImpl<byte[]>(this, byte[].class);
    }

    public <T extends Serializable> MessagingMessageBuilder<T> createMessage(Class<T> clazz) {
        return new MessagingMessageBuilderImpl<T>(this, clazz);
    }

    public boolean isClosed() {
        if (this.consumer == null && this.producer == null) {
            return true;
        }
        if (this.consumer == null) {
            return this.producer.isClosed();
        }
        if (this.producer == null) {
            return this.consumer.isClosed();
        }
        return this.consumer.isClosed() && this.producer.isClosed();
    }

    public void close(boolean force) throws MessagingException {
        this.closeProducer(force, 5000L, TimeUnit.MILLISECONDS);
        this.closeConsumer(force, 5000L, TimeUnit.MILLISECONDS);
    }

    private void closeConsumer(boolean force, long time, TimeUnit unit) throws MessagingException {
        if (this.consumer != null) {
            this.consumer.close(force, time, unit);
        }
    }

    private void closeProducer(boolean force, long time, TimeUnit unit) throws MessagingException {
        if (this.producer != null) {
            this.producer.close(force, time, unit);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getAddress() {
        return this.normalizedAddress;
    }

    public String getClientId() {
        return this.clientId;
    }

    private String createClientId() {
        return "GCID_" + UUID.randomUUID().toString().substring(0, 8);
    }

    public String toString() {
        return "AmqpMessagingEndpoint{name='" + this.name + '\'' + ", clientId='" + this.clientId + ", normalizedAddress='" + this.normalizedAddress + "', binding=" + this.binding + '\'' + '}';
    }
}

