/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.request.impl;

import com.sap.cloud.sdk.service.prov.api.EntityData;
import com.sap.cloud.sdk.service.prov.api.EntityMetadata;
import com.sap.cloud.sdk.service.prov.api.exception.DataConversionException;
import com.sap.cloud.sdk.service.prov.api.request.RequestContext;
import com.sap.cloud.sdk.service.prov.api.request.UpdateRequest;
import com.sap.cloud.sdk.service.prov.api.util.DataConversionUtility;
import com.sap.cloud.sdk.service.prov.api.util.PojoUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class UpdateRequestImpl
extends UpdateRequest {
    private Object data;
    private Map<String, Object> keys;
    private Set<String> initialListOfProperties;

    public UpdateRequestImpl(RequestContext requestContext, String entityName, EntityMetadata entityMetadata, Map<String, List<String>> headers, Map<String, Object> keys, String httpMethod) {
        this.requestContext = requestContext;
        this.entityMetadata = entityMetadata;
        this.entityName = entityName;
        this.keys = keys;
        this.httpMethod = httpMethod;
        this.initialiseHeaders(headers);
    }

    @Override
    public Map<String, Object> getKeys() {
        return this.keys;
    }

    @Override
    public EntityData getData() {
        return DataConversionUtility.convertToEntityData(this.data, this.entityName, this.entityMetadata.getKeyNames());
    }

    public void setData(Object incomingData) {
        if (this.initialListOfProperties == null) {
            if (incomingData instanceof Map) {
                this.initialListOfProperties = ((Map)incomingData).keySet();
            } else if (incomingData instanceof EntityData) {
                this.initialListOfProperties = ((EntityData)incomingData).asMap().keySet();
            }
        }
        if (incomingData != null && !(incomingData instanceof EntityData)) {
            Map<String, Object> tempData = PojoUtil.getMapUsingBeanUtils(incomingData);
            if (!(incomingData instanceof Map)) {
                List extraPropertiesInIncomingData = tempData.keySet().stream().filter(prop -> !this.initialListOfProperties.contains(prop)).collect(Collectors.toList());
                extraPropertiesInIncomingData.stream().filter(prop -> tempData.get(prop) == null).forEach(p -> tempData.remove(p));
            }
            this.data = DataConversionUtility.convertToEntityData(tempData, this.entityName, this.entityMetadata.getKeyNames());
        } else {
            this.data = incomingData;
        }
    }

    @Override
    public Map<String, Object> getMapData() {
        return DataConversionUtility.convertToMap(this.data);
    }

    @Override
    public <T> T getDataAs(Class<T> clazz) throws DataConversionException {
        return DataConversionUtility.convertToClass(clazz, this.data);
    }
}

