/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.internal;

import com.sap.cloud.sdk.service.prov.api.ElementType;
import com.sap.cloud.sdk.service.prov.api.EntityData;
import com.sap.cloud.sdk.service.prov.api.EntityDataBuilder;
import com.sap.cloud.sdk.service.prov.api.EntityMetadata;
import com.sap.cloud.sdk.service.prov.api.internal.DefaultEntityData;
import com.sap.cloud.sdk.service.prov.api.internal.DefaultEntityMetadata;
import com.sap.cloud.sdk.service.prov.api.internal.HasMetadata;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultEntityDataBuilder
implements EntityDataBuilder {
    HashMap<String, Object> properties = new HashMap();
    List<String> elements = new ArrayList<String>();
    List<String> associationElements = new ArrayList<String>();
    List<String> keys = new ArrayList<String>();
    HashMap<String, ElementType> elementTypes = new HashMap();
    String entityName;
    String namespace;
    Map<String, Object> associationProperties = new HashMap<String, Object>();

    public DefaultEntityDataBuilder() {
        this.elements = new ArrayList<String>();
    }

    public DefaultEntityDataBuilder(EntityData ed) {
        EntityMetadata em = ((HasMetadata)((Object)ed)).getEntityMetadata();
        this.elements.addAll(em.getElementNames());
        Map<String, Object> localAssociationProperties = ed.getAssociations();
        if (localAssociationProperties != null && !localAssociationProperties.isEmpty()) {
            this.associationProperties.putAll(localAssociationProperties);
        }
        for (String element : this.elements) {
            if (!ed.contains(element)) continue;
            this.properties.put(element, ed.getElementValue(element));
        }
        this.keys.addAll(em.getKeyNames());
        this.entityName = em.getName();
        this.namespace = em.getNamespace();
        this.elementTypes = this.copyElementTypes(em);
        this.associationElements = em.getAssociationNames();
        if (this.associationElements != null) {
            for (String associationElement : this.associationElements) {
                if (!ed.contains(associationElement)) continue;
                this.properties.put(associationElement, ed.getElementValue(associationElement));
            }
        }
    }

    private HashMap<String, ElementType> copyElementTypes(EntityMetadata em) {
        if (em instanceof DefaultEntityData) {
            return ((DefaultEntityMetadata)em).getElementTypes();
        }
        HashMap<String, ElementType> elementTypes = new HashMap<String, ElementType>();
        for (String element : em.getElementNames()) {
            elementTypes.put(element, em.getElementType(element));
        }
        return elementTypes;
    }

    @Override
    public DefaultEntityDataBuilder addElement(String name, Object value) {
        if (!this.properties.containsKey(name) && !this.elements.contains(name)) {
            this.elements.add(name);
        }
        this.properties.put(name, value);
        if (value instanceof HashMap) {
            this.elementTypes.put(name, ElementType.STRUCTURED_TYPE);
        } else {
            this.elementTypes.put(name, ElementType.SIMPLE_TYPE);
        }
        return this;
    }

    private List<String> getFlattenedElementsFromHashMap(String name, HashMap<String, Object> value) {
        ArrayList<String> flattened = new ArrayList<String>();
        if (value == null || value.isEmpty()) {
            return flattened;
        }
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            String path = name + "." + entry.getKey();
            if (entry.getValue() instanceof HashMap) {
                flattened.addAll(this.getFlattenedElementsFromHashMap(path, (HashMap)entry.getValue()));
                continue;
            }
            flattened.add(path);
        }
        return flattened;
    }

    @Override
    public DefaultEntityDataBuilder addKeyElement(String name, Object value) {
        if (!this.elements.contains(name)) {
            this.elements.add(name);
        }
        this.properties.put(name, value);
        if (!this.keys.contains(name)) {
            this.keys.add(name);
        }
        if (value instanceof HashMap) {
            this.elementTypes.put(name, ElementType.STRUCTURED_TYPE);
        } else {
            this.elementTypes.put(name, ElementType.SIMPLE_TYPE);
        }
        return this;
    }

    @Override
    public DefaultEntityDataBuilder removeElement(String name) {
        this.properties.remove(name);
        this.elements.remove(name);
        this.keys.remove(name);
        return this;
    }

    @Override
    public EntityData buildEntityData(String name) {
        ArrayList<String> flattenedElements = new ArrayList<String>();
        for (String element : this.elementTypes.keySet()) {
            ElementType type = this.elementTypes.get(element);
            if (type.equals((Object)ElementType.SIMPLE_TYPE)) {
                flattenedElements.add(element);
                continue;
            }
            HashMap value = (HashMap)this.properties.get(element);
            flattenedElements.addAll(this.getFlattenedElementsFromHashMap(element, value));
        }
        DefaultEntityMetadata em = new DefaultEntityMetadata().setEntityName(name).setElements(this.elements).setKeys(this.keys).setNamespace(this.namespace).setElementTypes(this.elementTypes).setFlattenedElements(flattenedElements);
        if (this.associationProperties.size() > 0) {
            return new DefaultEntityData(this.properties, this.associationProperties, em);
        }
        return new DefaultEntityData(this.properties, em);
    }

    @Override
    public EntityDataBuilder addAssociationElement(String name, Object value) {
        this.associationProperties.put(name, value);
        return this;
    }
}

