/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.service.prov.api.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.sap.cloud.sdk.service.prov.api.connection.HashedData;
import com.sap.cloud.sdk.service.prov.api.connection.HashedDataImpl;
import com.sap.cloud.sdk.service.prov.api.connection.ThreadSafeObjectStore;
import com.sap.cloud.sdk.service.prov.api.internal.AdminDataAnnotation;
import com.sap.cloud.sdk.service.prov.api.internal.CSNNotSetException;
import com.sap.cloud.sdk.service.prov.api.security.AuthorizationDetails;
import com.sap.cloud.sdk.service.prov.api.util.GenericUtilityMethods;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSNUtil {
    private static final String DEFINITIONS = "definitions";
    private static final String ELEMENTS = "elements";
    private static final String ON = "on";
    private static final String REF = "ref";
    private static final String NO_REF_CONSTRAINT = "Unable to create with navigation because the corresponding referential constraint is missing in the csn file";
    private static final String PARAMS = "params";
    private static final String TYPE = "type";
    private static final String SQL_MAPPING = "@sql_mapping";
    private static final String ODATA_INSERTED = "@odata.on.insert";
    private static final String ODATA_UPDATED = "@odata.on.update";
    private static final String CDS_INSERTED = "@cds.on.insert";
    private static final String CDS_UPDATED = "@cds.on.update";
    private static final String ODATA_COMPUTED = "@Core.Computed";
    private static final String ODATA_IMMUTABLE = "@Core.Immutable";
    private static final String ORDER_DEFAULT = "@Order.default";
    private static final String ODATA_SEARCHABLE = "@Capabilities.SearchRestrictions.Searchable";
    private static final String ODATA_DEFAULT_SEARCH_ELEMENT = "@Search.defaultSearchElement";
    private static final String ODATA_DEFAULT_SEARCH_ELEMENT_WITH_FUZZY = "@Search.fuzzinessThreshold";
    private static final String ODATA_NOW = "now";
    private static final String ODATA_USER = "user";
    private static final String ODATA_HASH = "#";
    private static final String CDS_PERSISTENCE_NAME = "@cds.persistence.name";
    private static final String CSN_NOT_FOUND = "CSN file not found.";
    private static final String DRAFT_ENABLED = "@odata.draft.enabled";
    private static final String KIND = "kind";
    private static final String RESTRICT = "@restrict";
    private static final String GRANT = "grant";
    private static final String CDS_QUERY_LIMIT = "@cds.query.limit";
    private static final String CDS_CONSISTENT_PAGING = "@cds.consistent.paging";
    private static final String SNAPSHOT_STORAGE_DAYS = "@snapshot.storage.days";
    private static volatile JsonNode staticCsn;
    private static volatile HashedData staticHashedCSN;
    private static boolean initialized;
    private static final String DRAFT_NODE = "@Common.DraftNode.PreparationAction";
    private static final String TARGET = "target";
    private static final String REQUIRES = "requires";
    private static final String LOCALIZED = "localized";
    private static final String CDS_TEMPORAL = "@cds.temporal";
    private static final String CDS_VALID = "@cds.valid";
    private static final String CDS_VALID_FROM = "@cds.valid.from";
    private static final String CDS_AUTOEXPOSE = "@cds.autoexpose";
    private static final String CDS_AUTOEXPOSED = "@cds.autoexposed";
    private static final String DELTA_ENABLED = "@odata.delta.enabled";
    private static final String DOT = ".";
    private static final String AGGREGATED_ENTITY = "@Aggregation.ApplySupported.PropertyRestrictions";
    private static final String CDS_COMPOSITION = "cds.Composition";
    private static final String CDS_ASSOCIATION = "cds.Association";
    private static final ObjectMapper objectMapper;
    private static final String ODATA_ETAG = "@odata.etag";
    private static final String CDS_ETAG = "@cds.etag";
    public static final String entitySemantics = "@PersonalData.EntitySemantics";
    public static final String auditLogOperation = "@AuditLog.Operation";
    public static final String Semantics = "@PersonalData.Semantics";
    public static final String dataChangeLogOperation = "@PersonalDataChangeLog.Operation";
    private static final String VIRTUAL = "virtual";
    static Logger logger;
    private static final LoadingCache<HashedData, JsonNode> parsedCsnModels;

    public static boolean isCreatable(String serviceName, String entityName) throws CSNNotSetException {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return true;
        }
        JsonNode insertable = csn.get(DEFINITIONS).get(serviceName + DOT + entityName).get("@Capabilities.InsertRestrictions.Insertable");
        return insertable == null || insertable.asText().equals("true");
    }

    public static InputStream getCsnAsInputStream() throws JsonProcessingException {
        return new ByteArrayInputStream(objectMapper.writeValueAsBytes((Object)CSNUtil.getCsn()));
    }

    public static InputStream getCsnAsInputStream(JsonNode csn) throws JsonProcessingException {
        return new ByteArrayInputStream(objectMapper.writeValueAsBytes((Object)csn));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void checkIfCSNInitialized() throws CSNNotSetException {
        if (staticCsn != null) return;
        Class<CSNUtil> clazz = CSNUtil.class;
        synchronized (CSNUtil.class) {
            if (staticCsn != null) return;
            if (initialized) {
                logger.error("Already tried to initialize the CSN and the initialization failed");
                throw new CSNNotSetException();
            }
            initialized = true;
            logger.debug("Finding local static CSN for initialization");
            try (InputStream inputStreamCSN = CSNUtil.class.getClassLoader().getResourceAsStream("edmx/csn.json");){
                if (inputStreamCSN == null) {
                    logger.error("static csn file not found");
                    throw new CSNNotSetException();
                }
                logger.debug("Starting local static CSN initialization");
                byte[] csnData = GenericUtilityMethods.getOutputStreamFromInputStream(inputStreamCSN).toByteArray();
                String hash = DigestUtils.shaHex((byte[])csnData);
                staticHashedCSN = new HashedDataImpl(hash, csnData);
                staticCsn = objectMapper.readTree(csnData);
                parsedCsnModels.put((Object)staticHashedCSN, (Object)staticCsn);
                logger.debug("Local static CSN initialization successfull");
            }
            catch (IOException e) {
                logger.error("Local static CSN initialization failed", (Throwable)e);
                throw new CSNNotSetException();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static boolean isUpdatable(String serviceName, String entityName) throws CSNNotSetException {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return true;
        }
        JsonNode updatable = csn.get(DEFINITIONS).get(serviceName + DOT + entityName).get("@Capabilities.UpdateRestrictions.Updatable");
        return updatable == null || updatable.asText().equals("true");
    }

    public static boolean isDeletable(String serviceName, String entityName) throws CSNNotSetException {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return true;
        }
        JsonNode deletable = csn.get(DEFINITIONS).get(serviceName + DOT + entityName).get("@Capabilities.DeleteRestrictions.Deletable");
        return deletable == null || deletable.asText().equals("true");
    }

    public static Map<String, AdminDataAnnotation> getAdminDataMapForCreate(String serviceName, String entityName, boolean userContextPresent) {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return new HashMap<String, AdminDataAnnotation>();
        }
        HashMap<String, AdminDataAnnotation> adminDataMap = new HashMap<String, AdminDataAnnotation>();
        if (csn.get(DEFINITIONS).get(serviceName + DOT + entityName) != null) {
            JsonNode node = csn.get(DEFINITIONS).get(serviceName + DOT + entityName).get(ELEMENTS);
            Iterator it = node.fieldNames();
            while (it.hasNext()) {
                JsonNode cdsupdateNode;
                JsonNode updateNode;
                JsonNode cdsinsertNode;
                String colName = (String)it.next();
                JsonNode insertNode = node.get(colName).get(ODATA_INSERTED);
                if (insertNode != null && insertNode.get(ODATA_HASH) != null) {
                    adminDataMap.put(colName, CSNUtil.getAdminDataAnnotation(insertNode.get(ODATA_HASH).asText(), userContextPresent));
                }
                if ((cdsinsertNode = node.get(colName).get(CDS_INSERTED)) != null && cdsinsertNode.get(ODATA_HASH) != null) {
                    adminDataMap.put(colName, CSNUtil.getAdminDataAnnotation(cdsinsertNode.get(ODATA_HASH).asText(), userContextPresent));
                }
                if ((updateNode = node.get(colName).get(ODATA_UPDATED)) != null && updateNode.get(ODATA_HASH) != null) {
                    adminDataMap.put(colName, CSNUtil.getAdminDataAnnotation(updateNode.get(ODATA_HASH).asText(), userContextPresent));
                }
                if ((cdsupdateNode = node.get(colName).get(CDS_UPDATED)) == null || cdsupdateNode.get(ODATA_HASH) == null) continue;
                adminDataMap.put(colName, CSNUtil.getAdminDataAnnotation(cdsupdateNode.get(ODATA_HASH).asText(), userContextPresent));
            }
        }
        return adminDataMap;
    }

    public static Map<String, AdminDataAnnotation> getAdminDataMapForDeepCreate(String serviceName, String parentEntityName, String assoEntityName, String entityName, boolean userContextPresent) {
        JsonNode entityNode;
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return new HashMap<String, AdminDataAnnotation>();
        }
        HashMap<String, AdminDataAnnotation> adminDataMap = new HashMap<String, AdminDataAnnotation>();
        if (csn.get(DEFINITIONS).get(serviceName + DOT + entityName) != null && (entityNode = csn.get(DEFINITIONS).get(serviceName + DOT + parentEntityName).get(ELEMENTS).get(assoEntityName)) != null) {
            JsonNode targetNode = entityNode.get(TARGET);
            JsonNode childNode = csn.get(DEFINITIONS).get(targetNode.asText());
            if (childNode != null) {
                JsonNode node = childNode.get(ELEMENTS);
                Iterator it = node.fieldNames();
                while (it.hasNext()) {
                    JsonNode cdsupdateNode;
                    JsonNode updateNode;
                    JsonNode cdsinsertNode;
                    String colName = (String)it.next();
                    JsonNode insertNode = node.get(colName).get(ODATA_INSERTED);
                    if (insertNode != null && insertNode.get(ODATA_HASH) != null) {
                        adminDataMap.put(colName, CSNUtil.getAdminDataAnnotation(insertNode.get(ODATA_HASH).asText(), userContextPresent));
                    }
                    if ((cdsinsertNode = node.get(colName).get(CDS_INSERTED)) != null && cdsinsertNode.get(ODATA_HASH) != null) {
                        adminDataMap.put(colName, CSNUtil.getAdminDataAnnotation(cdsinsertNode.get(ODATA_HASH).asText(), userContextPresent));
                    }
                    if ((updateNode = node.get(colName).get(ODATA_UPDATED)) != null && updateNode.get(ODATA_HASH) != null) {
                        adminDataMap.put(colName, CSNUtil.getAdminDataAnnotation(updateNode.get(ODATA_HASH).asText(), userContextPresent));
                    }
                    if ((cdsupdateNode = node.get(colName).get(CDS_UPDATED)) == null || cdsupdateNode.get(ODATA_HASH) == null) continue;
                    adminDataMap.put(colName, CSNUtil.getAdminDataAnnotation(cdsupdateNode.get(ODATA_HASH).asText(), userContextPresent));
                }
            }
        }
        return adminDataMap;
    }

    public static Map<String, AdminDataAnnotation> getAdminDataMapForUpdate(String serviceName, String entityName, boolean userContextPresent) {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return new HashMap<String, AdminDataAnnotation>();
        }
        HashMap<String, AdminDataAnnotation> adminDataMap = new HashMap<String, AdminDataAnnotation>();
        if (csn.get(DEFINITIONS).get(serviceName + DOT + entityName) != null) {
            JsonNode node = csn.get(DEFINITIONS).get(serviceName + DOT + entityName).get(ELEMENTS);
            Iterator it = node.fieldNames();
            while (it.hasNext()) {
                JsonNode computeNode;
                JsonNode cdscreateNode;
                JsonNode createNode;
                JsonNode cdsupdateNode;
                String colName = (String)it.next();
                JsonNode updateNode = node.get(colName).get(ODATA_UPDATED);
                if (updateNode != null && updateNode.get(ODATA_HASH) != null) {
                    adminDataMap.put(colName, CSNUtil.getAdminDataAnnotation(updateNode.get(ODATA_HASH).asText(), userContextPresent));
                }
                if ((cdsupdateNode = node.get(colName).get(CDS_UPDATED)) != null && cdsupdateNode.get(ODATA_HASH) != null) {
                    adminDataMap.put(colName, CSNUtil.getAdminDataAnnotation(cdsupdateNode.get(ODATA_HASH).asText(), userContextPresent));
                }
                if ((createNode = node.get(colName).get(ODATA_INSERTED)) != null && createNode.get(ODATA_HASH) != null) {
                    adminDataMap.put(colName, AdminDataAnnotation.NO_CHANGE);
                }
                if ((cdscreateNode = node.get(colName).get(CDS_INSERTED)) != null && cdscreateNode.get(ODATA_HASH) != null) {
                    adminDataMap.put(colName, AdminDataAnnotation.NO_CHANGE);
                }
                if ((computeNode = node.get(colName).get(ODATA_IMMUTABLE)) != null && computeNode.get(ODATA_HASH) != null && computeNode.get(ODATA_HASH).asText().equals("false")) {
                    adminDataMap.put(colName, CSNUtil.getAdminDataAnnotation(computeNode.get(ODATA_HASH).asText(), false));
                    continue;
                }
                if (computeNode == null || !computeNode.asBoolean()) continue;
                adminDataMap.put(colName, AdminDataAnnotation.IMMUTABLE_FIELD);
            }
        }
        return adminDataMap;
    }

    public static List<String> getSearchableProperties(String serviceName, String entityName) {
        JsonNode entityNode;
        JsonNode csn = CSNUtil.getCsn();
        ArrayList<String> searchableProperties = new ArrayList<String>();
        if (csn != null && (entityNode = csn.get(DEFINITIONS).get(serviceName + DOT + entityName)) != null && entityNode.get(ODATA_SEARCHABLE) != null && entityNode.get(ODATA_SEARCHABLE).asBoolean()) {
            JsonNode propertyNode = entityNode.get(ELEMENTS);
            Iterator it = propertyNode.fieldNames();
            while (it.hasNext()) {
                String colName = (String)it.next();
                JsonNode defaultSearchNode = propertyNode.get(colName).get(ODATA_DEFAULT_SEARCH_ELEMENT);
                if (defaultSearchNode == null || !defaultSearchNode.asBoolean()) continue;
                searchableProperties.add(colName);
            }
            return searchableProperties.isEmpty() ? null : searchableProperties;
        }
        return null;
    }

    public static Map<String, Double> getSearchablePropertiesWithFuzzy(String serviceName, String entityName) {
        HashMap<String, Double> searchableFuzzyProperties = new HashMap<String, Double>();
        JsonNode csn = CSNUtil.getCsn();
        if (csn != null) {
            JsonNode entityNode = csn.get(DEFINITIONS).get(serviceName + DOT + entityName);
            if (entityNode != null && entityNode.get(ODATA_SEARCHABLE) != null && entityNode.get(ODATA_SEARCHABLE).asBoolean()) {
                JsonNode propertyNode = entityNode.get(ELEMENTS);
                Iterator it = propertyNode.fieldNames();
                while (it.hasNext()) {
                    String colName = (String)it.next();
                    JsonNode defaultSearchNode = propertyNode.get(colName).get(ODATA_DEFAULT_SEARCH_ELEMENT_WITH_FUZZY);
                    if (defaultSearchNode == null) continue;
                    searchableFuzzyProperties.put(colName.toLowerCase(), Double.parseDouble(defaultSearchNode.asText()));
                }
                return searchableFuzzyProperties.isEmpty() ? null : searchableFuzzyProperties;
            }
            return null;
        }
        return null;
    }

    public static Set<String> getProperties(String serviceName, String entityName) {
        JsonNode entityNode;
        LinkedHashSet<String> properties = new LinkedHashSet<String>();
        JsonNode csn = CSNUtil.getCsn();
        if (csn != null && (entityNode = csn.get(DEFINITIONS).get(serviceName + DOT + entityName)) != null) {
            JsonNode propertyNode = entityNode.get(ELEMENTS);
            Iterator it = propertyNode.fieldNames();
            while (it.hasNext()) {
                String colName = (String)it.next();
                String elementType = propertyNode.get(colName).get(TYPE).asText();
                if (elementType == null || elementType.contains("Association") || elementType.contains("Composition")) continue;
                properties.add(colName);
            }
            return properties.isEmpty() ? null : properties;
        }
        return properties;
    }

    private static AdminDataAnnotation getAdminDataAnnotation(String annotation, boolean userContextPresent) {
        switch (annotation) {
            case "now": {
                return AdminDataAnnotation.NOW;
            }
            case "user": {
                if (userContextPresent) {
                    return AdminDataAnnotation.APPLICATION_USER;
                }
                return AdminDataAnnotation.DB_USER;
            }
        }
        return null;
    }

    public static boolean isPlainSqlMapping() {
        String sqlMapping;
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return false;
        }
        String string = sqlMapping = csn.get(SQL_MAPPING) == null ? null : csn.get(SQL_MAPPING).asText();
        if (sqlMapping != null) {
            return sqlMapping.equals("plain");
        }
        String csnVersion = csn.get("version") != null ? csn.get("version").get("csn").asText() : csn.get("$version").asText();
        logger.debug("Csn version is " + csnVersion);
        int versionNumber = Integer.parseInt(csnVersion.replaceAll("\\.", ""));
        return versionNumber >= 10;
    }

    public static boolean isHdbcdsMapping() {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return false;
        }
        String sqlMapping = csn.get(SQL_MAPPING) == null ? null : csn.get(SQL_MAPPING).asText();
        return sqlMapping != null && sqlMapping.equals("hdbcds");
    }

    public static String getEntityName(String serviceName, String parentEntityName, String associationName) {
        JsonNode propertyNode;
        JsonNode associationNode;
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return null;
        }
        String entityName = null;
        JsonNode entityNode = csn.get(DEFINITIONS).get(serviceName + DOT + parentEntityName);
        if (entityNode != null && (associationNode = (propertyNode = entityNode.get(ELEMENTS)).get(associationName)) != null && (entityName = associationNode.get(TARGET).asText()) != null && entityName.contains(DOT)) {
            entityName = entityName.substring(entityName.lastIndexOf(46) + 1);
        }
        return entityName;
    }

    public static AuthorizationDetails getAuthorizationDetails(String serviceOrEntityName) {
        JsonNode entityNode;
        JsonNode csn = CSNUtil.getCsn();
        if (csn != null && (entityNode = csn.get(DEFINITIONS).get(serviceOrEntityName)) != null) {
            return CSNUtil.getAuthorizationDetails(entityNode);
        }
        return null;
    }

    private static AuthorizationDetails getAuthorizationDetails(JsonNode entityNode) {
        HashMap<String, Object> authDetails = new HashMap<String, Object>();
        if (entityNode.get(KIND) != null) {
            if (entityNode.get(KIND).asText().equals("service")) {
                authDetails.put(KIND, entityNode.get(KIND));
                authDetails.put(REQUIRES, entityNode.get("@requires"));
                return CSNUtil.getAuthorizationDetailsPojo(authDetails);
            }
            if (entityNode.get(KIND).asText().equals("entity") || entityNode.get(KIND).asText().equals("view") || entityNode.get(KIND).asText().equals("action") || entityNode.get(KIND).asText().equals("function")) {
                authDetails.put(KIND, entityNode.get(KIND));
                JsonNode restrictDetails = entityNode.get(RESTRICT);
                CSNUtil.convertToArray(restrictDetails);
                authDetails.put("restrict", entityNode.get(RESTRICT));
                return CSNUtil.getAuthorizationDetailsPojo(authDetails);
            }
        }
        return null;
    }

    private static void convertToArray(JsonNode restrictDetails) {
        if (null != restrictDetails) {
            for (JsonNode currentRule : restrictDetails) {
                if (currentRule.get(GRANT) == null || currentRule.get(GRANT).isArray()) continue;
                String grantStr = currentRule.get(GRANT).asText();
                ((ObjectNode)currentRule).remove(GRANT);
                ((ObjectNode)currentRule).putArray(GRANT).add(grantStr);
            }
        }
    }

    private static AuthorizationDetails getAuthorizationDetailsPojo(Map<String, Object> authDetails) {
        ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        if (authDetails.get(REQUIRES) instanceof TextNode) {
            authDetails.put(REQUIRES, Arrays.asList(authDetails.get(REQUIRES)));
        }
        AuthorizationDetails pojo = (AuthorizationDetails)mapper.convertValue(authDetails, AuthorizationDetails.class);
        return pojo;
    }

    public static String getPersistenceName(String fqEntityName, String elementName) {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return null;
        }
        JsonNode elementNode = csn.get(DEFINITIONS).get(fqEntityName);
        if (elementNode == null) {
            return null;
        }
        if (elementName != null) {
            elementNode = elementNode.get(ELEMENTS).get(elementName);
        }
        if (elementNode == null) {
            return null;
        }
        return elementNode.get(CDS_PERSISTENCE_NAME) == null ? null : elementNode.get(CDS_PERSISTENCE_NAME).asText();
    }

    public static boolean isDraftEnabledEntity(String entityName, String serviceName) {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return false;
        }
        if (csn.get(DEFINITIONS).get(serviceName + DOT + entityName) == null) {
            return false;
        }
        JsonNode draftEnabled = csn.get(DEFINITIONS).get(serviceName + DOT + entityName).get(DRAFT_ENABLED);
        return draftEnabled != null && "true".equals(draftEnabled.asText());
    }

    public static boolean isDefaultOrderEnabled(String entityName, String serviceName) {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return false;
        }
        JsonNode orderEnabled = csn.get(DEFINITIONS).get(serviceName + DOT + entityName);
        if (orderEnabled != null) {
            return orderEnabled.get(ORDER_DEFAULT) != null && orderEnabled.get(ORDER_DEFAULT).asText().equals("true");
        }
        return false;
    }

    public static String getCDSDataType(String entityName, String serviceName, String propName) {
        JsonNode entityNode = CSNUtil.getCsn().get(DEFINITIONS).get(serviceName + DOT + entityName);
        if (entityNode != null) {
            return entityNode.get(ELEMENTS).get(propName).get(TYPE).asText();
        }
        return null;
    }

    public static JsonNode getCsn() {
        HashedData csnForThread = ThreadSafeObjectStore.getCsnForCurrentThread();
        if (csnForThread != null) {
            return (JsonNode)parsedCsnModels.getUnchecked((Object)csnForThread);
        }
        try {
            CSNUtil.checkIfCSNInitialized();
        }
        catch (CSNNotSetException e) {
            logger.error(CSN_NOT_FOUND, (Throwable)e);
        }
        return staticCsn;
    }

    public static HashedData getHashedCsn() {
        HashedData csnForThread = ThreadSafeObjectStore.getCsnForCurrentThread();
        if (csnForThread != null) {
            return csnForThread;
        }
        try {
            CSNUtil.checkIfCSNInitialized();
        }
        catch (CSNNotSetException e) {
            logger.error(CSN_NOT_FOUND, (Throwable)e);
            throw new RuntimeException(CSN_NOT_FOUND);
        }
        return staticHashedCSN;
    }

    public static boolean isDraftNodeEntity(String entityName, String serviceName) {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return false;
        }
        if (csn.get(DEFINITIONS).get(serviceName + DOT + entityName) == null) {
            return false;
        }
        JsonNode draftEnabled = csn.get(DEFINITIONS).get(serviceName + DOT + entityName).get(DRAFT_NODE);
        return draftEnabled != null && "draftPrepare".equals(draftEnabled.asText());
    }

    public static Map<String, List<String>> getCompositionTree(final String serviceName, final String entityName) {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return new HashMap<String, List<String>>();
        }
        final JsonNode entityNode = csn.get(DEFINITIONS).get(serviceName + DOT + entityName);
        Map.Entry<String, JsonNode> rootEntry = new Map.Entry<String, JsonNode>(){

            @Override
            public JsonNode setValue(JsonNode value) {
                return null;
            }

            @Override
            public JsonNode getValue() {
                return entityNode;
            }

            @Override
            public String getKey() {
                return serviceName + CSNUtil.DOT + entityName;
            }
        };
        return CSNUtil.constructCompositionTree(rootEntry, serviceName);
    }

    public static Map<String, List<String>> getDraftTree(String serviceName) {
        HashMap<String, Map<String, List<String>>> draftTree = new HashMap<String, Map<String, List<String>>>();
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return new HashMap<String, List<String>>();
        }
        Map.Entry root = null;
        JsonNode alldefs = csn.get(DEFINITIONS);
        Iterator nodes = alldefs.fields();
        while (nodes.hasNext()) {
            Map.Entry entry = (Map.Entry)nodes.next();
            if (!((String)entry.getKey()).startsWith(serviceName) || ((JsonNode)entry.getValue()).get(DRAFT_ENABLED) == null || !((JsonNode)entry.getValue()).get(DRAFT_ENABLED).asText().equals("true")) continue;
            root = entry;
            break;
        }
        if (root != null) {
            draftTree.put(serviceName, CSNUtil.constructCompositionTree(root, serviceName));
        }
        return (Map)draftTree.get(serviceName);
    }

    private static Map<String, List<String>> constructCompositionTree(Map.Entry<String, JsonNode> currentNode, String serviceName) {
        HashMap<String, List<String>> draftTree = new HashMap<String, List<String>>();
        ArrayList<String> compositions = new ArrayList<String>();
        final JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return draftTree;
        }
        for (final JsonNode property : currentNode.getValue().get(ELEMENTS)) {
            if (property.get(TYPE) == null || !property.get(TYPE).asText().equalsIgnoreCase(CDS_COMPOSITION)) continue;
            compositions.add(property.get(TARGET).asText().substring(serviceName.length() + 1));
            Map.Entry<String, JsonNode> compositionNode = new Map.Entry<String, JsonNode>(){

                @Override
                public JsonNode setValue(JsonNode value) {
                    return null;
                }

                @Override
                public JsonNode getValue() {
                    return csn.get(CSNUtil.DEFINITIONS).get(property.get(CSNUtil.TARGET).asText());
                }

                @Override
                public String getKey() {
                    return property.get(CSNUtil.TARGET).asText();
                }
            };
            draftTree.putAll(CSNUtil.constructCompositionTree(compositionNode, serviceName));
        }
        draftTree.put(currentNode.getKey().substring(serviceName.length() + 1), compositions);
        return draftTree;
    }

    public static Long getQueryLimit(String serviceName) {
        JsonNode csn = CSNUtil.getCsn();
        JsonNode queryLimit = null;
        if (csn == null) {
            return null;
        }
        if (csn.get(DEFINITIONS).get(serviceName) != null) {
            queryLimit = csn.get(DEFINITIONS).get(serviceName).get(CDS_QUERY_LIMIT);
        }
        if (queryLimit != null) {
            return queryLimit.asLong();
        }
        return null;
    }

    public static boolean isConsistentPagingEnabled(String serviceName, String entityName) {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return false;
        }
        JsonNode orderEnabled = csn.get(DEFINITIONS).get(serviceName + DOT + entityName);
        if (orderEnabled != null) {
            return orderEnabled.get(CDS_CONSISTENT_PAGING) != null && orderEnabled.get(CDS_CONSISTENT_PAGING).asText().equals("true");
        }
        return false;
    }

    public static List<String> getTemporalEntities(String serviceName) {
        JsonNode csn = CSNUtil.getCsn();
        ArrayList<String> temoralList = new ArrayList<String>();
        if (csn == null) {
            return temoralList;
        }
        Iterator nodes = csn.get(DEFINITIONS).fields();
        block0: while (nodes.hasNext()) {
            Map.Entry entry = (Map.Entry)nodes.next();
            Iterator FiledsinEachField = ((JsonNode)entry.getValue()).fields();
            while (FiledsinEachField.hasNext()) {
                Map.Entry fieldEntry = (Map.Entry)FiledsinEachField.next();
                if (((String)fieldEntry.getKey()).startsWith(ELEMENTS)) {
                    Iterator elementsIterator = ((JsonNode)fieldEntry.getValue()).fields();
                    while (elementsIterator.hasNext()) {
                        Map.Entry element = (Map.Entry)elementsIterator.next();
                        if (!((JsonNode)element.getValue()).toString().contains(CDS_VALID) || !((String)entry.getKey()).startsWith(serviceName)) continue;
                        temoralList.add((String)entry.getKey());
                        break;
                    }
                }
                if (!((String)fieldEntry.getKey()).startsWith(CDS_TEMPORAL)) continue;
                if (!((String)entry.getKey()).startsWith(serviceName)) continue block0;
                temoralList.add((String)entry.getKey());
                continue block0;
            }
        }
        return temoralList;
    }

    public static Boolean isLocalized(String serviceName, String entityName) {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return false;
        }
        if (CSNUtil.isDraftEnabledEntity(entityName, serviceName)) {
            return false;
        }
        if (CSNUtil.isDraftNodeEntity(entityName, serviceName)) {
            return false;
        }
        String fqEntityName = serviceName + DOT + entityName;
        JsonNode elementNode = csn.get(DEFINITIONS).get(fqEntityName);
        if (elementNode == null) {
            return false;
        }
        String localizedEntityName = "localized." + serviceName + DOT + entityName;
        if (csn.get(DEFINITIONS).get(localizedEntityName) != null) {
            return true;
        }
        return false;
    }

    public static Boolean isLocalizedForDraft(String serviceName, String entityName) {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return false;
        }
        String fqEntityName = serviceName + DOT + entityName;
        JsonNode elementNode = csn.get(DEFINITIONS).get(fqEntityName);
        if (elementNode == null) {
            return false;
        }
        String localizedEntityName = "localized." + serviceName + DOT + entityName;
        if (csn.get(DEFINITIONS).get(localizedEntityName) == null || elementNode.get(ELEMENTS) == null || elementNode.get(ELEMENTS).size() == 0) {
            return false;
        }
        Iterator elements = elementNode.get(ELEMENTS).elements();
        while (elements.hasNext()) {
            JsonNode property = (JsonNode)elements.next();
            if (property.get(LOCALIZED) == null || !property.get(LOCALIZED).asBoolean() || elementNode.get(ELEMENTS).get(LOCALIZED) == null || elementNode.get(ELEMENTS).get(LOCALIZED).get(TARGET) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnyTemporal(String serviceName, String entitySetName) {
        boolean temporal = false;
        List<String> temporalEntityList = CSNUtil.getTemporalEntities(serviceName);
        Map<String, List<String>> compositionTree = CSNUtil.getCompositionTree(serviceName, entitySetName);
        if (!compositionTree.isEmpty()) {
            for (Map.Entry<String, List<String>> id : compositionTree.entrySet()) {
                int i;
                if (id.getKey() != null) {
                    for (i = 0; i < temporalEntityList.size(); ++i) {
                        if (!id.getKey().equalsIgnoreCase(temporalEntityList.get(i).split("\\.")[1])) continue;
                        temporal = true;
                        break;
                    }
                }
                if (id.getValue().isEmpty()) continue;
                block2: for (i = 0; i < temporalEntityList.size(); ++i) {
                    for (int j = 0; j < id.getValue().size(); ++j) {
                        if (!id.getValue().get(j).equalsIgnoreCase(temporalEntityList.get(i).split("\\.")[1])) continue;
                        temporal = true;
                        continue block2;
                    }
                }
            }
        }
        return temporal;
    }

    public static boolean isTemporal(String serviceName, String requestURL) {
        boolean temporal = false;
        List<String> temporalEntityList = CSNUtil.getTemporalEntities(serviceName);
        for (int i = 0; i < temporalEntityList.size(); ++i) {
            if (!requestURL.toLowerCase().contains(temporalEntityList.get(i).split("\\.")[1].toLowerCase())) continue;
            temporal = true;
        }
        return temporal;
    }

    public static boolean isEntityTemporal(String serviceName, String entitySetName) {
        List<String> temporalEntityList = CSNUtil.getTemporalEntities(serviceName);
        Boolean temporal = false;
        for (int i = 0; i < temporalEntityList.size(); ++i) {
            if (!entitySetName.equals(temporalEntityList.get(i).split("\\.")[1])) continue;
            temporal = true;
            break;
        }
        return temporal;
    }

    public static List<String> getRootEntitiesWithDeltaEnabled(String serviceName, String entityName) {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return null;
        }
        HashMap<String, ArrayList<String>> entitiesAndCompositions = new HashMap();
        Map<Object, Object> rootEntitiesWithDeltaenabled = new HashMap();
        ArrayList<String> listOfEntitiesToBeUpdated = new ArrayList<String>();
        ArrayList<String> listOfRootEntitiesToBeUpdated = new ArrayList<String>();
        if (serviceName == null || serviceName.isEmpty()) {
            return listOfRootEntitiesToBeUpdated;
        }
        rootEntitiesWithDeltaenabled = CSNUtil.getRootEntitiesWithDeltaEnabled(csn, serviceName);
        entitiesAndCompositions = CSNUtil.getEntitiesAndComposition(csn, serviceName);
        ArrayList rootEntitesForService = (ArrayList)rootEntitiesWithDeltaenabled.get(serviceName);
        CSNUtil.updateListofEntitesToBeUpdated(listOfEntitiesToBeUpdated, serviceName + DOT + entityName, entitiesAndCompositions);
        for (int i = 0; i < rootEntitesForService.size(); ++i) {
            for (int j = 0; j < listOfEntitiesToBeUpdated.size(); ++j) {
                if (((String)rootEntitesForService.get(i)).compareTo(listOfEntitiesToBeUpdated.get(j)) != 0) continue;
                listOfRootEntitiesToBeUpdated.add(listOfEntitiesToBeUpdated.get(j));
            }
        }
        return listOfRootEntitiesToBeUpdated;
    }

    private static void updateListofEntitesToBeUpdated(ArrayList<String> listOfEntitiesToBeUpdated, String childEntity, Map<String, ArrayList<String>> entitiesAndCompositions) {
        for (Map.Entry<String, ArrayList<String>> entry : entitiesAndCompositions.entrySet()) {
            ArrayList<String> listOfChildren = entry.getValue();
            for (String child : listOfChildren) {
                if (!childEntity.equalsIgnoreCase(child)) continue;
                listOfEntitiesToBeUpdated.add(entry.getKey());
                CSNUtil.updateListofEntitesToBeUpdated(listOfEntitiesToBeUpdated, entry.getKey(), entitiesAndCompositions);
            }
        }
        if (listOfEntitiesToBeUpdated.isEmpty() && entitiesAndCompositions.containsKey(childEntity)) {
            listOfEntitiesToBeUpdated.add(childEntity);
        }
    }

    private static Map<String, ArrayList<String>> getRootEntitiesWithDeltaEnabled(JsonNode csn, String serviceName) {
        HashMap<String, ArrayList<String>> rootEntitiesWithDeltaenabled = new HashMap<String, ArrayList<String>>();
        JsonNode definitions = csn.get(DEFINITIONS);
        ArrayList<String> rootEntities = new ArrayList<String>();
        rootEntitiesWithDeltaenabled.put(serviceName, new ArrayList());
        Iterator fieldNames = definitions.fieldNames();
        while (fieldNames.hasNext()) {
            String fielName = (String)fieldNames.next();
            if (!fielName.startsWith(serviceName)) continue;
            rootEntities.add(fielName);
        }
        for (String rootString : rootEntities) {
            if (definitions.get(rootString).get(DELTA_ENABLED) == null || !definitions.get(rootString).get(DELTA_ENABLED).asBoolean()) continue;
            ((ArrayList)rootEntitiesWithDeltaenabled.get(serviceName)).add(rootString);
        }
        return rootEntitiesWithDeltaenabled;
    }

    private static Map<String, ArrayList<String>> getEntitiesAndComposition(JsonNode csn, String serviceName) {
        HashMap<String, ArrayList<String>> entitiesAndCompositions = new HashMap<String, ArrayList<String>>();
        JsonNode definitions = csn.get(DEFINITIONS);
        ArrayList<String> rootEntities = new ArrayList<String>();
        Iterator fieldNames = definitions.fieldNames();
        while (fieldNames.hasNext()) {
            String fielName = (String)fieldNames.next();
            if (!fielName.startsWith(serviceName)) continue;
            rootEntities.add(fielName);
        }
        for (String entity : rootEntities) {
            ArrayList<String> compositions = new ArrayList<String>();
            if (definitions.get(entity).get(ELEMENTS) == null) continue;
            Iterator iterator = definitions.get(entity).get(ELEMENTS).fields();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (((JsonNode)entry.getValue()).get(TYPE) == null || !((JsonNode)entry.getValue()).get(TYPE).asText().equals(CDS_COMPOSITION)) continue;
                compositions.add(((JsonNode)entry.getValue()).get(TARGET).asText());
            }
            if (compositions.size() <= 0) continue;
            entitiesAndCompositions.put(entity, compositions);
        }
        return entitiesAndCompositions;
    }

    public static String getcompositionPath(String serviceName, String root, String element) {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return null;
        }
        if (root.equals(element)) {
            return "";
        }
        String path = CSNUtil.getPathtoChild(serviceName + DOT + root, serviceName + DOT + element, serviceName, csn);
        if (path == null || path.length() == 0) {
            return null;
        }
        return path;
    }

    private static String getAssociationPropertyNameForTarget(String rootEntity, String entityToBeFound) {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return null;
        }
        JsonNode elementNode = csn.get(DEFINITIONS).get(rootEntity);
        if (elementNode == null || elementNode.get(ELEMENTS) == null || elementNode.get(ELEMENTS).size() == 0) {
            return null;
        }
        Iterator elements = elementNode.get(ELEMENTS).fields();
        while (elements.hasNext()) {
            Map.Entry property = (Map.Entry)elements.next();
            if (((JsonNode)property.getValue()).get(TARGET) == null || ((JsonNode)property.getValue()).get(TARGET).asText().compareTo(entityToBeFound) != 0) continue;
            return (String)property.getKey();
        }
        return null;
    }

    public static List<String> getKeys(String serviceName, String element) {
        ArrayList<String> keys = new ArrayList<String>();
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return null;
        }
        JsonNode elementNode = csn.get(DEFINITIONS).get(serviceName + DOT + element);
        if (elementNode == null || elementNode.get(ELEMENTS) == null || elementNode.get(ELEMENTS).size() == 0) {
            return null;
        }
        Iterator elements = elementNode.get(ELEMENTS).fields();
        while (elements.hasNext()) {
            Map.Entry property = (Map.Entry)elements.next();
            if (((JsonNode)property.getValue()).get("key") == null || !((JsonNode)property.getValue()).get("key").asBoolean()) continue;
            keys.add((String)property.getKey());
        }
        return keys;
    }

    public static List<Map<String, String>> getOrderByProperties(String serviceName, String entityName) {
        JsonNode propertyNode;
        JsonNode selectNode;
        JsonNode queryNode;
        ArrayList<Map<String, String>> orderByOptions = new ArrayList<Map<String, String>>();
        JsonNode csn = CSNUtil.getCsn();
        if (csn != null && csn.get(DEFINITIONS) != null && csn.get(DEFINITIONS).get(serviceName + DOT + entityName) != null && (queryNode = csn.get(DEFINITIONS).get(serviceName + DOT + entityName).get("query")) != null && (selectNode = queryNode.get("SELECT")) != null && (propertyNode = selectNode.get("orderBy")) != null) {
            for (JsonNode property : propertyNode) {
                JsonNode elementNameNode = property.get(REF);
                HashMap<String, String> selectProp = new HashMap<String, String>(1);
                String propertyName = elementNameNode.get(0).asText();
                String sort = property.get("sort") != null ? property.get("sort").asText() : "asc";
                selectProp.put(propertyName, sort);
                orderByOptions.add(selectProp);
            }
        }
        return orderByOptions;
    }

    public static boolean isDeltaEnabled(String serviceName, String entityName) {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return false;
        }
        List<String> roots = CSNUtil.getRootEntitiesWithDeltaEnabled(serviceName, entityName);
        if (roots != null && roots.size() > 0) {
            return true;
        }
        JsonNode deltaEnabled = csn.get(DEFINITIONS).get(serviceName + DOT + entityName);
        if (deltaEnabled != null) {
            return deltaEnabled.get(DELTA_ENABLED) != null && deltaEnabled.get(DELTA_ENABLED).asText().equals("true");
        }
        return false;
    }

    private static String getPathtoChild(String startEntity, String childTobeFound, String serviceName, JsonNode csn) {
        Map<Object, Object> entitiesAndCompositions = new HashMap();
        entitiesAndCompositions = CSNUtil.getEntitiesAndComposition(csn, serviceName);
        List childEntities = (List)entitiesAndCompositions.get(startEntity);
        if (childEntities == null) {
            return null;
        }
        for (int i = 0; i < childEntities.size(); ++i) {
            String assocName = CSNUtil.getAssociationPropertyNameForTarget(startEntity, (String)childEntities.get(i));
            if (assocName == null) continue;
            if (childTobeFound.compareToIgnoreCase((String)childEntities.get(i)) == 0) {
                return assocName;
            }
            String path = CSNUtil.getPathtoChild((String)childEntities.get(i), childTobeFound, serviceName, csn);
            if (path == null) {
                if (i != childEntities.size() - 1) continue;
                return null;
            }
            path = assocName + DOT + path;
            return path;
        }
        return null;
    }

    public static List<String> getAggregationColumns(String serviceName, String entityName) {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return null;
        }
        ArrayList<String> columnList = new ArrayList<String>();
        JsonNode entityNode = csn.get(DEFINITIONS).get(serviceName + DOT + entityName);
        if (entityNode != null) {
            JsonNode propertyNode = entityNode.get(ELEMENTS);
            Iterator it = propertyNode.fieldNames();
            while (it.hasNext()) {
                String colName = (String)it.next();
                if (propertyNode.get(colName).get("@Aggregation.default") == null) continue;
                columnList.add(colName);
            }
        }
        return columnList;
    }

    public static List<String> getAllColumns(String serviceName, String entityName) {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> columnList = new ArrayList<String>();
        JsonNode entityNode = csn.get(DEFINITIONS).get(serviceName + DOT + entityName);
        if (entityNode != null) {
            JsonNode propertyNode = entityNode.get(ELEMENTS);
            Iterator iterator = propertyNode.fields();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (CDS_COMPOSITION.equalsIgnoreCase(((JsonNode)entry.getValue()).get(TYPE).asText()) || CDS_ASSOCIATION.equalsIgnoreCase(((JsonNode)entry.getValue()).get(TYPE).asText())) continue;
                columnList.add((String)entry.getKey());
            }
        }
        return columnList;
    }

    public static String getTemporalDataType(String serviceName) {
        Map.Entry fieldEntry;
        Iterator FiledsinEachField;
        Map.Entry entry;
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return null;
        }
        Iterator nodes = csn.get(DEFINITIONS).fields();
        Iterator nodes1 = csn.get(DEFINITIONS).fields();
        String temporalKey = null;
        boolean breakcondition = false;
        String temporaldatatype = null;
        while (nodes.hasNext()) {
            entry = (Map.Entry)nodes.next();
            FiledsinEachField = ((JsonNode)entry.getValue()).fields();
            while (FiledsinEachField.hasNext()) {
                fieldEntry = (Map.Entry)FiledsinEachField.next();
                if (!((String)fieldEntry.getKey()).startsWith(CDS_TEMPORAL) || fieldEntry.getValue() == null || !((JsonNode)fieldEntry.getValue()).toString().contains("{") || !((JsonNode)fieldEntry.getValue()).toString().contains("}") || !((JsonNode)fieldEntry.getValue()).toString().contains(":")) continue;
                String parsedValue = ((JsonNode)fieldEntry.getValue()).toString().replace("{", "").replaceAll("}", "").split(":")[1];
                temporalKey = parsedValue.substring(1, parsedValue.length() - 1);
                break;
            }
            if (temporalKey == null) continue;
            break;
        }
        while (nodes1.hasNext()) {
            entry = (Map.Entry)nodes1.next();
            FiledsinEachField = ((JsonNode)entry.getValue()).fields();
            block3: while (FiledsinEachField.hasNext()) {
                Map.Entry property;
                Iterator propertyIterator;
                Map.Entry element;
                fieldEntry = (Map.Entry)FiledsinEachField.next();
                Iterator elementsIterator = null;
                if (!((String)fieldEntry.getKey()).startsWith(ELEMENTS)) continue;
                elementsIterator = ((JsonNode)fieldEntry.getValue()).fields();
                if (temporalKey != null) {
                    while (elementsIterator.hasNext()) {
                        element = (Map.Entry)elementsIterator.next();
                        if (((String)entry.getKey()).startsWith(serviceName) && ((String)element.getKey()).toString().equals(temporalKey)) {
                            propertyIterator = ((JsonNode)element.getValue()).fields();
                            while (propertyIterator.hasNext()) {
                                property = (Map.Entry)propertyIterator.next();
                                if (!((String)property.getKey()).toString().startsWith(TYPE)) continue;
                                temporaldatatype = ((JsonNode)property.getValue()).asText();
                                breakcondition = true;
                                break;
                            }
                        }
                        if (!breakcondition) continue;
                        continue block3;
                    }
                    continue;
                }
                while (elementsIterator.hasNext()) {
                    element = (Map.Entry)elementsIterator.next();
                    if (((String)entry.getKey()).startsWith(serviceName) && ((JsonNode)element.getValue()).toString().contains(CDS_VALID_FROM)) {
                        propertyIterator = ((JsonNode)element.getValue()).fields();
                        while (propertyIterator.hasNext()) {
                            property = (Map.Entry)propertyIterator.next();
                            if (!((String)property.getKey()).toString().startsWith(TYPE)) continue;
                            temporaldatatype = ((JsonNode)property.getValue()).asText();
                            breakcondition = true;
                            break;
                        }
                    }
                    if (!breakcondition) continue;
                    continue block3;
                }
            }
        }
        return temporaldatatype;
    }

    public static boolean isAutoExposedAndAutoExpose(String entityName, String serviceName) {
        JsonNode node;
        JsonNode csn = CSNUtil.getCsn();
        if (csn != null && (node = csn.get(DEFINITIONS).get(serviceName + DOT + entityName)) != null) {
            return node.get(CDS_AUTOEXPOSED) != null && node.get(CDS_AUTOEXPOSE) != null;
        }
        return false;
    }

    public static boolean isAutoExposed(String entityName, String serviceName) {
        JsonNode node;
        JsonNode csn = CSNUtil.getCsn();
        if (csn != null && (node = csn.get(DEFINITIONS).get(serviceName + DOT + entityName)) != null) {
            return node.get(CDS_AUTOEXPOSED) != null && node.get(CDS_AUTOEXPOSE) == null;
        }
        return false;
    }

    public static boolean isAggregatedEntity(String serviceName, String entityName) {
        JsonNode entityNode;
        JsonNode csn = CSNUtil.getCsn();
        return csn != null && (entityNode = csn.get(DEFINITIONS).get(serviceName + DOT + entityName)) != null && entityNode.get(AGGREGATED_ENTITY) != null && entityNode.get(AGGREGATED_ENTITY).asBoolean();
    }

    public static String getEtagProperty(String fullyQualifiedEntityName) {
        String result = null;
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return null;
        }
        JsonNode entityNode = csn.get(DEFINITIONS).get(fullyQualifiedEntityName);
        if (entityNode == null) {
            return null;
        }
        Iterator itr = entityNode.get(ELEMENTS).fields();
        while (itr != null && itr.hasNext()) {
            Map.Entry entry = (Map.Entry)itr.next();
            JsonNode property = (JsonNode)entry.getValue();
            if ((property.get(ODATA_ETAG) == null || !property.get(ODATA_ETAG).asBoolean()) && (property.get(CDS_ETAG) == null || !property.get(CDS_ETAG).asBoolean())) continue;
            result = (String)entry.getKey();
            break;
        }
        return result;
    }

    public static Map<String, List<String>> getReferences(String serviceName, String entityName, boolean readCompositionsOnly) {
        HashMap<String, List<String>> references = new HashMap<String, List<String>>();
        HashSet<String> fromProperty = new HashSet<String>();
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return null;
        }
        JsonNode entityNode = csn.get(DEFINITIONS).get(serviceName + DOT + entityName);
        if (entityNode != null) {
            JsonNode propertyNode = entityNode.get(ELEMENTS);
            Iterator iterator = propertyNode.fields();
            String key = null;
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (key == null && ((JsonNode)entry.getValue()).get("key") != null && ((JsonNode)entry.getValue()).get("key").asBoolean()) {
                    key = (String)entry.getKey();
                }
                if (!CDS_COMPOSITION.equalsIgnoreCase(((JsonNode)entry.getValue()).get(TYPE).asText()) && (!CDS_ASSOCIATION.equalsIgnoreCase(((JsonNode)entry.getValue()).get(TYPE).asText()) || readCompositionsOnly)) continue;
                ArrayList<String> fromToKeys = new ArrayList<String>(2);
                String from = null;
                String to = null;
                JsonNode ref = ((JsonNode)entry.getValue()).get(ON);
                if (ref != null) {
                    if (ref.get(0).get(REF).size() == 2) {
                        to = ref.get(0).get(REF).get(1).asText();
                    } else {
                        from = ref.get(0).get(REF).get(0).asText();
                    }
                    if (ref.get(2).get(REF).size() == 2) {
                        to = ref.get(2).get(REF).get(1).asText();
                    } else {
                        from = ref.get(2).get(REF).get(0).asText();
                    }
                } else {
                    ref = ((JsonNode)entry.getValue()).get("onCond");
                    if (ref != null) {
                        if (ref.get("args").get(0).get("=").asText().contains(DOT)) {
                            to = ref.get("args").get(0).get("=").asText();
                            to = to.substring(to.lastIndexOf(DOT) + 1);
                        } else {
                            from = ref.get("args").get(0).get("=").asText();
                        }
                        if (ref.get("args").get(1).get("=").asText().contains(DOT)) {
                            to = ref.get("args").get(1).get("=").asText();
                            to = to.substring(to.lastIndexOf(DOT) + 1);
                        } else {
                            from = ref.get("args").get(1).get("=").asText();
                        }
                    } else {
                        ref = ((JsonNode)entry.getValue()).get("keys");
                        if (ref != null) {
                            to = ref.get(0).get(REF).get(0).asText();
                            from = ref.get(0).get("$generatedFieldName").asText();
                        }
                    }
                }
                if ("$self".equals(from)) {
                    from = key;
                    to = key;
                }
                fromProperty.add(from);
                fromToKeys.add(from);
                fromToKeys.add(to);
                String navigationEntityName = ((JsonNode)entry.getValue()).get(TARGET).asText();
                navigationEntityName = navigationEntityName.substring(navigationEntityName.lastIndexOf(DOT) + 1);
                references.put(navigationEntityName, fromToKeys);
            }
        }
        if (!fromProperty.isEmpty()) {
            references.put(entityName, new ArrayList(fromProperty));
        }
        return references;
    }

    public static Map<String, List<String>> getReferences(String serviceName, String entityName) {
        return CSNUtil.getReferences(serviceName, entityName, false);
    }

    public static Integer getSnapshotStorageDays() {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return null;
        }
        JsonNode entityNode = csn.get(DEFINITIONS).get(SNAPSHOT_STORAGE_DAYS);
        if (entityNode != null) {
            return entityNode.asInt();
        }
        return null;
    }

    public static boolean isConsistentPagingOrDeltaEnabled() {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return false;
        }
        Iterator nodes = csn.get(DEFINITIONS).fields();
        while (nodes.hasNext()) {
            Map.Entry entry = (Map.Entry)nodes.next();
            JsonNode serviceNode = (JsonNode)entry.getValue();
            if (serviceNode != null && serviceNode.get(CDS_CONSISTENT_PAGING) != null && serviceNode.get(CDS_CONSISTENT_PAGING).asBoolean()) {
                return true;
            }
            if (serviceNode == null || serviceNode.get(DELTA_ENABLED) == null || !serviceNode.get(DELTA_ENABLED).asBoolean()) continue;
            return true;
        }
        return false;
    }

    public static String getNavName(String serviceName, String entityName, String targetNav) {
        String navName = null;
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return null;
        }
        JsonNode entityNode = csn.get(DEFINITIONS).get(serviceName + DOT + entityName);
        if (entityNode != null) {
            JsonNode propertyNode = entityNode.get(ELEMENTS);
            Iterator iterator = propertyNode.fields();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                JsonNode targetNode = ((JsonNode)entry.getValue()).get(TARGET);
                if (targetNode == null || !targetNode.asText().equals(serviceName + DOT + targetNav)) continue;
                return (String)entry.getKey();
            }
        }
        return navName;
    }

    public static boolean isAuditLogEnabled(String serviceName, String entityName, String operation) {
        JsonNode entityNode;
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return false;
        }
        boolean chkEntityEligible = false;
        boolean chkOperationEligible = false;
        JsonNode node = csn.get(DEFINITIONS).get(serviceName + DOT + entityName);
        if (node.get(KIND).asText().equals("view")) {
            String entity = node.get("source").asText();
            entityNode = csn.get(DEFINITIONS).get(entity);
        } else {
            entityNode = node;
        }
        if (entityNode.get(entitySemantics) != null) {
            chkEntityEligible = true;
            if (entityNode.get("@AuditLog.Operation." + operation) != null && entityNode.get("@AuditLog.Operation." + operation).asBoolean()) {
                chkOperationEligible = true;
            }
        } else if (entityNode.get(Semantics) != null) {
            chkEntityEligible = true;
            if (entityNode.get("@PersonalDataChangeLog.Operation." + operation) != null && entityNode.get("@PersonalDataChangeLog.Operation." + operation).asBoolean()) {
                chkOperationEligible = true;
            }
        }
        return chkEntityEligible && chkOperationEligible;
    }

    public static Map<String, AdminDataAnnotation> getDataMapForCoreComputed(String serviceName, String entityName) {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return new HashMap<String, AdminDataAnnotation>();
        }
        HashMap<String, AdminDataAnnotation> computeDataMap = new HashMap<String, AdminDataAnnotation>();
        JsonNode node = csn.get(DEFINITIONS).get(serviceName + DOT + entityName).get(ELEMENTS);
        Iterator it = node.fieldNames();
        while (it.hasNext()) {
            String colName = (String)it.next();
            JsonNode computeNode = node.get(colName).get(ODATA_COMPUTED);
            JsonNode virtualNode = node.get(colName).get(VIRTUAL);
            if (computeNode != null && computeNode.get(ODATA_HASH) != null && computeNode.get(ODATA_HASH).asText().equals("false")) {
                computeDataMap.put(colName, CSNUtil.getAdminDataAnnotation(computeNode.get(ODATA_HASH).asText(), false));
                continue;
            }
            if (computeNode == null || !computeNode.asBoolean() || virtualNode != null && virtualNode.asBoolean()) continue;
            computeDataMap.put(colName, AdminDataAnnotation.COMPUTED_FIELD);
        }
        return computeDataMap;
    }

    public static Map<String, AdminDataAnnotation> getDataMapForCoreImmutable(String serviceName, String entityName) {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return new HashMap<String, AdminDataAnnotation>();
        }
        HashMap<String, AdminDataAnnotation> computeDataMap = new HashMap<String, AdminDataAnnotation>();
        JsonNode node = csn.get(DEFINITIONS).get(serviceName + DOT + entityName).get(ELEMENTS);
        Iterator it = node.fieldNames();
        while (it.hasNext()) {
            String colName = (String)it.next();
            JsonNode computeNode = node.get(colName).get(ODATA_IMMUTABLE);
            if (computeNode != null && computeNode.get(ODATA_HASH) != null && computeNode.get(ODATA_HASH).asText().equals("false")) {
                computeDataMap.put(colName, CSNUtil.getAdminDataAnnotation(computeNode.get(ODATA_HASH).asText(), false));
                continue;
            }
            if (computeNode == null || !computeNode.asBoolean()) continue;
            computeDataMap.put(colName, AdminDataAnnotation.IMMUTABLE_FIELD);
        }
        return computeDataMap;
    }

    public static Set<String> getVirtualElement(String serviceName, String entityName) {
        JsonNode csn = CSNUtil.getCsn();
        if (csn == null) {
            return new HashSet<String>();
        }
        HashSet<String> VirtualElements = new HashSet<String>();
        if (csn.get(DEFINITIONS).get(serviceName + DOT + entityName) != null) {
            JsonNode node = csn.get(DEFINITIONS).get(serviceName + DOT + entityName).get(ELEMENTS);
            Iterator it = node.fieldNames();
            while (it.hasNext()) {
                String colName = (String)it.next();
                JsonNode virtualNode = node.get(colName).get(VIRTUAL);
                if (virtualNode == null || !virtualNode.asBoolean()) continue;
                VirtualElements.add(colName);
            }
        }
        return VirtualElements;
    }

    public static boolean checkVirtualElement(String propName, Set<String> virtualElements) {
        if (virtualElements == null) {
            return false;
        }
        if (virtualElements.isEmpty()) {
            return false;
        }
        for (String ve : virtualElements) {
            if (propName.equals(ve)) {
                return true;
            }
            if (!propName.contains(ve.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    public static String getAggregationRefElement(String serviceName, String element, String entity) {
        JsonNode csn = CSNUtil.getCsn();
        String refrenceElement = null;
        JsonNode aggregation = csn.get(DEFINITIONS).get(serviceName + DOT + entity).get(ELEMENTS).get(element).get("@Aggregation.referenceElement");
        if (aggregation != null) {
            StringBuilder refElement = new StringBuilder();
            aggregation.forEach(refEl -> {
                if (refElement.length() > 0) {
                    refElement.append(", " + refEl.asText());
                } else {
                    refElement.append(refEl.asText());
                }
            });
            refrenceElement = refElement.toString();
        }
        return refrenceElement;
    }

    public static String getCDSParamDataType(String entityName, String serviceName, String paramName) {
        JsonNode entityNode = CSNUtil.getCsn().get(DEFINITIONS).get(serviceName + DOT + entityName);
        if (entityNode != null) {
            return entityNode.get(PARAMS).get(paramName).get(TYPE).asText();
        }
        return null;
    }

    public static Map<String, String> getReferentialConstarint(String serviceName, String entityName, String navigation) {
        HashMap<String, String> refConstarints = null;
        try {
            JsonNode csn = CSNUtil.getCsn();
            String childProperty = null;
            String parentProperty = null;
            refConstarints = new HashMap<String, String>();
            if (csn == null) {
                return null;
            }
            JsonNode insertable = csn.get(DEFINITIONS).get(serviceName + DOT + entityName).get(ELEMENTS).get(navigation);
            ArrayNode node = (ArrayNode)insertable.get(ON);
            for (int i = 0; i < node.size(); ++i) {
                ArrayNode refNode = (ArrayNode)node.get(i).get(REF);
                if (refNode != null && refNode.size() == 2) {
                    childProperty = node.get(i).get(REF).get(1).asText();
                } else if (refNode != null && refNode.size() == 1) {
                    parentProperty = node.get(i).get(REF).get(0).asText();
                }
                if (parentProperty == null || childProperty == null) continue;
                refConstarints.put(parentProperty, childProperty);
                parentProperty = null;
                childProperty = null;
            }
        }
        catch (Exception e) {
            logger.error(NO_REF_CONSTRAINT);
            return null;
        }
        return refConstarints;
    }

    static {
        initialized = false;
        objectMapper = new ObjectMapper();
        logger = LoggerFactory.getLogger(CSNUtil.class);
        parsedCsnModels = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<HashedData, JsonNode>(){

            public JsonNode load(HashedData key) throws IOException {
                return objectMapper.readTree(key.getData());
            }
        });
    }
}

