/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.uri.expression;

import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.api.uri.expression.BinaryExpression;
import org.apache.olingo.odata2.api.uri.expression.BinaryOperator;
import org.apache.olingo.odata2.api.uri.expression.CommonExpression;
import org.apache.olingo.odata2.api.uri.expression.ExceptionVisitExpression;
import org.apache.olingo.odata2.api.uri.expression.ExpressionKind;
import org.apache.olingo.odata2.api.uri.expression.ExpressionVisitor;
import org.apache.olingo.odata2.core.uri.expression.InfoBinaryOperator;
import org.apache.olingo.odata2.core.uri.expression.Token;

public class BinaryExpressionImpl
implements BinaryExpression {
    protected final InfoBinaryOperator operatorInfo;
    protected final CommonExpression leftSide;
    protected final CommonExpression rightSide;
    protected final Token token;
    protected EdmType edmType;

    public BinaryExpressionImpl(InfoBinaryOperator operatorInfo, CommonExpression leftSide, CommonExpression rightSide, Token token) {
        this.operatorInfo = operatorInfo;
        this.leftSide = leftSide;
        this.rightSide = rightSide;
        this.token = token;
        this.edmType = null;
    }

    @Override
    public BinaryOperator getOperator() {
        return this.operatorInfo.getOperator();
    }

    @Override
    public CommonExpression getLeftOperand() {
        return this.leftSide;
    }

    @Override
    public CommonExpression getRightOperand() {
        return this.rightSide;
    }

    @Override
    public EdmType getEdmType() {
        return this.edmType;
    }

    @Override
    public CommonExpression setEdmType(EdmType edmType) {
        this.edmType = edmType;
        return this;
    }

    @Override
    public ExpressionKind getKind() {
        return ExpressionKind.BINARY;
    }

    @Override
    public String getUriLiteral() {
        return this.operatorInfo.getSyntax();
    }

    @Override
    public Object accept(ExpressionVisitor visitor) throws ExceptionVisitExpression, ODataApplicationException {
        Object retLeftSide = this.leftSide.accept(visitor);
        Object retRightSide = this.rightSide.accept(visitor);
        return visitor.visitBinary(this, this.operatorInfo.getOperator(), retLeftSide, retRightSide);
    }

    public Token getToken() {
        return this.token;
    }
}

