/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.edm;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.core.edm.AbstractSimpleType;
import org.apache.olingo.odata2.core.edm.EdmDateTime;

public class EdmDateTimeOffset
extends AbstractSimpleType {
    private static final Pattern PATTERN = Pattern.compile("\\p{Digit}{1,4}-\\p{Digit}{1,2}-\\p{Digit}{1,2}T\\p{Digit}{1,2}:\\p{Digit}{1,2}(?::\\p{Digit}{1,2}(?:\\.\\p{Digit}{1,7})?)?(Z|([-+]\\p{Digit}{1,2}:\\p{Digit}{2}))?");
    private static final Pattern JSON_PATTERN = Pattern.compile("/Date\\((-?\\p{Digit}+)(?:(\\+|-)(\\p{Digit}{1,4}))?\\)/");
    private static final EdmDateTimeOffset instance = new EdmDateTimeOffset();

    public static EdmDateTimeOffset getInstance() {
        return instance;
    }

    @Override
    public Class<?> getDefaultType() {
        return Calendar.class;
    }

    @Override
    protected <T> T internalValueOfString(String value, EdmLiteralKind literalKind, EdmFacets facets, Class<T> returnType) throws EdmSimpleTypeException {
        Matcher matcher;
        if (literalKind == EdmLiteralKind.URI) {
            if (value.length() > 16 && value.toLowerCase().startsWith("datetimeoffset'") && value.endsWith("'")) {
                return this.internalValueOfString(value.substring(15, value.length() - 1), EdmLiteralKind.DEFAULT, facets, returnType);
            }
            throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value));
        }
        Calendar dateTimeValue = null;
        long millis = 0L;
        if (literalKind == EdmLiteralKind.JSON && (matcher = JSON_PATTERN.matcher(value)).matches()) {
            try {
                millis = Long.parseLong(matcher.group(1));
            }
            catch (NumberFormatException e) {
                throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value), (Throwable)e);
            }
            String timeZone = "GMT";
            if (matcher.group(2) != null) {
                int offsetInMinutes = Integer.parseInt(matcher.group(3));
                if (offsetInMinutes >= 1440) {
                    throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value));
                }
                if (offsetInMinutes != 0) {
                    timeZone = timeZone + matcher.group(2) + String.valueOf(offsetInMinutes / 60) + ":" + String.format("%02d", offsetInMinutes % 60);
                    millis -= (long)(("+".equals(matcher.group(2)) ? 1 : -1) * offsetInMinutes * 60 * 1000);
                }
            }
            dateTimeValue = Calendar.getInstance(TimeZone.getTimeZone(timeZone));
        }
        int nanoSeconds = 0;
        if (dateTimeValue == null) {
            Matcher matcher2 = PATTERN.matcher(value);
            if (!matcher2.matches()) {
                throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value));
            }
            String timeZoneOffset = matcher2.group(1) != null && matcher2.group(2) != null && !matcher2.group(2).matches("[-+]0+:0+") ? matcher2.group(2) : null;
            dateTimeValue = Calendar.getInstance(TimeZone.getTimeZone("GMT" + timeZoneOffset));
            if (dateTimeValue.get(15) == 0 && timeZoneOffset != null) {
                throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value));
            }
            dateTimeValue.clear();
            Timestamp timestamp = EdmDateTime.getInstance().internalValueOfString(value.substring(0, matcher2.group(1) == null ? value.length() : matcher2.start(1)), EdmLiteralKind.DEFAULT, facets, Timestamp.class);
            millis = timestamp.getTime() - (long)dateTimeValue.get(15);
            nanoSeconds = timestamp.getNanos();
            if (nanoSeconds != 0 && timeZoneOffset == null) {
                Class<Timestamp> returnTypeTmsp = Timestamp.class;
                if (returnTypeTmsp.isAssignableFrom(Timestamp.class)) {
                    Timestamp tmStamp = new Timestamp(millis);
                    tmStamp.setNanos(nanoSeconds);
                    return returnTypeTmsp.cast(tmStamp);
                }
            } else if (nanoSeconds % 1000000 != 0 && !returnType.isAssignableFrom(Timestamp.class)) {
                throw new EdmSimpleTypeException(EdmSimpleTypeException.LITERAL_ILLEGAL_CONTENT.addContent(value));
            }
        }
        if (returnType.isAssignableFrom(Calendar.class)) {
            dateTimeValue.clear();
            dateTimeValue.setTimeInMillis(millis);
            return returnType.cast(dateTimeValue);
        }
        if (returnType.isAssignableFrom(Long.class)) {
            return returnType.cast(millis);
        }
        if (returnType.isAssignableFrom(Date.class)) {
            return returnType.cast(new Date(millis));
        }
        if (returnType.isAssignableFrom(Timestamp.class)) {
            Timestamp timestamp = new Timestamp(millis);
            if (literalKind != EdmLiteralKind.JSON) {
                timestamp.setNanos(nanoSeconds);
            }
            return returnType.cast(timestamp);
        }
        throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(returnType));
    }

    @Override
    protected <T> String internalValueToString(T value, EdmLiteralKind literalKind, EdmFacets facets) throws EdmSimpleTypeException {
        int offset;
        Calendar dateTimeValue;
        Long milliSeconds;
        if (value instanceof Date) {
            milliSeconds = ((Date)value).getTime();
            dateTimeValue = Calendar.getInstance();
            dateTimeValue.setTime((Date)value);
            offset = dateTimeValue.get(15) + dateTimeValue.get(16);
        } else if (value instanceof Calendar) {
            dateTimeValue = (Calendar)((Calendar)value).clone();
            milliSeconds = dateTimeValue.getTimeInMillis();
            offset = dateTimeValue.get(15) + dateTimeValue.get(16);
        } else if (value instanceof Long) {
            milliSeconds = (Long)value;
            offset = 0;
        } else {
            throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED.addContent(value.getClass()));
        }
        milliSeconds = milliSeconds + (long)offset;
        int offsetInMinutes = offset / 60 / 1000;
        if (literalKind == EdmLiteralKind.JSON) {
            if (value instanceof Timestamp && ((Timestamp)value).getNanos() % 1000000 != 0) {
                throw new EdmSimpleTypeException(EdmSimpleTypeException.VALUE_ILLEGAL_CONTENT.addContent(value));
            }
            return "/Date(" + milliSeconds + (offset == 0 ? "" : String.format("%+05d", offsetInMinutes)) + ")/";
        }
        String localTimeString = EdmDateTime.getInstance().valueToString(value instanceof Timestamp ? value : milliSeconds, EdmLiteralKind.DEFAULT, facets);
        int offsetHours = offsetInMinutes / 60;
        int offsetMinutes = Math.abs(offsetInMinutes % 60);
        String offsetString = offset == 0 ? "Z" : String.format("%+03d:%02d", offsetHours, offsetMinutes);
        return localTimeString + offsetString;
    }

    @Override
    public String toUriLiteral(String literal) throws EdmSimpleTypeException {
        return "datetimeoffset'" + literal + "'";
    }
}

