/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.client.core.uri.util;

import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.client.api.uri.QueryOption;
import org.apache.olingo.odata2.client.api.uri.SegmentType;
import org.apache.olingo.odata2.client.core.uri.Segment;
import org.apache.olingo.odata2.core.commons.Encoder;

public class UriUtil {
    private UriUtil() {
    }

    public static URI getUri(List<Segment> segments, Map<String, String> queryOptions, Map<String, String> customQueryOptions, Map<String, Object> functionImportParameters) {
        StringBuilder segmentsBuilder = new StringBuilder();
        if (segments.size() == 1 && segments.get(0).getType() == SegmentType.INITIAL && customQueryOptions.isEmpty() && queryOptions.isEmpty() && functionImportParameters.isEmpty()) {
            segmentsBuilder.append(segments.get(0).getValue());
            if (segmentsBuilder.charAt(segmentsBuilder.length() - 1) != '/') {
                segmentsBuilder.append('/');
            }
            return URI.create(segmentsBuilder.toString());
        }
        for (Segment seg : segments) {
            if (segmentsBuilder.length() > 0 && seg.getType() != SegmentType.KEY && seg.getType() != SegmentType.NAVIGATION_TO_MANY_WITH_KEY && seg.getType() != SegmentType.FUNCTIONIMPORT_WITH_KEY && segmentsBuilder.charAt(segmentsBuilder.length() - 1) != '/') {
                segmentsBuilder.append('/');
            }
            segmentsBuilder.append(seg.getValue());
        }
        try {
            if (!queryOptions.isEmpty()) {
                UriUtil.appendQuerySegmentDelimiter(true, true, segmentsBuilder);
                int i = 0;
                for (Map.Entry<String, String> option : queryOptions.entrySet()) {
                    UriUtil.appendQuerySegments(QueryOption.valueOf(option.getKey()).getValue(), option.getValue(), segmentsBuilder, true);
                    if (++i >= queryOptions.size()) continue;
                    segmentsBuilder.append("&");
                }
            }
            if (!customQueryOptions.isEmpty()) {
                UriUtil.appendQuerySegmentDelimiter(queryOptions.isEmpty(), true, segmentsBuilder);
                int i = 0;
                for (Map.Entry<String, String> option : customQueryOptions.entrySet()) {
                    UriUtil.appendQuerySegments(option.getKey(), option.getValue(), segmentsBuilder, false);
                    if (++i >= customQueryOptions.size()) continue;
                    segmentsBuilder.append("&");
                }
            }
            if (!functionImportParameters.isEmpty()) {
                UriUtil.appendQuerySegmentDelimiter(queryOptions.isEmpty(), customQueryOptions.isEmpty(), segmentsBuilder);
                int i = 0;
                for (Map.Entry<String, Object> funcParam : functionImportParameters.entrySet()) {
                    UriUtil.appendQuerySegments(funcParam.getKey(), funcParam.getValue(), segmentsBuilder, false);
                    if (++i >= functionImportParameters.size()) continue;
                    segmentsBuilder.append("&");
                }
            }
            return URI.create(segmentsBuilder.toString());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Could not build valid URI", e);
        }
    }

    private static void appendQuerySegmentDelimiter(boolean isQueryOptions, boolean isCustomQueryOptions, StringBuilder segmentsBuilder) {
        if (!isQueryOptions || !isCustomQueryOptions) {
            segmentsBuilder.append("&");
        } else {
            segmentsBuilder.append("?");
        }
    }

    private static void appendQuerySegments(String name, Object value, StringBuilder segmentsBuilder, boolean isQueryOption) {
        if (isQueryOption) {
            segmentsBuilder.append(name);
        } else {
            segmentsBuilder.append(Encoder.encode(name));
        }
        segmentsBuilder.append("=");
        segmentsBuilder.append(Encoder.encode(value.toString()));
    }

    public static String join(String[] items, String separator) {
        return UriUtil.join(items, separator, 0, items.length);
    }

    private static String join(String[] items, String separator, int startIndex, int endIndex) {
        int noOfItems;
        if (items == null) {
            return null;
        }
        if (separator == null) {
            separator = "";
        }
        if ((noOfItems = endIndex - startIndex) <= 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder(noOfItems * 16);
        for (int i = startIndex; i < endIndex; ++i) {
            if (i > startIndex) {
                buf.append(separator);
            }
            if (items[i] == null) continue;
            buf.append(items[i]);
        }
        return buf.toString();
    }

    public static void appendQueryOption(String paramName, String paramValue, Map<String, String> queryOptions, boolean replace) {
        StringBuilder builder = new StringBuilder();
        if (!replace && queryOptions.containsKey(paramName)) {
            builder.append(queryOptions.get(paramName)).append(',');
        }
        builder.append(paramValue);
        queryOptions.put(paramName, builder.toString());
    }
}

