/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.client.core.ep.serializer;

import java.io.IOException;
import java.io.Writer;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.client.api.ep.Entity;
import org.apache.olingo.odata2.client.api.ep.EntityCollection;
import org.apache.olingo.odata2.client.api.ep.EntityCollectionSerializerProperties;
import org.apache.olingo.odata2.client.api.ep.EntitySerializerProperties;
import org.apache.olingo.odata2.client.core.ep.serializer.JsonEntryEntitySerializer;
import org.apache.olingo.odata2.core.ep.EntityProviderProducerException;
import org.apache.olingo.odata2.core.ep.aggregator.EntityInfoAggregator;
import org.apache.olingo.odata2.core.ep.util.JsonStreamWriter;

public class JsonFeedEntitySerializer {
    private final EntityCollectionSerializerProperties properties;

    public JsonFeedEntitySerializer(EntityCollectionSerializerProperties properties) {
        this.properties = properties == null ? EntityCollectionSerializerProperties.serviceRoot(null).build() : properties;
    }

    public void appendAsArray(Writer writer, EntityInfoAggregator entityInfo, EntityCollection data) throws EntityProviderException {
        JsonStreamWriter jsonStreamWriter = new JsonStreamWriter(writer);
        try {
            jsonStreamWriter.beginArray();
            this.appendEntries(writer, entityInfo, data, jsonStreamWriter);
            jsonStreamWriter.endArray();
        }
        catch (IOException e) {
            throw new EntityProviderProducerException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
    }

    public void appendAsObject(Writer writer, EntityInfoAggregator entityInfo, EntityCollection data) throws EntityProviderException {
        if (data == null) {
            throw new EntityProviderException(EntityProviderException.NULL_VALUE);
        }
        JsonStreamWriter jsonStreamWriter = new JsonStreamWriter(writer);
        try {
            jsonStreamWriter.beginObject();
            jsonStreamWriter.name("results").beginArray();
            this.appendEntries(writer, entityInfo, data, jsonStreamWriter);
            jsonStreamWriter.endArray();
            jsonStreamWriter.endObject();
        }
        catch (IOException e) {
            throw new EntityProviderProducerException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
    }

    private void appendEntries(Writer writer, EntityInfoAggregator entityInfo, EntityCollection data, JsonStreamWriter jsonStreamWriter) throws EntityProviderException, IOException {
        boolean first = true;
        for (Entity entryData : data.getEntities()) {
            if (first) {
                first = false;
            } else {
                jsonStreamWriter.separator();
            }
            EntitySerializerProperties entryProperties = entryData == null || entryData.getWriteProperties() == null ? (data.getGlobalEntityProperties() != null ? data.getGlobalEntityProperties() : EntitySerializerProperties.serviceRoot(this.properties.getServiceRoot()).build()) : entryData.getWriteProperties();
            JsonEntryEntitySerializer entryProducer = new JsonEntryEntitySerializer(entryProperties);
            entryProducer.append(writer, entityInfo, entryData);
        }
    }
}

