/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.client.core.ep.serializer;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.olingo.odata2.api.edm.EdmCustomizableFeedMappings;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmMapping;
import org.apache.olingo.odata2.api.edm.EdmMultiplicity;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.client.api.ep.Entity;
import org.apache.olingo.odata2.client.api.ep.EntityCollection;
import org.apache.olingo.odata2.client.api.ep.EntityCollectionSerializerProperties;
import org.apache.olingo.odata2.client.api.ep.EntitySerializerProperties;
import org.apache.olingo.odata2.client.core.ep.serializer.AtomFeedSerializer;
import org.apache.olingo.odata2.client.core.ep.serializer.XmlPropertyEntitySerializer;
import org.apache.olingo.odata2.core.commons.ContentType;
import org.apache.olingo.odata2.core.commons.Encoder;
import org.apache.olingo.odata2.core.edm.EdmDateTimeOffset;
import org.apache.olingo.odata2.core.ep.EntityProviderProducerException;
import org.apache.olingo.odata2.core.ep.aggregator.EntityInfoAggregator;
import org.apache.olingo.odata2.core.ep.aggregator.EntityPropertyInfo;

public class AtomEntryEntitySerializer {
    private final EntitySerializerProperties properties;
    private static final String VALUE = "/$value";

    public AtomEntryEntitySerializer(EntitySerializerProperties properties) {
        this.properties = properties == null ? EntitySerializerProperties.serviceRoot(null).build() : properties;
    }

    public void append(XMLStreamWriter writer, EntityInfoAggregator eia, Entity data, boolean isRootElement, boolean isFeedPart) throws EntityProviderException {
        try {
            if (this.properties.getServiceRoot() == null) {
                throw new EntityProviderProducerException(EntityProviderException.MANDATORY_WRITE_PROPERTY);
            }
            writer.writeStartElement("entry");
            if (isRootElement) {
                writer.writeDefaultNamespace("http://www.w3.org/2005/Atom");
                writer.writeNamespace("m", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata");
                writer.writeNamespace("d", "http://schemas.microsoft.com/ado/2007/08/dataservices");
            }
            if (!isFeedPart) {
                writer.writeAttribute("xml", "http://www.w3.org/XML/1998/namespace", "base", this.properties.getServiceRoot().toASCIIString());
            }
            String selfLink = null;
            if (this.properties.isIncludeMetadata()) {
                selfLink = AtomEntryEntitySerializer.createSelfLink(eia, data.getProperties(), null, this.properties.isKeyAutoGenerated(), false);
                this.appendAtomMandatoryParts(writer, eia, data.getProperties());
                this.appendAtomOptionalParts(writer, eia, data.getProperties());
                this.appendAtomEditLink(writer, eia, selfLink);
                if (eia.getEntityType().hasStream()) {
                    this.appendAtomContentLink(writer, eia, data.getProperties(), selfLink);
                }
            }
            this.appendNavigationLinks(writer, eia, data);
            this.appendCustomProperties(writer, eia, data.getProperties());
            if (eia.getEntityType().hasStream()) {
                if (this.properties.isIncludeMetadata()) {
                    this.appendAtomContentPart(writer, eia, data.getProperties(), selfLink);
                }
                this.appendProperties(writer, eia, data.getProperties());
            } else {
                writer.writeStartElement("content");
                writer.writeAttribute("type", ContentType.APPLICATION_XML.toString());
                this.appendProperties(writer, eia, data.getProperties());
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.flush();
        }
        catch (XMLStreamException e) {
            throw new EntityProviderProducerException(EntityProviderException.COMMON, (Throwable)e);
        }
        catch (EdmException e) {
            throw new EntityProviderProducerException(e.getMessageReference(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new EntityProviderProducerException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    private void appendNavigationLinks(XMLStreamWriter writer, EntityInfoAggregator eia, Entity data) throws EntityProviderException, EdmException, URISyntaxException, XMLStreamException {
        for (Map.Entry<String, Object> entry : data.getNavigations().entrySet()) {
            boolean isFeed;
            EntityInfoAggregator targetEntityInfo = EntityInfoAggregator.create(eia.getEntitySet().getRelatedEntitySet((EdmNavigationProperty)eia.getEntityType().getProperty(entry.getKey())));
            boolean bl = isFeed = eia.getNavigationPropertyInfo(entry.getKey()).getMultiplicity() == EdmMultiplicity.MANY;
            if (entry.getValue() == null) {
                throw new EntityProviderProducerException(EntityProviderProducerException.NULL_VALUE);
            }
            if (entry.getValue() instanceof Map) {
                Map navigationKeyMap = (Map)entry.getValue();
                if (navigationKeyMap == null || navigationKeyMap.isEmpty()) continue;
                this.appendAtomNavigationLink(writer, AtomEntryEntitySerializer.createSelfLink(targetEntityInfo, navigationKeyMap, null, this.properties.isKeyAutoGenerated(), false), entry.getKey(), isFeed);
                writer.writeEndElement();
                continue;
            }
            if (entry.getValue() instanceof Entity) {
                Entity navigationEntity = (Entity)entry.getValue();
                Map<String, Object> navigationKeyMap = navigationEntity.getProperties();
                if (navigationKeyMap == null || navigationKeyMap.isEmpty()) continue;
                String navigationPropertyName = entry.getKey();
                String selfLink = AtomEntryEntitySerializer.createSelfLink(eia, data.getProperties(), navigationPropertyName, this.properties.isKeyAutoGenerated(), false);
                this.appendNavigationLink(writer, selfLink, navigationPropertyName);
                writer.writeAttribute("type", ContentType.APPLICATION_ATOM_XML_ENTRY.toString());
                this.appendInlineEntry(writer, navigationPropertyName, eia, data);
                writer.writeEndElement();
                continue;
            }
            if (entry.getValue() instanceof EntityCollection) {
                String navigationPropertyName = entry.getKey();
                String selfLink = AtomEntryEntitySerializer.createSelfLink(eia, data.getProperties(), navigationPropertyName, this.properties.isKeyAutoGenerated(), false);
                if (((EntityCollection)entry.getValue()).getEntities().isEmpty()) continue;
                this.appendNavigationLink(writer, selfLink, navigationPropertyName);
                writer.writeAttribute("type", ContentType.APPLICATION_ATOM_XML_FEED.toString());
                this.appendInlineFeed(writer, navigationPropertyName, eia, data);
                writer.writeEndElement();
                continue;
            }
            throw new EntityProviderProducerException(EntityProviderProducerException.INCORRECT_NAVIGATION_TYPE);
        }
    }

    private void appendNavigationLink(XMLStreamWriter writer, String selfLink, String navigationPropertyName) throws XMLStreamException {
        writer.writeStartElement("link");
        writer.writeAttribute("href", selfLink);
        writer.writeAttribute("rel", "http://schemas.microsoft.com/ado/2007/08/dataservices/related/" + navigationPropertyName);
        writer.writeAttribute("title", navigationPropertyName);
    }

    private void appendCustomProperties(XMLStreamWriter writer, EntityInfoAggregator eia, Map<String, Object> data) throws EntityProviderException {
        List<String> noneSyndicationTargetPaths = eia.getNoneSyndicationTargetPathNames();
        for (String tpName : noneSyndicationTargetPaths) {
            EntityPropertyInfo info = eia.getTargetPathInfo(tpName);
            String name = info.getName();
            XmlPropertyEntitySerializer aps = new XmlPropertyEntitySerializer(this.properties);
            aps.appendCustomProperty(writer, name, info, data.get(name));
        }
    }

    private void appendAtomNavigationLink(XMLStreamWriter writer, String target, String navigationPropertyName, boolean isFeed) throws EntityProviderException, EdmException, URISyntaxException {
        try {
            writer.writeStartElement("link");
            writer.writeAttribute("href", target);
            writer.writeAttribute("rel", "http://schemas.microsoft.com/ado/2007/08/dataservices/related/" + navigationPropertyName);
            writer.writeAttribute("title", navigationPropertyName);
            if (isFeed) {
                writer.writeAttribute("type", ContentType.APPLICATION_ATOM_XML_FEED.toString());
            } else {
                writer.writeAttribute("type", ContentType.APPLICATION_ATOM_XML_ENTRY.toString());
            }
        }
        catch (XMLStreamException e) {
            throw new EntityProviderProducerException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    private void appendInlineFeed(XMLStreamWriter writer, String navigationPropertyName, EntityInfoAggregator eia, Entity data) throws EntityProviderException, XMLStreamException, EdmException {
        if (eia.getNavigationPropertyNames().contains(navigationPropertyName) && data != null && data.getNavigations().containsKey(navigationPropertyName)) {
            EdmNavigationProperty navProp = (EdmNavigationProperty)eia.getEntityType().getProperty(navigationPropertyName);
            if (navProp == null) {
                throw new EntityProviderProducerException(EntityProviderException.EXPANDNOTSUPPORTED);
            }
            EntityCollection inlineData = (EntityCollection)data.getNavigation(navigationPropertyName);
            if (inlineData == null) {
                inlineData = new EntityCollection();
            }
            if (inlineData.getEntities().isEmpty()) {
                return;
            }
            writer.writeStartElement("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "inline");
            EntityCollectionSerializerProperties inlineProperties = inlineData.getCollectionProperties() == null ? EntityCollectionSerializerProperties.serviceRoot(data.getWriteProperties().getServiceRoot()).build() : inlineData.getCollectionProperties();
            EdmEntitySet inlineEntitySet = eia.getEntitySet().getRelatedEntitySet(navProp);
            AtomFeedSerializer inlineFeedProducer = new AtomFeedSerializer(inlineProperties);
            inlineData.setCollectionProperties(inlineProperties);
            EntityInfoAggregator inlineEia = EntityInfoAggregator.create(inlineEntitySet, null);
            inlineFeedProducer.append(writer, inlineEia, inlineData, true);
            writer.writeEndElement();
        }
    }

    private void appendInlineEntry(XMLStreamWriter writer, String navigationPropertyName, EntityInfoAggregator eia, Entity data) throws EntityProviderException, XMLStreamException, EdmException {
        if (data.getNavigations() != null && data.getNavigations().containsKey(navigationPropertyName)) {
            EdmNavigationProperty navProp = (EdmNavigationProperty)eia.getEntityType().getProperty(navigationPropertyName);
            Entity inlineData = (Entity)data.getNavigation(navigationPropertyName);
            if (inlineData == null || inlineData.getProperties().size() == 0) {
                return;
            }
            writer.writeStartElement("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "inline");
            if (inlineData != null && !inlineData.getProperties().isEmpty()) {
                inlineData.setWriteProperties(inlineData.getWriteProperties() == null ? data.getWriteProperties() : inlineData.getWriteProperties());
                EdmEntitySet inlineEntitySet = eia.getEntitySet().getRelatedEntitySet(navProp);
                AtomEntryEntitySerializer inlineProducer = new AtomEntryEntitySerializer(inlineData.getWriteProperties());
                EntityInfoAggregator inlineEia = EntityInfoAggregator.create(inlineEntitySet, null);
                inlineProducer.append(writer, inlineEia, inlineData, false, false);
            }
            writer.writeEndElement();
        }
    }

    private void appendAtomEditLink(XMLStreamWriter writer, EntityInfoAggregator eia, String selfLink) throws EntityProviderException {
        try {
            writer.writeStartElement("link");
            writer.writeAttribute("href", selfLink);
            writer.writeAttribute("rel", "edit");
            writer.writeAttribute("title", eia.getEntityType().getName());
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new EntityProviderProducerException(EntityProviderException.COMMON, (Throwable)e);
        }
        catch (EdmException e) {
            throw new EntityProviderProducerException(e.getMessageReference(), (Throwable)e);
        }
    }

    private void appendAtomContentLink(XMLStreamWriter writer, EntityInfoAggregator eia, Map<String, Object> data, String selfLink) throws EntityProviderException, EdmException {
        try {
            String mediaResourceMimeTypeKey;
            String mediaResourceMimeType = null;
            EdmMapping entityTypeMapping = eia.getEntityType().getMapping();
            if (entityTypeMapping != null && (mediaResourceMimeTypeKey = entityTypeMapping.getMediaResourceMimeTypeKey()) != null) {
                mediaResourceMimeType = (String)data.get(mediaResourceMimeTypeKey);
            }
            if (mediaResourceMimeType == null) {
                mediaResourceMimeType = ContentType.APPLICATION_OCTET_STREAM.toString();
            }
            writer.writeStartElement("link");
            writer.writeAttribute("href", selfLink + VALUE);
            writer.writeAttribute("rel", "edit-media");
            writer.writeAttribute("type", mediaResourceMimeType);
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new EntityProviderProducerException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    private void appendAtomContentPart(XMLStreamWriter writer, EntityInfoAggregator eia, Map<String, Object> data, String selfLink) throws EntityProviderException, EdmException {
        try {
            EdmMapping entityTypeMapping = eia.getEntityType().getMapping();
            String self = null;
            String mediaResourceMimeType = null;
            if (entityTypeMapping != null) {
                String mediaResourceMimeTypeKey;
                String mediaResourceSourceKey = entityTypeMapping.getMediaResourceSourceKey();
                if (mediaResourceSourceKey != null) {
                    self = (String)data.get(mediaResourceSourceKey);
                }
                if (self == null) {
                    self = selfLink + VALUE;
                }
                if ((mediaResourceMimeTypeKey = entityTypeMapping.getMediaResourceMimeTypeKey()) != null) {
                    mediaResourceMimeType = (String)data.get(mediaResourceMimeTypeKey);
                }
                if (mediaResourceMimeType == null) {
                    mediaResourceMimeType = ContentType.APPLICATION_OCTET_STREAM.toString();
                }
            } else {
                self = selfLink + VALUE;
                mediaResourceMimeType = ContentType.APPLICATION_OCTET_STREAM.toString();
            }
            writer.writeStartElement("content");
            writer.writeAttribute("type", mediaResourceMimeType);
            writer.writeAttribute("src", self);
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new EntityProviderProducerException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    private void appendAtomMandatoryParts(XMLStreamWriter writer, EntityInfoAggregator eia, Map<String, Object> data) throws EntityProviderException {
        try {
            writer.writeStartElement("id");
            String idlocation = this.properties.getServiceRoot().toASCIIString() + AtomEntryEntitySerializer.createSelfLink(eia, data, null, this.properties.isKeyAutoGenerated(), true);
            writer.writeCharacters(idlocation);
            writer.writeEndElement();
            writer.writeStartElement("title");
            writer.writeAttribute("type", "text");
            EntityPropertyInfo titleInfo = eia.getTargetPathInfo("SyndicationTitle");
            if (titleInfo != null) {
                EdmSimpleType st = (EdmSimpleType)titleInfo.getType();
                Object object = data.get(titleInfo.getName());
                String title = null;
                try {
                    title = st.valueToString(object, EdmLiteralKind.DEFAULT, titleInfo.getFacets());
                }
                catch (EdmSimpleTypeException e) {
                    throw new EntityProviderProducerException(EdmSimpleTypeException.getMessageReference(e.getMessageReference()).updateContent(e.getMessageReference().getContent(), titleInfo.getName()), (Throwable)e);
                }
                if (title != null) {
                    writer.writeCharacters(title);
                }
            } else {
                writer.writeCharacters(eia.getEntitySetName());
            }
            writer.writeEndElement();
            writer.writeStartElement("updated");
            writer.writeCharacters(this.getUpdatedString(eia, data));
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new EntityProviderProducerException(EntityProviderException.COMMON, (Throwable)e);
        }
        catch (EdmSimpleTypeException e) {
            throw new EntityProviderProducerException(e.getMessageReference(), (Throwable)e);
        }
    }

    String getUpdatedString(EntityInfoAggregator eia, Map<String, Object> data) throws EdmSimpleTypeException, EntityProviderProducerException {
        Object updateDate = null;
        EdmFacets updateFacets = null;
        EntityPropertyInfo updatedInfo = eia.getTargetPathInfo("SyndicationUpdated");
        if (updatedInfo != null && (updateDate = data.get(updatedInfo.getName())) != null) {
            updateFacets = updatedInfo.getFacets();
        }
        if (updateDate == null) {
            updateDate = new Date();
        }
        try {
            return EdmDateTimeOffset.getInstance().valueToString(updateDate, EdmLiteralKind.DEFAULT, updateFacets);
        }
        catch (EdmSimpleTypeException e) {
            throw new EntityProviderProducerException(EdmSimpleTypeException.getMessageReference(e.getMessageReference()).updateContent(e.getMessageReference().getContent(), updatedInfo == null ? null : updatedInfo.getName()), (Throwable)e);
        }
    }

    private String getTargetPathValue(EntityInfoAggregator eia, String targetPath, Map<String, Object> data) throws EntityProviderException {
        EntityPropertyInfo info = null;
        try {
            info = eia.getTargetPathInfo(targetPath);
            if (info != null) {
                EdmSimpleType type = (EdmSimpleType)info.getType();
                Object value = data.get(info.getName());
                return type.valueToString(value, EdmLiteralKind.DEFAULT, info.getFacets());
            }
            return null;
        }
        catch (EdmSimpleTypeException e) {
            throw new EntityProviderProducerException(EdmSimpleTypeException.getMessageReference(e.getMessageReference()).updateContent(e.getMessageReference().getContent(), info.getName()), (Throwable)e);
        }
    }

    private void appendAtomOptionalParts(XMLStreamWriter writer, EntityInfoAggregator eia, Map<String, Object> data) throws EntityProviderException {
        try {
            String authorEmail = this.getTargetPathValue(eia, "SyndicationAuthorEmail", data);
            String authorName = this.getTargetPathValue(eia, "SyndicationAuthorName", data);
            String authorUri = this.getTargetPathValue(eia, "SyndicationAuthorUri", data);
            if (authorEmail != null || authorName != null || authorUri != null) {
                writer.writeStartElement("author");
                this.appendAtomOptionalPart(writer, "name", authorName, false);
                this.appendAtomOptionalPart(writer, "email", authorEmail, false);
                this.appendAtomOptionalPart(writer, "uri", authorUri, false);
                writer.writeEndElement();
            }
            String summary = this.getTargetPathValue(eia, "SyndicationSummary", data);
            this.appendAtomOptionalPart(writer, "summary", summary, true);
            String contributorName = this.getTargetPathValue(eia, "SyndicationContributorName", data);
            String contributorEmail = this.getTargetPathValue(eia, "SyndicationContributorEmail", data);
            String contributorUri = this.getTargetPathValue(eia, "SyndicationContributorUri", data);
            if (contributorEmail != null || contributorName != null || contributorUri != null) {
                writer.writeStartElement("contributor");
                this.appendAtomOptionalPart(writer, "name", contributorName, false);
                this.appendAtomOptionalPart(writer, "email", contributorEmail, false);
                this.appendAtomOptionalPart(writer, "uri", contributorUri, false);
                writer.writeEndElement();
            }
            String rights = this.getTargetPathValue(eia, "SyndicationRights", data);
            this.appendAtomOptionalPart(writer, "rights", rights, true);
            String published = this.getTargetPathValue(eia, "SyndicationPublished", data);
            this.appendAtomOptionalPart(writer, "published", published, false);
            String term = eia.getEntityType().getNamespace() + "." + eia.getEntityType().getName();
            writer.writeStartElement("category");
            writer.writeAttribute("term", term);
            writer.writeAttribute("scheme", "http://schemas.microsoft.com/ado/2007/08/dataservices/scheme");
            writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new EntityProviderProducerException(EntityProviderException.COMMON, (Throwable)e);
        }
        catch (EdmException e) {
            throw new EntityProviderProducerException(e.getMessageReference(), (Throwable)e);
        }
    }

    private void appendAtomOptionalPart(XMLStreamWriter writer, String name, String value, boolean writeType) throws EntityProviderException {
        try {
            if (value != null) {
                writer.writeStartElement(name);
                if (writeType) {
                    writer.writeAttribute("type", "text");
                }
                writer.writeCharacters(value);
                writer.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            throw new EntityProviderProducerException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    static String createSelfLink(EntityInfoAggregator eia, Map<String, Object> data, String extension, boolean isKeyAutoGenerated, boolean isIdTag) throws EntityProviderException {
        StringBuilder sb = new StringBuilder();
        if (!eia.isDefaultEntityContainer()) {
            sb.append(Encoder.encode(eia.getEntityContainerName())).append(".");
        }
        sb.append(Encoder.encode(eia.getEntitySetName()));
        String keyValue = AtomEntryEntitySerializer.createEntryKey(eia, data, isKeyAutoGenerated, isIdTag);
        if (isIdTag && isKeyAutoGenerated && "".equals(keyValue) && keyValue.length() == 0) {
            sb.append(extension == null ? "" : "/" + extension);
        } else {
            sb.append("(").append(keyValue).append(")").append(extension == null ? "" : "/" + extension);
        }
        return sb.toString();
    }

    private static String createEntryKey(EntityInfoAggregator entityInfo, Map<String, Object> data, boolean isKeyAutoGenerated, boolean isIdTag) throws EntityProviderException {
        List<EntityPropertyInfo> keyPropertyInfos = entityInfo.getKeyPropertyInfos();
        StringBuilder keys = new StringBuilder();
        for (EntityPropertyInfo keyPropertyInfo : keyPropertyInfos) {
            if (keys.length() > 0) {
                keys.append(',');
            }
            String name = keyPropertyInfo.getName();
            if (keyPropertyInfos.size() > 1) {
                keys.append(Encoder.encode(name)).append('=');
            }
            EdmSimpleType type = (EdmSimpleType)keyPropertyInfo.getType();
            try {
                String keyValue = null;
                if (isKeyAutoGenerated && data.get(name) == null) {
                    Object value = AtomEntryEntitySerializer.fetchDefaultValue(type.getDefaultType());
                    keyValue = Encoder.encode(type.valueToString(value, EdmLiteralKind.URI, keyPropertyInfo.getFacets()));
                } else {
                    keyValue = Encoder.encode(type.valueToString(data.get(name), EdmLiteralKind.URI, keyPropertyInfo.getFacets()));
                }
                keys.append(keyValue);
            }
            catch (EdmSimpleTypeException e) {
                throw new EntityProviderProducerException(EdmSimpleTypeException.getMessageReference(e.getMessageReference()).updateContent(e.getMessageReference().getContent(), name), (Throwable)e);
            }
        }
        return keys.toString();
    }

    private static Object fetchDefaultValue(Class<?> edmType) throws EntityProviderProducerException {
        if (edmType == Boolean.TYPE || edmType == Boolean.class) {
            return false;
        }
        if (edmType == String.class) {
            return "A";
        }
        if (edmType == Byte.TYPE || edmType == Byte.class) {
            return new Byte(Byte.parseByte("0"));
        }
        if (edmType == Character.TYPE) {
            return new Character('A');
        }
        if (edmType == Short.TYPE || edmType == Short.class) {
            return new Short(Short.parseShort("0"));
        }
        if (edmType == Integer.TYPE || edmType == Integer.class) {
            return new Integer(0);
        }
        if (edmType == Long.TYPE || edmType == Long.class) {
            return new Long(0L);
        }
        if (edmType == Float.TYPE || edmType == Float.class) {
            return new Float(0.0f);
        }
        if (edmType == Double.TYPE || edmType == Double.class) {
            return new Double(0.0);
        }
        if (edmType == BigDecimal.class) {
            return BigDecimal.valueOf(0.0);
        }
        if (edmType == UUID.class) {
            return UUID.fromString("00000000-0000-0000-0000-000000000000");
        }
        if (edmType == Timestamp.class) {
            return new Timestamp(Calendar.getInstance().getTimeInMillis());
        }
        if (edmType == Calendar.class) {
            return Calendar.getInstance();
        }
        if (edmType == byte[].class || edmType == Byte[].class) {
            return new byte[0];
        }
        if (edmType == Date.class) {
            return new Date();
        }
        if (edmType == BigInteger.class) {
            return new BigInteger("0");
        }
        if (edmType == Time.class) {
            return new Time(0L);
        }
        throw new EntityProviderProducerException(EdmSimpleTypeException.VALUE_TYPE_NOT_SUPPORTED);
    }

    private void appendProperties(XMLStreamWriter writer, EntityInfoAggregator eia, Map<String, Object> data) throws EntityProviderException {
        try {
            if (!data.isEmpty() && data.size() > 0) {
                writer.writeStartElement("http://schemas.microsoft.com/ado/2007/08/dataservices/metadata", "properties");
                for (String propertyName : eia.getPropertyNames()) {
                    if (!data.containsKey(propertyName)) continue;
                    this.appendPropertyNameValue(writer, eia, data, propertyName);
                }
                writer.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            throw new EntityProviderProducerException(EntityProviderException.COMMON, (Throwable)e);
        }
    }

    private void appendPropertyNameValue(XMLStreamWriter writer, EntityInfoAggregator eia, Map<String, Object> data, String propertyName) throws EntityProviderException {
        EntityPropertyInfo propertyInfo = eia.getPropertyInfo(propertyName);
        if (this.isNotMappedViaCustomMapping(propertyInfo)) {
            Object value = data.get(propertyName);
            XmlPropertyEntitySerializer aps = new XmlPropertyEntitySerializer(this.properties);
            aps.append(writer, propertyInfo.getName(), propertyInfo, value);
        }
    }

    private boolean isNotMappedViaCustomMapping(EntityPropertyInfo propertyInfo) {
        EdmCustomizableFeedMappings customMapping = propertyInfo.getCustomMapping();
        if (customMapping != null && customMapping.isFcKeepInContent() != null) {
            return customMapping.isFcKeepInContent();
        }
        return true;
    }
}

