/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.client.core.ep.deserializer;

import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.ep.feed.ODataDeltaFeed;
import org.apache.olingo.odata2.client.api.ep.EntityStream;
import org.apache.olingo.odata2.client.core.ep.deserializer.XmlEntryDeserializer;
import org.apache.olingo.odata2.client.core.ep.deserializer.XmlFeedDeserializer;
import org.apache.olingo.odata2.client.core.ep.deserializer.XmlPropertyDeserializer;
import org.apache.olingo.odata2.core.commons.XmlHelper;
import org.apache.olingo.odata2.core.ep.aggregator.EntityInfoAggregator;
import org.apache.olingo.odata2.core.ep.aggregator.EntityPropertyInfo;

public class XmlEntityDeserializer {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ODataDeltaFeed readFeed(EdmEntitySet entitySet, EntityStream entity) throws EntityProviderException {
        ODataDeltaFeed oDataDeltaFeed;
        XMLStreamReader reader = null;
        EntityProviderException cachedException = null;
        try {
            reader = XmlHelper.createStreamReader(entity.getContent());
            EntityInfoAggregator eia = EntityInfoAggregator.create(entitySet);
            XmlFeedDeserializer xfc = new XmlFeedDeserializer();
            oDataDeltaFeed = xfc.readFeed(reader, eia, entity.getReadProperties());
            if (reader == null) return oDataDeltaFeed;
        }
        catch (EntityProviderException e) {
            try {
                cachedException = e;
                throw cachedException;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (XMLStreamException e2) {
                    if (cachedException != null) {
                        throw cachedException;
                    }
                    throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e2.getClass().getSimpleName()), (Throwable)e2);
                }
            }
        }
        try {
            reader.close();
            return oDataDeltaFeed;
        }
        catch (XMLStreamException e) {
            if (cachedException != null) {
                throw cachedException;
            }
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ODataEntry readEntry(EdmEntitySet entitySet, EntityStream entity) throws EntityProviderException {
        ODataEntry oDataEntry;
        XMLStreamReader reader = null;
        EntityProviderException cachedException = null;
        try {
            reader = XmlHelper.createStreamReader(entity.getContent());
            EntityInfoAggregator eia = EntityInfoAggregator.create(entitySet);
            oDataEntry = new XmlEntryDeserializer().readEntry(reader, eia, entity.getReadProperties(), false);
            if (reader == null) return oDataEntry;
        }
        catch (EntityProviderException e) {
            try {
                cachedException = e;
                throw cachedException;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (XMLStreamException e2) {
                    if (cachedException != null) {
                        throw cachedException;
                    }
                    throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e2.getClass().getSimpleName()), (Throwable)e2);
                }
            }
        }
        try {
            reader.close();
            return oDataEntry;
        }
        catch (XMLStreamException e) {
            if (cachedException != null) {
                throw cachedException;
            }
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object readCollection(EntityPropertyInfo info, EntityStream entityStream) throws EntityProviderException {
        List<Object> list;
        XMLStreamReader reader = null;
        EntityProviderException cachedException = null;
        try {
            reader = XmlHelper.createStreamReader(entityStream.getContent());
            list = new XmlPropertyDeserializer().readCollection(reader, info, entityStream.getReadProperties());
            if (reader == null) return list;
        }
        catch (EntityProviderException e) {
            try {
                cachedException = e;
                throw cachedException;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (XMLStreamException e2) {
                    if (cachedException != null) {
                        throw cachedException;
                    }
                    throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e2.getClass().getSimpleName()), (Throwable)e2);
                }
            }
        }
        try {
            reader.close();
            return list;
        }
        catch (XMLStreamException e) {
            if (cachedException != null) {
                throw cachedException;
            }
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> readProperty(EntityPropertyInfo propertyInfo, EntityStream entityStream) throws EntityProviderException {
        Map<String, Object> map;
        XMLStreamReader reader = null;
        EntityProviderException cachedException = null;
        try {
            reader = XmlHelper.createStreamReader(entityStream.getContent());
            map = new XmlPropertyDeserializer().readProperty(reader, propertyInfo, entityStream.getReadProperties());
            if (reader == null) return map;
        }
        catch (EntityProviderException e) {
            try {
                cachedException = e;
                throw cachedException;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (XMLStreamException e2) {
                    if (cachedException != null) {
                        throw cachedException;
                    }
                    throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e2.getClass().getSimpleName()), (Throwable)e2);
                }
            }
        }
        try {
            reader.close();
            return map;
        }
        catch (XMLStreamException e) {
            if (cachedException != null) {
                throw cachedException;
            }
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
    }
}

