/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.client.core.edm.Impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.edm.EdmAssociation;
import org.apache.olingo.odata2.api.edm.EdmComplexType;
import org.apache.olingo.odata2.api.edm.EdmEntityContainer;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFunctionImport;
import org.apache.olingo.odata2.api.edm.EdmServiceMetadata;
import org.apache.olingo.odata2.api.edm.FullQualifiedName;
import org.apache.olingo.odata2.client.api.edm.ClientEdm;
import org.apache.olingo.odata2.client.api.edm.EdmSchema;

public class EdmImpl
implements ClientEdm {
    protected Map<FullQualifiedName, EdmEntityContainer> edmEntityContainers = new HashMap<FullQualifiedName, EdmEntityContainer>();
    protected Map<FullQualifiedName, EdmEntityType> edmEntityTypes = new HashMap<FullQualifiedName, EdmEntityType>();
    private Map<FullQualifiedName, EdmComplexType> edmComplexTypes = new HashMap<FullQualifiedName, EdmComplexType>();
    private Map<FullQualifiedName, EdmAssociation> edmAssociations = new HashMap<FullQualifiedName, EdmAssociation>();
    private Map<String, String> aliasToNamespaceInfo = new HashMap<String, String>();
    private List<EdmEntitySet> edmEntitySets;
    private List<EdmFunctionImport> edmFunctionImports;
    private List<EdmSchema> edmSchema;
    private EdmEntityContainer defaultEdmEntityContainer;

    @Override
    public EdmEntityContainer getEntityContainer(String name) throws EdmException {
        for (Map.Entry<FullQualifiedName, EdmEntityContainer> entry : this.edmEntityContainers.entrySet()) {
            if (!entry.getKey().getName().equals(name)) continue;
            return entry.getValue();
        }
        return null;
    }

    public EdmImpl setEdmSchemas(List<EdmSchema> edmSchema) {
        this.edmSchema = edmSchema;
        return this;
    }

    @Override
    public EdmEntityType getEntityType(String namespaceOrAlias, String name) throws EdmException {
        FullQualifiedName fqName = this.getNamespaceForAlias(namespaceOrAlias, name);
        return this.edmEntityTypes.get(fqName);
    }

    private FullQualifiedName getNamespaceForAlias(String namespaceOrAlias, String name) throws EdmException {
        String namespace = this.aliasToNamespaceInfo.get(namespaceOrAlias);
        if (namespace != null) {
            return new FullQualifiedName(namespace, name);
        }
        return new FullQualifiedName(namespaceOrAlias, name);
    }

    @Override
    public EdmComplexType getComplexType(String namespaceOrAlias, String name) throws EdmException {
        FullQualifiedName fqName = this.getNamespaceForAlias(namespaceOrAlias, name);
        return this.edmComplexTypes.get(fqName);
    }

    @Override
    public EdmAssociation getAssociation(String namespaceOrAlias, String name) throws EdmException {
        FullQualifiedName fqName = this.getNamespaceForAlias(namespaceOrAlias, name);
        return this.edmAssociations.get(fqName);
    }

    public EdmImpl setDefaultEntityContainer(EdmEntityContainer defaultEdmEntityContainer) throws EdmException {
        this.defaultEdmEntityContainer = defaultEdmEntityContainer;
        return this;
    }

    @Override
    public EdmEntityContainer getDefaultEntityContainer() throws EdmException {
        return this.defaultEdmEntityContainer;
    }

    @Override
    public List<EdmEntitySet> getEntitySets() throws EdmException {
        return this.edmEntitySets;
    }

    @Override
    public List<EdmFunctionImport> getFunctionImports() throws EdmException {
        return this.edmFunctionImports;
    }

    @Override
    public EdmServiceMetadata getServiceMetadata() {
        return null;
    }

    public Map<FullQualifiedName, EdmEntityContainer> getEdmEntityContainers() {
        return this.edmEntityContainers;
    }

    public EdmImpl setEdmEntityContainers(Map<FullQualifiedName, EdmEntityContainer> edmEntityContainers) {
        this.edmEntityContainers = edmEntityContainers;
        return this;
    }

    public Map<FullQualifiedName, EdmEntityType> getEdmEntityTypes() {
        return this.edmEntityTypes;
    }

    public EdmImpl setEdmEntityTypes(Map<FullQualifiedName, EdmEntityType> edmEntityTypes) {
        this.edmEntityTypes = edmEntityTypes;
        return this;
    }

    public Map<FullQualifiedName, EdmComplexType> getEdmComplexTypes() {
        return this.edmComplexTypes;
    }

    public EdmImpl setEdmComplexTypes(Map<FullQualifiedName, EdmComplexType> edmComplexTypes) {
        this.edmComplexTypes = edmComplexTypes;
        return this;
    }

    public Map<FullQualifiedName, EdmAssociation> getEdmAssociations() {
        return this.edmAssociations;
    }

    public EdmImpl setEdmAssociations(Map<FullQualifiedName, EdmAssociation> edmAssociations) {
        this.edmAssociations = edmAssociations;
        return this;
    }

    public Map<String, String> getAliasToNamespaceInfo() {
        return this.aliasToNamespaceInfo;
    }

    public EdmImpl setAliasToNamespaceInfo(Map<String, String> aliasToNamespaceInfo) {
        this.aliasToNamespaceInfo = aliasToNamespaceInfo;
        return this;
    }

    public List<EdmEntitySet> getEdmEntitySets() {
        return this.edmEntitySets;
    }

    public EdmImpl setEdmEntitySets(List<EdmEntitySet> edmEntitySets) {
        this.edmEntitySets = edmEntitySets;
        return this;
    }

    public List<EdmFunctionImport> getEdmFunctionImports() {
        return this.edmFunctionImports;
    }

    public EdmImpl setEdmFunctionImports(List<EdmFunctionImport> edmFunctionImports) {
        this.edmFunctionImports = edmFunctionImports;
        return this;
    }

    @Override
    public List<EdmSchema> getSchemas() {
        return this.edmSchema;
    }

    public String toString() {
        return String.format("EdmImpl", new Object[0]);
    }
}

