/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.tokenflows;

import com.sap.cloud.security.config.ClientIdentity;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceEndpointsProvider;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenResponse;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenService;
import com.sap.cloud.security.xsuaa.tokenflows.TokenFlowException;
import com.sap.cloud.security.xsuaa.tokenflows.XsuaaTokenFlowsUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class ClientCredentialsTokenFlow {
    private final OAuth2TokenService tokenService;
    private final OAuth2ServiceEndpointsProvider endpointsProvider;
    private final ClientIdentity clientIdentity;
    private boolean disableCache = false;
    private List<String> scopes = new ArrayList<String>();
    private String subdomain;
    private String zoneId;
    private Map<String, String> authzAttributes;

    ClientCredentialsTokenFlow(OAuth2TokenService tokenService, OAuth2ServiceEndpointsProvider endpointsProvider, ClientIdentity clientIdentity) {
        Assertions.assertNotNull(tokenService, "OAuth2TokenService must not be null.");
        Assertions.assertNotNull(endpointsProvider, "OAuth2ServiceEndpointsProvider must not be null.");
        Assertions.assertNotNull(clientIdentity, "ClientIdentity must not be null.");
        this.tokenService = tokenService;
        this.endpointsProvider = endpointsProvider;
        this.clientIdentity = clientIdentity;
    }

    public ClientCredentialsTokenFlow attributes(Map<String, String> additionalAuthorizationAttributes) {
        this.authzAttributes = additionalAuthorizationAttributes;
        return this;
    }

    public ClientCredentialsTokenFlow subdomain(String subdomain) {
        this.subdomain = subdomain;
        return this;
    }

    public ClientCredentialsTokenFlow zoneId(String zoneId) {
        this.zoneId = zoneId;
        return this;
    }

    public ClientCredentialsTokenFlow scopes(String ... scopes) {
        Assertions.assertNotNull(scopes, "Scopes must not be null!");
        this.scopes = Arrays.asList(scopes);
        return this;
    }

    public ClientCredentialsTokenFlow disableCache(boolean disableCache) {
        this.disableCache = disableCache;
        return this;
    }

    @Nullable
    public OAuth2TokenResponse execute() throws IllegalArgumentException, TokenFlowException {
        String scopesParameter;
        HashMap<String, String> requestParameter = new HashMap<String, String>();
        String authorities = XsuaaTokenFlowsUtils.buildAdditionalAuthoritiesJson(this.authzAttributes);
        if (authorities != null) {
            requestParameter.put("authorities", authorities);
        }
        if (!(scopesParameter = String.join((CharSequence)" ", this.scopes)).isEmpty()) {
            requestParameter.put("scope", scopesParameter);
        }
        try {
            return this.tokenService.retrieveAccessTokenViaClientCredentialsGrant(this.endpointsProvider.getTokenEndpoint(), this.clientIdentity, this.zoneId, this.subdomain, requestParameter, this.disableCache);
        }
        catch (OAuth2ServiceException e) {
            throw new TokenFlowException(String.format("Error requesting technical user token with grant_type 'client_credentials': %s", e.getMessage()), e);
        }
    }
}

