/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.xsuaa.client;

import com.sap.cloud.security.servlet.MDCHelper;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.client.AbstractOAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.OAuth2ServiceException;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenResponse;
import com.sap.cloud.security.xsuaa.tokenflows.TokenCacheConfiguration;
import com.sap.cloud.security.xsuaa.util.HttpClientUtil;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.util.UriComponentsBuilder;

public class XsuaaOAuth2TokenService
extends AbstractOAuth2TokenService {
    private static final Logger LOGGER = LoggerFactory.getLogger(XsuaaOAuth2TokenService.class);
    private final RestOperations restOperations;

    public XsuaaOAuth2TokenService(@Nonnull RestOperations restOperations) {
        this(restOperations, TokenCacheConfiguration.defaultConfiguration());
    }

    public XsuaaOAuth2TokenService(@Nonnull RestOperations restOperations, @Nonnull TokenCacheConfiguration tokenCacheConfiguration) {
        super(tokenCacheConfiguration);
        Assertions.assertNotNull(restOperations, "restOperations is required");
        this.restOperations = restOperations;
    }

    @Override
    protected OAuth2TokenResponse requestAccessToken(URI tokenEndpointUri, com.sap.cloud.security.xsuaa.http.HttpHeaders headers, Map<String, String> parameters) throws OAuth2ServiceException {
        ResponseEntity responseEntity;
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)tokenEndpointUri);
        URI requestUri = builder.build().encode().toUri();
        HttpHeaders springHeaders = new HttpHeaders();
        headers.getHeaders().forEach(h -> springHeaders.add(h.getName(), h.getValue()));
        springHeaders.add("X-CorrelationID", MDCHelper.getOrCreateCorrelationId());
        springHeaders.add("User-Agent", HttpClientUtil.getUserAgent());
        HttpEntity requestEntity = new HttpEntity(this.copyIntoForm(parameters), (MultiValueMap)springHeaders);
        try {
            LOGGER.debug("Requesting access token from url='{}' and headers={}", (Object)requestUri, (Object)springHeaders);
            responseEntity = this.restOperations.postForEntity(requestUri, (Object)requestEntity, Map.class);
        }
        catch (HttpClientErrorException ex) {
            String warningMsg = String.format("Error retrieving JWT token. Received status code %s. Call to XSUAA was not successful: %s", ex.getStatusCode(), ex.getResponseBodyAsString());
            throw new OAuth2ServiceException(warningMsg, ex.getStatusCode().value(), XsuaaOAuth2TokenService.getHeaders(ex.getResponseHeaders()));
        }
        catch (HttpServerErrorException ex) {
            String warningMsg = String.format("Server error while obtaining access token from XSUAA (%s): %s", ex.getStatusCode(), ex.getResponseBodyAsString());
            LOGGER.error(warningMsg, (Throwable)ex);
            throw new OAuth2ServiceException(warningMsg, ex.getStatusCode().value(), XsuaaOAuth2TokenService.getHeaders(ex.getResponseHeaders()));
        }
        catch (ResourceAccessException ex) {
            String warningMsg = String.format("RestClient isn't configured properly - Error while obtaining access token from XSUAA (%s): %s", requestUri, ex.getLocalizedMessage());
            LOGGER.error(warningMsg);
            throw ex;
        }
        LOGGER.debug("Received statusCode {}", (Object)responseEntity.getStatusCode());
        Map accessTokenMap = (Map)responseEntity.getBody();
        String accessToken = (String)accessTokenMap.get("access_token");
        long expiresIn = Long.parseLong(String.valueOf(accessTokenMap.get("expires_in")));
        String refreshToken = (String)accessTokenMap.get("refresh_token");
        String tokenType = (String)accessTokenMap.get("token_type");
        return new OAuth2TokenResponse(accessToken, expiresIn, refreshToken, tokenType);
    }

    private static List<String> getHeaders(HttpHeaders ex) {
        if (ex != null) {
            return ex.toSingleValueMap().entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).toList();
        }
        return Collections.emptyList();
    }

    private MultiValueMap<String, String> copyIntoForm(Map<String, String> parameters) {
        LinkedMultiValueMap formData = new LinkedMultiValueMap();
        if (parameters != null) {
            parameters.forEach((arg_0, arg_1) -> ((MultiValueMap)formData).add(arg_0, arg_1));
        }
        return formData;
    }
}

