/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.generator.annotation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.datamodel.odata.generator.MessageCollector;
import com.sap.cloud.sdk.datamodel.odata.generator.annotation.AnnotationDefinition;
import com.sap.cloud.sdk.datamodel.odata.generator.annotation.AnnotationParameter;
import com.sap.cloud.sdk.datamodel.odata.generator.annotation.AnnotationStrategy;
import com.sap.cloud.sdk.datamodel.odata.generator.annotation.EntityAnnotationModel;
import com.sap.cloud.sdk.datamodel.odata.generator.annotation.EntityPropertyAnnotationModel;
import com.sap.cloud.sdk.datamodel.odata.generator.annotation.NavigationPropertyAnnotationModel;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBinaryAdapter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;
import org.slf4j.Logger;

public class DefaultAnnotationStrategy
implements AnnotationStrategy {
    private static final Logger logger = MessageCollector.getLogger(DefaultAnnotationStrategy.class);
    private static final int JAVA_MAXIMUM_ARGUMENTS = 254;
    private static final Map<String, Class<?>> ODATA_GSON_TYPE_ADAPTERS = new HashMap();
    private static final Map<String, Class<?>> ODATA_JACKSON_TYPE_DESERIALIZER;
    private static final Map<String, Class<?>> ODATA_JACKSON_TYPE_SERIALIZER;
    private static final Map<String, Class<?>> ODATA_TYPE_CONVERTER;

    @Override
    @Nonnull
    public Set<AnnotationDefinition> getAnnotationsForEntity(@Nonnull EntityAnnotationModel context) {
        boolean isArgLimitExceeded;
        LinkedHashSet<AnnotationDefinition> result = new LinkedHashSet<AnnotationDefinition>();
        boolean bl = isArgLimitExceeded = context.getNumberOfProperties() > 254;
        if (!isArgLimitExceeded) {
            result.add(new AnnotationDefinition(Builder.class));
        } else {
            logger.info(String.format("  VdmObject class %s has %d properties, which exceeds the Java limit of constructor arguments (%d). Builder will not be available for this entity.", context.getJavaClassName(), context.getNumberOfProperties(), 254));
        }
        result.add(new AnnotationDefinition(Data.class));
        if (!isArgLimitExceeded) {
            result.add(new AnnotationDefinition(NoArgsConstructor.class));
            result.add(new AnnotationDefinition(AllArgsConstructor.class));
        }
        result.add(new AnnotationDefinition(ToString.class, new AnnotationParameter("doNotUseGetters", true), new AnnotationParameter("callSuper", true)));
        result.add(new AnnotationDefinition(EqualsAndHashCode.class, new AnnotationParameter("doNotUseGetters", true), new AnnotationParameter("callSuper", true)));
        result.add(new AnnotationDefinition(JsonAdapter.class, new AnnotationParameter("value", ODataVdmEntityAdapterFactory.class)));
        return result;
    }

    @Override
    @Nonnull
    public Set<AnnotationDefinition> getAnnotationsForEntityProperty(@Nonnull EntityPropertyAnnotationModel context) {
        LinkedHashSet<AnnotationDefinition> result = new LinkedHashSet<AnnotationDefinition>();
        if (context.isKeyField()) {
            result.add(new AnnotationDefinition(Key.class));
        }
        result.add(new AnnotationDefinition(SerializedName.class, new AnnotationParameter("value", context.getEdmName())));
        result.add(new AnnotationDefinition(JsonProperty.class, new AnnotationParameter("value", context.getEdmName())));
        result.add(new AnnotationDefinition(Nullable.class));
        AnnotationDefinition converterAnnotation = new AnnotationDefinition(ODataField.class, new AnnotationParameter("odataName", context.getEdmName()));
        if (context.isSimpleType()) {
            if (ODATA_JACKSON_TYPE_SERIALIZER.containsKey(context.getEdmType())) {
                result.add(new AnnotationDefinition(JsonSerialize.class, new AnnotationParameter("using", ODATA_JACKSON_TYPE_SERIALIZER.get(context.getEdmType()))));
            }
            if (ODATA_JACKSON_TYPE_DESERIALIZER.containsKey(context.getEdmType())) {
                result.add(new AnnotationDefinition(JsonDeserialize.class, new AnnotationParameter("using", ODATA_JACKSON_TYPE_DESERIALIZER.get(context.getEdmType()))));
            }
            if (ODATA_GSON_TYPE_ADAPTERS.containsKey(context.getEdmType())) {
                result.add(new AnnotationDefinition(JsonAdapter.class, new AnnotationParameter("value", ODATA_GSON_TYPE_ADAPTERS.get(context.getEdmType()))));
            }
            if (ODATA_TYPE_CONVERTER.containsKey(context.getEdmType())) {
                converterAnnotation.addAnnotationParameter(new AnnotationParameter("converter", ODATA_TYPE_CONVERTER.get(context.getEdmType())));
            }
        }
        result.add(converterAnnotation);
        return result;
    }

    @Override
    @Nonnull
    public Set<AnnotationDefinition> getAnnotationsForAssociatedEntity(@Nonnull NavigationPropertyAnnotationModel context) {
        LinkedHashSet<AnnotationDefinition> result = new LinkedHashSet<AnnotationDefinition>();
        result.add(new AnnotationDefinition(SerializedName.class, new AnnotationParameter("value", context.getEdmName())));
        result.add(new AnnotationDefinition(JsonProperty.class, new AnnotationParameter("value", context.getEdmName())));
        result.add(new AnnotationDefinition(ODataField.class, new AnnotationParameter("odataName", context.getEdmName())));
        if (!context.isManyMultiplicity()) {
            result.add(new AnnotationDefinition(Nullable.class));
        }
        return result;
    }

    @Override
    @Nonnull
    public Set<AnnotationDefinition> getAnnotationsForComplexType(@Nonnull EntityAnnotationModel context) {
        return this.getAnnotationsForEntity(context);
    }

    @Override
    @Nonnull
    public Set<AnnotationDefinition> getAnnotationsForComplexTypeProperty(@Nonnull EntityPropertyAnnotationModel context) {
        return this.getAnnotationsForEntityProperty(context);
    }

    static {
        ODATA_GSON_TYPE_ADAPTERS.put("Binary", ODataBinaryAdapter.class);
        ODATA_GSON_TYPE_ADAPTERS.put("Boolean", ODataBooleanAdapter.class);
        ODATA_GSON_TYPE_ADAPTERS.put("DateTime", LocalDateTimeAdapter.class);
        ODATA_GSON_TYPE_ADAPTERS.put("DateTimeOffset", ZonedDateTimeAdapter.class);
        ODATA_GSON_TYPE_ADAPTERS.put("Time", LocalTimeAdapter.class);
        ODATA_JACKSON_TYPE_DESERIALIZER = new HashMap();
        ODATA_JACKSON_TYPE_DESERIALIZER.put("DateTime", JacksonLocalDateTimeDeserializer.class);
        ODATA_JACKSON_TYPE_DESERIALIZER.put("DateTimeOffset", JacksonZonedDateTimeDeserializer.class);
        ODATA_JACKSON_TYPE_DESERIALIZER.put("Time", JacksonLocalTimeDeserializer.class);
        ODATA_JACKSON_TYPE_SERIALIZER = new HashMap();
        ODATA_JACKSON_TYPE_SERIALIZER.put("DateTime", JacksonLocalDateTimeSerializer.class);
        ODATA_JACKSON_TYPE_SERIALIZER.put("DateTimeOffset", JacksonZonedDateTimeSerializer.class);
        ODATA_JACKSON_TYPE_SERIALIZER.put("Time", JacksonLocalTimeSerializer.class);
        ODATA_TYPE_CONVERTER = new HashMap();
        ODATA_TYPE_CONVERTER.put("DateTime", LocalDateTimeCalendarConverter.class);
        ODATA_TYPE_CONVERTER.put("DateTimeOffset", ZonedDateTimeCalendarConverter.class);
        ODATA_TYPE_CONVERTER.put("Time", LocalTimeCalendarConverter.class);
    }
}

