/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.generator;

import com.sap.cloud.sdk.cloudplatform.util.StringUtils;
import com.sap.cloud.sdk.datamodel.odata.generator.MessageCollector;
import com.sap.cloud.sdk.datamodel.odata.generator.MetadataFileUtils;
import com.sap.cloud.sdk.datamodel.odata.generator.ODataGeneratorReadException;
import com.sap.cloud.sdk.datamodel.odata.generator.ServiceDetails;
import com.sap.cloud.sdk.datamodel.odata.generator.ServiceDetailsParser;
import com.sap.cloud.sdk.datamodel.odata.generator.ServiceDetailsPojo;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ServiceDetailsResolver {
    private static final Logger logger = MessageCollector.getLogger(ServiceDetailsResolver.class);
    @Nullable
    private final String defaultBasePath;
    private final Charset encoding;

    ServiceDetailsResolver(Charset encoding) {
        this.encoding = encoding;
        this.defaultBasePath = null;
    }

    ServiceDetailsResolver(@Nullable String defaultBasePath, Charset encoding) {
        this.defaultBasePath = defaultBasePath;
        this.encoding = encoding;
    }

    @Nonnull
    ServiceDetails createServiceDetails(@Nonnull File edmxFile, @Nullable File swaggerFile) {
        ServiceDetails details = null;
        if (swaggerFile != null && swaggerFile.exists()) {
            details = this.readFromSwaggerFile(swaggerFile);
        } else if (swaggerFile != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Could not find swagger file at " + swaggerFile.getAbsolutePath() + ". Trying to use the default base path.");
            }
        } else {
            logger.debug("No swagger file given. Trying to use the default base path.");
        }
        if (details == null && this.defaultBasePath != null) {
            details = this.createFromDefaultBasePath(edmxFile);
        } else if (details == null) {
            logger.debug("No default base path given. Trying to read the base path from the metadata file.");
        }
        if (details == null) {
            details = this.readServiceDetailsFromMetadataFile(edmxFile);
        }
        if (details == null || details.getServiceUrl() == null) {
            throw new ODataGeneratorReadException("Could not determine a valid default service path. A default service path is the prefix of the HTTP query component used for all outgoing queries of the service to be generated (if no custom service path is given).\nTried to determine the service path with the following priority:\n 1. The 'basePath' field in the swagger file\n 2. The default base path (if given via the Maven Plugin or Builder method) concatenated with the namespace defined in metadata file. In case of no namespace, filename is considered as the service name.\n 3. The atom:link field in the metadata file.");
        }
        return details;
    }

    @Nonnull
    private ServiceDetails createFromDefaultBasePath(@Nonnull File metadataFile) {
        String serviceName = this.readServiceNameFromMetaDataFile(metadataFile);
        String serviceUrl = this.defaultBasePath + serviceName;
        ServiceDetailsPojo serviceDetails = new ServiceDetailsPojo();
        serviceDetails.setServiceUrl(serviceUrl);
        return serviceDetails;
    }

    @Nonnull
    private String readServiceNameFromMetaDataFile(@Nonnull File metadataFile) {
        String serviceName = this.getMetadataNamespace(metadataFile);
        if (StringUtils.isBlank((String)serviceName)) {
            serviceName = FilenameUtils.getBaseName((String)metadataFile.getAbsolutePath());
        }
        return serviceName;
    }

    @Nullable
    private String getMetadataNamespace(@Nonnull File metadataFile) {
        Document doc = MetadataFileUtils.getMetadataDocumentObject(metadataFile);
        if (doc != null) {
            NodeList schemas = doc.getElementsByTagName("Schema");
            if (schemas.getLength() > 1) {
                logger.info(String.format("Expected to have a single schema tag in the metadata file %s, but found %d instead. The first schema with a defined namespace found will be used.", metadataFile.getName(), schemas.getLength()));
            }
            return ServiceDetailsResolver.getFirstDefinedNamespace(schemas);
        }
        return null;
    }

    @Nullable
    private static String getFirstDefinedNamespace(@Nonnull NodeList schemaNodes) {
        for (int i = 0; i < schemaNodes.getLength(); ++i) {
            String namespace;
            Node namespaceNode;
            Node schema = schemaNodes.item(i);
            NamedNodeMap schemaAttributeMap = schema.getAttributes();
            if (schemaAttributeMap.getLength() == 0 || (namespaceNode = schemaAttributeMap.getNamedItem("Namespace")) == null || StringUtils.isBlank((String)(namespace = namespaceNode.getNodeValue()))) continue;
            return namespace;
        }
        return null;
    }

    @Nonnull
    private ServiceDetails readFromSwaggerFile(@Nonnull File swaggerFile) {
        ServiceDetails details = ServiceDetailsParser.parse(swaggerFile, this.encoding);
        this.adjustServiceUrl(details);
        return details;
    }

    private void adjustServiceUrl(@Nonnull ServiceDetails details) {
        String prefixToRemove = "/s4hanacloud";
        String serviceUrl = details.getServiceUrl();
        String adjustedUrl = StringUtils.removeStartIgnoreCase((String)serviceUrl, (String)"/s4hanacloud");
        details.setServiceUrl(adjustedUrl);
    }

    @Nullable
    private ServiceDetails readServiceDetailsFromMetadataFile(@Nonnull File metadataFile) {
        String fullServiceUrl = this.getMetadataServiceUrl(metadataFile);
        if (fullServiceUrl != null) {
            String serviceUrl = this.adjustMetadataServiceUrl(fullServiceUrl);
            ServiceDetailsPojo serviceDetails = new ServiceDetailsPojo();
            serviceDetails.setServiceUrl(serviceUrl);
            return serviceDetails;
        }
        return null;
    }

    @Nonnull
    private String adjustMetadataServiceUrl(@Nonnull String fullServiceUrl) {
        URI uri;
        Object parsableServiceUrl = fullServiceUrl;
        if (!fullServiceUrl.startsWith("http")) {
            parsableServiceUrl = "https://" + (String)parsableServiceUrl;
        }
        try {
            uri = new URI((String)parsableServiceUrl);
        }
        catch (URISyntaxException e) {
            throw new ODataGeneratorReadException("Could not parse the atom:link url " + fullServiceUrl, e);
        }
        return StringUtils.removeEndIgnoreCase((String)uri.getPath(), (String)"/$metadata");
    }

    @Nullable
    private String getMetadataServiceUrl(@Nonnull File metadataFile) {
        Document doc = MetadataFileUtils.getMetadataDocumentObject(metadataFile);
        if (doc != null) {
            Node atomLinkNode;
            NodeList schemas = doc.getElementsByTagName("Schema");
            if (schemas.getLength() > 1) {
                logger.info(String.format("Expected to have a single schema tag in the metadata file %s, but found %d instead. The first atom:link found will be used.", metadataFile.getName(), schemas.getLength()));
            }
            if ((atomLinkNode = ServiceDetailsResolver.findFirstChildNodeWithAtomLink(schemas)) != null) {
                return ServiceDetailsResolver.getAtomLinkServiceUrlFromNode(atomLinkNode);
            }
        }
        return null;
    }

    @Nullable
    private static Node findFirstChildNodeWithAtomLink(@Nonnull NodeList schemaNodes) {
        for (int i = 0; i < schemaNodes.getLength(); ++i) {
            Node schema = schemaNodes.item(i);
            NodeList childNodes = schema.getChildNodes();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                Node child = childNodes.item(j);
                if (!ServiceDetailsResolver.isNodeAtomLinkWithSelfRelation(child)) continue;
                return child;
            }
        }
        return null;
    }

    private static boolean isNodeAtomLinkWithSelfRelation(@Nonnull Node node) {
        if (node.getNodeType() == 1 && "atom:link".equals(node.getNodeName())) {
            return "self".equals(node.getAttributes().getNamedItem("rel").getNodeValue());
        }
        return false;
    }

    @Nullable
    private static String getAtomLinkServiceUrlFromNode(@Nonnull Node node) {
        return node.getAttributes().getNamedItem("href").getNodeValue();
    }
}

