/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.generator;

import com.google.common.base.CaseFormat;
import com.google.common.base.Strings;
import com.google.common.escape.Escaper;
import com.google.common.html.HtmlEscapers;
import com.sap.cloud.sdk.cloudplatform.util.StringUtils;
import com.sap.cloud.sdk.datamodel.odata.generator.DefaultServiceBatchChangeSetGenerator;
import com.sap.cloud.sdk.datamodel.odata.generator.DefaultServiceBatchGenerator;
import com.sap.cloud.sdk.datamodel.odata.generator.DeprecationUtils;
import com.sap.cloud.sdk.datamodel.odata.generator.EntityMetadata;
import com.sap.cloud.sdk.datamodel.odata.generator.EntityPropertyModel;
import com.sap.cloud.sdk.datamodel.odata.generator.FunctionImportParameterModel;
import com.sap.cloud.sdk.datamodel.odata.generator.NamingContext;
import com.sap.cloud.sdk.datamodel.odata.generator.ODataGeneratorException;
import com.sap.cloud.sdk.datamodel.odata.generator.ODataGeneratorWriteException;
import com.sap.cloud.sdk.datamodel.odata.generator.Service;
import com.sap.cloud.sdk.datamodel.odata.generator.ServiceBatchChangeSetGenerator;
import com.sap.cloud.sdk.datamodel.odata.generator.ServiceBatchGenerator;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchService;
import com.sap.cloud.sdk.datamodel.odata.utility.LegacyClassScanner;
import com.sap.cloud.sdk.datamodel.odata.utility.NamingStrategy;
import com.sap.cloud.sdk.datamodel.odata.utility.NamingUtils;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JCommentPart;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import io.vavr.control.Option;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceClassGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceClassGenerator.class);
    private static final String SERVICE_INTERFACE_NAMING = "%sService";
    private static final String SERVICE_IMPLEMENTATION_NAMING = "Default%sService";
    static final String DEFAULT_SERVICE_PATH_FIELD_NAMING = "DEFAULT_SERVICE_PATH";
    private static final String SERVICE_PATH_FIELD_NAMING = "servicePath";
    private static final String BUSINESS_HUB_LINK_TEMPLATE = "<p>Reference: <a href='https://api.sap.com/shell/discover/contentpackage/SAPS4HANACloud/api/%s?section=OVERVIEW'>SAP Business Accelerator Hub</a></p>";
    private final Map<String, JDefinedClass> generatedServiceInterfaceClasses = new HashMap<String, JDefinedClass>();
    private final Map<String, JDefinedClass> generatedServiceImplementationClasses = new HashMap<String, JDefinedClass>();
    private final Map<String, BatchRelevantStubs> generatedBatchRelevantStubs = new HashMap<String, BatchRelevantStubs>();
    private final Escaper htmlEscaper = HtmlEscapers.htmlEscaper();
    private final JCodeModel codeModel;
    private final JPackage servicePackage;
    private final JPackage namespaceParentPackage;
    private final NamingStrategy codeNamingStrategy;
    private final ServiceBatchChangeSetGenerator serviceBatchChangeSetGenerator;
    private final ServiceBatchGenerator serviceBatchGenerator;
    private final DefaultServiceBatchGenerator defaultServiceBatchGenerator;
    private final DefaultServiceBatchChangeSetGenerator defaultServiceBatchChangeSetGenerator;
    private final boolean serviceMethodsPerEntitySet;
    private final LegacyClassScanner classScanner;
    private String customDeprecationNoticeForService = null;

    private void addClassLevelJavadoc(JDocComment javadoc, Service service) {
        Collection<Service.ExternalOverview> additionalDetails;
        if (!Strings.isNullOrEmpty((String)service.getInfoDescription())) {
            Object description = this.htmlEscaper.escape(service.getInfoDescription());
            if (!((String)description).matches(".*[.?!]\\s*$")) {
                description = (String)description + ".";
            }
            javadoc.add((Object)String.format("<p>%s</p>", description));
        }
        if (!Strings.isNullOrEmpty((String)service.getExternalUrl())) {
            javadoc.add((Object)String.format("<p><a href='%s'>%s</a></p>", service.getExternalUrl(), Strings.isNullOrEmpty((String)service.getExternalDescription()) ? service.getExternalUrl() : service.getExternalDescription()));
        }
        if (service.hasLinkToApiBusinessHub()) {
            javadoc.add((Object)String.format(BUSINESS_HUB_LINK_TEMPLATE, service.getName()));
        }
        javadoc.add((Object)"<h3>Details:</h3><table summary='Details'>");
        javadoc.add((Object)String.format("<tr><td align='right'>OData Service:</td><td>%s</td></tr>", service.getName()));
        if (!Strings.isNullOrEmpty((String)service.getInfoVersion())) {
            javadoc.add((Object)String.format("<tr><td align='right'>API Version:</td><td>%s</td></tr>", service.getInfoVersion()));
        }
        if (!Strings.isNullOrEmpty((String)service.getMinErpVersion())) {
            javadoc.add((Object)String.format("<tr><td align='right'>Minimum ERP Version:</td><td>%s</td></tr>", service.getMinErpVersion()));
        }
        if ((additionalDetails = service.getExternalOverview()) != null) {
            for (Service.ExternalOverview entry : additionalDetails) {
                if (Strings.isNullOrEmpty((String)entry.getName()) || entry.getValues() == null) continue;
                javadoc.add((Object)String.format("<tr><td align='right'>%s:</td><td>%s</td></tr>", entry.getName(), String.join((CharSequence)", ", entry.getValues())));
            }
        }
        javadoc.add((Object)"</table>");
    }

    private JDefinedClass generateServiceInterface(Service service, String formattedInterfaceName) throws JClassAlreadyExistsException {
        JDefinedClass interfaceClass = this.servicePackage._interface(formattedInterfaceName);
        this.addClassLevelJavadoc(interfaceClass.javadoc(), service);
        JFieldVar defaultServicePathField = interfaceClass.field(0, String.class, DEFAULT_SERVICE_PATH_FIELD_NAMING, JExpr.lit((String)service.getServiceUrl()));
        defaultServicePathField.javadoc().add((Object)"If no other path was provided via the {@link #withServicePath(String)} method, this is the default service path used to access the endpoint.");
        DeprecationUtils.addStatusInformation(interfaceClass, service, this.customDeprecationNoticeForService);
        JMethod withServicePathMethod = interfaceClass.method(0, (JType)interfaceClass, "withServicePath");
        withServicePathMethod.annotate(Nonnull.class);
        JVar servicePathParam = withServicePathMethod.param(8, String.class, SERVICE_PATH_FIELD_NAMING);
        servicePathParam.annotate(Nonnull.class);
        withServicePathMethod.javadoc().add((Object)"Overrides the default service path and returns a new service instance with the specified service path. Also adjusts the respective entity URLs.");
        withServicePathMethod.javadoc().addParam(servicePathParam).add((Object)"Service path that will override the default.");
        withServicePathMethod.javadoc().addReturn().add((Object)"A new service instance with the specified service path.");
        return interfaceClass;
    }

    private JDefinedClass generateServiceImplementation(JDefinedClass serviceInterfaceClass, Service service, String formattedClassName) throws JClassAlreadyExistsException {
        JDefinedClass serviceClass = this.servicePackage._class(formattedClassName)._implements((JClass)serviceInterfaceClass);
        this.addClassLevelJavadoc(serviceClass.javadoc(), service);
        DeprecationUtils.addStatusInformation(serviceClass, service, this.customDeprecationNoticeForService);
        JFieldVar servicePathField = serviceClass.field(12, String.class, SERVICE_PATH_FIELD_NAMING);
        servicePathField.annotate(Nonnull.class);
        JMethod noArgsConstructor = serviceClass.constructor(1);
        noArgsConstructor.body().assign((JAssignmentTarget)JExpr.ref((String)SERVICE_PATH_FIELD_NAMING), (JExpression)serviceInterfaceClass.staticRef(DEFAULT_SERVICE_PATH_FIELD_NAMING));
        noArgsConstructor.javadoc().add((Object)String.format("Creates a service using {@link %s#%s} to send the requests.", serviceInterfaceClass.name(), DEFAULT_SERVICE_PATH_FIELD_NAMING));
        JMethod servicePathConstructor = serviceClass.constructor(4);
        JVar servicePathParameter = servicePathConstructor.param(8, String.class, SERVICE_PATH_FIELD_NAMING);
        servicePathParameter.annotate(Nonnull.class);
        servicePathConstructor.body().assign((JAssignmentTarget)JExpr._this().ref((JVar)servicePathField), (JExpression)servicePathParameter);
        servicePathConstructor.javadoc().add((Object)"Creates a service using the provided service path to send the requests.\n");
        servicePathConstructor.javadoc().add((Object)"<p>\n");
        servicePathConstructor.javadoc().add((Object)"Used by the fluent {@link #withServicePath(String)} method.");
        JMethod withServicePathMethod = serviceClass.method(1, (JType)serviceClass, "withServicePath");
        withServicePathMethod.annotate(Override.class);
        withServicePathMethod.annotate(Nonnull.class);
        JVar servicePathParam = withServicePathMethod.param(8, String.class, SERVICE_PATH_FIELD_NAMING);
        servicePathParam.annotate(Nonnull.class);
        withServicePathMethod.body()._return((JExpression)JExpr._new((JClass)serviceClass).arg((JExpression)servicePathParam));
        return serviceClass;
    }

    JDefinedClass getOrGenerateServiceInterfaceClass(Service service) {
        String formattedInterfaceName = String.format(SERVICE_INTERFACE_NAMING, service.getJavaClassName());
        JDefinedClass interfaceClass = this.generatedServiceInterfaceClasses.get(service.getName());
        if (interfaceClass == null) {
            try {
                interfaceClass = this.generateServiceInterface(service, formattedInterfaceName);
            }
            catch (JClassAlreadyExistsException e) {
                log.error("Failed to get or generate interface: {} for service: {}", (Object)formattedInterfaceName, (Object)service);
                this.generatedServiceInterfaceClasses.entrySet().stream().filter(entry -> ((JDefinedClass)entry.getValue()).name().equals(formattedInterfaceName)).map(Map.Entry::getKey).findFirst().ifPresent(s -> log.error("An interface with the same name was already defined by service: {}", s));
                throw new ODataGeneratorException("Failed to generate service interface " + formattedInterfaceName, e);
            }
            this.generatedServiceInterfaceClasses.put(service.getName(), interfaceClass);
        }
        return interfaceClass;
    }

    JDefinedClass getOrGenerateServiceImplementationClass(Service service, JDefinedClass interfaceClass) {
        String formattedClassName = String.format(SERVICE_IMPLEMENTATION_NAMING, service.getJavaClassName());
        JDefinedClass implementationClass = this.generatedServiceImplementationClasses.get(service.getName());
        if (implementationClass == null) {
            try {
                implementationClass = this.generateServiceImplementation(interfaceClass, service, formattedClassName);
            }
            catch (JClassAlreadyExistsException e) {
                log.error("Failed to get or generate class: {} for service: {}", (Object)formattedClassName, (Object)service.getName());
                this.generatedServiceImplementationClasses.entrySet().stream().filter(entry -> ((JDefinedClass)entry.getValue()).name().equals(formattedClassName)).map(Map.Entry::getKey).findFirst().ifPresent(s -> log.error("A class with the same name was already defined by service: {}", s));
                throw new ODataGeneratorException(e);
            }
            this.generatedServiceImplementationClasses.put(service.getName(), implementationClass);
        }
        return implementationClass;
    }

    private BatchRelevantStubs getOrCreateBatchRelevantStubs(JClassContainer targetPackage, JDefinedClass serviceInterface, JDefinedClass serviceImplementation, Service service) {
        BatchRelevantStubs batchRelevantStubs = this.generatedBatchRelevantStubs.get(serviceInterface.name());
        if (batchRelevantStubs == null) {
            try {
                ServiceBatchGenerator.InterfaceStub serviceBatchInterface = this.serviceBatchGenerator.createInterfaceStub(targetPackage, serviceInterface);
                ServiceBatchChangeSetGenerator.InterfaceStub serviceBatchChangeSetInterface = this.serviceBatchChangeSetGenerator.createInterfaceStub(targetPackage, serviceInterface);
                DefaultServiceBatchGenerator.ClassStub defaultServiceBatchImplementation = this.defaultServiceBatchGenerator.createDefaultImplementation(targetPackage, serviceInterface, serviceBatchInterface, serviceBatchChangeSetInterface, service);
                DefaultServiceBatchChangeSetGenerator.ClassStub defaultServiceBatchChangeSetImplementation = this.defaultServiceBatchChangeSetGenerator.createDefaultImplementation(targetPackage, serviceInterface, serviceBatchChangeSetInterface, serviceBatchInterface, defaultServiceBatchImplementation, service);
                serviceBatchChangeSetInterface.addSuperClass(serviceBatchInterface);
                serviceBatchInterface.addSuperClass(serviceBatchChangeSetInterface);
                defaultServiceBatchImplementation.implementBeginChangeSetMethod(serviceBatchChangeSetInterface, defaultServiceBatchChangeSetImplementation);
                this.addBatchSupport(serviceInterface, serviceImplementation, serviceBatchInterface, defaultServiceBatchImplementation);
                batchRelevantStubs = new BatchRelevantStubs(serviceBatchInterface, serviceBatchChangeSetInterface, defaultServiceBatchImplementation, defaultServiceBatchChangeSetImplementation);
                this.generatedBatchRelevantStubs.put(serviceInterface.name(), batchRelevantStubs);
            }
            catch (JClassAlreadyExistsException e) {
                throw new ODataGeneratorException(e);
            }
        }
        return batchRelevantStubs;
    }

    private void addBatchSupport(JDefinedClass serviceInterface, JDefinedClass serviceImplementation, ServiceBatchGenerator.InterfaceStub batchInterface, DefaultServiceBatchGenerator.ClassStub batchImplementation) {
        serviceInterface._extends(this.codeModel.ref(BatchService.class).narrow((JClass)batchInterface.getServiceBatchStub()));
        JMethod batchMethodImplementation = serviceImplementation.method(1, (JType)batchImplementation.getDefaultServiceBatchStub(), "batch");
        batchMethodImplementation.annotate(Override.class);
        batchMethodImplementation.annotate(Nonnull.class);
        batchMethodImplementation.body()._return((JExpression)JExpr._new((JClass)batchImplementation.getDefaultServiceBatchStub()).arg(JExpr._this()).arg((JExpression)JExpr.ref((String)SERVICE_PATH_FIELD_NAMING)));
    }

    ServiceClassAmplifier getOrGenerateServiceClassesAndGetAmplifier(Service service) {
        JPackage concreteBatchPackage = this.namespaceParentPackage.subPackage(service.getJavaPackageName()).subPackage("batch");
        JDefinedClass serviceInterfaceClass = this.getOrGenerateServiceInterfaceClass(service);
        JDefinedClass serviceImplementationClass = this.getOrGenerateServiceImplementationClass(service, serviceInterfaceClass);
        BatchRelevantStubs batchRelevantStubs = this.getOrCreateBatchRelevantStubs((JClassContainer)concreteBatchPackage, serviceInterfaceClass, serviceImplementationClass, service);
        return new ServiceClassAmplifier(serviceInterfaceClass, serviceImplementationClass, batchRelevantStubs.serviceBatchChangeSetInterface, batchRelevantStubs.defaultServiceBatchChangeSetImplementation, this.codeNamingStrategy, this.serviceMethodsPerEntitySet, this.classScanner);
    }

    private static String getMethodNameSuffixFromEntitySet(String entitySetName) {
        return StringUtils.removeStartIgnoreCase((String)entitySetName, (String)"A_");
    }

    Option<String> getQualifiedServiceInterfaceName(String serviceName) {
        return Option.of((Object)this.generatedServiceInterfaceClasses.get(serviceName).fullName());
    }

    Option<String> getQualifiedServiceImplementationClassName(String serviceName) {
        return Option.of((Object)this.generatedServiceImplementationClasses.get(serviceName).fullName());
    }

    boolean wasServiceGenerated(String serviceName) {
        return this.generatedServiceInterfaceClasses.containsKey(serviceName);
    }

    @Generated
    public ServiceClassGenerator(JCodeModel codeModel, JPackage servicePackage, JPackage namespaceParentPackage, NamingStrategy codeNamingStrategy, ServiceBatchChangeSetGenerator serviceBatchChangeSetGenerator, ServiceBatchGenerator serviceBatchGenerator, DefaultServiceBatchGenerator defaultServiceBatchGenerator, DefaultServiceBatchChangeSetGenerator defaultServiceBatchChangeSetGenerator, boolean serviceMethodsPerEntitySet, LegacyClassScanner classScanner) {
        this.codeModel = codeModel;
        this.servicePackage = servicePackage;
        this.namespaceParentPackage = namespaceParentPackage;
        this.codeNamingStrategy = codeNamingStrategy;
        this.serviceBatchChangeSetGenerator = serviceBatchChangeSetGenerator;
        this.serviceBatchGenerator = serviceBatchGenerator;
        this.defaultServiceBatchGenerator = defaultServiceBatchGenerator;
        this.defaultServiceBatchChangeSetGenerator = defaultServiceBatchChangeSetGenerator;
        this.serviceMethodsPerEntitySet = serviceMethodsPerEntitySet;
        this.classScanner = classScanner;
    }

    @Generated
    void setCustomDeprecationNoticeForService(String customDeprecationNoticeForService) {
        this.customDeprecationNoticeForService = customDeprecationNoticeForService;
    }

    private static class BatchRelevantStubs {
        final ServiceBatchGenerator.InterfaceStub serviceBatchInterface;
        final ServiceBatchChangeSetGenerator.InterfaceStub serviceBatchChangeSetInterface;
        final DefaultServiceBatchGenerator.ClassStub defaultServiceBatchImplementation;
        final DefaultServiceBatchChangeSetGenerator.ClassStub defaultServiceBatchChangeSetImplementation;

        @Generated
        public BatchRelevantStubs(ServiceBatchGenerator.InterfaceStub serviceBatchInterface, ServiceBatchChangeSetGenerator.InterfaceStub serviceBatchChangeSetInterface, DefaultServiceBatchGenerator.ClassStub defaultServiceBatchImplementation, DefaultServiceBatchChangeSetGenerator.ClassStub defaultServiceBatchChangeSetImplementation) {
            this.serviceBatchInterface = serviceBatchInterface;
            this.serviceBatchChangeSetInterface = serviceBatchChangeSetInterface;
            this.defaultServiceBatchImplementation = defaultServiceBatchImplementation;
            this.defaultServiceBatchChangeSetImplementation = defaultServiceBatchChangeSetImplementation;
        }
    }

    static final class ServiceClassAmplifier {
        private final JDefinedClass serviceInterfaceClass;
        private final JDefinedClass serviceImplementationClass;
        private final ServiceBatchChangeSetGenerator.InterfaceStub serviceBatchChangeSetInterface;
        private final DefaultServiceBatchChangeSetGenerator.ClassStub defaultServiceBatchChangeSetImplementationImplementation;
        private final NamingStrategy codeNamingStrategy;
        private final boolean serviceMethodsPerEntitySet;
        private final LegacyClassScanner classScanner;

        Iterable<EntityPropertyModel> getRefinedKeyProperties(@Nonnull String methodName, @Nonnull Iterable<EntityPropertyModel> keyProperties) {
            List getByKeyMethodArguments = this.classScanner.determineArgumentsForMethod(this.serviceInterfaceClass.fullName(), methodName, keyProperties, EntityPropertyModel::getJavaFieldName);
            if (getByKeyMethodArguments.size() != 1) {
                String msg = String.format("Entity in class %s has different key parameters than last time the code generator run.", this.serviceInterfaceClass.fullName());
                log.error("{} Found the following key parameter groups: {}", (Object)msg, (Object)getByKeyMethodArguments);
                throw new ODataGeneratorWriteException(msg);
            }
            return (Iterable)getByKeyMethodArguments.get(0);
        }

        String getByKeyMethodName(EntityMetadata entityMetadata) {
            String methodNameSuffix = this.serviceMethodsPerEntitySet ? ServiceClassGenerator.getMethodNameSuffixFromEntitySet(entityMetadata.getEntitySetName()) : entityMetadata.getGeneratedEntityClass().name();
            return NamingUtils.deriveGetEntityServiceMethodName((String)methodNameSuffix);
        }

        void addGetByKeyMethod(EntityMetadata entityMetadata, JDefinedClass generatedEntityByKeyFluentHelperClass, String methodName, Iterable<EntityPropertyModel> keyProperties) {
            JDefinedClass entityClass = entityMetadata.getGeneratedEntityClass();
            JMethod interfaceMethod = this.serviceInterfaceClass.method(0, (JType)generatedEntityByKeyFluentHelperClass, methodName);
            interfaceMethod.annotate(Nonnull.class);
            interfaceMethod.javadoc().add((Object)String.format("Fetch a single {@link %s %s} entity using key fields.", entityClass.fullName(), entityClass.name()));
            interfaceMethod.javadoc().addReturn().add((Object)String.format("A fluent helper to fetch a single {@link %s %s} entity using key fields. This fluent helper allows methods which modify the underlying query to be called before executing the query itself. To perform execution, call the {@link %s#execute execute} method on the fluent helper object. ", entityClass.fullName(), entityClass.name(), generatedEntityByKeyFluentHelperClass.fullName()));
            JMethod implementationMethod = this.serviceImplementationClass.method(1, (JType)generatedEntityByKeyFluentHelperClass, methodName);
            implementationMethod.annotate(Override.class);
            implementationMethod.annotate(Nonnull.class);
            HashMap<String, JVar> generatedParameters = new HashMap<String, JVar>();
            for (EntityPropertyModel keyProperty : keyProperties) {
                JVar interfaceKeyParameter = interfaceMethod.param(8, keyProperty.getJavaFieldType(), keyProperty.getJavaFieldName());
                JCommentPart parameterJavadoc = interfaceMethod.javadoc().addParam(interfaceKeyParameter);
                parameterJavadoc.add((Object)keyProperty.getBasicDescription());
                if (!Strings.isNullOrEmpty((String)keyProperty.getBasicDescription())) {
                    parameterJavadoc.add((Object)String.format("<p>%s</p>", keyProperty.getConstraintsDescription()));
                }
                JVar implementationKeyParameter = implementationMethod.param(8, keyProperty.getJavaFieldType(), keyProperty.getJavaFieldName());
                generatedParameters.put(keyProperty.getJavaFieldName(), implementationKeyParameter);
            }
            JInvocation newExp = JExpr._new((JClass)generatedEntityByKeyFluentHelperClass);
            newExp.arg((JExpression)JExpr.ref((String)ServiceClassGenerator.SERVICE_PATH_FIELD_NAMING)).arg(entityMetadata.getEntitySetName());
            for (EntityPropertyModel model : keyProperties) {
                newExp.arg((JExpression)generatedParameters.get(model.getJavaFieldName()));
            }
            implementationMethod.body()._return((JExpression)newExp);
        }

        void addGetAllMethod(EntityMetadata entityMetadata, JDefinedClass generatedEntityFluentHelperClass) {
            JDefinedClass entityClass = entityMetadata.getGeneratedEntityClass();
            String methodNameSuffix = this.serviceMethodsPerEntitySet ? ServiceClassGenerator.getMethodNameSuffixFromEntitySet(entityMetadata.getEntitySetName()) : entityClass.name();
            String methodName = NamingUtils.deriveGetAllEntitiesServiceMethodName((String)methodNameSuffix);
            JMethod interfaceMethod = this.serviceInterfaceClass.method(0, (JType)generatedEntityFluentHelperClass, methodName);
            interfaceMethod.annotate(Nonnull.class);
            interfaceMethod.javadoc().add((Object)String.format("Fetch multiple {@link %s %s} entities.", entityClass.fullName(), entityClass.name()));
            interfaceMethod.javadoc().addReturn().add((Object)String.format("A fluent helper to fetch multiple {@link %s %s} entities. This fluent helper allows methods which modify the underlying query to be called before executing the query itself. To perform execution, call the {@link %s#execute execute} method on the fluent helper object. ", entityClass.fullName(), entityClass.name(), generatedEntityFluentHelperClass.fullName()));
            JMethod implementationMethod = this.serviceImplementationClass.method(1, (JType)generatedEntityFluentHelperClass, methodName);
            implementationMethod.annotate(Override.class);
            implementationMethod.annotate(Nonnull.class);
            implementationMethod.body()._return((JExpression)JExpr._new((JClass)generatedEntityFluentHelperClass).arg((JExpression)JExpr.ref((String)ServiceClassGenerator.SERVICE_PATH_FIELD_NAMING)).arg(entityMetadata.getEntitySetName()));
        }

        void addFunctionImportMethod(String edmName, String edmLabel, String description, Iterable<FunctionImportParameterModel> parameters, JDefinedClass functionImportFluentHelperClass, NamingContext functionImportFetchMethodNamingContext) {
            String methodNameFetch = functionImportFetchMethodNamingContext.ensureUniqueName(this.codeNamingStrategy.generateJavaOperationMethodName(edmName, edmLabel));
            List functionImportFactoryMethods = this.classScanner.determineArgumentsForMethod(this.serviceInterfaceClass.fullName(), methodNameFetch, parameters, FunctionImportParameterModel::getJavaName);
            for (List factoryMethodArguments : functionImportFactoryMethods) {
                JMethod interfaceMethod = this.serviceInterfaceClass.method(0, (JType)functionImportFluentHelperClass, methodNameFetch);
                interfaceMethod.annotate(Nonnull.class);
                interfaceMethod.javadoc().add((Object)(Strings.isNullOrEmpty((String)description) ? "" : description));
                interfaceMethod.javadoc().add((Object)String.format("<p>Creates a fluent helper for the <b>%s</b> OData function import.</p>", edmName));
                interfaceMethod.javadoc().addReturn().add((Object)String.format("A fluent helper object that will execute the <b>%s</b> OData function import with the provided parameters. To perform execution, call the {@link %s#execute execute} method on the fluent helper object.", edmName, functionImportFluentHelperClass.fullName()));
                JMethod implementationMethod = this.serviceImplementationClass.method(1, (JType)functionImportFluentHelperClass, methodNameFetch);
                implementationMethod.annotate(Override.class);
                implementationMethod.annotate(Nonnull.class);
                JInvocation newHelperStatement = JExpr._new((JClass)functionImportFluentHelperClass);
                newHelperStatement.arg((JExpression)JExpr.ref((String)ServiceClassGenerator.SERVICE_PATH_FIELD_NAMING));
                for (FunctionImportParameterModel parameter : factoryMethodArguments) {
                    JVar interfaceParameter = interfaceMethod.param(8, parameter.getJavaType(), parameter.getJavaName());
                    interfaceParameter.annotate(parameter.isNonnull() ? Nonnull.class : Nullable.class);
                    JCommentPart parameterDoc = interfaceMethod.javadoc().addParam(interfaceParameter);
                    if (!Strings.isNullOrEmpty((String)parameter.getDescription())) {
                        parameterDoc.add((Object)parameter.getDescription());
                    }
                    JVar implementationParameter = implementationMethod.param(8, parameter.getJavaType(), parameter.getJavaName());
                    implementationParameter.annotate(parameter.isNonnull() ? Nonnull.class : Nullable.class);
                    newHelperStatement.arg((JExpression)implementationParameter);
                }
                implementationMethod.body()._return((JExpression)newHelperStatement);
            }
        }

        void addCreateMethod(EntityMetadata entityMetadata, JDefinedClass generatedCreateFluentHelperClass) {
            JDefinedClass entityClass = entityMetadata.getGeneratedEntityClass();
            String methodNameSuffix = this.serviceMethodsPerEntitySet ? ServiceClassGenerator.getMethodNameSuffixFromEntitySet(entityMetadata.getEntitySetName()) : entityClass.name();
            String methodName = NamingUtils.deriveCreateEntityServiceMethodName((String)methodNameSuffix);
            String parameterName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, entityClass.name());
            JMethod interfaceMethod = this.serviceInterfaceClass.method(0, (JType)generatedCreateFluentHelperClass, methodName);
            interfaceMethod.annotate(Nonnull.class);
            JVar interfaceEntityParam = interfaceMethod.param(8, (JType)entityClass, parameterName);
            interfaceEntityParam.annotate(Nonnull.class);
            interfaceMethod.javadoc().add((Object)String.format("Create a new {@link %s %s} entity and save it to the S/4HANA system.", entityClass.fullName(), entityClass.name()));
            interfaceMethod.javadoc().addParam(interfaceEntityParam).add((Object)String.format("{@link %s %s} entity object that will be created in the S/4HANA system.", entityClass.fullName(), entityClass.name()));
            interfaceMethod.javadoc().addReturn().add((Object)String.format("A fluent helper to create a new {@link %s %s} entity. To perform execution, call the {@link %s#execute execute} method on the fluent helper object. ", entityClass.fullName(), entityClass.name(), generatedCreateFluentHelperClass.fullName()));
            JMethod batchInterfaceMethod = this.serviceBatchChangeSetInterface.addMethod(interfaceMethod);
            this.defaultServiceBatchChangeSetImplementationImplementation.addCreateMethodImplementation(interfaceMethod, batchInterfaceMethod);
            JMethod implementationMethod = this.serviceImplementationClass.method(1, (JType)generatedCreateFluentHelperClass, methodName);
            implementationMethod.annotate(Override.class);
            implementationMethod.annotate(Nonnull.class);
            JVar implementationEntityParam = implementationMethod.param(8, (JType)entityClass, parameterName);
            implementationEntityParam.annotate(Nonnull.class);
            implementationMethod.body()._return((JExpression)JExpr._new((JClass)generatedCreateFluentHelperClass).arg((JExpression)JExpr.ref((String)ServiceClassGenerator.SERVICE_PATH_FIELD_NAMING)).arg((JExpression)implementationEntityParam).arg(entityMetadata.getEntitySetName()));
        }

        void addUpdateMethod(EntityMetadata entityMetadata, JDefinedClass generatedUpdateFluentHelperClass) {
            JDefinedClass entityClass = entityMetadata.getGeneratedEntityClass();
            String methodNameSuffix = this.serviceMethodsPerEntitySet ? ServiceClassGenerator.getMethodNameSuffixFromEntitySet(entityMetadata.getEntitySetName()) : entityClass.name();
            String methodName = NamingUtils.deriveUpdateEntityServiceMethodName((String)methodNameSuffix);
            String parameterName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, entityClass.name());
            JMethod interfaceMethod = this.serviceInterfaceClass.method(0, (JType)generatedUpdateFluentHelperClass, methodName);
            interfaceMethod.annotate(Nonnull.class);
            JVar interfaceEntityParam = interfaceMethod.param(8, (JType)entityClass, parameterName);
            interfaceEntityParam.annotate(Nonnull.class);
            interfaceMethod.javadoc().add((Object)String.format("Update an existing {@link %s %s} entity and save it to the S/4HANA system.", entityClass.fullName(), entityClass.name()));
            interfaceMethod.javadoc().addParam(interfaceEntityParam).add((Object)String.format("{@link %s %s} entity object that will be updated in the S/4HANA system.", entityClass.fullName(), entityClass.name()));
            interfaceMethod.javadoc().addReturn().add((Object)String.format("A fluent helper to update an existing {@link %s %s} entity. To perform execution, call the {@link %s#execute execute} method on the fluent helper object. ", entityClass.fullName(), entityClass.name(), generatedUpdateFluentHelperClass.fullName()));
            JMethod batchInterfaceMethod = this.serviceBatchChangeSetInterface.addMethod(interfaceMethod);
            this.defaultServiceBatchChangeSetImplementationImplementation.addUpdateMethodImplementation(interfaceMethod, batchInterfaceMethod);
            JMethod implementationMethod = this.serviceImplementationClass.method(1, (JType)generatedUpdateFluentHelperClass, methodName);
            implementationMethod.annotate(Override.class);
            implementationMethod.annotate(Nonnull.class);
            JVar implementationEntityParam = implementationMethod.param(8, (JType)entityClass, parameterName);
            implementationEntityParam.annotate(Nonnull.class);
            implementationMethod.body()._return((JExpression)JExpr._new((JClass)generatedUpdateFluentHelperClass).arg((JExpression)JExpr.ref((String)ServiceClassGenerator.SERVICE_PATH_FIELD_NAMING)).arg((JExpression)implementationEntityParam).arg(entityMetadata.getEntitySetName()));
        }

        void addDeleteMethod(EntityMetadata entityMetadata, JDefinedClass generatedDeleteFluentHelperClass) {
            JDefinedClass entityClass = entityMetadata.getGeneratedEntityClass();
            String methodNameSuffix = this.serviceMethodsPerEntitySet ? ServiceClassGenerator.getMethodNameSuffixFromEntitySet(entityMetadata.getEntitySetName()) : entityClass.name();
            String methodName = NamingUtils.deriveDeleteEntityServiceMethodName((String)methodNameSuffix);
            String parameterName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, entityClass.name());
            JMethod interfaceMethod = this.serviceInterfaceClass.method(0, (JType)generatedDeleteFluentHelperClass, methodName);
            interfaceMethod.annotate(Nonnull.class);
            JVar interfaceEntityParam = interfaceMethod.param(8, (JType)entityClass, parameterName);
            interfaceEntityParam.annotate(Nonnull.class);
            interfaceMethod.javadoc().add((Object)String.format("Deletes an existing {@link %s %s} entity in the S/4HANA system.", entityClass.fullName(), entityClass.name()));
            interfaceMethod.javadoc().addParam(interfaceEntityParam).add((Object)String.format("{@link %s %s} entity object that will be deleted in the S/4HANA system.", entityClass.fullName(), entityClass.name()));
            interfaceMethod.javadoc().addReturn().add((Object)String.format("A fluent helper to delete an existing {@link %s %s} entity. To perform execution, call the {@link %s#execute execute} method on the fluent helper object. ", entityClass.fullName(), entityClass.name(), generatedDeleteFluentHelperClass.fullName()));
            JMethod batchInterfaceMethod = this.serviceBatchChangeSetInterface.addMethod(interfaceMethod);
            this.defaultServiceBatchChangeSetImplementationImplementation.addDeleteMethodImplementation(interfaceMethod, batchInterfaceMethod);
            JMethod implementationMethod = this.serviceImplementationClass.method(1, (JType)generatedDeleteFluentHelperClass, methodName);
            implementationMethod.annotate(Override.class);
            implementationMethod.annotate(Nonnull.class);
            JVar implementationEntityParam = implementationMethod.param(8, (JType)entityClass, parameterName);
            implementationEntityParam.annotate(Nonnull.class);
            implementationMethod.body()._return((JExpression)JExpr._new((JClass)generatedDeleteFluentHelperClass).arg((JExpression)JExpr.ref((String)ServiceClassGenerator.SERVICE_PATH_FIELD_NAMING)).arg((JExpression)implementationEntityParam).arg(entityMetadata.getEntitySetName()));
        }

        @Generated
        public ServiceClassAmplifier(JDefinedClass serviceInterfaceClass, JDefinedClass serviceImplementationClass, ServiceBatchChangeSetGenerator.InterfaceStub serviceBatchChangeSetInterface, DefaultServiceBatchChangeSetGenerator.ClassStub defaultServiceBatchChangeSetImplementationImplementation, NamingStrategy codeNamingStrategy, boolean serviceMethodsPerEntitySet, LegacyClassScanner classScanner) {
            this.serviceInterfaceClass = serviceInterfaceClass;
            this.serviceImplementationClass = serviceImplementationClass;
            this.serviceBatchChangeSetInterface = serviceBatchChangeSetInterface;
            this.defaultServiceBatchChangeSetImplementationImplementation = defaultServiceBatchChangeSetImplementationImplementation;
            this.codeNamingStrategy = codeNamingStrategy;
            this.serviceMethodsPerEntitySet = serviceMethodsPerEntitySet;
            this.classScanner = classScanner;
        }

        @Generated
        JDefinedClass getServiceInterfaceClass() {
            return this.serviceInterfaceClass;
        }
    }
}

