/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.generator;

import com.sap.cloud.sdk.datamodel.odata.generator.ServiceBatchGenerator;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JCommentPart;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.Collection;
import javax.annotation.Nonnull;
import lombok.Generated;

class ServiceBatchChangeSetGenerator {
    private final JCodeModel codeModel;

    InterfaceStub createInterfaceStub(JClassContainer targetPackage, JDefinedClass serviceInterface) throws JClassAlreadyExistsException {
        JDefinedClass interfaceToCreate = targetPackage._interface(1, ServiceBatchChangeSetGenerator.createInterfaceName(serviceInterface));
        interfaceToCreate.javadoc().add((Object)String.format("This interface enables you to combine multiple operations into one change set. For further information have a look into the {@link %s %s}.", serviceInterface.fullName(), serviceInterface.name()));
        return new InterfaceStub(interfaceToCreate);
    }

    private JMethod addMethod(JDefinedClass interfaceToAddTo, JMethod interfaceMethod) {
        JMethod methodAdded = interfaceToAddTo.method(interfaceMethod.mods().getValue(), (JType)interfaceToAddTo, interfaceMethod.name());
        for (JVar paramToAdd : interfaceMethod.params()) {
            JVar paramAdded = methodAdded.param(paramToAdd.mods().getValue(), paramToAdd.type(), paramToAdd.name());
            JCommentPart paramJavadoc = interfaceMethod.javadoc().addParam(paramToAdd);
            methodAdded.javadoc().addParam(paramAdded).addAll((Collection)paramJavadoc);
            for (JAnnotationUse annotationToAdd : paramToAdd.annotations()) {
                paramAdded.annotate(annotationToAdd.getAnnotationClass());
            }
        }
        for (JAnnotationUse methodAnnotationToAdd : interfaceMethod.annotations()) {
            methodAdded.annotate(methodAnnotationToAdd.getAnnotationClass());
        }
        methodAdded.javadoc().addAll((Collection)interfaceMethod.javadoc());
        methodAdded.javadoc().addReturn().add((Object)"This fluent helper to continue adding operations to the change set. To finalize the current change set call {@link #endChangeSet endChangeSet} on the returned fluent helper object.");
        return methodAdded;
    }

    private void addSuperClass(JDefinedClass stubToModify, JDefinedClass batchInterface) {
        stubToModify._extends(this.codeModel.ref(FluentHelperBatchEndChangeSet.class).narrow((JClass)batchInterface));
        stubToModify._extends(this.codeModel.ref(FluentHelperBatchChangeSet.class).narrow((JClass)stubToModify));
    }

    private static String createInterfaceName(JDefinedClass serviceInterface) {
        return serviceInterface.name() + "BatchChangeSet";
    }

    @Generated
    ServiceBatchChangeSetGenerator(JCodeModel codeModel) {
        this.codeModel = codeModel;
    }

    class InterfaceStub {
        @Nonnull
        private final JDefinedClass serviceBatchChangeSetStub;

        JMethod addMethod(JMethod interfaceMethod) {
            return ServiceBatchChangeSetGenerator.this.addMethod(this.serviceBatchChangeSetStub, interfaceMethod);
        }

        void addSuperClass(ServiceBatchGenerator.InterfaceStub serviceBatchStub) {
            ServiceBatchChangeSetGenerator.this.addSuperClass(this.serviceBatchChangeSetStub, serviceBatchStub.getServiceBatchStub());
        }

        @Generated
        private InterfaceStub(JDefinedClass serviceBatchChangeSetStub) {
            if (serviceBatchChangeSetStub == null) {
                throw new NullPointerException("serviceBatchChangeSetStub is marked non-null but is null");
            }
            this.serviceBatchChangeSetStub = serviceBatchChangeSetStub;
        }

        @Nonnull
        @Generated
        JDefinedClass getServiceBatchChangeSetStub() {
            return this.serviceBatchChangeSetStub;
        }
    }
}

