/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.generator;

import com.google.common.collect.Lists;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.generator.AnnotationHelper;
import com.sap.cloud.sdk.datamodel.odata.generator.JavadocUtils;
import com.sap.cloud.sdk.datamodel.odata.generator.MessageCollector;
import com.sap.cloud.sdk.datamodel.odata.generator.Multiplicity;
import com.sap.cloud.sdk.datamodel.odata.generator.NavigationPropertyModel;
import com.sap.cloud.sdk.datamodel.odata.generator.NavigationPropertyModelAnnotationWrapper;
import com.sap.cloud.sdk.datamodel.odata.generator.ODataGeneratorException;
import com.sap.cloud.sdk.datamodel.odata.generator.annotation.AnnotationStrategy;
import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocCommentable;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JForEach;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import io.vavr.control.Option;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.SourceVersion;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;
import org.slf4j.Logger;

class NavigationPropertyMethodsGenerator {
    private static final Logger logger = MessageCollector.getLogger(NavigationPropertyMethodsGenerator.class);
    private final JCodeModel codeModel;
    private final JDefinedClass entityClass;

    NavigationPropertyMethodsGenerator(JCodeModel codeModel, JDefinedClass entityClass) {
        this.codeModel = codeModel;
        this.entityClass = entityClass;
    }

    @Nonnull
    Map<String, JFieldVar> createNavigationPropertyFields(Iterable<NavigationPropertyModel> navigationProperties, Map<String, JDefinedClass> generatedEntities, AnnotationStrategy annotationStrategy) {
        HashMap<String, JFieldVar> navigationPropertyFields = new HashMap<String, JFieldVar>();
        for (NavigationPropertyModel navigationProperty : navigationProperties) {
            JDefinedClass associatedEntity = this.getAssociatedEntity(navigationProperty, generatedEntities);
            if (associatedEntity == null) continue;
            navigationPropertyFields.put(navigationProperty.getEdmName(), this.createNavigationPropertyField(navigationProperty, associatedEntity, annotationStrategy));
        }
        return navigationPropertyFields;
    }

    void addNavigationPropertyMethods(Map<String, JDefinedClass> generatedEntities, Iterable<NavigationPropertyModel> navigationProperties, Map<String, JFieldVar> generatedNavigationPropertyFields, JDocCommentable selectableInterface, JClass entityOneToManyLink, JClass entityOneToOneLink) {
        JClass mapType = this.codeModel.ref(Map.class).narrow(new Class[]{String.class, Object.class});
        List fromMapContents = this.entityClass.getMethod("fromMap", new JType[]{mapType}).body().getContents();
        Object statementBeforeSuper = fromMapContents.get(fromMapContents.size() - 2);
        JBlock fromMapBlock = statementBeforeSuper instanceof JBlock ? (JBlock)statementBeforeSuper : null;
        JClass fieldMapClass = this.codeModel.ref(Map.class).narrow(new Class[]{String.class, Object.class});
        JMethod toMapOfNavigationPropertiesMethod = this.entityClass.method(2, (JType)fieldMapClass, "toMapOfNavigationProperties");
        toMapOfNavigationPropertiesMethod.annotate(Nonnull.class);
        toMapOfNavigationPropertiesMethod.annotate(Override.class);
        JVar valuesMap = toMapOfNavigationPropertiesMethod.body().decl(8, (JType)fieldMapClass, "cloudSdkValues", (JExpression)JExpr._super().invoke("toMapOfNavigationProperties"));
        for (NavigationPropertyModel navigationProperty : navigationProperties) {
            JFieldVar navigationPropertyField = generatedNavigationPropertyFields.get(navigationProperty.getEdmName());
            JDefinedClass associatedEntity = this.getAssociatedEntity(navigationProperty, generatedEntities);
            if (navigationPropertyField == null || associatedEntity == null) continue;
            this.addNavigationPropertyLogic(navigationPropertyField, selectableInterface, entityOneToManyLink, entityOneToOneLink, mapType, toMapOfNavigationPropertiesMethod, fromMapBlock, navigationProperty, associatedEntity);
            navigationPropertyField.annotate(Getter.class).param("value", (JExpression)this.codeModel.ref(AccessLevel.class).staticRef("NONE"));
            navigationPropertyField.annotate(Setter.class).param("value", (JExpression)this.codeModel.ref(AccessLevel.class).staticRef("NONE"));
        }
        toMapOfNavigationPropertiesMethod.body()._return((JExpression)valuesMap);
    }

    @Nullable
    private JDefinedClass getAssociatedEntity(NavigationPropertyModel navigationProperty, Map<String, JDefinedClass> generatedEntities) {
        JDefinedClass associatedEntity = generatedEntities.get(navigationProperty.getReturnEntityType());
        if (associatedEntity == null) {
            logger.warn("Unable to generate code for navigation property " + navigationProperty.getEdmName() + " of entity " + this.entityClass.name() + ":  Associated entity type " + navigationProperty.getReturnEntityType() + " is either not found or its entity set has been filtered out.");
        }
        return associatedEntity;
    }

    private JFieldVar createNavigationPropertyField(NavigationPropertyModel navigationProperty, JDefinedClass associatedEntity, AnnotationStrategy annotationStrategy) {
        boolean isOneToMany = navigationProperty.getMultiplicity() == Multiplicity.MANY;
        Object returnType = isOneToMany ? this.codeModel.ref(List.class).narrow((JClass)associatedEntity) : associatedEntity;
        JFieldVar navigationPropertyField = this.createClassMember(navigationProperty, associatedEntity, isOneToMany, (JClass)returnType, annotationStrategy);
        this.changeBuilder(navigationProperty, associatedEntity, isOneToMany, navigationPropertyField);
        return navigationPropertyField;
    }

    private void addNavigationPropertyLogic(JFieldVar navigationPropertyField, JDocCommentable selectableInterface, JClass specificEntityOneToManyLinkClass, JClass specificEntityOneToOneLinkClass, JClass mapType, JMethod toMapOfNavigationPropertiesMethod, JBlock fromMapBlock, NavigationPropertyModel navigationProperty, JDefinedClass associatedEntity) {
        boolean isOneToMany = navigationProperty.getMultiplicity() == Multiplicity.MANY;
        JType returnType = navigationPropertyField.type();
        JFieldVar fluentHelperField = isOneToMany ? this.createLinkConstant(specificEntityOneToManyLinkClass, navigationProperty, associatedEntity) : this.createLinkConstant(specificEntityOneToOneLinkClass, navigationProperty, associatedEntity);
        JavadocUtils.addFieldReference(selectableInterface, this.entityClass, fluentHelperField);
        if (fromMapBlock != null) {
            this.handleFromMapAdditions(mapType, fromMapBlock, navigationProperty, associatedEntity, isOneToMany, navigationPropertyField);
        }
        this.createFetchMethod(navigationProperty, associatedEntity, isOneToMany, returnType, (JAssignmentTarget)navigationPropertyField);
        this.createGetIfPresentMethod(navigationProperty, associatedEntity, isOneToMany, returnType, (JExpression)navigationPropertyField);
        this.createSetterMethod(navigationProperty, associatedEntity, isOneToMany, returnType, (JAssignmentTarget)navigationPropertyField);
        if (isOneToMany) {
            this.createAddMethod(navigationProperty, associatedEntity, (JAssignmentTarget)navigationPropertyField);
        }
        this.addIfAndPutStatementToNavigationPropertiesMap(toMapOfNavigationPropertiesMethod, navigationProperty, navigationPropertyField);
    }

    private void addIfAndPutStatementToNavigationPropertiesMap(JMethod toMapOfNavigationPropertiesMethod, NavigationPropertyModel navigationProperty, JFieldVar propField) {
        JBlock body = toMapOfNavigationPropertiesMethod.body();
        body._if(propField.ne(JExpr._null()))._then().invoke(JExpr.direct((String)"cloudSdkValues"), "put").arg(navigationProperty.getEdmName()).arg((JExpression)propField);
    }

    private void createAddMethod(NavigationPropertyModel navigationProperty, JDefinedClass associatedEntity, JAssignmentTarget propField) {
        String addToName = navigationProperty.getJavaMethodNameAdd();
        JMethod addToMethod = this.entityClass.method(1, (JType)this.codeModel.VOID, addToName);
        JVar entity = addToMethod.varParam((JType)associatedEntity, "entity");
        addToMethod.javadoc().add((Object)String.format("Adds elements to the list of associated <b>%s</b> entities. This corresponds to the OData navigation property <b>%s</b>.", associatedEntity.name(), navigationProperty.getEdmName()));
        addToMethod.javadoc().add((Object)JavadocUtils.getLazyWarningMessage(navigationProperty, this.entityClass));
        addToMethod.javadoc().addParam(entity).add((Object)String.format("Array of <b>%s</b> entities.", associatedEntity.name()));
        addToMethod.body()._if(propField.eq(JExpr._null()))._then().assign(propField, (JExpression)this.codeModel.ref(Lists.class).staticInvoke("newArrayList"));
        addToMethod.body().invoke((JExpression)propField, "addAll").arg((JExpression)this.codeModel.ref(Lists.class).staticInvoke("newArrayList").arg((JExpression)entity));
    }

    private void createSetterMethod(NavigationPropertyModel navigationProperty, JDefinedClass associatedEntity, boolean isOneToMany, JType returnType, JAssignmentTarget propField) {
        if (isOneToMany) {
            String setterName = navigationProperty.getJavaMethodNameSet();
            JMethod setterMethod = this.entityClass.method(1, (JType)this.codeModel.VOID, setterName);
            setterMethod.javadoc().add((Object)String.format("Overwrites the list of associated <b>%s</b> entities for the loaded navigation property <b>%s</b>.", associatedEntity.name(), navigationProperty.getEdmName()));
            setterMethod.javadoc().add((Object)JavadocUtils.getLazyWarningMessage(navigationProperty, this.entityClass));
            JVar setterParam = setterMethod.param(8, returnType, "cloudSdkValue");
            setterMethod.javadoc().addParam(setterParam).add((Object)String.format("List of <b>%s</b> entities.", associatedEntity.name()));
            setterParam.annotate(Nonnull.class);
            JBlock setterBody = setterMethod.body();
            setterBody._if(propField.eq(JExpr._null()))._then().assign(propField, (JExpression)this.codeModel.ref(Lists.class).staticInvoke("newArrayList"));
            setterBody.invoke((JExpression)propField, "clear");
            setterBody.invoke((JExpression)propField, "addAll").arg((JExpression)setterParam);
        } else {
            String setterName = navigationProperty.getJavaMethodNameSet();
            JMethod setterMethod = this.entityClass.method(1, (JType)this.codeModel.VOID, setterName);
            setterMethod.javadoc().add((Object)String.format("Overwrites the associated <b>%s</b> entity for the loaded navigation property <b>%s</b>.", associatedEntity.name(), navigationProperty.getEdmName()));
            JVar setterParam = setterMethod.param(8, returnType, "cloudSdkValue");
            setterMethod.javadoc().addParam(setterParam).add((Object)String.format("New <b>%s</b> entity.", associatedEntity.name()));
            JBlock setterBody = setterMethod.body();
            setterBody.assign(propField, (JExpression)setterParam);
        }
    }

    private void createGetIfPresentMethod(NavigationPropertyModel navigationProperty, JDefinedClass associatedEntity, boolean isOneToMany, JType returnType, JExpression propField) {
        String getterIfPresentName = navigationProperty.getJavaMethodNameGetIfPresent();
        JMethod getterIfPresentMethod = this.entityClass.method(1, (JType)this.codeModel.ref(Option.class).narrow(returnType), getterIfPresentName);
        getterIfPresentMethod.annotate(Nonnull.class);
        getterIfPresentMethod.javadoc().add((Object)String.format("Retrieval of associated <b>%s</b> %s. This corresponds to the OData navigation property <b>%s</b>.\n<p>\nIf the navigation property for an entity <b>%s</b> has not been resolved yet, this method will <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.", associatedEntity.name(), isOneToMany ? "entities (one to many)" : "entity (one to one)", navigationProperty.getEdmName(), this.entityClass.name()));
        getterIfPresentMethod.javadoc().addReturn().add((Object)String.format("If the information for navigation property <b>%s</b> is already loaded, the result will contain the <b>%s</b> %s. If not, an <code>Option</code> with result state <code>empty</code> is returned.", navigationProperty.getEdmName(), associatedEntity.name(), isOneToMany ? "entities" : "entity"));
        getterIfPresentMethod.body()._return((JExpression)this.codeModel.ref(Option.class).staticInvoke("of").arg(propField));
    }

    private void createFetchMethod(NavigationPropertyModel navigationProperty, JDefinedClass associatedEntity, boolean isOneToMany, JType returnType, JAssignmentTarget propField) {
        JMethod fetchMethod = this.entityClass.method(1, returnType, navigationProperty.getJavaMethodNameFetch());
        this.fillFetchJavadoc(navigationProperty, associatedEntity, isOneToMany, (JDocCommentable)fetchMethod);
        this.fillFetchMethodBody(navigationProperty, associatedEntity, isOneToMany, fetchMethod);
        String getterFetchName = navigationProperty.getJavaMethodNameGetOrFetch();
        JMethod getterFetchMethod = this.entityClass.method(1, returnType, getterFetchName);
        this.fillGetOrFetchJavadoc(navigationProperty, associatedEntity, isOneToMany, (JDocCommentable)getterFetchMethod);
        this.fillGetOrFetchMethodBody(propField, fetchMethod, getterFetchMethod);
        if (isOneToMany) {
            fetchMethod.annotate(Nonnull.class);
            getterFetchMethod.annotate(Nonnull.class);
        } else {
            fetchMethod.annotate(Nullable.class);
            getterFetchMethod.annotate(Nullable.class);
        }
    }

    private void fillGetOrFetchMethodBody(JAssignmentTarget propField, JMethod fetchMethod, JMethod getterFetchMethod) {
        JBlock getterBody = getterFetchMethod.body();
        getterBody._if(propField.eq(JExpr._null()))._then().assign(propField, (JExpression)JExpr.invoke((JMethod)fetchMethod));
        getterBody._return((JExpression)propField);
    }

    private void fillGetOrFetchJavadoc(NavigationPropertyModel navigationProperty, JDefinedClass associatedEntity, boolean isOneToMany, JDocCommentable getterFetchMethod) {
        getterFetchMethod.javadoc().add((Object)String.format("Retrieval of associated <b>%s</b> %s. This corresponds to the OData navigation property <b>%s</b>.", associatedEntity.name(), isOneToMany ? "entities (one to many)" : "entity (one to one)", navigationProperty.getEdmName()));
        getterFetchMethod.javadoc().add((Object)JavadocUtils.getLazyWarningMessage(navigationProperty, this.entityClass));
        getterFetchMethod.javadoc().addReturn().add((Object)String.format("List of associated <b>%s</b> %s.", associatedEntity.name(), isOneToMany ? "entities" : "entity"));
        getterFetchMethod.javadoc().addThrows(ODataException.class).append((Object)"If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and therefore has no ERP configuration context assigned. An entity is managed if it has been either retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or UPDATE call. ");
    }

    private void fillFetchJavadoc(NavigationPropertyModel navigationProperty, JDefinedClass associatedEntity, boolean isOneToMany, JDocCommentable fetchMethod) {
        fetchMethod.javadoc().add((Object)String.format("Fetches the <b>%s</b> %s associated with this entity. This corresponds to the OData navigation property <b>%s</b>.\n<p>\nPlease note: This method will not cache or persist the query results.", associatedEntity.name(), isOneToMany ? "entities (one to many)" : "entity (one to one)", navigationProperty.getEdmName()));
        fetchMethod.javadoc().addReturn().add((Object)String.format(isOneToMany ? "List containing one or more associated <b>%s</b> entities. If no entities are associated then an empty list is returned. " : "The single associated <b>%s</b> entity, or {@code null} if an entity is not associated. ", associatedEntity.name()));
        fetchMethod.javadoc().addThrows(ODataException.class).append((Object)"If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and therefore has no ERP configuration context assigned. An entity is managed if it has been either retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or UPDATE call. ");
    }

    private void fillFetchMethodBody(NavigationPropertyModel navigationProperty, JDefinedClass associatedEntity, boolean isOneToMany, JMethod fetchMethod) {
        String fieldName = navigationProperty.getEdmName();
        JExpression fieldType = associatedEntity.dotclass();
        String methodName = isOneToMany ? "fetchFieldAsList" : "fetchFieldAsSingle";
        fetchMethod.body()._return((JExpression)JExpr.invoke((String)methodName).arg(fieldName).arg(fieldType));
    }

    private JFieldVar createLinkConstant(JClass specificEntityLinkClass, NavigationPropertyModel navigationProperty, JDefinedClass associatedEntity) {
        String linkConstantName = navigationProperty.getJavaConstantName();
        JClass linkType = specificEntityLinkClass.narrow((JClass)associatedEntity);
        JInvocation initLink = JExpr._new((JClass)linkType).arg(navigationProperty.getEdmName());
        JFieldVar fluentHelperField = this.entityClass.field(25, (JType)linkType, linkConstantName, (JExpression)initLink);
        fluentHelperField.javadoc().add((Object)String.format("Use with available fluent helpers to apply the <b>%s</b> navigation property to query operations.", navigationProperty.getEdmName()));
        return fluentHelperField;
    }

    private JFieldVar createClassMember(NavigationPropertyModel navigationProperty, JDefinedClass associatedEntity, boolean isOneToMany, JClass returnType, AnnotationStrategy annotationStrategy) {
        String classMemberName = navigationProperty.getJavaMemberName();
        JFieldVar propField = this.entityClass.field(4, (JType)returnType, classMemberName);
        NavigationPropertyModelAnnotationWrapper annotationModel = new NavigationPropertyModelAnnotationWrapper(navigationProperty);
        AnnotationHelper.addAllAnnotationsToJavaItem(annotationStrategy.getAnnotationsForAssociatedEntity(annotationModel), (JAnnotatable)propField);
        propField.javadoc().add((Object)String.format("Navigation property <b>%s</b> for <b>%s</b> to %s <b>%s</b>.", navigationProperty.getEdmName(), this.entityClass.name(), isOneToMany ? "multiple" : "single", associatedEntity.name()));
        return propField;
    }

    private void handleFromMapAdditions(JClass mapType, JBlock fromMapBlock, NavigationPropertyModel navigationProperty, JDefinedClass associatedEntity, boolean isOneToMany, JFieldVar propField) {
        JFieldVar recursiveCallTarget;
        JVar recursiveCallSource;
        JBlock recursiveCallContainer;
        JBlock foundValueBlock = fromMapBlock._if((JExpression)JExpr.direct((String)"cloudSdkValues").invoke("containsKey").arg(navigationProperty.getEdmName()))._then();
        JVar newValue = foundValueBlock.decl(8, (JType)this.codeModel.ref(Object.class), "cloudSdkValue", (JExpression)JExpr.direct((String)"cloudSdkValues").invoke("remove").arg(navigationProperty.getEdmName()));
        if (isOneToMany) {
            JBlock isIterableBlock = foundValueBlock._if(newValue._instanceof((JType)this.codeModel.ref(Iterable.class)))._then();
            JConditional isNullCheck = isIterableBlock._if(propField.eq(JExpr._null()));
            isNullCheck._then().assign((JAssignmentTarget)propField, (JExpression)this.codeModel.ref(Lists.class).staticInvoke("newArrayList"));
            isNullCheck._else().assign((JAssignmentTarget)propField, (JExpression)this.codeModel.ref(Lists.class).staticInvoke("newArrayList").arg((JExpression)propField));
            JVar varI = isIterableBlock.decl((JType)this.codeModel.INT, "i", JExpr.lit((int)0));
            JForEach forEach = isIterableBlock.forEach((JType)this.codeModel.ref(Object.class), "item", (JExpression)JExpr.cast((JType)this.codeModel.ref(Iterable.class).narrow(this.codeModel.wildcard()), (JExpression)newValue));
            recursiveCallContainer = forEach.body();
            recursiveCallSource = forEach.var();
            recursiveCallContainer._if(recursiveCallSource._instanceof((JType)this.codeModel.ref(Map.class)).not())._then()._continue();
            recursiveCallTarget = recursiveCallContainer.decl((JType)associatedEntity, "entity");
            JConditional foundElement = recursiveCallContainer._if(propField.invoke("size").gt((JExpression)varI));
            JBlock foundElementBlock = foundElement._then();
            foundElementBlock.assign((JAssignmentTarget)recursiveCallTarget, (JExpression)propField.invoke("get").arg((JExpression)varI));
            JBlock notFoundBlock = foundElement._else();
            notFoundBlock.assign((JAssignmentTarget)recursiveCallTarget, (JExpression)JExpr._new((JClass)associatedEntity));
            notFoundBlock.invoke((JExpression)propField, "add").arg((JExpression)recursiveCallTarget);
            recursiveCallContainer.assign((JAssignmentTarget)varI, varI.plus(JExpr.lit((int)1)));
        } else {
            recursiveCallContainer = foundValueBlock._if(newValue._instanceof((JType)this.codeModel.ref(Map.class)))._then();
            recursiveCallContainer._if(propField.eq(JExpr._null()))._then().assign((JAssignmentTarget)propField, (JExpression)JExpr._new((JClass)associatedEntity));
            recursiveCallTarget = propField;
            recursiveCallSource = newValue;
        }
        recursiveCallContainer.directStatement("@SuppressWarnings(\"unchecked\")");
        JVar inputMapVar = recursiveCallContainer.decl(8, (JType)mapType, "inputMap", (JExpression)JExpr.cast((JType)mapType, (JExpression)recursiveCallSource));
        recursiveCallContainer.invoke((JExpression)recursiveCallTarget, "fromMap").arg((JExpression)inputMapVar);
    }

    private void changeBuilder(NavigationPropertyModel navigationProperty, JDefinedClass associatedEntity, boolean isOneToMany, JFieldVar classMemberField) {
        JDefinedClass builderClass = this.getOrGenerateBuilder();
        JInvocation init = isOneToMany ? this.codeModel.ref(Lists.class).staticInvoke("newArrayList") : null;
        String classMemberName = classMemberField.name();
        JType returnType = classMemberField.type();
        JFieldVar buildField = builderClass.field(4, returnType, classMemberName, (JExpression)init);
        JMethod origMethod = builderClass.method(4, (JType)builderClass, classMemberName);
        JVar origMethodVal = origMethod.param(8, returnType, "cloudSdkValue");
        if (isOneToMany) {
            origMethod.body().invoke((JExpression)buildField, "addAll").arg((JExpression)origMethodVal);
        } else {
            origMethod.body().assign((JAssignmentTarget)buildField, (JExpression)origMethodVal);
        }
        origMethod.body()._return(JExpr._this());
        String builderFieldName = navigationProperty.getJavaMethodNameSetBuilder();
        if (SourceVersion.isKeyword(builderFieldName)) {
            logger.warn("Skip builder setter method with name \"{}\" for being a reserved keyword.", (Object)builderFieldName);
        } else {
            JInvocation invocation;
            JMethod fixedMethod = builderClass.method(1, (JType)builderClass, builderFieldName);
            if (isOneToMany) {
                JVar fixedMethodParam = fixedMethod.varParam((JType)associatedEntity, "cloudSdkValue");
                invocation = JExpr.invoke((JMethod)origMethod).arg((JExpression)this.codeModel.ref(Lists.class).staticInvoke("newArrayList").arg((JExpression)fixedMethodParam));
                fixedMethod.javadoc().addParam(fixedMethodParam).add((Object)String.format("The %ss to build this %s with.", associatedEntity.name(), this.entityClass.name()));
            } else {
                JVar fixedMethodParam = fixedMethod.param(8, (JType)associatedEntity, "cloudSdkValue");
                invocation = JExpr.invoke((JMethod)origMethod).arg((JExpression)fixedMethodParam);
                fixedMethod.javadoc().addParam(fixedMethodParam).add((Object)String.format("The %s to build this %s with.", associatedEntity.name(), this.entityClass.name()));
            }
            fixedMethod.body()._return((JExpression)invocation);
            fixedMethod.annotate(Nonnull.class);
            fixedMethod.javadoc().add((Object)classMemberField.javadoc());
            fixedMethod.javadoc().addReturn().add((Object)"This Builder to allow for a fluent interface.");
        }
        JFieldVar originalField = (JFieldVar)this.entityClass.fields().get(builderFieldName);
        if (originalField != null) {
            this.provideBuilderMethodFromField(builderClass, originalField);
        }
    }

    private JDefinedClass getOrGenerateBuilder() {
        JDefinedClass builderCLass = null;
        String builderName = this.entityClass.name() + "Builder";
        Iterator it = this.entityClass.classes();
        while (it.hasNext()) {
            JDefinedClass cl = (JDefinedClass)it.next();
            if (!cl.name().equals(builderName)) continue;
            builderCLass = cl;
            break;
        }
        if (builderCLass == null) {
            try {
                builderCLass = this.entityClass._class(25, builderName);
                builderCLass.javadoc().add((Object)String.format("Helper class to allow for fluent creation of %s instances.", this.entityClass.name()));
            }
            catch (JClassAlreadyExistsException e) {
                throw new ODataGeneratorException(String.format("Builder class does already exist for entity \"%s\".", this.entityClass.name()), e);
            }
        }
        return builderCLass;
    }

    private void provideBuilderMethodFromField(JDefinedClass builderClass, JFieldVar originalField) {
        JType origType = originalField.type();
        String origName = originalField.name();
        JMethod originalMethod = builderClass.method(1, (JType)builderClass, origName);
        JFieldVar origBuildField = builderClass.field(4, origType, origName, JExpr._null());
        JVar originalMethodParameter = originalMethod.param(8, origType, "cloudSdkValue");
        originalMethod.javadoc().add((Object)originalField.javadoc());
        originalMethod.body().assign((JAssignmentTarget)origBuildField, (JExpression)originalMethodParameter);
        originalMethod.body()._return(JExpr._this());
        originalMethod.annotate(Nonnull.class);
        originalMethod.javadoc().addReturn().add((Object)"This Builder to allow for a fluent interface.");
        originalMethod.javadoc().addParam(originalMethodParameter.name()).add((Object)String.format("The %s to build this %s with.", origName, this.entityClass.name()));
    }
}

