/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.generator;

import com.google.common.base.Strings;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.util.StringUtils;
import com.sap.cloud.sdk.datamodel.odata.generator.AnnotationHelper;
import com.sap.cloud.sdk.datamodel.odata.generator.ApiFunction;
import com.sap.cloud.sdk.datamodel.odata.generator.CodeModelUtils;
import com.sap.cloud.sdk.datamodel.odata.generator.DeprecationUtils;
import com.sap.cloud.sdk.datamodel.odata.generator.EntityFieldGenerator;
import com.sap.cloud.sdk.datamodel.odata.generator.EntityLinkGenerator;
import com.sap.cloud.sdk.datamodel.odata.generator.EntityMetadata;
import com.sap.cloud.sdk.datamodel.odata.generator.EntityPropertyModel;
import com.sap.cloud.sdk.datamodel.odata.generator.EntityPropertyModelAnnotationWrapper;
import com.sap.cloud.sdk.datamodel.odata.generator.EntitySelectableGenerator;
import com.sap.cloud.sdk.datamodel.odata.generator.FieldFunctionGenerator;
import com.sap.cloud.sdk.datamodel.odata.generator.FluentHelperClassGenerator;
import com.sap.cloud.sdk.datamodel.odata.generator.FunctionImportParameterModel;
import com.sap.cloud.sdk.datamodel.odata.generator.JavadocUtils;
import com.sap.cloud.sdk.datamodel.odata.generator.LowercaseNameFormattingStrategy;
import com.sap.cloud.sdk.datamodel.odata.generator.MessageCollector;
import com.sap.cloud.sdk.datamodel.odata.generator.Multiplicity;
import com.sap.cloud.sdk.datamodel.odata.generator.NamingContext;
import com.sap.cloud.sdk.datamodel.odata.generator.NavigationPropertyMethodsGenerator;
import com.sap.cloud.sdk.datamodel.odata.generator.NavigationPropertyModel;
import com.sap.cloud.sdk.datamodel.odata.generator.ODataGeneratorException;
import com.sap.cloud.sdk.datamodel.odata.generator.PreparedEntityBluePrint;
import com.sap.cloud.sdk.datamodel.odata.generator.Service;
import com.sap.cloud.sdk.datamodel.odata.generator.ServiceClassGenerator;
import com.sap.cloud.sdk.datamodel.odata.generator.TypeKind;
import com.sap.cloud.sdk.datamodel.odata.generator.VdmObjectModel;
import com.sap.cloud.sdk.datamodel.odata.generator.VdmObjectModelAnnotationWrapper;
import com.sap.cloud.sdk.datamodel.odata.generator.annotation.AnnotationStrategy;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmComplex;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmMediaEntity;
import com.sap.cloud.sdk.datamodel.odata.utility.NamingStrategy;
import com.sap.cloud.sdk.datamodel.odata.utility.NamingUtils;
import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocCommentable;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import io.vavr.control.Option;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;

class NamespaceClassGenerator {
    private static final Logger logger = MessageCollector.getLogger(NamespaceClassGenerator.class);
    private final Map<String, JPackage> generatedNamespacePackages = new HashMap<String, JPackage>();
    private final Map<String, PreparedEntityBluePrint> entityBluePrintMap = new HashMap<String, PreparedEntityBluePrint>();
    private final Table<String, ApiFunction, JDefinedClass> generatedFluentHelperClassesPerEntityType = HashBasedTable.create();
    private final JCodeModel codeModel;
    private final JPackage namespaceParentPackage;
    private final NamingStrategy codeNamingStrategy;
    private final AnnotationStrategy annotationStrategy;
    private final boolean generatePojosOnly;

    NamespaceClassGenerator(JCodeModel codeModel, JPackage namespaceParentPackage, NamingStrategy codeNamingStrategy, AnnotationStrategy annotationStrategy, boolean generatePojosOnly) {
        this.codeModel = codeModel;
        this.namespaceParentPackage = namespaceParentPackage;
        this.codeNamingStrategy = codeNamingStrategy;
        this.annotationStrategy = annotationStrategy;
        this.generatePojosOnly = generatePojosOnly;
    }

    private ClassGeneratorResult generateEdmEntityClass(JPackage namespacePackage, VdmObjectModel entityModel, Service service) throws JClassAlreadyExistsException {
        JDefinedClass entityOneToOneLinkClass;
        JDefinedClass entityOneToManyLinkClass;
        JDefinedClass specificEntityFieldClass;
        JDefinedClass specificEntitySelectableInterface;
        JDefinedClass generatedEntityClass = this.generateEntityClassStub((JClassContainer)namespacePackage, entityModel.getJavaClassName(), entityModel.isMediaStreamExposed());
        if (this.generatePojosOnly) {
            specificEntitySelectableInterface = null;
            specificEntityFieldClass = null;
            entityOneToManyLinkClass = null;
            entityOneToOneLinkClass = null;
        } else {
            EntitySelectableGenerator entitySelectableGenerator = new EntitySelectableGenerator(this.codeModel);
            EntityFieldGenerator entityFieldGenerator = new EntityFieldGenerator(this.codeModel);
            EntityLinkGenerator entityLinkGenerator = new EntityLinkGenerator(this.codeModel);
            specificEntitySelectableInterface = entitySelectableGenerator.generateSpecificEntitySelectableInterface(namespacePackage, generatedEntityClass);
            entityOneToManyLinkClass = entityLinkGenerator.generateSpecificEntityLinkClass(namespacePackage, generatedEntityClass, specificEntitySelectableInterface);
            entityOneToOneLinkClass = entityLinkGenerator.generateSpecificEntityLinkOneToOneClass(namespacePackage, generatedEntityClass, entityOneToManyLinkClass, service);
            specificEntityFieldClass = entityFieldGenerator.generateSpecificEntityFieldClass(namespacePackage, generatedEntityClass, specificEntitySelectableInterface);
            entitySelectableGenerator.addClassLevelJavadoc((JDocCommentable)specificEntitySelectableInterface, generatedEntityClass, specificEntityFieldClass, entityOneToManyLinkClass);
        }
        generatedEntityClass = this.completeEntityClassGeneration(generatedEntityClass, specificEntityFieldClass, entityModel, specificEntitySelectableInterface);
        return new ClassGeneratorResult(generatedEntityClass, specificEntitySelectableInterface, entityOneToManyLinkClass, entityOneToOneLinkClass);
    }

    private JDefinedClass generateEntityClassStub(JClassContainer namespacePackage, String javaClassName, boolean isMediaStreamExposed) throws JClassAlreadyExistsException {
        JDefinedClass entityClass = namespacePackage._class(1, javaClassName);
        JClass jClass = isMediaStreamExposed ? this.codeModel.ref(VdmMediaEntity.class) : this.codeModel.ref(VdmEntity.class);
        entityClass._extends(jClass.narrow((JClass)entityClass));
        return entityClass;
    }

    private JDefinedClass completeEntityClassGeneration(JDefinedClass entityClass, JDefinedClass specificEntityFieldClass, VdmObjectModel entityModel, JDefinedClass selectableInterface) {
        JMethod getTypeMethod = entityClass.method(1, (JType)this.codeModel.ref(Class.class).narrow((JClass)entityClass), "getType");
        getTypeMethod.annotate(this.codeModel.ref(Nonnull.class));
        getTypeMethod.annotate(this.codeModel.ref(Override.class));
        getTypeMethod.body()._return(entityClass.dotclass());
        if (!Strings.isNullOrEmpty((String)entityModel.getDescription())) {
            entityClass.javadoc().add((Object)entityModel.getDescription());
        }
        entityClass.javadoc().add((Object)String.format("<p>Original entity name from the Odata EDM: <b>%s</b></p>", entityModel.getEdmName()));
        if (!this.generatePojosOnly) {
            this.createMemberAllFields(entityClass, selectableInterface);
        }
        VdmObjectModelAnnotationWrapper entityAnnotationModel = new VdmObjectModelAnnotationWrapper(entityModel);
        AnnotationHelper.addAllAnnotationsToJavaItem(this.annotationStrategy.getAnnotationsForEntity(entityAnnotationModel), (JAnnotatable)entityClass);
        for (Map.Entry<String, EntityPropertyModel> entry : entityModel.getProperties().entrySet()) {
            EntityPropertyModel mapping = entry.getValue();
            this.addPropertyAsField(entityClass, specificEntityFieldClass, selectableInterface, mapping);
        }
        JMethod entityCollectionMethod = entityClass.method(2, String.class, "getEntityCollection");
        entityCollectionMethod.annotate(Override.class);
        entityCollectionMethod.body()._return(JExpr.lit((String)entityModel.getEdmEntityCollectionName()));
        if (!this.generatePojosOnly) {
            this.createMethodGetKey(entityModel.getProperties(), entityClass);
            this.createMethodToMap(entityModel.getProperties(), entityClass);
            this.processClassFields(entityModel.getProperties(), entityClass);
            FieldFunctionGenerator fieldFunctionGenerator = new FieldFunctionGenerator(this.codeModel);
            fieldFunctionGenerator.addFieldFunction(entityClass, specificEntityFieldClass);
            fieldFunctionGenerator.addFieldFunctionWithTypeConverter(entityClass, specificEntityFieldClass);
            this.overrideGetDestinationForFetchMethod(entityClass);
            this.overrideSetServicePathForFetchMethod(entityClass);
            this.overrideAttachToServiceMethod(entityClass);
        }
        return entityClass;
    }

    private void addPropertyAsField(JDefinedClass entityClass, JDefinedClass specificEntityFieldClass, JDefinedClass selectableInterface, EntityPropertyModel mapping) {
        JFieldVar entityClassField = entityClass.field(4, mapping.getJavaFieldType(), mapping.getJavaFieldName());
        if (mapping.isKeyField()) {
            entityClassField.javadoc().add((Object)"(Key Field)");
        }
        entityClassField.javadoc().add((Object)mapping.getConstraintsDescription());
        entityClassField.javadoc().add((Object)String.format("<p>Original property name from the Odata EDM: <b>%s</b></p>", mapping.getEdmName()));
        if (!Strings.isNullOrEmpty((String)mapping.getDetailedDescription())) {
            entityClassField.javadoc().add((Object)String.format("<p>%s</p>", mapping.getDetailedDescription()));
        }
        if (!Strings.isNullOrEmpty((String)mapping.getBasicDescription())) {
            entityClassField.javadoc().addReturn().add((Object)mapping.getBasicDescription());
        } else {
            entityClassField.javadoc().addReturn().add((Object)String.format("The %s contained in this entity.", entityClassField.name()));
        }
        EntityPropertyModelAnnotationWrapper propertyAnnotationModel = new EntityPropertyModelAnnotationWrapper(mapping);
        AnnotationHelper.addAllAnnotationsToJavaItem(this.annotationStrategy.getAnnotationsForEntityProperty(propertyAnnotationModel), (JAnnotatable)entityClassField);
        this.generateSetterMethod(entityClass, entityClassField, mapping.getEdmName(), mapping.getBasicDescription());
        if (!this.generatePojosOnly && mapping.isSimpleType()) {
            JFieldVar fluentHelperField = entityClass.field(25, (JType)specificEntityFieldClass.narrow(mapping.getJavaFieldType()), mapping.getJavaConstantName(), (JExpression)JExpr._new((JClass)specificEntityFieldClass.narrow(mapping.getJavaFieldType())).arg(mapping.getEdmName()));
            fluentHelperField.javadoc().add((Object)String.format("Use with available fluent helpers to apply the <b>%s</b> field to query operations.", mapping.getEdmName()));
            JavadocUtils.addFieldReference((JDocCommentable)selectableInterface, entityClass, fluentHelperField);
        }
    }

    private void generateSetterMethod(@Nonnull JDefinedClass entityClass, @Nonnull JFieldVar fieldVar, @Nonnull String fieldName, @Nullable String parameterDescription) {
        JMethod setterMethod = entityClass.method(1, (JType)this.codeModel.VOID, "set" + StringUtils.capitalize((String)fieldVar.name()));
        JVar inputParam = setterMethod.param(8, fieldVar.type(), fieldVar.name());
        inputParam.annotate(Nullable.class);
        setterMethod.body().invoke("rememberChangedField").arg(fieldName).arg((JExpression)JExpr._this().ref((JVar)fieldVar));
        setterMethod.body().assign((JAssignmentTarget)JExpr._this().ref(fieldVar.name()), (JExpression)inputParam);
        String paramJavadoc = Strings.isNullOrEmpty((String)parameterDescription) ? String.format("The %s to set.", fieldVar.name()) : parameterDescription;
        setterMethod.javadoc().add((Object)fieldVar.javadoc());
        setterMethod.javadoc().addParam(inputParam).append((Object)paramJavadoc);
    }

    void addNavigationPropertyCode(PreparedEntityBluePrint entityBluePrint, Map<String, JDefinedClass> generatedEntities) {
        NavigationPropertyMethodsGenerator navPropGenerator = new NavigationPropertyMethodsGenerator(this.codeModel, entityBluePrint.getEntityClass());
        Map<String, JFieldVar> generatedNavigationPropertyFields = navPropGenerator.createNavigationPropertyFields(entityBluePrint.getNavigationProperties(), generatedEntities, this.annotationStrategy);
        if (!this.generatePojosOnly) {
            navPropGenerator.addNavigationPropertyMethods(generatedEntities, entityBluePrint.getNavigationProperties(), generatedNavigationPropertyFields, (JDocCommentable)entityBluePrint.getSelectableInterface(), (JClass)entityBluePrint.getEntityOneToManyLinkClass(), (JClass)entityBluePrint.getEntityOneToOneLinkClass());
        }
    }

    private JDefinedClass generateComplexTypeClass(JPackage namespacePackage, VdmObjectModel complexTypeModel) throws JClassAlreadyExistsException {
        JDefinedClass complexTypeClass = namespacePackage._class(1, complexTypeModel.getJavaClassName());
        complexTypeClass._extends(this.codeModel.ref(VdmComplex.class).narrow((JClass)complexTypeClass));
        JMethod getTypeMethod = complexTypeClass.method(1, (JType)this.codeModel.ref(Class.class).narrow((JClass)complexTypeClass), "getType");
        getTypeMethod.annotate(this.codeModel.ref(Nonnull.class));
        getTypeMethod.annotate(this.codeModel.ref(Override.class));
        getTypeMethod.body()._return(complexTypeClass.dotclass());
        if (!Strings.isNullOrEmpty((String)complexTypeModel.getDescription())) {
            complexTypeClass.javadoc().add((Object)complexTypeModel.getDescription());
        }
        complexTypeClass.javadoc().add((Object)String.format("<p>Original complex type name from the Odata EDM: <b>%s</b></p>", complexTypeModel.getEdmName()));
        VdmObjectModelAnnotationWrapper complexTypeAnnotationModel = new VdmObjectModelAnnotationWrapper(complexTypeModel);
        AnnotationHelper.addAllAnnotationsToJavaItem(this.annotationStrategy.getAnnotationsForComplexType(complexTypeAnnotationModel), (JAnnotatable)complexTypeClass);
        this.createMethodToMap(complexTypeModel.getProperties(), complexTypeClass);
        this.processClassFields(complexTypeModel.getProperties(), complexTypeClass);
        this.createMethodGetKey(complexTypeModel.getProperties(), complexTypeClass);
        for (Map.Entry<String, EntityPropertyModel> entry : complexTypeModel.getProperties().entrySet()) {
            EntityPropertyModel mapping = entry.getValue();
            this.processComplexTypeClassField(complexTypeClass, mapping);
        }
        return complexTypeClass;
    }

    private void processComplexTypeClassField(JDefinedClass complexTypeClass, EntityPropertyModel mapping) {
        JFieldVar complexTypeClassField = complexTypeClass.field(4, mapping.getJavaFieldType(), mapping.getJavaFieldName());
        if (mapping.isKeyField()) {
            complexTypeClassField.javadoc().add((Object)"(Key Field) ");
        }
        complexTypeClassField.javadoc().add((Object)mapping.getConstraintsDescription());
        complexTypeClassField.javadoc().add((Object)String.format("<p>Original property from the Odata EDM: <b>%s</b></p>", mapping.getEdmName()));
        if (!Strings.isNullOrEmpty((String)mapping.getDetailedDescription())) {
            complexTypeClassField.javadoc().add((Object)String.format("<p>%s</p>", mapping.getDetailedDescription()));
        }
        if (!Strings.isNullOrEmpty((String)mapping.getBasicDescription())) {
            complexTypeClassField.javadoc().addReturn().add((Object)mapping.getBasicDescription());
        }
        complexTypeClassField.javadoc().addParam((JVar)complexTypeClassField).add((Object)"");
        EntityPropertyModelAnnotationWrapper complexTypePropertyAnnotationModel = new EntityPropertyModelAnnotationWrapper(mapping);
        AnnotationHelper.addAllAnnotationsToJavaItem(this.annotationStrategy.getAnnotationsForComplexTypeProperty(complexTypePropertyAnnotationModel), (JAnnotatable)complexTypeClassField);
        this.generateSetterMethod(complexTypeClass, complexTypeClassField, mapping.getEdmName(), mapping.getBasicDescription());
    }

    private void createMemberAllFields(JDefinedClass entityClass, JDefinedClass selectableInterface) {
        String linkConstantName = "ALL_FIELDS";
        entityClass.field(25, (JType)selectableInterface, "ALL_FIELDS", (JExpression)CodeModelUtils.directExpression("() -> \"*\"")).javadoc().add((Object)("Selector for all available fields of " + entityClass.name() + "."));
    }

    private void createMethodToMap(Map<String, EntityPropertyModel> entityClassFields, JDefinedClass entityClass) {
        JClass fieldMapClass = this.codeModel.ref(Map.class).narrow(new Class[]{String.class, Object.class});
        JMethod toMapMethod = entityClass.method(2, (JType)fieldMapClass, "toMapOfFields");
        toMapMethod.annotate(Nonnull.class);
        toMapMethod.annotate(Override.class);
        JBlock body = toMapMethod.body();
        JVar v = body.decl(8, (JType)fieldMapClass, "cloudSdkValues", (JExpression)JExpr._super().invoke("toMapOfFields"));
        for (Map.Entry<String, EntityPropertyModel> entry : entityClassFields.entrySet()) {
            String javaFieldName = entry.getValue().getJavaFieldName();
            String javaMethodName = "get" + StringUtils.capitalize((String)javaFieldName);
            body.invoke((JExpression)v, "put").arg(entry.getKey()).arg((JExpression)JExpr.invoke((String)javaMethodName));
        }
        body._return((JExpression)v);
    }

    private void processClassFields(Map<String, EntityPropertyModel> entityClassFields, JDefinedClass entityClass) {
        JClass fieldMapClass = this.codeModel.ref(Map.class).narrow(new Class[]{String.class, Object.class});
        JMethod fromMapMethod = entityClass.method(2, (JType)this.codeModel.VOID, "fromMap");
        fromMapMethod.annotate(Override.class);
        JVar inputValues = fromMapMethod.param(8, (JType)fieldMapClass, "inputValues");
        JBlock body = fromMapMethod.body();
        JVar values = body.decl(8, (JType)fieldMapClass, "cloudSdkValues", (JExpression)this.codeModel.ref(Maps.class).staticInvoke("newLinkedHashMap").arg((JExpression)inputValues));
        body.block().directStatement("// simple properties");
        JBlock simplePropertiesBlock = new JBlock(true, true);
        body.add((JStatement)simplePropertiesBlock);
        body.block().directStatement("// structured properties");
        JBlock complexPropertiesBlock = new JBlock(true, true);
        body.add((JStatement)complexPropertiesBlock);
        for (Map.Entry<String, EntityPropertyModel> entry : entityClassFields.entrySet()) {
            this.processClassField(fieldMapClass, values, simplePropertiesBlock, complexPropertiesBlock, entry);
        }
        body.block().directStatement("// navigation properties");
        JBlock navigationPropertiesBlock = new JBlock(true, true);
        body.add((JStatement)navigationPropertiesBlock);
        body.block().invoke(JExpr._super(), "fromMap").arg((JExpression)values);
    }

    private void processClassField(JClass fieldMapClass, JVar values, JBlock simplePropertiesBlock, JBlock complexPropertiesBlock, Map.Entry<String, EntityPropertyModel> entry) {
        String javaFieldName = entry.getValue().getJavaFieldName();
        String javaMethodGet = "get" + StringUtils.capitalize((String)javaFieldName);
        String javaMethodSet = "set" + StringUtils.capitalize((String)javaFieldName);
        if (entry.getValue().isSimpleType()) {
            JBlock ifFoundBody = simplePropertiesBlock._if((JExpression)values.invoke("containsKey").arg(entry.getKey()))._then();
            JVar value = ifFoundBody.decl(8, (JType)this.codeModel.ref(Object.class), "value", (JExpression)values.invoke("remove").arg(entry.getKey()));
            JBlock ifChangeBody = ifFoundBody._if(value.eq(JExpr._null()).cor(value.invoke("equals").arg((JExpression)JExpr.invoke((String)javaMethodGet)).not()))._then();
            ifChangeBody.invoke(javaMethodSet).arg((JExpression)JExpr.cast((JType)entry.getValue().getJavaFieldType(), (JExpression)value));
        } else {
            JBlock ifFoundBody = complexPropertiesBlock._if((JExpression)values.invoke("containsKey").arg(entry.getKey()))._then();
            JVar value = ifFoundBody.decl(8, (JType)this.codeModel.ref(Object.class), "value", (JExpression)values.invoke("remove").arg(entry.getKey()));
            JBlock ifIsMap = ifFoundBody._if(value._instanceof((JType)this.codeModel.ref(Map.class)))._then();
            ifIsMap._if(JExpr.invoke((String)javaMethodGet).eq(JExpr._null()))._then().invoke(javaMethodSet).arg((JExpression)JExpr._new((JType)entry.getValue().getJavaFieldType()));
            ifIsMap.directStatement("@SuppressWarnings(\"unchecked\")");
            JVar varInputMap = ifIsMap.decl(8, (JType)fieldMapClass, "inputMap", (JExpression)JExpr.cast((JType)fieldMapClass, (JExpression)value));
            ifIsMap.invoke((JExpression)JExpr.invoke((String)javaMethodGet), "fromMap").arg((JExpression)varInputMap);
            ifFoundBody._if(value.eq(JExpr._null()).cand(JExpr.invoke((String)javaMethodGet).ne(JExpr._null())))._then().invoke(javaMethodSet).arg(JExpr._null());
        }
    }

    private void createMethodGetKey(Map<String, EntityPropertyModel> entityClassFields, JDefinedClass entityClass) {
        JClass fieldMapClass = this.codeModel.ref(Map.class).narrow(new Class[]{String.class, Object.class});
        JMethod getKeyMethod = entityClass.method(2, (JType)fieldMapClass, "getKey");
        getKeyMethod.annotate(Nonnull.class);
        getKeyMethod.annotate(Override.class);
        JBlock body = getKeyMethod.body();
        JVar v = body.decl(8, (JType)fieldMapClass, "result", (JExpression)this.codeModel.ref(Maps.class).staticInvoke("newLinkedHashMap"));
        for (Map.Entry<String, EntityPropertyModel> entry : entityClassFields.entrySet()) {
            if (!entry.getValue().isKeyField()) continue;
            String javaFieldName = entry.getValue().getJavaFieldName();
            String javaMethodName = "get" + StringUtils.capitalize((String)javaFieldName);
            body.invoke((JExpression)v, "put").arg(entry.getKey()).arg((JExpression)JExpr.invoke((String)javaMethodName));
        }
        body._return((JExpression)v);
    }

    private JPackage getOrGenerateNamespacePackage(String packageName) {
        JPackage namespacePackage = this.generatedNamespacePackages.get(packageName);
        if (namespacePackage == null) {
            namespacePackage = this.namespaceParentPackage.subPackage(packageName);
            this.generatedNamespacePackages.put(packageName, namespacePackage);
        }
        return namespacePackage;
    }

    void processFunctionImport(ServiceClassGenerator serviceClassGenerator, FluentHelperClassGenerator fluentGenerator, Service service, Map<String, JDefinedClass> generatedEntities, Map<String, JDefinedClass> generatedComplexTypes, Service.FunctionImport functionImport, NamingContext functionImportClassNamingContext, NamingContext functionImportFetchMethodNamingContext) throws JClassAlreadyExistsException {
        JClass javaReturnType;
        ServiceClassGenerator.ServiceClassAmplifier serviceClassAmplifier = serviceClassGenerator.getOrGenerateServiceClassesAndGetAmplifier(service);
        Service.Type edmReturnType = functionImport.getReturnType();
        if (edmReturnType == null) {
            javaReturnType = this.codeModel.ref(Void.class);
        } else {
            switch (edmReturnType.getKind()) {
                case SIMPLE: {
                    Service.SimpleType edmSimpleReturnType = (Service.SimpleType)edmReturnType;
                    javaReturnType = this.codeModel.ref(edmSimpleReturnType.getDefaultType());
                    break;
                }
                case COMPLEX: {
                    JPackage namespacePackage = this.getOrGenerateNamespacePackage(service.getJavaPackageName());
                    javaReturnType = (JType)generatedComplexTypes.get(edmReturnType.getName());
                    if (javaReturnType != null) break;
                    Service.ComplexType edmComplexReturnType = (Service.ComplexType)((Object)edmReturnType);
                    JDefinedClass generatedComplexType = this.processComplexType(namespacePackage, generatedComplexTypes, edmComplexReturnType);
                    generatedComplexTypes.put(edmReturnType.getName(), generatedComplexType);
                    javaReturnType = generatedComplexType;
                    break;
                }
                case ENTITY: {
                    javaReturnType = (JType)generatedEntities.get(edmReturnType.getName());
                    if (javaReturnType != null) break;
                    logger.warn(String.format("Unable to generate code for function import '%s': Return type is an entity (%s), but it is either not found or its entity set has been filtered out.", functionImport.getName(), edmReturnType.getName()));
                    return;
                }
                default: {
                    logger.error("Unsupported EDM return type found for function import " + functionImport.getName());
                    return;
                }
            }
        }
        boolean isCollectionReturnType = functionImport.getReturnTypeMultiplicity() == Multiplicity.MANY;
        List<FunctionImportParameterModel> parameters = this.processFunctionImportParameters(functionImport);
        if (parameters == null) {
            return;
        }
        String functionImportName = functionImport.getName();
        String functionImportLabel = functionImport.getLabel();
        String functionImportDescription = JavadocUtils.getCompleteDescription(functionImport);
        JDefinedClass functionImportFluentHelperClass = fluentGenerator.generateFunctionImportFluentHelperClass(this.getOrGenerateNamespacePackage(service.getJavaPackageName()), functionImportName, functionImportLabel, (JType)javaReturnType, isCollectionReturnType, functionImport.getHttpMethod(), parameters, functionImportClassNamingContext);
        serviceClassAmplifier.addFunctionImportMethod(functionImportName, functionImportLabel, functionImportDescription, parameters, functionImportFluentHelperClass, functionImportFetchMethodNamingContext);
    }

    private List<FunctionImportParameterModel> processFunctionImportParameters(Service.FunctionImport functionImport) {
        LinkedList<FunctionImportParameterModel> functionImportParameters = new LinkedList<FunctionImportParameterModel>();
        NamingContext functionImportParameterNamingContext = new NamingContext();
        for (String parameterName : functionImport.getParameterNames()) {
            Service.Parameter parameter = functionImport.getParameter(parameterName);
            Service.Type edmParameterType = parameter.getType();
            if (edmParameterType.getKind() == TypeKind.SIMPLE) {
                Service.SimpleType edmParameterSimpleType = (Service.SimpleType)edmParameterType;
                String parameterLabel = parameter.getLabel();
                String javaName = functionImportParameterNamingContext.ensureUniqueName(this.codeNamingStrategy.generateJavaMethodParameterName(parameterName, parameterLabel));
                JClass javaType = this.codeModel.ref(edmParameterSimpleType.getDefaultType());
                functionImportParameters.add(new FunctionImportParameterModel(parameterName, edmParameterType.getName(), javaName, (JType)javaType, JavadocUtils.getDescriptionAndConstraints(parameterName, parameter), (Boolean)Option.of((Object)parameter.getFacets()).map(Service.Facets::isNullable).getOrNull()));
                continue;
            }
            logger.warn("Skipping generation of function import {}: The function has a non-simple parameter {}. This feature is not yet supported by the OData V2 generator.", (Object)functionImport.getName(), (Object)parameterName);
            return null;
        }
        return functionImportParameters;
    }

    private JDefinedClass processComplexType(JPackage namespacePackage, Map<String, JDefinedClass> generatedComplexTypes, Service.ComplexType complexTypeMetadata) throws JClassAlreadyExistsException {
        logger.info("  Found complex type " + complexTypeMetadata.getName());
        String complexTypeDescription = JavadocUtils.getCompleteDescription(complexTypeMetadata);
        NamingContext complexTypePropertyNamingContext = new NamingContext();
        complexTypePropertyNamingContext.loadGettersAndSettersOfClassAsAlreadyPresentFields(VdmComplex.class);
        Map<String, EntityPropertyModel> entityClassFields = this.processProperties(namespacePackage, generatedComplexTypes, complexTypeMetadata, complexTypePropertyNamingContext, new NamingContext());
        VdmObjectModel complexTypeModel = new VdmObjectModel(complexTypeMetadata.getName(), complexTypeMetadata.getLabel(), null, null, complexTypeMetadata.getName(), entityClassFields, complexTypeDescription, false);
        return this.generateComplexTypeClass(namespacePackage, complexTypeModel);
    }

    private Map<String, EntityPropertyModel> processProperties(JPackage namespacePackage, Map<String, JDefinedClass> generatedComplexTypes, Service.StructuralType typeMetadata, NamingContext entityNamingContext, NamingContext entityClassConstantNamingContext) throws JClassAlreadyExistsException {
        LinkedHashMap<String, EntityPropertyModel> entityClassFields = new LinkedHashMap<String, EntityPropertyModel>();
        for (String propertyName : typeMetadata.getPropertyNames()) {
            EntityPropertyModel entityPropertyModel = this.processProperty(namespacePackage, generatedComplexTypes, typeMetadata, propertyName, entityNamingContext, entityClassConstantNamingContext);
            entityClassFields.put(propertyName, entityPropertyModel);
        }
        return entityClassFields;
    }

    private EntityPropertyModel processProperty(JPackage namespacePackage, Map<String, JDefinedClass> generatedComplexTypes, Service.StructuralType typeMetadata, String propertyName, NamingContext entityNamingContext, NamingContext entityClassConstantNamingContext) throws JClassAlreadyExistsException {
        Service.Typed propertyMetadata = typeMetadata.getProperty(propertyName);
        Service.Type propertyType = propertyMetadata.getType();
        TypeKind propertyKind = propertyType.getKind();
        String propertyBasicDescription = null;
        String propertyDetailedDescription = null;
        String propertyConstraintsDescription = null;
        String propertyLabel = null;
        if (propertyMetadata instanceof Service.Property) {
            propertyBasicDescription = JavadocUtils.getBasicDescription((Service.Annotatable)((Object)propertyMetadata));
            propertyDetailedDescription = JavadocUtils.getDetailedDescription((Service.Annotatable)((Object)propertyMetadata));
            propertyConstraintsDescription = JavadocUtils.getConstraints((Service.Element)propertyMetadata);
            propertyLabel = ((Service.Annotatable)((Object)propertyMetadata)).getLabel();
        }
        String classFieldName = entityNamingContext.ensureUniqueName(this.codeNamingStrategy.generateJavaFieldName(propertyName, propertyLabel));
        String classConstantName = entityClassConstantNamingContext.ensureUniqueName(this.codeNamingStrategy.generateJavaConstantName(classFieldName, null));
        switch (propertyKind) {
            case SIMPLE: {
                Service.SimpleType simpleType = (Service.SimpleType)propertyType;
                Class<?> classFieldType = simpleType.getDefaultType();
                return new EntityPropertyModel(propertyName, propertyLabel, simpleType.getName(), classFieldName, (JType)this.codeModel.ref(classFieldType), classConstantName, true, false, propertyBasicDescription, propertyDetailedDescription, propertyConstraintsDescription);
            }
            case COMPLEX: {
                Service.ComplexType complexType = (Service.ComplexType)((Object)propertyType);
                String complexTypeName = complexType.getName();
                JDefinedClass generatedComplexType = generatedComplexTypes.get(complexTypeName);
                if (generatedComplexType == null) {
                    generatedComplexType = this.processComplexType(namespacePackage, generatedComplexTypes, complexType);
                    generatedComplexTypes.put(complexTypeName, generatedComplexType);
                }
                return new EntityPropertyModel(propertyName, propertyLabel, complexType.getName(), classFieldName, (JType)generatedComplexType, classConstantName, false, false, propertyBasicDescription, propertyDetailedDescription, propertyConstraintsDescription);
            }
        }
        logger.error(String.format("    Unsupported type detected:\n      property name: %s, type: %s", propertyName, propertyType.getKind().toString()));
        return null;
    }

    Option<PreparedEntityBluePrint> processEntitySet(ServiceClassGenerator serviceClassGenerator, FluentHelperClassGenerator fluentGenerator, Service service, String odataEndpointPath, Map<String, JDefinedClass> generatedEntities, Map<String, JDefinedClass> generatedComplexTypes, Service.EntitySet entitySet, NamingContext entityClassNamingContext, boolean serviceMethodsPerEntitySet) throws JClassAlreadyExistsException {
        Option maybeGeneratedBlueprint;
        JDefinedClass entityClass;
        Service.EntityType entityType = entitySet.getEntityType();
        String entityTypeName = entityType.getName();
        logger.info("  Found entity type " + entityTypeName + " from set " + entitySet.getName());
        JPackage namespacePackage = this.getOrGenerateNamespacePackage(service.getJavaPackageName());
        if (!generatedEntities.containsKey(entityTypeName)) {
            this.generatedFluentHelperClassesPerEntityType.clear();
            String entityTypeLabel = entityType.getLabel();
            String entityDescription = JavadocUtils.getCompleteDescription(entityType);
            String javaClassName = entityClassNamingContext.ensureUniqueName(this.codeNamingStrategy.generateJavaClassName(entityTypeName, entityTypeLabel));
            NamingContext entityPropertyNamingContext = new NamingContext(new LowercaseNameFormattingStrategy());
            entityPropertyNamingContext.loadGettersAndSettersOfClassAsAlreadyPresentFields(VdmEntity.class);
            entityPropertyNamingContext.loadKnownGeneratedFields();
            NamingContext entityClassConstantNamingContext = new NamingContext();
            Map<String, EntityPropertyModel> entityClassFields = this.processProperties(namespacePackage, generatedComplexTypes, entityType, entityPropertyNamingContext, entityClassConstantNamingContext);
            VdmObjectModel entityModel = new VdmObjectModel(entityTypeName, entityTypeLabel, odataEndpointPath, entitySet.getName(), javaClassName, entityClassFields, entityDescription, entityType.hasMediaStream());
            List<EntityPropertyModel> keyProperties = this.processKeyProperties(entityType, entityClassFields);
            List<NavigationPropertyModel> navigationProperties = this.processNavigationProperties(entityType, entityPropertyNamingContext, entityClassConstantNamingContext);
            ClassGeneratorResult result = this.generateEdmEntityClass(namespacePackage, entityModel, service);
            entityClass = result.getGeneratedEntityClass();
            generatedEntities.put(entityTypeName, entityClass);
            JDefinedClass specificEntitySelectableInterface = result.getSpecificEntitySelectableInterface();
            JDefinedClass entityOneToManyLink = result.getEntityOneToManyLink();
            JDefinedClass entityOneToOneLink = result.getEntityOneToOneLink();
            PreparedEntityBluePrint entityBluePrint = new PreparedEntityBluePrint(entityClass, specificEntitySelectableInterface, entityOneToManyLink, entityOneToOneLink, navigationProperties, keyProperties);
            this.entityBluePrintMap.put(entityTypeName, entityBluePrint);
            maybeGeneratedBlueprint = Option.of((Object)entityBluePrint);
        } else {
            logger.info("Model class for entity type " + entityTypeName + " has already been generated. Proceeding with generating the service methods.");
            entityClass = generatedEntities.get(entityTypeName);
            maybeGeneratedBlueprint = Option.none();
        }
        if (this.generatePojosOnly) {
            return maybeGeneratedBlueprint;
        }
        ServiceClassGenerator.ServiceClassAmplifier serviceClassAmplifier = serviceClassGenerator.getOrGenerateServiceClassesAndGetAmplifier(service);
        if (maybeGeneratedBlueprint.isDefined()) {
            this.addDefaultServicePathMethod(entityClass, serviceClassAmplifier.getServiceInterfaceClass(), service);
        }
        if (maybeGeneratedBlueprint.isEmpty() && !serviceMethodsPerEntitySet) {
            return maybeGeneratedBlueprint;
        }
        Collection<ApiFunction> allowedFunctions = service.getAllowedFunctionsByEntity(entitySet.getName());
        PreparedEntityBluePrint entityBluePrint = (PreparedEntityBluePrint)maybeGeneratedBlueprint.getOrElse(() -> this.entityBluePrintMap.get(entityType.getName()));
        if (allowedFunctions != null && !allowedFunctions.isEmpty()) {
            List<EntityPropertyModel> entityKeyProperties = entityBluePrint.getKeyProperties();
            this.addAllowedFunctions(serviceClassAmplifier, fluentGenerator, entityClassNamingContext, new EntityMetadata(namespacePackage, entityClass, entityTypeName, entitySet.getName()), allowedFunctions, entityKeyProperties, entityBluePrint.getSelectableInterface());
        }
        return maybeGeneratedBlueprint;
    }

    private void addDefaultServicePathMethod(JDefinedClass generatedEntityClass, JDefinedClass serviceInterfaceClass, Service service) {
        JMethod defaultServicePathMethod = generatedEntityClass.method(2, String.class, "getDefaultServicePath");
        defaultServicePathMethod.annotate(Override.class);
        DeprecationUtils.addGetDefaultServicePathBody(defaultServicePathMethod, serviceInterfaceClass, service);
    }

    private void addAllowedFunctions(ServiceClassGenerator.ServiceClassAmplifier serviceClassAmplifier, FluentHelperClassGenerator fluentGenerator, NamingContext entityClassNamingContext, EntityMetadata entityMetadata, Collection<ApiFunction> allowedFunctions, Iterable<EntityPropertyModel> keyProperties, JDefinedClass specificEntitySelectableInterface) throws JClassAlreadyExistsException {
        Collection<Object> functionsToAdd = allowedFunctions.isEmpty() ? Collections.emptyList() : EnumSet.copyOf(allowedFunctions);
        for (ApiFunction apiFunction : functionsToAdd) {
            this.addFunction(serviceClassAmplifier, fluentGenerator, entityClassNamingContext, entityMetadata, apiFunction, keyProperties, specificEntitySelectableInterface);
        }
    }

    private void addFunction(ServiceClassGenerator.ServiceClassAmplifier serviceClassAmplifier, FluentHelperClassGenerator fluentGenerator, NamingContext entityClassNamingContext, EntityMetadata entityMetadata, ApiFunction function, Iterable<EntityPropertyModel> keyProperties, JDefinedClass specificEntitySelectableInterface) throws JClassAlreadyExistsException {
        String entityClassName = entityMetadata.getGeneratedEntityClass().name();
        switch (function) {
            case READ: {
                JDefinedClass generatedFluentHelperClass = (JDefinedClass)this.generatedFluentHelperClassesPerEntityType.get((Object)entityClassName, (Object)ApiFunction.READ);
                if (generatedFluentHelperClass == null) {
                    generatedFluentHelperClass = fluentGenerator.generateEntityReadFluentHelperClass(entityClassNamingContext, (JClassContainer)entityMetadata.getNamespacePackage(), entityMetadata.getGeneratedEntityClass(), specificEntitySelectableInterface);
                    this.generatedFluentHelperClassesPerEntityType.put((Object)entityClassName, (Object)ApiFunction.READ, (Object)generatedFluentHelperClass);
                }
                serviceClassAmplifier.addGetAllMethod(entityMetadata, generatedFluentHelperClass);
                break;
            }
            case READ_BY_KEY: {
                JDefinedClass generatedFluentHelperClass = (JDefinedClass)this.generatedFluentHelperClassesPerEntityType.get((Object)entityClassName, (Object)ApiFunction.READ_BY_KEY);
                String getByKeyMethodName = serviceClassAmplifier.getByKeyMethodName(entityMetadata);
                keyProperties = serviceClassAmplifier.getRefinedKeyProperties(getByKeyMethodName, keyProperties);
                if (generatedFluentHelperClass == null) {
                    generatedFluentHelperClass = fluentGenerator.generateEntityByKeyFluentHelperClass(entityClassNamingContext, (JClassContainer)entityMetadata.getNamespacePackage(), entityMetadata.getGeneratedEntityClass(), keyProperties, specificEntitySelectableInterface);
                    this.generatedFluentHelperClassesPerEntityType.put((Object)entityClassName, (Object)ApiFunction.READ_BY_KEY, (Object)generatedFluentHelperClass);
                }
                serviceClassAmplifier.addGetByKeyMethod(entityMetadata, generatedFluentHelperClass, getByKeyMethodName, keyProperties);
                break;
            }
            case CREATE: {
                JDefinedClass generatedFluentHelperClass = (JDefinedClass)this.generatedFluentHelperClassesPerEntityType.get((Object)entityClassName, (Object)ApiFunction.CREATE);
                if (generatedFluentHelperClass == null) {
                    generatedFluentHelperClass = fluentGenerator.generateCreateFluentHelper(entityClassNamingContext, entityMetadata.getNamespacePackage(), entityMetadata.getGeneratedEntityClass());
                    this.generatedFluentHelperClassesPerEntityType.put((Object)entityClassName, (Object)ApiFunction.CREATE, (Object)generatedFluentHelperClass);
                }
                serviceClassAmplifier.addCreateMethod(entityMetadata, generatedFluentHelperClass);
                break;
            }
            case UPDATE: {
                JDefinedClass generatedFluentHelperClass = (JDefinedClass)this.generatedFluentHelperClassesPerEntityType.get((Object)entityClassName, (Object)ApiFunction.UPDATE);
                if (generatedFluentHelperClass == null) {
                    generatedFluentHelperClass = fluentGenerator.generateUpdateFluentHelper(entityClassNamingContext, entityMetadata.getNamespacePackage(), entityMetadata.getGeneratedEntityClass());
                    this.generatedFluentHelperClassesPerEntityType.put((Object)entityClassName, (Object)ApiFunction.UPDATE, (Object)generatedFluentHelperClass);
                }
                serviceClassAmplifier.addUpdateMethod(entityMetadata, generatedFluentHelperClass);
                break;
            }
            case DELETE: {
                JDefinedClass generatedFluentHelperClass = (JDefinedClass)this.generatedFluentHelperClassesPerEntityType.get((Object)entityClassName, (Object)ApiFunction.DELETE);
                if (generatedFluentHelperClass == null) {
                    generatedFluentHelperClass = fluentGenerator.generateDeleteFluentHelper(entityClassNamingContext, entityMetadata.getNamespacePackage(), entityMetadata.getGeneratedEntityClass());
                    this.generatedFluentHelperClassesPerEntityType.put((Object)entityClassName, (Object)ApiFunction.DELETE, (Object)generatedFluentHelperClass);
                }
                serviceClassAmplifier.addDeleteMethod(entityMetadata, generatedFluentHelperClass);
                break;
            }
            default: {
                throw new ODataGeneratorException("Found unknown ApiFunction: " + String.valueOf((Object)function));
            }
        }
    }

    private List<EntityPropertyModel> processKeyProperties(Service.EntityType typeMetadata, Map<String, EntityPropertyModel> entityClassFields) {
        LinkedList<EntityPropertyModel> keyProperties = new LinkedList<EntityPropertyModel>();
        for (String keyPropertyName : typeMetadata.getKeyPropertyNames()) {
            EntityPropertyModel propertyMapping = entityClassFields.get(keyPropertyName);
            if (propertyMapping != null) {
                propertyMapping.setKeyField(true);
                keyProperties.add(propertyMapping);
                continue;
            }
            logger.error("Key property " + keyPropertyName + " was not found in the set of processed properties.");
        }
        return keyProperties;
    }

    private List<NavigationPropertyModel> processNavigationProperties(Service.EntityType entityType, NamingContext entityPropertyNamingContext, NamingContext entityClassConstantNamingContext) {
        LinkedList<NavigationPropertyModel> navigationPropertyMappings = new LinkedList<NavigationPropertyModel>();
        NamingContext navPropertiesNamingContext = new NamingContext();
        NamingContext builderMethodNamingContext = new NamingContext();
        for (String navigationPropertyName : entityType.getNavigationPropertyNames()) {
            Service.Typed navigationProperty = entityType.getProperty(navigationPropertyName);
            String javaMemberName = entityPropertyNamingContext.ensureUniqueName(this.codeNamingStrategy.generateJavaNavigationPropertyFieldName(navigationPropertyName));
            String javaConstantName = entityClassConstantNamingContext.ensureUniqueName(this.codeNamingStrategy.generateJavaNavigationPropertyConstantName(navigationPropertyName));
            String javaMethodBaseName = navPropertiesNamingContext.ensureUniqueName(this.codeNamingStrategy.generateJavaMethodName(navigationPropertyName));
            String javaBuilderMethodName = builderMethodNamingContext.ensureUniqueName(this.codeNamingStrategy.generateJavaBuilderMethodName(navigationPropertyName));
            navigationPropertyMappings.add(new NavigationPropertyModel(navigationPropertyName, navigationProperty.getType().getName(), navigationProperty.getMultiplicity(), javaMemberName, javaConstantName, NamingUtils.deriveJavaFetchMethodName((String)javaMethodBaseName), NamingUtils.deriveJavaGetIfPresentMethodName((String)javaMethodBaseName), NamingUtils.deriveJavaGetOrFetchMethodName((String)javaMethodBaseName), NamingUtils.deriveJavaAddMethodName((String)javaMethodBaseName), NamingUtils.deriveJavaSetMethodName((String)javaMethodBaseName), javaBuilderMethodName));
        }
        return navigationPropertyMappings;
    }

    private void overrideSetServicePathForFetchMethod(JDefinedClass entityClass) {
        JMethod setterMethod = entityClass.method(2, (JType)this.codeModel.VOID, "setServicePathForFetch");
        setterMethod.annotate(Override.class);
        JVar newValueVar = setterMethod.param(8, String.class, "servicePathForFetch");
        newValueVar.annotate(Nullable.class);
        setterMethod.body().invoke(JExpr._super(), "setServicePathForFetch").arg((JExpression)newValueVar);
    }

    private void overrideGetDestinationForFetchMethod(JDefinedClass entityClass) {
        JMethod getterMethod = entityClass.method(1, Destination.class, "getDestinationForFetch");
        getterMethod.annotate(Override.class);
        getterMethod.annotate(Nullable.class);
        getterMethod.body()._return((JExpression)JExpr._super().invoke("getDestinationForFetch"));
    }

    private void overrideAttachToServiceMethod(JDefinedClass entityClass) {
        JMethod attachMethod = entityClass.method(1, (JType)this.codeModel.VOID, "attachToService");
        attachMethod.annotate(Override.class);
        JVar servicePathVar = attachMethod.param(8, String.class, "servicePath");
        servicePathVar.annotate(Nullable.class);
        JVar destinationVar = attachMethod.param(8, Destination.class, "destination");
        destinationVar.annotate(Nonnull.class);
        attachMethod.body().invoke(JExpr._super(), "attachToService").arg((JExpression)servicePathVar).arg((JExpression)destinationVar);
    }

    Option<String> getQualifiedEntityClassName(@Nonnull String entitySetName) {
        return this.entityBluePrintMap.containsKey(entitySetName) ? Option.some((Object)this.entityBluePrintMap.get(entitySetName).getEntityClass().fullName()) : Option.none();
    }

    public static final class ClassGeneratorResult {
        @Nonnull
        final JDefinedClass generatedEntityClass;
        @Nullable
        final JDefinedClass specificEntitySelectableInterface;
        @Nullable
        final JDefinedClass entityOneToManyLink;
        @Nullable
        final JDefinedClass entityOneToOneLink;

        @Generated
        public ClassGeneratorResult(@Nonnull JDefinedClass generatedEntityClass, @Nullable JDefinedClass specificEntitySelectableInterface, @Nullable JDefinedClass entityOneToManyLink, @Nullable JDefinedClass entityOneToOneLink) {
            if (generatedEntityClass == null) {
                throw new NullPointerException("generatedEntityClass is marked non-null but is null");
            }
            this.generatedEntityClass = generatedEntityClass;
            this.specificEntitySelectableInterface = specificEntitySelectableInterface;
            this.entityOneToManyLink = entityOneToManyLink;
            this.entityOneToOneLink = entityOneToOneLink;
        }

        @Nonnull
        @Generated
        public JDefinedClass getGeneratedEntityClass() {
            return this.generatedEntityClass;
        }

        @Nullable
        @Generated
        public JDefinedClass getSpecificEntitySelectableInterface() {
            return this.specificEntitySelectableInterface;
        }

        @Nullable
        @Generated
        public JDefinedClass getEntityOneToManyLink() {
            return this.entityOneToManyLink;
        }

        @Nullable
        @Generated
        public JDefinedClass getEntityOneToOneLink() {
            return this.entityOneToOneLink;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClassGeneratorResult)) {
                return false;
            }
            ClassGeneratorResult other = (ClassGeneratorResult)o;
            JDefinedClass this$generatedEntityClass = this.getGeneratedEntityClass();
            JDefinedClass other$generatedEntityClass = other.getGeneratedEntityClass();
            if (this$generatedEntityClass == null ? other$generatedEntityClass != null : !this$generatedEntityClass.equals(other$generatedEntityClass)) {
                return false;
            }
            JDefinedClass this$specificEntitySelectableInterface = this.getSpecificEntitySelectableInterface();
            JDefinedClass other$specificEntitySelectableInterface = other.getSpecificEntitySelectableInterface();
            if (this$specificEntitySelectableInterface == null ? other$specificEntitySelectableInterface != null : !this$specificEntitySelectableInterface.equals(other$specificEntitySelectableInterface)) {
                return false;
            }
            JDefinedClass this$entityOneToManyLink = this.getEntityOneToManyLink();
            JDefinedClass other$entityOneToManyLink = other.getEntityOneToManyLink();
            if (this$entityOneToManyLink == null ? other$entityOneToManyLink != null : !this$entityOneToManyLink.equals(other$entityOneToManyLink)) {
                return false;
            }
            JDefinedClass this$entityOneToOneLink = this.getEntityOneToOneLink();
            JDefinedClass other$entityOneToOneLink = other.getEntityOneToOneLink();
            return !(this$entityOneToOneLink == null ? other$entityOneToOneLink != null : !this$entityOneToOneLink.equals(other$entityOneToOneLink));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            JDefinedClass $generatedEntityClass = this.getGeneratedEntityClass();
            result = result * 59 + ($generatedEntityClass == null ? 43 : $generatedEntityClass.hashCode());
            JDefinedClass $specificEntitySelectableInterface = this.getSpecificEntitySelectableInterface();
            result = result * 59 + ($specificEntitySelectableInterface == null ? 43 : $specificEntitySelectableInterface.hashCode());
            JDefinedClass $entityOneToManyLink = this.getEntityOneToManyLink();
            result = result * 59 + ($entityOneToManyLink == null ? 43 : $entityOneToManyLink.hashCode());
            JDefinedClass $entityOneToOneLink = this.getEntityOneToOneLink();
            result = result * 59 + ($entityOneToOneLink == null ? 43 : $entityOneToOneLink.hashCode());
            return result;
        }

        @Nonnull
        @Generated
        public String toString() {
            return "NamespaceClassGenerator.ClassGeneratorResult(generatedEntityClass=" + String.valueOf(this.getGeneratedEntityClass()) + ", specificEntitySelectableInterface=" + String.valueOf(this.getSpecificEntitySelectableInterface()) + ", entityOneToManyLink=" + String.valueOf(this.getEntityOneToManyLink()) + ", entityOneToOneLink=" + String.valueOf(this.getEntityOneToOneLink()) + ")";
        }
    }
}

