/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.generator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class MessageCollector {
    private static final MessageCollectorCollection collection = new MessageCollectorCollection();

    @Nonnull
    public static Logger getLogger(@Nonnull Class<?> cls) {
        return new MessageCollectorLogger(cls, collection);
    }

    @Nonnull
    public static List<String> getErrorMessages() {
        return collection.getMessages(LogLevel.ERROR);
    }

    @Nonnull
    public static List<String> getWarningMessages() {
        return collection.getMessages(LogLevel.WARN);
    }

    private static final class MessageCollectorLogger
    implements Logger {
        private final Logger baseLogger;
        private final Class<?> cls;
        private final MessageCollectorCollection collection;

        private MessageCollectorLogger(Class<?> cls, MessageCollectorCollection collection) {
            this.baseLogger = LoggerFactory.getLogger(cls);
            this.cls = cls;
            this.collection = collection;
        }

        @Nonnull
        public String getName() {
            return this.baseLogger.getName();
        }

        public boolean isTraceEnabled() {
            return this.baseLogger.isTraceEnabled();
        }

        public void trace(String msg) {
            this.baseLogger.trace(msg);
            this.collection.collectLogMessage(LogLevel.TRACE, this.cls, new LoggerContent(msg));
        }

        public void trace(String format, Object arg) {
            this.baseLogger.trace(format, arg);
            this.collection.collectLogMessage(LogLevel.TRACE, this.cls, new LoggerContent(format, arg));
        }

        public void trace(String format, Object arg1, Object arg2) {
            this.baseLogger.trace(format, arg1, arg2);
            this.collection.collectLogMessage(LogLevel.TRACE, this.cls, new LoggerContent(format, arg1, arg2));
        }

        public void trace(String format, Object ... arguments) {
            this.baseLogger.trace(format, arguments);
            this.collection.collectLogMessage(LogLevel.TRACE, this.cls, new LoggerContent(format, arguments));
        }

        public void trace(String msg, Throwable t) {
            this.baseLogger.trace(msg, t);
            this.collection.collectLogMessage(LogLevel.TRACE, this.cls, new LoggerContent(msg));
        }

        public boolean isTraceEnabled(Marker marker) {
            return this.baseLogger.isTraceEnabled(marker);
        }

        public void trace(Marker marker, String msg) {
            this.baseLogger.trace(marker, msg);
            this.collection.collectLogMessage(LogLevel.TRACE, this.cls, new LoggerContent(msg));
        }

        public void trace(Marker marker, String format, Object arg) {
            this.baseLogger.trace(marker, format, arg);
            this.collection.collectLogMessage(LogLevel.TRACE, this.cls, new LoggerContent(format, arg));
        }

        public void trace(Marker marker, String format, Object arg1, Object arg2) {
            this.baseLogger.trace(marker, format, arg1, arg2);
            this.collection.collectLogMessage(LogLevel.TRACE, this.cls, new LoggerContent(format, arg1, arg2));
        }

        public void trace(Marker marker, String format, Object ... argArray) {
            this.baseLogger.trace(marker, format, argArray);
            this.collection.collectLogMessage(LogLevel.TRACE, this.cls, new LoggerContent(format, argArray));
        }

        public void trace(Marker marker, String msg, Throwable t) {
            this.baseLogger.trace(marker, msg, t);
            this.collection.collectLogMessage(LogLevel.TRACE, this.cls, new LoggerContent(msg));
        }

        public boolean isDebugEnabled() {
            return this.baseLogger.isDebugEnabled();
        }

        public void debug(String msg) {
            this.baseLogger.debug(msg);
            this.collection.collectLogMessage(LogLevel.DEBUG, this.cls, new LoggerContent(msg));
        }

        public void debug(String format, Object arg) {
            this.baseLogger.debug(format, arg);
            this.collection.collectLogMessage(LogLevel.DEBUG, this.cls, new LoggerContent(format, arg));
        }

        public void debug(String format, Object arg1, Object arg2) {
            this.baseLogger.debug(format, arg1, arg2);
            this.collection.collectLogMessage(LogLevel.DEBUG, this.cls, new LoggerContent(format, arg1, arg2));
        }

        public void debug(String format, Object ... arguments) {
            this.baseLogger.debug(format, arguments);
            this.collection.collectLogMessage(LogLevel.DEBUG, this.cls, new LoggerContent(format, arguments));
        }

        public void debug(String msg, Throwable t) {
            this.baseLogger.debug(msg, t);
            this.collection.collectLogMessage(LogLevel.DEBUG, this.cls, new LoggerContent(msg));
        }

        public boolean isDebugEnabled(Marker marker) {
            return this.baseLogger.isDebugEnabled(marker);
        }

        public void debug(Marker marker, String msg) {
            this.baseLogger.debug(marker, msg);
            this.collection.collectLogMessage(LogLevel.DEBUG, this.cls, new LoggerContent(msg));
        }

        public void debug(Marker marker, String format, Object arg) {
            this.baseLogger.debug(marker, format, arg);
            this.collection.collectLogMessage(LogLevel.DEBUG, this.cls, new LoggerContent(format, arg));
        }

        public void debug(Marker marker, String format, Object arg1, Object arg2) {
            this.baseLogger.debug(marker, format, arg1, arg2);
            this.collection.collectLogMessage(LogLevel.DEBUG, this.cls, new LoggerContent(format, arg1, arg2));
        }

        public void debug(Marker marker, String format, Object ... arguments) {
            this.baseLogger.debug(marker, format, arguments);
            this.collection.collectLogMessage(LogLevel.DEBUG, this.cls, new LoggerContent(format, arguments));
        }

        public void debug(Marker marker, String msg, Throwable t) {
            this.baseLogger.debug(marker, msg, t);
            this.collection.collectLogMessage(LogLevel.DEBUG, this.cls, new LoggerContent(msg));
        }

        public boolean isInfoEnabled() {
            return this.baseLogger.isInfoEnabled();
        }

        public void info(String msg) {
            this.baseLogger.info(msg);
            this.collection.collectLogMessage(LogLevel.INFO, this.cls, new LoggerContent(msg));
        }

        public void info(String format, Object arg) {
            this.baseLogger.info(format, arg);
            this.collection.collectLogMessage(LogLevel.INFO, this.cls, new LoggerContent(format, arg));
        }

        public void info(String format, Object arg1, Object arg2) {
            this.baseLogger.info(format, arg1, arg2);
            this.collection.collectLogMessage(LogLevel.INFO, this.cls, new LoggerContent(format, arg1, arg2));
        }

        public void info(String format, Object ... arguments) {
            this.baseLogger.info(format, arguments);
            this.collection.collectLogMessage(LogLevel.INFO, this.cls, new LoggerContent(format, arguments));
        }

        public void info(String msg, Throwable t) {
            this.baseLogger.info(msg, t);
            this.collection.collectLogMessage(LogLevel.INFO, this.cls, new LoggerContent(msg));
        }

        public boolean isInfoEnabled(Marker marker) {
            return this.baseLogger.isInfoEnabled(marker);
        }

        public void info(Marker marker, String msg) {
            this.baseLogger.info(marker, msg);
            this.collection.collectLogMessage(LogLevel.INFO, this.cls, new LoggerContent(msg));
        }

        public void info(Marker marker, String format, Object arg) {
            this.baseLogger.info(marker, format, arg);
            this.collection.collectLogMessage(LogLevel.INFO, this.cls, new LoggerContent(format, arg));
        }

        public void info(Marker marker, String format, Object arg1, Object arg2) {
            this.baseLogger.info(marker, format, arg1, arg2);
            this.collection.collectLogMessage(LogLevel.INFO, this.cls, new LoggerContent(format, arg1, arg2));
        }

        public void info(Marker marker, String format, Object ... arguments) {
            this.baseLogger.info(marker, format, arguments);
            this.collection.collectLogMessage(LogLevel.INFO, this.cls, new LoggerContent(format, arguments));
        }

        public void info(Marker marker, String msg, Throwable t) {
            this.baseLogger.info(marker, msg, t);
            this.collection.collectLogMessage(LogLevel.INFO, this.cls, new LoggerContent(msg, t));
        }

        public boolean isWarnEnabled() {
            return this.baseLogger.isWarnEnabled();
        }

        public void warn(String msg) {
            this.baseLogger.warn(msg);
            this.collection.collectLogMessage(LogLevel.WARN, this.cls, new LoggerContent(msg));
        }

        public void warn(String format, Object arg) {
            this.baseLogger.warn(format, arg);
            this.collection.collectLogMessage(LogLevel.WARN, this.cls, new LoggerContent(format, arg));
        }

        public void warn(String format, Object ... arguments) {
            this.baseLogger.warn(format, arguments);
            this.collection.collectLogMessage(LogLevel.WARN, this.cls, new LoggerContent(format, arguments));
        }

        public void warn(String format, Object arg1, Object arg2) {
            this.baseLogger.warn(format, arg1, arg2);
            this.collection.collectLogMessage(LogLevel.WARN, this.cls, new LoggerContent(format, arg1, arg2));
        }

        public void warn(String msg, Throwable t) {
            this.baseLogger.warn(msg, t);
            this.collection.collectLogMessage(LogLevel.WARN, this.cls, new LoggerContent(msg, t));
        }

        public boolean isWarnEnabled(Marker marker) {
            return this.baseLogger.isWarnEnabled(marker);
        }

        public void warn(Marker marker, String msg) {
            this.baseLogger.warn(marker, msg);
            this.collection.collectLogMessage(LogLevel.WARN, this.cls, new LoggerContent(msg));
        }

        public void warn(Marker marker, String format, Object arg) {
            this.baseLogger.warn(marker, format, arg);
            this.collection.collectLogMessage(LogLevel.WARN, this.cls, new LoggerContent(format, arg));
        }

        public void warn(Marker marker, String format, Object arg1, Object arg2) {
            this.baseLogger.warn(marker, format, arg1, arg2);
            this.collection.collectLogMessage(LogLevel.WARN, this.cls, new LoggerContent(format, arg1, arg2));
        }

        public void warn(Marker marker, String format, Object ... arguments) {
            this.baseLogger.warn(marker, format, arguments);
            this.collection.collectLogMessage(LogLevel.WARN, this.cls, new LoggerContent(format, arguments));
        }

        public void warn(Marker marker, String msg, Throwable t) {
            this.baseLogger.warn(marker, msg, t);
            this.collection.collectLogMessage(LogLevel.WARN, this.cls, new LoggerContent(msg));
        }

        public boolean isErrorEnabled() {
            return this.baseLogger.isErrorEnabled();
        }

        public void error(String msg) {
            this.baseLogger.error(msg);
            this.collection.collectLogMessage(LogLevel.ERROR, this.cls, new LoggerContent(msg));
        }

        public void error(String format, Object arg) {
            this.baseLogger.error(format, arg);
            this.collection.collectLogMessage(LogLevel.ERROR, this.cls, new LoggerContent(format, arg));
        }

        public void error(String format, Object arg1, Object arg2) {
            this.baseLogger.error(format, arg1, arg2);
            this.collection.collectLogMessage(LogLevel.ERROR, this.cls, new LoggerContent(format, arg1, arg2));
        }

        public void error(String format, Object ... arguments) {
            this.baseLogger.error(format, arguments);
            this.collection.collectLogMessage(LogLevel.ERROR, this.cls, new LoggerContent(format, arguments));
        }

        public void error(String msg, Throwable t) {
            this.baseLogger.error(msg, t);
            this.collection.collectLogMessage(LogLevel.ERROR, this.cls, new LoggerContent(msg, t));
        }

        public boolean isErrorEnabled(Marker marker) {
            return this.baseLogger.isErrorEnabled(marker);
        }

        public void error(Marker marker, String msg) {
            this.baseLogger.error(marker, msg);
            this.collection.collectLogMessage(LogLevel.ERROR, this.cls, new LoggerContent(msg));
        }

        public void error(Marker marker, String format, Object arg) {
            this.baseLogger.error(marker, format, arg);
            this.collection.collectLogMessage(LogLevel.ERROR, this.cls, new LoggerContent(format, arg));
        }

        public void error(Marker marker, String format, Object arg1, Object arg2) {
            this.baseLogger.error(marker, format, arg1, arg2);
            this.collection.collectLogMessage(LogLevel.ERROR, this.cls, new LoggerContent(format, arg1, arg2));
        }

        public void error(Marker marker, String format, Object ... arguments) {
            this.baseLogger.error(marker, format, arguments);
            this.collection.collectLogMessage(LogLevel.ERROR, this.cls, new LoggerContent(format, arguments));
        }

        public void error(Marker marker, String msg, Throwable t) {
            this.baseLogger.error(marker, msg, t);
            this.collection.collectLogMessage(LogLevel.ERROR, this.cls, new LoggerContent(msg));
        }
    }

    private static final class MessageCollectorCollection {
        private final Map<LogLevel, Map<Class<?>, List<LoggerContent>>> collector = new EnumMap(LogLevel.class);

        private MessageCollectorCollection() {
        }

        void collectLogMessage(LogLevel logLevel, Class<?> cls, LoggerContent content) {
            Map levelEntries = MessageCollectorCollection.getOrDefault(this.collector, logLevel, new HashMap());
            List classEntries = MessageCollectorCollection.getOrDefault(levelEntries, cls, new ArrayList());
            classEntries.add(content);
            levelEntries.put(cls, classEntries);
            this.collector.put(logLevel, levelEntries);
        }

        List<String> getMessages(LogLevel level) {
            Map levelEntries = MessageCollectorCollection.getOrDefault(this.collector, level, Collections.emptyMap());
            ArrayList<String> allMessages = new ArrayList<String>();
            for (List contents : levelEntries.values()) {
                for (LoggerContent content : contents) {
                    allMessages.add(content.getFormattedMessage());
                }
            }
            return allMessages;
        }

        static <K, V> V getOrDefault(Map<K, V> map, K key, V defaultValue) {
            return map.getOrDefault(key, defaultValue);
        }
    }

    private static enum LogLevel {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }

    private static final class LoggerContent {
        private final String message;
        private final Object[] arguments;

        private LoggerContent(String message) {
            this(message, null);
        }

        private LoggerContent(String message, Object ... arguments) {
            this.message = message;
            this.arguments = arguments;
        }

        private String getFormattedMessage() {
            if (this.arguments != null) {
                return String.format(this.message, this.arguments);
            }
            return this.message;
        }
    }
}

