/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.generator;

import com.google.common.base.Strings;
import com.sap.cloud.sdk.datamodel.odata.generator.NavigationPropertyModel;
import com.sap.cloud.sdk.datamodel.odata.generator.Service;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JDocCommentable;
import com.sun.codemodel.JFieldVar;
import java.util.LinkedList;

class JavadocUtils {
    static final String ILLEGAL_STATE_JAVADOC_STRING = "If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and therefore has no ERP configuration context assigned. An entity is managed if it has been either retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or UPDATE call. ";
    private static final String lazyWarningTemplate = "\n<p>\nIf the navigation property <b>%s</b> of a queried <b>%s</b> is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.\n<p>\nPlease note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the first time and it has not yet been loaded, an OData query will be run in order to load the missing information and its result will get cached for future invocations.";

    JavadocUtils() {
    }

    static void addFieldReference(JDocCommentable target, JDefinedClass entityClass, JFieldVar entityField) {
        JDocComment targetDoc = target.javadoc();
        targetDoc.add(targetDoc.size() - 1, (Object)String.format("\n<li>{@link %1$s#%2$s %2$s}</li>", entityClass.fullName(), entityField.name()));
    }

    static String getLazyWarningMessage(NavigationPropertyModel navigationProperty, JDefinedClass entityClass) {
        return String.format(lazyWarningTemplate, navigationProperty.getEdmName(), entityClass.name());
    }

    static String formatDescriptionText(String rawText) {
        return rawText.replaceAll(" {2,}", " ");
    }

    private static String getDocumentationElementValue(Service.Annotatable annotatable, String docElementName) {
        Service.AnnotationElement docElement = annotatable.getDocumentationElement();
        if (docElement != null) {
            for (Service.AnnotationElement annotationElement : docElement.getChildElements()) {
                String trimmedText;
                if (!annotationElement.getName().equals(docElementName) || annotationElement.getText() == null || (trimmedText = annotationElement.getText().trim()).isEmpty()) continue;
                return trimmedText;
            }
        }
        return null;
    }

    static String getBasicDescription(Service.Annotatable element) {
        String trimmedText;
        String documentationElementString = JavadocUtils.getDocumentationElementValue(element, "Summary");
        if (!Strings.isNullOrEmpty((String)documentationElementString)) {
            return documentationElementString;
        }
        String descriptionAttribute = element.getQuickInfo();
        if (descriptionAttribute == null) {
            descriptionAttribute = element.getLabel();
        }
        if (descriptionAttribute != null && !(trimmedText = descriptionAttribute.trim()).isEmpty()) {
            return trimmedText;
        }
        return "";
    }

    static String getDetailedDescription(Service.Annotatable edmElement) {
        String documentationElementString = JavadocUtils.getDocumentationElementValue(edmElement, "LongDescription");
        if (!Strings.isNullOrEmpty((String)documentationElementString)) {
            return documentationElementString;
        }
        return "";
    }

    static String getCompleteDescription(Service.Annotatable element) {
        String basicDescription = JavadocUtils.getBasicDescription(element);
        String detailedDescription = JavadocUtils.getDetailedDescription(element);
        return basicDescription + (basicDescription.isEmpty() ? detailedDescription : String.format("<p>%s</p>", detailedDescription));
    }

    static String getConstraints(Service.Element edmElement) {
        Object parameterConstraintsString = "Constraints: ";
        Service.Facets parameterFacets = edmElement.getFacets();
        LinkedList<String> parameterFacetsStrings = new LinkedList<String>();
        if (parameterFacets != null) {
            if (parameterFacets.isNullable() != null && parameterFacets.isNullable().booleanValue()) {
                parameterFacetsStrings.add("Nullable");
            } else {
                parameterFacetsStrings.add("Not nullable");
            }
            if (!Strings.isNullOrEmpty((String)parameterFacets.getDefaultValue())) {
                parameterFacetsStrings.add(String.format("Default value: %s", parameterFacets.getDefaultValue()));
            }
            if (parameterFacets.getMaxLength() != null) {
                parameterFacetsStrings.add(String.format("Maximum length: %s", parameterFacets.getMaxLength().toString()));
            }
            if (parameterFacets.getPrecision() != null) {
                parameterFacetsStrings.add(String.format("Precision: %s", parameterFacets.getPrecision().toString()));
            }
            if (parameterFacets.getScale() != null) {
                parameterFacetsStrings.add(String.format("Scale: %s", parameterFacets.getScale().toString()));
            }
        }
        parameterConstraintsString = !parameterFacetsStrings.isEmpty() ? (String)parameterConstraintsString + String.join((CharSequence)", ", parameterFacetsStrings) : (String)parameterConstraintsString + "none";
        return parameterConstraintsString;
    }

    static <T extends Service.Annotatable & Service.Element> String getDescriptionAndConstraints(String edmName, T edmElement) {
        Object description = JavadocUtils.getCompleteDescription(edmElement);
        String constraints = JavadocUtils.getConstraints(edmElement);
        description = (String)description + (((String)description).isEmpty() ? constraints : String.format("<p>%s</p>", constraints));
        String edmReference = String.format("Original parameter name from the Odata EDM: <b>%s</b>", edmName);
        description = (String)description + (((String)description).isEmpty() ? edmReference : String.format("<p>%s</p>", edmReference));
        return description;
    }

    static void inheritJavadoc(JDocCommentable commentable) {
        commentable.javadoc().add((Object)"{@inheritDoc}");
    }
}

