/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.generator;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocCommentable;
import com.sun.codemodel.JPackage;

class EntitySelectableGenerator {
    private static final String CLASS_NAME_SELECTABLE_SUFFIX = "Selectable";
    private static final String NAMESPACE_SUB_PACKAGE_NAME = "selectable";
    private final JCodeModel codeModel;

    EntitySelectableGenerator(JCodeModel codeModel) {
        this.codeModel = codeModel;
    }

    JDefinedClass generateSpecificEntitySelectableInterface(JPackage namespacePackage, JDefinedClass entityClass) throws JClassAlreadyExistsException {
        String entityClassName = entityClass.name();
        JPackage selectableSubPackage = namespacePackage.subPackage(NAMESPACE_SUB_PACKAGE_NAME);
        JDefinedClass specificEntitySelector = selectableSubPackage._interface(1, entityClassName + CLASS_NAME_SELECTABLE_SUFFIX);
        specificEntitySelector._extends(this.codeModel.ref(EntitySelectable.class).narrow((JClass)entityClass));
        return specificEntitySelector;
    }

    void addClassLevelJavadoc(JDocCommentable entitySelectableInterface, JDefinedClass entityClass, JDefinedClass entityField, JDefinedClass entityLink) {
        entitySelectableInterface.javadoc().add((Object)String.format("Interface to enable OData entity selectors for {@link %1$s %2$s}. This interface is used by {@link %3$s %4$s} and {@link %5$s %6$s}.\n\n", entityClass.fullName(), entityClass.name(), entityField.fullName(), entityField.name(), entityLink.fullName(), entityLink.name()));
        entitySelectableInterface.javadoc().add((Object)"<p>Available instances:\n<ul>");
        entitySelectableInterface.javadoc().add((Object)"\n</ul>");
    }
}

